/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.treemap.Algorithm;
import com.treemap.BarAlgorithm;
import com.treemap.BinaryTreeAlgorithm;
import com.treemap.CirclePackingAlgorithm;
import com.treemap.CircularAlgorithm;
import com.treemap.IcicleAlgorithm;
import com.treemap.MatrixAlgorithm;
import com.treemap.PieAlgorithm;
import com.treemap.PivotByAlgorithm;
import com.treemap.SliceAndDiceAlgorithm;
import com.treemap.SplitAlgorithm;
import com.treemap.SquarifiedAlgorithm;
import com.treemap.SquarifiedPlusAlgorithm;
import com.treemap.StripAlgorithm;
import com.treemap.SunburstAlgorithm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u001d\b\u0004\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004J\u0006\u0010\u000b\u001a\u00020\u0004J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rJ\u0013\u0010\u000e\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0086\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/treemap/AlgorithmFactory;", "", "entries", "", "Lcom/treemap/Algorithm;", "<init>", "([Lcom/treemap/Algorithm;)V", "", "add", "", "entry", "getDefault", "getAlgorithms", "", "get", "name", "", "Companion", "treemap"})
@StabilityInferred(parameters=0)
public final class AlgorithmFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Algorithm> entries;
    public static final int $stable = 8;
    @NotNull
    private static final Algorithm BINARY_TREE = new BinaryTreeAlgorithm(false, 1, null);
    @NotNull
    private static final Algorithm SLICE = new SliceAndDiceAlgorithm(null, 1, null);
    @NotNull
    private static final Algorithm SQUARIFIED = new SquarifiedAlgorithm();
    @NotNull
    private static final Algorithm SQUARIFIEDPLUS = new SquarifiedPlusAlgorithm();
    @NotNull
    private static final Algorithm STRIP = new StripAlgorithm(false, 1, null);
    @NotNull
    private static final Algorithm PIVOT_BY_SPLIT_SIZE = new PivotByAlgorithm(null, 1, null);
    @NotNull
    private static final Algorithm SPLIT = new SplitAlgorithm();
    @NotNull
    private static final Algorithm CIRCULAR = new CircularAlgorithm();
    @NotNull
    private static final Algorithm CIRCLEPACKING = new CirclePackingAlgorithm();
    @NotNull
    private static final Algorithm PIE = new PieAlgorithm();
    @NotNull
    private static final Algorithm BAR = new BarAlgorithm(0.0, null, 3, null);
    @NotNull
    private static final Algorithm MATRIX = new MatrixAlgorithm();
    @NotNull
    private static final Algorithm SUNBURST = new SunburstAlgorithm();
    @NotNull
    private static final Algorithm ICICLE = new IcicleAlgorithm();
    @NotNull
    private static final AlgorithmFactory ourInstance;

    protected AlgorithmFactory(Algorithm ... entries) {
        Intrinsics.checkNotNullParameter((Object)entries, (String)"entries");
        this.entries = new ArrayList();
        CollectionsKt.addAll((Collection)this.entries, (Object[])entries);
    }

    public final void add(@NotNull Algorithm entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.entries.add(entry);
    }

    @NotNull
    public final Algorithm getDefault() {
        return SQUARIFIEDPLUS;
    }

    @NotNull
    public final List<Algorithm> getAlgorithms() {
        return this.entries;
    }

    @NotNull
    public final Algorithm get(@Nullable String name) {
        for (Algorithm algorithm : this.entries) {
            if (!algorithm.toString().equals(name)) continue;
            return algorithm;
        }
        return this.getDefault();
    }

    @NotNull
    public static final Algorithm getBINARY_TREE() {
        return Companion.getBINARY_TREE();
    }

    @NotNull
    public static final Algorithm getSLICE() {
        return Companion.getSLICE();
    }

    @NotNull
    public static final Algorithm getSQUARIFIED() {
        return Companion.getSQUARIFIED();
    }

    @NotNull
    public static final Algorithm getSQUARIFIEDPLUS() {
        return Companion.getSQUARIFIEDPLUS();
    }

    @NotNull
    public static final Algorithm getSTRIP() {
        return Companion.getSTRIP();
    }

    @NotNull
    public static final Algorithm getPIVOT_BY_SPLIT_SIZE() {
        return Companion.getPIVOT_BY_SPLIT_SIZE();
    }

    @NotNull
    public static final Algorithm getSPLIT() {
        return Companion.getSPLIT();
    }

    @NotNull
    public static final Algorithm getCIRCLEPACKING() {
        return Companion.getCIRCLEPACKING();
    }

    @NotNull
    public static final Algorithm getPIE() {
        return Companion.getPIE();
    }

    @NotNull
    public static final Algorithm getBAR() {
        return Companion.getBAR();
    }

    @NotNull
    public static final Algorithm getMATRIX() {
        return Companion.getMATRIX();
    }

    @NotNull
    public static final Algorithm getSUNBURST() {
        return Companion.getSUNBURST();
    }

    @NotNull
    public static final Algorithm getICICLE() {
        return Companion.getICICLE();
    }

    @JvmStatic
    @NotNull
    public static final AlgorithmFactory getInstance() {
        return Companion.getInstance();
    }

    static {
        Algorithm[] algorithmArray = new Algorithm[]{BINARY_TREE, SLICE, SQUARIFIED, SQUARIFIEDPLUS, STRIP, PIVOT_BY_SPLIT_SIZE, SPLIT, CIRCULAR, BAR, PIE, SUNBURST, MATRIX, ICICLE};
        ourInstance = new AlgorithmFactory(algorithmArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b*\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u00101\u001a\u000200H\u0007R\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0003\u001a\u0004\b\u000b\u0010\bR\u001c\u0010\f\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0003\u001a\u0004\b\u000e\u0010\bR\u001c\u0010\u000f\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\u0003\u001a\u0004\b\u0011\u0010\bR\u001c\u0010\u0012\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0013\u0010\u0003\u001a\u0004\b\u0014\u0010\bR\u001c\u0010\u0015\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0016\u0010\u0003\u001a\u0004\b\u0017\u0010\bR\u001c\u0010\u0018\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0019\u0010\u0003\u001a\u0004\b\u001a\u0010\bR\u0011\u0010\u001b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\bR\u001c\u0010\u001d\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001e\u0010\u0003\u001a\u0004\b\u001f\u0010\bR\u001c\u0010 \u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b!\u0010\u0003\u001a\u0004\b\"\u0010\bR\u001c\u0010#\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b$\u0010\u0003\u001a\u0004\b%\u0010\bR\u001c\u0010&\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b'\u0010\u0003\u001a\u0004\b(\u0010\bR\u001c\u0010)\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b*\u0010\u0003\u001a\u0004\b+\u0010\bR\u001c\u0010,\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b-\u0010\u0003\u001a\u0004\b.\u0010\bR\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/treemap/AlgorithmFactory$Companion;", "", "<init>", "()V", "BINARY_TREE", "Lcom/treemap/Algorithm;", "getBINARY_TREE$annotations", "getBINARY_TREE", "()Lcom/treemap/Algorithm;", "SLICE", "getSLICE$annotations", "getSLICE", "SQUARIFIED", "getSQUARIFIED$annotations", "getSQUARIFIED", "SQUARIFIEDPLUS", "getSQUARIFIEDPLUS$annotations", "getSQUARIFIEDPLUS", "STRIP", "getSTRIP$annotations", "getSTRIP", "PIVOT_BY_SPLIT_SIZE", "getPIVOT_BY_SPLIT_SIZE$annotations", "getPIVOT_BY_SPLIT_SIZE", "SPLIT", "getSPLIT$annotations", "getSPLIT", "CIRCULAR", "getCIRCULAR", "CIRCLEPACKING", "getCIRCLEPACKING$annotations", "getCIRCLEPACKING", "PIE", "getPIE$annotations", "getPIE", "BAR", "getBAR$annotations", "getBAR", "MATRIX", "getMATRIX$annotations", "getMATRIX", "SUNBURST", "getSUNBURST$annotations", "getSUNBURST", "ICICLE", "getICICLE$annotations", "getICICLE", "ourInstance", "Lcom/treemap/AlgorithmFactory;", "getInstance", "treemap"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Algorithm getBINARY_TREE() {
            return BINARY_TREE;
        }

        @JvmStatic
        public static /* synthetic */ void getBINARY_TREE$annotations() {
        }

        @NotNull
        public final Algorithm getSLICE() {
            return SLICE;
        }

        @JvmStatic
        public static /* synthetic */ void getSLICE$annotations() {
        }

        @NotNull
        public final Algorithm getSQUARIFIED() {
            return SQUARIFIED;
        }

        @JvmStatic
        public static /* synthetic */ void getSQUARIFIED$annotations() {
        }

        @NotNull
        public final Algorithm getSQUARIFIEDPLUS() {
            return SQUARIFIEDPLUS;
        }

        @JvmStatic
        public static /* synthetic */ void getSQUARIFIEDPLUS$annotations() {
        }

        @NotNull
        public final Algorithm getSTRIP() {
            return STRIP;
        }

        @JvmStatic
        public static /* synthetic */ void getSTRIP$annotations() {
        }

        @NotNull
        public final Algorithm getPIVOT_BY_SPLIT_SIZE() {
            return PIVOT_BY_SPLIT_SIZE;
        }

        @JvmStatic
        public static /* synthetic */ void getPIVOT_BY_SPLIT_SIZE$annotations() {
        }

        @NotNull
        public final Algorithm getSPLIT() {
            return SPLIT;
        }

        @JvmStatic
        public static /* synthetic */ void getSPLIT$annotations() {
        }

        @NotNull
        public final Algorithm getCIRCULAR() {
            return CIRCULAR;
        }

        @NotNull
        public final Algorithm getCIRCLEPACKING() {
            return CIRCLEPACKING;
        }

        @JvmStatic
        public static /* synthetic */ void getCIRCLEPACKING$annotations() {
        }

        @NotNull
        public final Algorithm getPIE() {
            return PIE;
        }

        @JvmStatic
        public static /* synthetic */ void getPIE$annotations() {
        }

        @NotNull
        public final Algorithm getBAR() {
            return BAR;
        }

        @JvmStatic
        public static /* synthetic */ void getBAR$annotations() {
        }

        @NotNull
        public final Algorithm getMATRIX() {
            return MATRIX;
        }

        @JvmStatic
        public static /* synthetic */ void getMATRIX$annotations() {
        }

        @NotNull
        public final Algorithm getSUNBURST() {
            return SUNBURST;
        }

        @JvmStatic
        public static /* synthetic */ void getSUNBURST$annotations() {
        }

        @NotNull
        public final Algorithm getICICLE() {
            return ICICLE;
        }

        @JvmStatic
        public static /* synthetic */ void getICICLE$annotations() {
        }

        @JvmStatic
        @NotNull
        public final AlgorithmFactory getInstance() {
            return ourInstance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

