/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.math.MathKt;
import com.macrofocus.common.properties.MutableProperties;
import com.treemap.AbstractAlgorithm;
import com.treemap.EqualCirclesInCircle;
import com.treemap.TreeMapAccessor;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.AffineTransform;
import org.mkui.geom.Ellipse2D;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u0007\u0018\u0000 A2\u00020\u0001:\u0004>?@AB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JG\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0013\"\u0004\b\u0000\u0010\u0014\"\u0004\b\u0001\u0010\u0015\"\u0004\b\u0002\u0010\u00162\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u00160\u00182\u0006\u0010\u0019\u001a\u0002H\u0014H\u0016\u00a2\u0006\u0002\u0010\u001aJU\u0010\u001b\u001a\u00020\u001c\"\u0004\b\u0000\u0010\u0014\"\u0004\b\u0001\u0010\u0015\"\u0004\b\u0002\u0010\u00162\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u00160\u00182\u0006\u0010\u0019\u001a\u0002H\u00142\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016\u00a2\u0006\u0002\u0010!Jo\u0010\"\u001a\u00020#\"\u0004\b\u0000\u0010\u0014\"\u0004\b\u0001\u0010\u0015\"\u0004\b\u0002\u0010\u00162\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u0002H\u00142\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H\u00140(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u00052\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H\u00140.2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016\u00a2\u0006\u0002\u0010/Jm\u00100\u001a\u00020#\"\u0004\b\u0000\u0010\u0014\"\u0004\b\u0001\u0010\u0015\"\u0004\b\u0002\u0010\u00162\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u0002H\u00142\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H\u00140(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u00052\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H\u00140.2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016\u00a2\u0006\u0002\u0010/J1\u00101\u001a\u0004\u0018\u00010\u001e\"\u0004\b\u0000\u0010\u00142\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H\u00140(2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H\u00140.H\u0002\u00a2\u0006\u0002\u00102JM\u00103\u001a\u00020\u001c\"\u0004\b\u0000\u0010\u0014\"\u0004\b\u0001\u0010\u0015\"\u0004\b\u0002\u0010\u00162\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u0016\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u0002H\u0014H\u0016\u00a2\u0006\u0002\u00104J\u0012\u00105\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u0006\u0010<\u001a\u00020\u000fJ\b\u0010=\u001a\u00020\u000fH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001e\u0010\r\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0018\u00010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u00106\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0014\u00108\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00107R\u0014\u00109\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u00107R\u0014\u0010:\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u00107R\u0014\u0010;\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u00107\u00a8\u0006B"}, d2={"Lcom/treemap/CircularAlgorithm;", "Lcom/treemap/AbstractAlgorithm;", "<init>", "()V", "verticalAlignment", "", "getVerticalAlignment", "()I", "setVerticalAlignment", "(I)V", "horizontalAlignment", "getHorizontalAlignment", "setHorizontalAlignment", "properties", "Lcom/macrofocus/common/properties/MutableProperties;", "", "getProperties", "()Lcom/macrofocus/common/properties/MutableProperties;", "iterator", "", "N", "Row", "Column", "model", "Lcom/treemap/TreeMapModel;", "root", "(Lcom/treemap/TreeMapModel;Ljava/lang/Object;)Ljava/lang/Iterable;", "startLayout", "", "bounds", "Lorg/mkui/geom/Rectangle2D;", "worker", "Lcom/treemap/TreeMapWorker;", "(Lorg/mkui/geom/Rectangle2D;Lcom/treemap/TreeMapModel;Ljava/lang/Object;Lcom/treemap/TreeMapWorker;)V", "depthFirstLayout", "", "shape", "Lorg/mkui/geom/Shape;", "parent", "children", "", "sumSizes", "", "horizontalVanishingPoint", "verticalVanishingPoint", "accessor", "Lcom/treemap/TreeMapAccessor;", "(Lorg/mkui/geom/Shape;Ljava/lang/Object;[Ljava/lang/Object;DIILcom/treemap/TreeMapAccessor;Lcom/treemap/TreeMapWorker;)Z", "breadthFirstLayout", "computeBoundingBox", "([Ljava/lang/Object;Lcom/treemap/TreeMapAccessor;)Lorg/mkui/geom/Rectangle2D;", "finishLayout", "(Lorg/mkui/geom/Rectangle2D;Lcom/treemap/TreeMapModel;Ljava/lang/Object;)V", "isCompatible", "isRenderingLeafLabelsSupported", "()Z", "isRenderingParentLabelSupported", "isColorParent", "isChildContained", "isSpaceFilling", "getName", "toString", "Pair", "Circle", "Complex", "Companion", "treemap"})
@StabilityInferred(parameters=0)
public final class CircularAlgorithm
extends AbstractAlgorithm {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int verticalAlignment;
    private int horizontalAlignment;
    public static final int $stable = 8;

    protected final int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    protected final void setVerticalAlignment(int n) {
        this.verticalAlignment = n;
    }

    protected final int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    protected final void setHorizontalAlignment(int n) {
        this.horizontalAlignment = n;
    }

    @Override
    @Nullable
    public MutableProperties<String> getProperties() {
        return null;
    }

    @Override
    @NotNull
    public <N, Row, Column> Iterable<N> iterator(@NotNull TreeMapModel<N, Row, Column> model, N root) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        return model.depthFirstIterator(root);
    }

    @Override
    public <N, Row, Column> void startLayout(@Nullable Rectangle2D bounds, @NotNull TreeMapModel<N, Row, Column> model, N root, @Nullable TreeMapWorker worker) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
    }

    @Override
    public <N, Row, Column> boolean depthFirstLayout(@Nullable Shape shape, N parent, @NotNull N[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, @NotNull TreeMapAccessor<? super N> accessor, @Nullable TreeMapWorker worker) {
        Object child;
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter(accessor, (String)"accessor");
        boolean equalSize = true;
        Double lastRadius = null;
        ArrayList<Circle> circles = new ArrayList<Circle>();
        int n = children.length;
        for (int i = 0; i < n; ++i) {
            child = children[i];
            Circle circle = new Circle();
            if (accessor.hasNoChildren(child)) {
                circle.setRadius(Math.max(0.0, Math.sqrt(accessor.getSize(child) / Math.PI)));
            } else {
                Shape s;
                Intrinsics.checkNotNull((Object)accessor.getShape(child));
                if (s != null) {
                    if (s instanceof Ellipse2D) {
                        Ellipse2D b = (Ellipse2D)s;
                        circle.setRadius(b.getWidth() / (double)2);
                    } else {
                        circle.setRadius(Math.max(0.0, Math.sqrt(accessor.getSize(child) / Math.PI)));
                    }
                } else {
                    circle.setRadius(Math.max(0.0, Math.sqrt(accessor.getSize(child) / Math.PI)));
                }
            }
            if (equalSize) {
                if (lastRadius == null) {
                    lastRadius = circle.getRadius();
                } else if (!(lastRadius.doubleValue() == circle.getRadius())) {
                    equalSize = false;
                }
            }
            circles.add(circle);
        }
        if (equalSize && circles.size() > 1 && circles.size() <= ((Object[])EqualCirclesInCircle.INSTANCE.getCci()).length) {
            float[] coordinates = EqualCirclesInCircle.INSTANCE.getCci()[circles.size() - 1];
            double radii = EqualCirclesInCircle.INSTANCE.getRadii()[circles.size() - 1];
            Double d = lastRadius;
            Intrinsics.checkNotNull((Object)d);
            double scale = d;
            int n2 = ((Collection)circles).size();
            for (int i = 0; i < n2; ++i) {
                Object e = circles.get(i);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                Circle circle = (Circle)e;
                circle.setCx((double)coordinates[i * 2] / radii * scale);
                circle.setCy((double)coordinates[i * 2 + 1] / radii * scale);
            }
        } else {
            CircularAlgorithm.Companion.pairPack(circles);
        }
        Circle boundingCircle = CircularAlgorithm.Companion.boundingCircle(circles);
        Iterator iterator2 = circles.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator radii = iterator2;
        while (radii.hasNext()) {
            Object e = radii.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            child = (Circle)e;
            ((Circle)child).setCx(((Circle)child).getCx() - boundingCircle.getCx());
            ((Circle)child).setCy(((Circle)child).getCy() - boundingCircle.getCy());
        }
        boundingCircle = CircularAlgorithm.Companion.boundingCircle(circles);
        if (shape == null) {
            if (boundingCircle != null && !MathKt.isNaN((double)boundingCircle.getRadius())) {
                Rectangle2D b = boundingCircle.getBounds2D();
                accessor.setShape(parent, (Shape)new Ellipse2D.Double(b.getX(), b.getY(), b.getWidth(), b.getHeight()));
            } else {
                accessor.setShape(parent, null);
            }
        }
        int n3 = children.length;
        for (int i = 0; i < n3; ++i) {
            Object e = circles.get(i);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            Circle circle = (Circle)e;
            N child2 = children[i];
            if (!MathKt.isNaN((double)circle.getRadius()) && circle.getRadius() > 0.0) {
                Rectangle2D b = circle.getBounds2D();
                accessor.setShape(child2, (Shape)new Ellipse2D.Double(b.getX(), b.getY(), b.getWidth(), b.getHeight()));
                continue;
            }
            accessor.setShape(child2, null);
        }
        return false;
    }

    @Override
    public <N, Row, Column> boolean breadthFirstLayout(@NotNull Shape shape, N parent, @NotNull N[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, @NotNull TreeMapAccessor<? super N> accessor, @Nullable TreeMapWorker worker) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter(accessor, (String)"accessor");
        Rectangle2D bounds = shape.getBounds2D();
        Rectangle2D cb = this.computeBoundingBox(children, accessor);
        if (cb != null) {
            double size = Math.min(bounds.getWidth(), bounds.getHeight());
            double xs = size / cb.getWidth();
            double ys = size / cb.getHeight();
            for (N node : children) {
                double tx = -cb.getMinX() * xs + bounds.getX();
                double ty = -cb.getMinY() * ys + bounds.getY();
                switch (this.horizontalAlignment) {
                    case 0: {
                        tx += (bounds.getWidth() - size) / (double)2;
                        break;
                    }
                    case 2: {
                        tx += bounds.getWidth() - size;
                    }
                }
                switch (this.verticalAlignment) {
                    case 0: {
                        ty += (bounds.getHeight() - size) / (double)2;
                        break;
                    }
                    case 3: {
                        ty += bounds.getHeight() - size;
                    }
                }
                AffineTransform at = new AffineTransform(xs, 0.0, 0.0, ys, tx, ty);
                Shape s = accessor.getShape(node);
                if (s != null) {
                    Shape x;
                    Rectangle2D b1 = s.getBounds2D();
                    Intrinsics.checkNotNull((Object)at.createTransformedShape((Shape)b1));
                    Rectangle2D b = x.getBounds2D();
                    accessor.setShape(node, (Shape)new Ellipse2D.Double(b.getX(), b.getY(), b.getWidth(), b.getHeight()));
                    continue;
                }
                accessor.setShape(node, null);
            }
        } else {
            for (N node : children) {
                accessor.setShape(node, null);
            }
        }
        return false;
    }

    private final <N> Rectangle2D computeBoundingBox(N[] children, TreeMapAccessor<? super N> accessor) {
        Rectangle2D rectangle2D;
        ArrayList<Circle> circles = new ArrayList<Circle>();
        for (N child : children) {
            Shape shape = accessor.getShape(child);
            if (shape == null || !(shape instanceof Ellipse2D)) continue;
            Ellipse2D ellipse2D = (Ellipse2D)shape;
            Circle circle = new Circle(ellipse2D.getCenterX(), ellipse2D.getCenterY(), ellipse2D.getWidth() / (double)2);
            circles.add(circle);
        }
        if (circles.size() > 0) {
            Circle circle = CircularAlgorithm.Companion.boundingCircle(circles);
            Rectangle2D b = circle.getBounds2D();
            rectangle2D = new Ellipse2D.Double(b.getX(), b.getY(), b.getWidth(), b.getHeight()).getBounds2D();
        } else {
            rectangle2D = null;
        }
        return rectangle2D;
    }

    @Override
    public <N, Row, Column> void finishLayout(@Nullable Rectangle2D bounds, @Nullable TreeMapModel<N, Row, Column> model, N root) {
    }

    @Override
    public boolean isCompatible(@Nullable Shape shape) {
        return shape instanceof Rectangle2D || shape instanceof Ellipse2D;
    }

    @Override
    public boolean isRenderingLeafLabelsSupported() {
        return true;
    }

    @Override
    public boolean isRenderingParentLabelSupported() {
        return true;
    }

    @Override
    public boolean isColorParent() {
        return true;
    }

    @Override
    public boolean isChildContained() {
        return false;
    }

    @Override
    public boolean isSpaceFilling() {
        return false;
    }

    @NotNull
    public final String getName() {
        return "Circular";
    }

    @NotNull
    public String toString() {
        return this.getName();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B!\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\bJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0015\u001a\u00020\u0005J\u000e\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0000J\u0011\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0000H\u0086\u0002J\u0016\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0005J\u0016\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0011\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u001f\u001a\u00020 H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u001a\u0010\u000f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\n\"\u0004\b\u0011\u0010\f\u00a8\u0006!"}, d2={"Lcom/treemap/CircularAlgorithm$Circle;", "", "<init>", "()V", "cx", "", "cy", "r", "(DDD)V", "getCx", "()D", "setCx", "(D)V", "getCy", "setCy", "radius", "getRadius", "setRadius", "intersects", "", "that", "error", "getIntersectionRadius", "contains", "px", "py", "getBounds2D", "Lorg/mkui/geom/Rectangle2D;", "compareTo", "", "c2", "toString", "", "treemap"})
    private static final class Circle
    implements Comparable<Circle> {
        private double cx;
        private double cy;
        private double radius;

        public final double getCx() {
            return this.cx;
        }

        public final void setCx(double d) {
            this.cx = d;
        }

        public final double getCy() {
            return this.cy;
        }

        public final void setCy(double d) {
            this.cy = d;
        }

        public final double getRadius() {
            return this.radius;
        }

        public final void setRadius(double d) {
            this.radius = d;
        }

        public Circle() {
        }

        public Circle(double cx, double cy, double r) {
            this.cx = cx;
            this.cy = cy;
            this.radius = r;
        }

        public final boolean intersects(@NotNull Circle that, double error) {
            Intrinsics.checkNotNullParameter((Object)that, (String)"that");
            double dist = (this.cx - that.cx) * (this.cx - that.cx) + (this.cy - that.cy) * (this.cy - that.cy);
            return dist < (this.radius + that.radius) * (this.radius + that.radius) - error;
        }

        public static /* synthetic */ boolean intersects$default(Circle circle, Circle circle2, double d, int n, Object object) {
            if ((n & 2) != 0) {
                d = 0.0;
            }
            return circle.intersects(circle2, d);
        }

        public final double getIntersectionRadius(@NotNull Circle that) {
            Intrinsics.checkNotNullParameter((Object)that, (String)"that");
            double dist = (this.cx - that.cx) * (this.cx - that.cx) + (this.cy - that.cy) * (this.cy - that.cy);
            return Math.sqrt(dist) - that.radius;
        }

        public final boolean contains(@NotNull Circle that) {
            Intrinsics.checkNotNullParameter((Object)that, (String)"that");
            return this.contains(that, 0.0);
        }

        public final boolean contains(@NotNull Circle that, double error) {
            Intrinsics.checkNotNullParameter((Object)that, (String)"that");
            double dist = Math.sqrt((this.cx - that.cx) * (this.cx - that.cx) + (this.cy - that.cy) * (this.cy - that.cy));
            return this.radius >= dist + that.radius - error;
        }

        public final boolean contains(double px, double py) {
            double dist = Math.sqrt((this.cx - px) * (this.cx - px) + (this.cy - py) * (this.cy - py));
            return this.radius >= dist;
        }

        @NotNull
        public final Rectangle2D getBounds2D() {
            return (Rectangle2D)new Rectangle2D.Double(this.cx - this.radius, this.cy - this.radius, this.radius * 2.0, this.radius * (double)2);
        }

        @Override
        public int compareTo(@NotNull Circle c2) {
            Intrinsics.checkNotNullParameter((Object)c2, (String)"c2");
            double cmp = this.radius - c2.radius;
            return cmp < 0.0 ? 1 : (cmp > 0.0 ? -1 : 0);
        }

        @NotNull
        public String toString() {
            return Reflection.getOrCreateKotlinClass(this.getClass()) + "[x:" + this.cx + ",y:" + this.cy + ",r:" + this.radius + "]";
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tH\u0002J(\u0010\n\u001a\u00020\u00052\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0002J \u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0002J \u0010\u0015\u001a\u00020\b2\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tH\u0002J \u0010\u0016\u001a\u00020\u00172\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/treemap/CircularAlgorithm$Companion;", "", "<init>", "()V", "pairPack", "", "circles", "Ljava/util/ArrayList;", "Lcom/treemap/CircularAlgorithm$Circle;", "Lkotlin/collections/ArrayList;", "doDefault", "error", "", "innerSoddyRadius", "ra", "rb", "rc", "outerSoddyCircle", "circleA", "circleB", "circleC", "boundingCircle", "boundingBox", "Lorg/mkui/geom/Rectangle2D$Double;", "treemap"})
    public static final class Companion {
        private Companion() {
        }

        private final void pairPack(ArrayList<Circle> circles) {
            double error = 0.01;
            switch (circles.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    Circle circle = circles.get(0);
                    Intrinsics.checkNotNullExpressionValue((Object)circle, (String)"get(...)");
                    Circle circle2 = circle;
                    circle2.setCx(0.0);
                    circle2.setCy(0.0);
                    break;
                }
                case 2: {
                    Circle circle = circles.get(0);
                    Intrinsics.checkNotNullExpressionValue((Object)circle, (String)"get(...)");
                    Circle c0 = circle;
                    Circle circle3 = circles.get(1);
                    Intrinsics.checkNotNullExpressionValue((Object)circle3, (String)"get(...)");
                    Circle c1 = circle3;
                    double radius = c0.getRadius() + c1.getRadius();
                    c0.setCx(c0.getRadius() - radius);
                    c1.setCx(radius - c1.getRadius());
                    c1.setCy(0.0);
                    c0.setCy(c1.getCy());
                    break;
                }
                case 4: {
                    Companion $this$pairPack_u24lambda_u240 = this;
                    boolean bl = false;
                    ArrayList sorted = new ArrayList(circles);
                    CollectionsKt.sort((List)sorted);
                    if (((Circle)sorted.get(0)).getRadius() / ((Circle)sorted.get(3)).getRadius() < 1.3) {
                        Object e = sorted.get(0);
                        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                        Circle c0 = (Circle)e;
                        Object e2 = sorted.get(1);
                        Intrinsics.checkNotNullExpressionValue(e2, (String)"get(...)");
                        Circle c1 = (Circle)e2;
                        Object e3 = sorted.get(2);
                        Intrinsics.checkNotNullExpressionValue(e3, (String)"get(...)");
                        Circle c2 = (Circle)e3;
                        Object e4 = sorted.get(3);
                        Intrinsics.checkNotNullExpressionValue(e4, (String)"get(...)");
                        Circle c3 = (Circle)e4;
                        c0.setCy(-c0.getRadius());
                        c0.setCx(c0.getCy());
                        c1.setCy(c1.getRadius());
                        c1.setCx(c1.getCy());
                        c2.setCx(c2.getRadius());
                        c2.setCy(-c2.getRadius());
                        c3.setCx(-c3.getRadius());
                        c3.setCy(c3.getRadius());
                    } else {
                        $this$pairPack_u24lambda_u240.doDefault(circles, error);
                    }
                    Companion $this$pairPack_u24lambda_u241 = this;
                    boolean bl2 = false;
                    $this$pairPack_u24lambda_u241.doDefault(circles, error);
                    break;
                }
                default: {
                    this.doDefault(circles, error);
                }
            }
        }

        private final void doDefault(ArrayList<Circle> circles, double error) {
            ArrayList sorted = new ArrayList(circles);
            CollectionsKt.sort((List)sorted);
            Object e = sorted.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            Circle ca = (Circle)e;
            Object e2 = sorted.get(1);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"get(...)");
            Circle cb = (Circle)e2;
            Object e3 = sorted.get(2);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"get(...)");
            Circle cc = (Circle)e3;
            double b = ca.getRadius() + cc.getRadius();
            double c = ca.getRadius() + cb.getRadius();
            double area = Math.sqrt(ca.getRadius() * cb.getRadius() * cc.getRadius() * (ca.getRadius() + cb.getRadius() + cc.getRadius()));
            double hc = (double)2 * area / c;
            ca.setCx(-ca.getRadius());
            ca.setCy(0.0);
            cb.setCx(cb.getRadius());
            cb.setCy(0.0);
            cc.setCx(ca.getCx() + Math.sqrt(b * b - hc * hc));
            cc.setCy(hc);
            Point2D.Double cp = new Point2D.Double();
            AffineTransform transform = new AffineTransform();
            double shift = ca.getRadius() - cb.getRadius();
            Circle circle = ca;
            circle.setCx(circle.getCx() + shift);
            circle = cb;
            circle.setCx(circle.getCx() + shift);
            circle = cc;
            circle.setCx(circle.getCx() + shift);
            if (sorted.size() > 3) {
                double smallestRadius = ((Circle)sorted.get(sorted.size() - 1)).getRadius();
                ArrayList<Pair> pairs = new ArrayList<Pair>();
                pairs.add(new Pair(cb, ca));
                pairs.add(new Pair(ca, cc));
                pairs.add(new Pair(cc, cb));
                double innerSoddyRadius = this.innerSoddyRadius(ca.getRadius(), cb.getRadius(), cc.getRadius());
                if (innerSoddyRadius >= smallestRadius) {
                    pairs.add(new Pair(ca, cb, innerSoddyRadius));
                    pairs.add(new Pair(cc, ca, innerSoddyRadius));
                    pairs.add(new Pair(cb, cc, innerSoddyRadius));
                }
                Point2D.Double closestPoint = new Point2D.Double();
                int closestEdgeIndex = 0;
                for (int i = 3; i < sorted.size(); ++i) {
                    cc = (Circle)sorted.get(i);
                    closestPoint.setX(Double.MAX_VALUE);
                    closestPoint.setY(Double.MAX_VALUE);
                    closestEdgeIndex = -1;
                    for (int pairIndex = 0; pairIndex < pairs.size(); ++pairIndex) {
                        boolean intersects = false;
                        Object e4 = pairs.get(pairIndex);
                        Intrinsics.checkNotNullExpressionValue(e4, (String)"get(...)");
                        Pair pair = (Pair)e4;
                        if (pair.getInnerSoddyRadius() < cc.getRadius() - error) {
                            intersects = true;
                        } else {
                            ca = pair.getCa();
                            cb = pair.getCb();
                            b = ca.getRadius() + cc.getRadius();
                            c = ca.getRadius() + cb.getRadius();
                            area = Math.sqrt(ca.getRadius() * cb.getRadius() * cc.getRadius() * (ca.getRadius() + cb.getRadius() + cc.getRadius()));
                            hc = (double)2 * area / c;
                            cp.setX(Math.sqrt(b * b - hc * hc));
                            cp.setY(hc);
                            double theta = Math.atan2(cb.getCy() - ca.getCy(), cb.getCx() - ca.getCx());
                            transform.setToIdentity();
                            transform.translate(ca.getCx(), ca.getCy());
                            transform.rotate(theta);
                            transform.transform((Point2D)cp, (Point2D)cp);
                            if (cp.getX() * cp.getX() + cp.getY() * cp.getY() >= closestPoint.getX() * closestPoint.getX() + closestPoint.getY() * closestPoint.getY()) {
                                intersects = true;
                            } else {
                                intersects = false;
                                cc.setCx(cp.getX());
                                cc.setCy(cp.getY());
                                for (int j = 0; j < i; ++j) {
                                    Object e5 = sorted.get(j);
                                    Intrinsics.checkNotNullExpressionValue(e5, (String)"get(...)");
                                    if (!cc.intersects((Circle)e5, error)) continue;
                                    Object e6 = sorted.get(j);
                                    Intrinsics.checkNotNullExpressionValue(e6, (String)"get(...)");
                                    pair.setInnerSoddyRadius(cc.getIntersectionRadius((Circle)e6));
                                    intersects = true;
                                    break;
                                }
                            }
                        }
                        if (intersects || !(cc.getCx() * cc.getCx() + cc.getCy() * cc.getCy() < closestPoint.getX() * closestPoint.getX() + closestPoint.getY() * closestPoint.getY())) continue;
                        closestPoint.setX(cc.getCx());
                        closestPoint.setY(cc.getCy());
                        closestEdgeIndex = pairIndex;
                    }
                    if (closestEdgeIndex < 0) continue;
                    cc.setCx(closestPoint.getX());
                    cc.setCy(closestPoint.getY());
                    ca = ((Pair)pairs.get(closestEdgeIndex)).getCa();
                    cb = ((Pair)pairs.get(closestEdgeIndex)).getCb();
                    innerSoddyRadius = this.innerSoddyRadius(ca.getRadius(), cb.getRadius(), cc.getRadius());
                    if (innerSoddyRadius >= smallestRadius) {
                        ((Pair)pairs.get(closestEdgeIndex)).setInnerSoddyRadius(innerSoddyRadius);
                        pairs.add(new Pair(cc, ca, innerSoddyRadius));
                        pairs.add(new Pair(cb, cc, innerSoddyRadius));
                    } else {
                        Object e7 = pairs.remove(closestEdgeIndex);
                        Intrinsics.checkNotNull(e7);
                    }
                    pairs.add(new Pair(ca, cc));
                    pairs.add(new Pair(cc, cb));
                }
            }
        }

        private final double innerSoddyRadius(double ra, double rb, double rc) {
            return ra * rb * rc / (ra * rc + ra * rb + rb * rc + Math.sqrt((double)4 * ra * rb * rc * (ra + rb + rc)));
        }

        private final Circle outerSoddyCircle(Circle circleA, Circle circleB, Circle circleC) {
            double ra = circleA.getRadius();
            double rb = circleB.getRadius();
            double rc = circleC.getRadius();
            double k1 = 0.0;
            double k2 = 0.0;
            double k3 = 0.0;
            double k4 = 0.0;
            k1 = 1.0 / ra;
            k2 = 1.0 / rb;
            k3 = 1.0 / rc;
            k4 = Math.abs(k1 + k2 + k3 - (double)2 * Math.sqrt(k1 * k2 + k2 * k3 + k3 * k1));
            Complex q1 = null;
            Complex q2 = null;
            Complex q3 = null;
            Complex q4 = null;
            q1 = new Complex(k1, 0.0).mul(new Complex(circleA.getCx(), circleA.getCy()));
            q2 = new Complex(k2, 0.0).mul(new Complex(circleB.getCx(), circleB.getCy()));
            q3 = new Complex(k3, 0.0).mul(new Complex(circleC.getCx(), circleC.getCy()));
            q4 = q1.add(q2).add(q3).sub(new Complex(2.0, 0.0).mul(q1.mul(q2).add(q2.mul(q3)).add(q3.mul(q1)).sqrt()));
            Complex z = q4.div(new Complex(k4, 0.0));
            return z.isNaN() || MathKt.isNaN((double)(1.0 / k4)) ? new Circle() : new Circle(-z.real(), -z.img(), 1.0 / k4);
        }

        private final Circle boundingCircle(ArrayList<Circle> circles) {
            Circle outerSoddy = null;
            if (circles.size() >= 3) {
                Circle circle = circles.get(0);
                Intrinsics.checkNotNullExpressionValue((Object)circle, (String)"get(...)");
                Circle circle2 = circles.get(1);
                Intrinsics.checkNotNullExpressionValue((Object)circle2, (String)"get(...)");
                Circle circle3 = circles.get(2);
                Intrinsics.checkNotNullExpressionValue((Object)circle3, (String)"get(...)");
                outerSoddy = this.outerSoddyCircle(circle, circle2, circle3);
                Iterator<Circle> iterator2 = circles.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
                Iterator<Circle> iterator3 = iterator2;
                while (iterator3.hasNext()) {
                    Circle c;
                    Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
                    double dist = Math.sqrt((outerSoddy.getCx() - c.getCx()) * (outerSoddy.getCx() - c.getCx()) + (outerSoddy.getCy() - c.getCy()) * (outerSoddy.getCy() - c.getCy()));
                    outerSoddy.setRadius(Math.max(outerSoddy.getRadius(), dist + c.getRadius()));
                }
            }
            Rectangle2D.Double bbox = this.boundingBox(circles);
            Circle bc = new Circle(bbox.getCenterX(), bbox.getCenterY(), Math.max(bbox.getWidth(), bbox.getHeight()) / (double)2);
            Iterator<Circle> iterator4 = circles.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator4, (String)"iterator(...)");
            Iterator<Circle> iterator5 = iterator4;
            while (iterator5.hasNext()) {
                Circle c;
                Intrinsics.checkNotNullExpressionValue((Object)iterator5.next(), (String)"next(...)");
                double dist = Math.sqrt((bc.getCx() - c.getCx()) * (bc.getCx() - c.getCx()) + (bc.getCy() - c.getCy()) * (bc.getCy() - c.getCy()));
                bc.setRadius(Math.max(bc.getRadius(), dist + c.getRadius()));
            }
            return outerSoddy == null || bc.getRadius() < outerSoddy.getRadius() ? bc : outerSoddy;
        }

        private final Rectangle2D.Double boundingBox(ArrayList<Circle> circles) {
            double minx = Double.MAX_VALUE;
            double maxx = Double.MIN_VALUE;
            double miny = Double.MAX_VALUE;
            double maxy = Double.MIN_VALUE;
            Iterator<Circle> iterator2 = circles.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            Iterator<Circle> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Circle c;
                Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
                minx = Math.min(minx, c.getCx() - c.getRadius());
                maxx = Math.max(maxx, c.getCx() + c.getRadius());
                miny = Math.min(miny, c.getCy() - c.getRadius());
                maxy = Math.max(maxy, c.getCy() + c.getRadius());
            }
            return new Rectangle2D.Double(minx, miny, maxx - minx, maxy - miny);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\u0003J\u0006\u0010\b\u001a\u00020\u0003J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0000J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0000J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0000J\u0011\u0010\r\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010\u000e\u001a\u00020\u0003J\u0006\u0010\u000f\u001a\u00020\u0003J\u0006\u0010\u0010\u001a\u00020\u0000J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0006\u0010\u0018\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/treemap/CircularAlgorithm$Complex;", "", "x", "", "y", "<init>", "(DD)V", "real", "img", "add", "that", "sub", "mul", "div", "arg", "mod", "sqrt", "equals", "", "o", "hashCode", "", "toString", "", "isNaN", "treemap"})
    private static final class Complex {
        private final double x;
        private final double y;

        public Complex(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public final double real() {
            return this.x;
        }

        public final double img() {
            return this.y;
        }

        @NotNull
        public final Complex add(@NotNull Complex that) {
            Intrinsics.checkNotNullParameter((Object)that, (String)"that");
            return new Complex(this.x + that.x, this.y + that.y);
        }

        @NotNull
        public final Complex sub(@NotNull Complex that) {
            Intrinsics.checkNotNullParameter((Object)that, (String)"that");
            return new Complex(this.x - that.x, this.y - that.y);
        }

        @NotNull
        public final Complex mul(@NotNull Complex that) {
            Intrinsics.checkNotNullParameter((Object)that, (String)"that");
            return new Complex(this.x * that.x - this.y * that.y, this.x * that.y + this.y * that.x);
        }

        @NotNull
        public final Complex div(@NotNull Complex that) {
            Intrinsics.checkNotNullParameter((Object)that, (String)"that");
            return new Complex((this.x * that.x + this.y * that.y) / (that.x * that.x + that.y * that.y), (this.y * that.x - this.x * that.y) / (that.x * that.x + that.y * that.y));
        }

        public final double arg() {
            return Math.atan2(this.y, this.x);
        }

        public final double mod() {
            return Math.sqrt(this.x * this.x + this.y * this.y);
        }

        @NotNull
        public final Complex sqrt() {
            double r = Math.sqrt(this.mod());
            double theta = this.arg() / (double)2;
            return new Complex(r * Math.cos(theta), r * Math.sin(theta));
        }

        public boolean equals(@Nullable Object o) {
            if (o instanceof Complex) {
                Object that = o;
                return ((Complex)that).x == this.x && ((Complex)that).y == this.y;
            }
            return false;
        }

        public int hashCode() {
            long bits = MathKt.doubleToLongBits((double)this.x);
            return (int)(bits ^= MathKt.doubleToLongBits((double)this.y) * (long)31) ^ (int)(bits >> 32);
        }

        @NotNull
        public String toString() {
            return this.y >= 0.0 ? "(" + this.x + "+" + this.y + "i)" : "(" + this.x + this.y + "i)";
        }

        public final boolean isNaN() {
            return MathKt.isNaN((double)this.x) || MathKt.isNaN((double)this.y);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/treemap/CircularAlgorithm$Pair;", "", "ca", "Lcom/treemap/CircularAlgorithm$Circle;", "cb", "<init>", "(Lcom/treemap/CircularAlgorithm$Circle;Lcom/treemap/CircularAlgorithm$Circle;)V", "innerSoddyRadius", "", "(Lcom/treemap/CircularAlgorithm$Circle;Lcom/treemap/CircularAlgorithm$Circle;D)V", "getCa", "()Lcom/treemap/CircularAlgorithm$Circle;", "getCb", "getInnerSoddyRadius", "()D", "setInnerSoddyRadius", "(D)V", "treemap"})
    private static final class Pair {
        @NotNull
        private final Circle ca;
        @NotNull
        private final Circle cb;
        private double innerSoddyRadius;

        @NotNull
        public final Circle getCa() {
            return this.ca;
        }

        @NotNull
        public final Circle getCb() {
            return this.cb;
        }

        public final double getInnerSoddyRadius() {
            return this.innerSoddyRadius;
        }

        public final void setInnerSoddyRadius(double d) {
            this.innerSoddyRadius = d;
        }

        public Pair(@NotNull Circle ca, @NotNull Circle cb) {
            Intrinsics.checkNotNullParameter((Object)ca, (String)"ca");
            Intrinsics.checkNotNullParameter((Object)cb, (String)"cb");
            this.innerSoddyRadius = Double.MAX_VALUE;
            this.ca = ca;
            this.cb = cb;
        }

        public Pair(@NotNull Circle ca, @NotNull Circle cb, double innerSoddyRadius) {
            Intrinsics.checkNotNullParameter((Object)ca, (String)"ca");
            Intrinsics.checkNotNullParameter((Object)cb, (String)"cb");
            this.innerSoddyRadius = Double.MAX_VALUE;
            this.ca = ca;
            this.cb = cb;
            this.innerSoddyRadius = innerSoddyRadius;
        }
    }
}

