/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.treemap.SurroundLabeling;
import com.treemap.TreeMapModel;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.labeling.ContrastEnhancement;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JI\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\"\u0004\b\u0000\u0010\u0007\"\u0004\b\u0001\u0010\b\"\u0004\b\u0002\u0010\t2\u0006\u0010\n\u001a\u0002H\u00072\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\t0\fH\u0014\u00a2\u0006\u0002\u0010\rJI\u0010\u000e\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\"\u0004\b\u0000\u0010\u0007\"\u0004\b\u0001\u0010\b\"\u0004\b\u0002\u0010\t2\u0006\u0010\n\u001a\u0002H\u00072\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\t0\fH\u0014\u00a2\u0006\u0002\u0010\rJI\u0010\u000f\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\"\u0004\b\u0000\u0010\u0007\"\u0004\b\u0001\u0010\b\"\u0004\b\u0002\u0010\t2\u0006\u0010\n\u001a\u0002H\u00072\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\t0\fH\u0014\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/treemap/ColoredSurroundLabeling;", "Lcom/treemap/SurroundLabeling;", "<init>", "()V", "getForegroundColor", "Ljava/awt/Color;", "Lorg/mkui/color/MkColor;", "N", "Row", "Column", "node", "model", "Lcom/treemap/TreeMapModel;", "(Ljava/lang/Object;Lcom/treemap/TreeMapModel;)Ljava/awt/Color;", "getEffectColor", "getBackgroundColor", "toString", "", "treemap"})
@StabilityInferred(parameters=1)
public final class ColoredSurroundLabeling
extends SurroundLabeling {
    public static final int $stable;

    @Override
    @Nullable
    protected <N, Row, Column> Color getForegroundColor(N node, @NotNull TreeMapModel<N, Row, Column> model) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Color foreground = model.getSettings().getColumnSettings(model.getGroupByColumn(node)).getHeaderForeground();
        Color background = this.getBackgroundColor(node, model);
        if (background != null) {
            ContrastEnhancement contrastEnhancement = model.getSettings().getColumnSettings(model.getGroupByColumn(node)).getLabelingContrastEnhancement();
            Intrinsics.checkNotNull((Object)contrastEnhancement);
            Color color = foreground;
            Intrinsics.checkNotNull((Object)color);
            foreground = contrastEnhancement.adjustLabelColor(color, background);
        }
        return foreground;
    }

    @Override
    @Nullable
    protected <N, Row, Column> Color getEffectColor(N node, @NotNull TreeMapModel<N, Row, Column> model) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        return model.getSettings().getColumnSettings(model.getGroupByColumn(node)).getHeaderEffectColor();
    }

    @Override
    @Nullable
    protected <N, Row, Column> Color getBackgroundColor(N node, @NotNull TreeMapModel<N, Row, Column> model) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        return model.getColor(node);
    }

    @Override
    @NotNull
    public String toString() {
        return "Surround (Colored)";
    }
}

