/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.geom.Dimension;
import com.treemap.TreeMapColumnSettings;
import com.treemap.TreeMapHeaderRenderer;
import com.treemap.TreeMapModel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.graphics.Insets;
import org.mkui.labeling.EnhancedLabel;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0007\u0018\u0000 \u0017*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u00020\u00042\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0005:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J7\u0010\n\u001a\u00020\u00042\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\f2\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0004J\u0012\u0010\u0015\u001a\u00020\u00122\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\tH\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/treemap/DefaultTreeMapHeaderRenderer;", "N", "Row", "Column", "Lorg/mkui/labeling/EnhancedLabel;", "Lcom/treemap/TreeMapHeaderRenderer;", "<init>", "()V", "name", "", "getTreeMapHeaderRendererComponent", "model", "Lcom/treemap/TreeMapModel;", "node", "dimension", "Lcom/macrofocus/common/geom/Dimension;", "(Lcom/treemap/TreeMapModel;Ljava/lang/Object;Lcom/macrofocus/common/geom/Dimension;)Lorg/mkui/labeling/EnhancedLabel;", "setValue", "", "value", "", "setName", "getName", "Companion", "treemap"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDefaultTreeMapHeaderRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultTreeMapHeaderRenderer.kt\ncom/treemap/DefaultTreeMapHeaderRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1#2:89\n*E\n"})
public final class DefaultTreeMapHeaderRenderer<N, Row, Column>
extends EnhancedLabel
implements TreeMapHeaderRenderer<N, Row, Column> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String name;
    public static final int $stable = 8;
    @NotNull
    private static final Insets DEFAULT_BORDER = new Insets(0, 0, 0, 0);

    public DefaultTreeMapHeaderRenderer() {
        this.setOpaque(false);
        this.setName("TreeMap.headerRenderer");
        this.setInsets(DEFAULT_BORDER.getTop(), DEFAULT_BORDER.getLeft(), DEFAULT_BORDER.getBottom(), DEFAULT_BORDER.getRight());
        this.setEffect((EnhancedLabel.Effect)EnhancedLabel.Effect.Emphasize.INSTANCE);
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(1);
        this.setRendering(EnhancedLabel.Rendering.Clip);
    }

    @Override
    @NotNull
    public EnhancedLabel getTreeMapHeaderRendererComponent(@NotNull TreeMapModel<N, Row, Column> model, N node, @NotNull Dimension dimension) {
        Float effectOpacity;
        Integer minimumCharactersToDisplay;
        int verticalAlignment;
        int horizontalAlignment;
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        String value = model.getLabelName(node);
        this.setValue(value);
        TreeMapColumnSettings settings = model.getSettings().getColumnSettings(model.getGroupByColumn(node));
        EnhancedLabel.Effect effect = settings.getHeaderEffect();
        if (effect != null) {
            this.setEffect(effect);
        }
        int it = horizontalAlignment = settings.getHeaderHorizontalAlignment();
        boolean bl = false;
        this.setHorizontalAlignment(it);
        int it2 = verticalAlignment = settings.getHeaderVerticalAlignment();
        boolean bl2 = false;
        this.setVerticalAlignment(it2);
        EnhancedLabel.Rendering rendering = settings.getHeaderRendering();
        if (rendering != null) {
            this.setRendering(rendering);
        }
        Integer n = minimumCharactersToDisplay = settings.getHeaderMinimumCharactersToDisplay();
        if (n != null) {
            int it3 = ((Number)n).intValue();
            boolean bl3 = false;
            this.setMinimumCharactersToDisplay(it3);
        }
        Float f = effectOpacity = settings.getHeaderEffectOpacity();
        if (f != null) {
            float it4 = ((Number)f).floatValue();
            boolean bl4 = false;
            this.setEffectOpacity(it4);
        }
        Insets insets = settings.getHeaderInsets();
        if (insets != null) {
            this.setInsets(insets.getTop(), insets.getLeft(), insets.getBottom(), insets.getRight());
        } else {
            this.setInsets(0, 0, 0, 0);
        }
        this.setDesiredWidth(dimension.getIwidth());
        this.setDesiredHeight(dimension.getIheight());
        return this;
    }

    protected final void setValue(@Nullable Object value) {
        Object object = value;
        if (object == null || (object = object.toString()) == null) {
            object = "";
        }
        this.setText((String)object);
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/treemap/DefaultTreeMapHeaderRenderer$Companion;", "", "<init>", "()V", "DEFAULT_BORDER", "Lorg/mkui/graphics/Insets;", "treemap"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

