/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.data.type.HtmlString;
import com.macrofocus.common.geom.Dimension;
import com.treemap.TreeMapColumnSettings;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapTooltipRenderer;
import com.treemap.TreeMapView;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.mkui.graphics.Insets;
import org.mkui.labeling.EnhancedLabel;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u0010*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u00020\u00042\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0005:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J?\u0010\b\u001a\u00020\u00042\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\n2\u0006\u0010\u000b\u001a\u00028\u00022\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/treemap/DefaultTreeMapTooltipRenderer;", "N", "Row", "Column", "Lorg/mkui/labeling/EnhancedLabel;", "Lcom/treemap/TreeMapTooltipRenderer;", "<init>", "()V", "getTooltipRendererComponent", "view", "Lcom/treemap/TreeMapView;", "column", "node", "dimension", "Lcom/macrofocus/common/geom/Dimension;", "(Lcom/treemap/TreeMapView;Ljava/lang/Object;Ljava/lang/Object;Lcom/macrofocus/common/geom/Dimension;)Lorg/mkui/labeling/EnhancedLabel;", "Companion", "treemap"})
@StabilityInferred(parameters=8)
public final class DefaultTreeMapTooltipRenderer<N, Row, Column>
extends EnhancedLabel
implements TreeMapTooltipRenderer<N, Row, Column> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    @NotNull
    private static final Insets DEFAULT_BORDER;

    public DefaultTreeMapTooltipRenderer() {
        this.setOpaque(false);
        this.setName("TreeMap.tooltipRenderer");
        this.setInsets(DEFAULT_BORDER.getTop(), DEFAULT_BORDER.getLeft(), DEFAULT_BORDER.getBottom(), DEFAULT_BORDER.getRight());
        this.setEffect((EnhancedLabel.Effect)EnhancedLabel.Effect.Plain.INSTANCE);
        this.setHorizontalAlignment(2);
        this.setRendering(EnhancedLabel.Rendering.WordWrap);
    }

    @Override
    @NotNull
    public EnhancedLabel getTooltipRendererComponent(@NotNull TreeMapView<N, Row, Column> view, Column column, N node, @NotNull Dimension dimension) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        TreeMapModel<N, Row, Column> treeMapModel = view.getModel();
        Intrinsics.checkNotNull(treeMapModel);
        TreeMapModel<N, Row, Column> model = treeMapModel;
        String value = model.getStringValue(node, column);
        this.setText(value);
        this.setHTML(model.getColumnClass(column) == Reflection.getOrCreateKotlinClass(HtmlString.class));
        TreeMapColumnSettings settings = model.getSettings().getColumnSettings(column);
        EnhancedLabel.Rendering rendering = settings.getTooltipRendering();
        if (rendering != null) {
            this.setRendering(rendering);
        }
        if (model.isNumericType(column)) {
            this.setHorizontalAlignment(4);
        } else {
            this.setHorizontalAlignment(2);
        }
        this.setDesiredWidth(dimension.getIwidth());
        this.setDesiredHeight(dimension.getIheight());
        return this;
    }

    static {
        DEFAULT_BORDER = new Insets(0, 2, 0, 1);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/treemap/DefaultTreeMapTooltipRenderer$Companion;", "", "<init>", "()V", "DEFAULT_BORDER", "Lorg/mkui/graphics/Insets;", "getDEFAULT_BORDER", "()Lorg/mkui/graphics/Insets;", "treemap"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Insets getDEFAULT_BORDER() {
            return DEFAULT_BORDER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

