/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.treemap.AbstractTreeMapNode;
import com.treemap.LeafTreeMapNode;
import com.treemap.Pair;
import com.treemap.TreeMapModel;
import com.treemap.treeplot.Spoint;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.Ellipse2D;
import org.mkui.geom.GeneralPath;
import org.mkui.geom.Shape;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0004\n\u0002\b\u0002\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003BI\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012$\u0010\u0006\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0003\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00018\u0001\u0012\b\u0010\t\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010+\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001cJ\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020/H\u0016J\u001a\u00102\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000303H\u0016J\u001a\u00104\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000303H\u0016J\u001c\u00105\u001a\u0002062\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0003H\u0016J\u001e\u00108\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000309J\u001e\u0010:\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00030\u0019J \u0010;\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010<\u001a\u00020\u0005H\u0016J\u001d\u0010=\u001a\u0004\u0018\u00010(2\u0006\u0010>\u001a\u00028\u00012\u0006\u0010?\u001a\u00028\u0001\u00a2\u0006\u0002\u0010@J\u001d\u0010A\u001a\u0004\u0018\u00010*2\u0006\u0010>\u001a\u00028\u00012\u0006\u0010?\u001a\u00028\u0001\u00a2\u0006\u0002\u0010BJ\u0014\u0010C\u001a\u0002062\f\u0010D\u001a\b\u0012\u0004\u0012\u00020F0EJ#\u0010G\u001a\b\u0012\u0004\u0012\u00020F0E2\u0006\u0010>\u001a\u00028\u00012\u0006\u0010?\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010HJ%\u0010I\u001a\b\u0012\u0004\u0012\u00020F0E2\b\u0010>\u001a\u0004\u0018\u00018\u00012\b\u0010?\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010HJ6\u0010J\u001a\u0004\u0018\u00010F2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020F0\u00162\b\u0010K\u001a\u0004\u0018\u00010F2\b\u0010L\u001a\u0004\u0018\u00010M2\b\u0010N\u001a\u0004\u0018\u00010MH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R:\u0010\u0012\u001a.\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0003\u0018\u00010\u0013j\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0003\u0018\u0001`\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0015\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0003\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000RR\u0010\u0017\u001aF\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00030\u0019\u0018\u00010\u0018j\"\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00030\u0019\u0018\u0001`\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\u0004\u0018\u00018\u0001X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\t\u001a\u0004\u0018\u00018\u00018VX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b\u001e\u0010\u001cR*\u0010!\u001a\u0004\u0018\u00010 2\b\u0010\u001f\u001a\u0004\u0018\u00010 8V@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R*\u0010&\u001a\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00010'\u0012\u0006\u0012\u0004\u0018\u00010(\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010)\u001a\u001c\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00010'\u0012\u0004\u0012\u00020*\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00100\u001a\u00020/8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101\u00a8\u0006O"}, d2={"Lcom/treemap/ParentTreeMapNode;", "Row", "Column", "Lcom/treemap/AbstractTreeMapNode;", "name", "", "model", "Lcom/treemap/TreeMapModel;", "groupByColumn", "childrenGroupByColumn", "<init>", "(Ljava/lang/Object;Lcom/treemap/TreeMapModel;Ljava/lang/Object;Ljava/lang/Object;)V", "sumSize", "", "getSumSize", "()D", "setSumSize", "(D)V", "children", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "childrenOfTypeParent", "", "indexReference", "Ljava/lang/ref/SoftReference;", "", "Lcom/macrofocus/common/collection/SoftReference;", "getGroupByColumn", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getChildrenGroupByColumn", "value", "Lorg/mkui/geom/Shape;", "nestedShape", "getNestedShape", "()Lorg/mkui/geom/Shape;", "setNestedShape", "(Lorg/mkui/geom/Shape;)V", "mecs", "Lcom/treemap/Pair;", "Lorg/mkui/geom/Ellipse2D;", "chs", "Lorg/mkui/geom/GeneralPath;", "getRow", "getChildCount", "", "hasNoChildren", "", "isLeaf", "()Z", "getChildren", "", "getChildrenOfTypeParent", "add", "", "child", "getIndex", "", "createIndex", "findChild", "getNodeName", "getMEC", "xVariable", "yVariable", "(Ljava/lang/Object;Ljava/lang/Object;)Lorg/mkui/geom/Ellipse2D;", "getCH", "(Ljava/lang/Object;Ljava/lang/Object;)Lorg/mkui/geom/GeneralPath;", "computeCHGraph", "points", "", "Lcom/treemap/treeplot/Spoint;", "getMECPoints", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "getCHPoints", "addPoint", "treeRoot", "xValue", "", "yValue", "treemap"})
@StabilityInferred(parameters=0)
public final class ParentTreeMapNode<Row, Column>
extends AbstractTreeMapNode<Row, Column> {
    @NotNull
    private final Object name;
    private double sumSize;
    @Nullable
    private LinkedHashSet<AbstractTreeMapNode<Row, Column>> children;
    @Nullable
    private List<AbstractTreeMapNode<Row, Column>> childrenOfTypeParent;
    @Nullable
    private SoftReference<Map<Object, AbstractTreeMapNode<Row, Column>>> indexReference;
    @Nullable
    private final Column groupByColumn;
    @Nullable
    private final Column childrenGroupByColumn;
    @Nullable
    private Shape nestedShape;
    @Nullable
    private Map<Pair<Column, Column>, Ellipse2D> mecs;
    @Nullable
    private Map<Pair<Column, Column>, GeneralPath> chs;
    public static final int $stable = 8;

    public ParentTreeMapNode(@NotNull Object name, @NotNull TreeMapModel<AbstractTreeMapNode<Row, Column>, Row, Column> model, @Nullable Column groupByColumn, @Nullable Column childrenGroupByColumn) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        super(model);
        this.name = name;
        this.sumSize = 1.0;
        this.groupByColumn = groupByColumn;
        this.childrenGroupByColumn = childrenGroupByColumn;
    }

    @Override
    public double getSumSize() {
        return this.sumSize;
    }

    @Override
    public void setSumSize(double d) {
        this.sumSize = d;
    }

    @Override
    @Nullable
    public Column getGroupByColumn() {
        return this.groupByColumn;
    }

    @Override
    @Nullable
    public Column getChildrenGroupByColumn() {
        return this.childrenGroupByColumn != null ? this.childrenGroupByColumn : this.getModel().getSettings().getSizeColumn();
    }

    @Override
    @Nullable
    public Shape getNestedShape() {
        return this.nestedShape != null ? this.nestedShape : this.getShape();
    }

    @Override
    public void setNestedShape(@Nullable Shape value) {
        this.nestedShape = value;
        super.setNestedShape(value);
    }

    @Override
    public Row getRow() {
        throw new IllegalStateException();
    }

    @Override
    public int getChildCount() {
        int n;
        if (this.children != null) {
            LinkedHashSet<AbstractTreeMapNode<Row, Column>> linkedHashSet = this.children;
            Intrinsics.checkNotNull(linkedHashSet);
            n = linkedHashSet.size();
        } else {
            n = 0;
        }
        return n;
    }

    @Override
    public boolean hasNoChildren() {
        return this.children == null;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    @NotNull
    public Iterable<AbstractTreeMapNode<Row, Column>> getChildren() {
        Collection collection = this.children != null ? (Collection)this.children : (Collection)CollectionsKt.emptyList();
        Intrinsics.checkNotNull((Object)collection);
        return collection;
    }

    @Override
    @NotNull
    public Iterable<AbstractTreeMapNode<Row, Column>> getChildrenOfTypeParent() {
        List<AbstractTreeMapNode<Row, Column>> list = this.childrenOfTypeParent != null ? this.childrenOfTypeParent : CollectionsKt.emptyList();
        Intrinsics.checkNotNull(list);
        return list;
    }

    @Override
    public void add(@NotNull AbstractTreeMapNode<Row, Column> child) {
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter(child, (String)"child");
                if (this.children == null) {
                    this.children = new LinkedHashSet();
                }
                if (!(child instanceof LeafTreeMapNode)) break block8;
                LinkedHashSet<AbstractTreeMapNode<Row, Column>> linkedHashSet = this.children;
                Intrinsics.checkNotNull(linkedHashSet);
                if (linkedHashSet.contains(child)) break block9;
            }
            LinkedHashSet<AbstractTreeMapNode<Row, Column>> linkedHashSet = this.children;
            Intrinsics.checkNotNull(linkedHashSet);
            linkedHashSet.add(child);
        }
        child.setParent(this.getSelf());
        if (child instanceof ParentTreeMapNode) {
            if (this.childrenOfTypeParent == null) {
                this.childrenOfTypeParent = new ArrayList();
            }
            List<AbstractTreeMapNode<Row, Column>> list = this.childrenOfTypeParent;
            Intrinsics.checkNotNull(list);
            list.add(child);
            if (this.indexReference != null) {
                SoftReference<Map<Object, AbstractTreeMapNode<Row, Column>>> softReference = this.indexReference;
                Intrinsics.checkNotNull(softReference);
                Map<Object, AbstractTreeMapNode<Row, Column>> index = softReference.get();
                if (index != null) {
                    index.put(((ParentTreeMapNode)child).getNodeName(), child);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Object, AbstractTreeMapNode<Row, Column>> getIndex() {
        Map<Object, AbstractTreeMapNode<Row, Column>> map;
        if (this.indexReference == null) {
            Map<Object, AbstractTreeMapNode<Row, Column>> index = this.createIndex();
            this.indexReference = new SoftReference<Map<Object, AbstractTreeMapNode<Row, Column>>>(index);
            map = index;
        } else {
            void var1_2;
            SoftReference<Map<Object, AbstractTreeMapNode<Row, Column>>> softReference = this.indexReference;
            Intrinsics.checkNotNull(softReference);
            Map<Object, AbstractTreeMapNode<Row, Column>> index = softReference.get();
            if (index == null) {
                index = this.createIndex();
                this.indexReference = new SoftReference<Map<Object, AbstractTreeMapNode<Row, Column>>>(index);
            }
            map = var1_2;
        }
        return map;
    }

    @NotNull
    public final Map<Object, AbstractTreeMapNode<Row, Column>> createIndex() {
        Map index = new HashMap();
        LinkedHashSet<AbstractTreeMapNode<Row, Column>> linkedHashSet = this.children;
        Intrinsics.checkNotNull(linkedHashSet);
        Iterator iterator2 = linkedHashSet.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object e = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            AbstractTreeMapNode child = (AbstractTreeMapNode)e;
            if (!(child instanceof ParentTreeMapNode)) continue;
            index.put(((ParentTreeMapNode)child).getNodeName(), child);
        }
        return index;
    }

    @Override
    @Nullable
    public AbstractTreeMapNode<Row, Column> findChild(@Nullable Object name) {
        return this.getIndex().get(name);
    }

    @Override
    @NotNull
    public Object getNodeName() {
        return this.name;
    }

    @Nullable
    public final Ellipse2D getMEC(Column xVariable, Column yVariable) {
        Ellipse2D ellipse2D;
        if (this.mecs == null) {
            this.mecs = new HashMap();
        }
        Column xColumnIndex = xVariable;
        Column yColumnIndex = yVariable;
        Pair<Column, Column> pair = Pair.Companion.create(xColumnIndex, yColumnIndex);
        Map<Pair<Column, Column>, Ellipse2D> map = this.mecs;
        Intrinsics.checkNotNull(map);
        if (map.containsKey(pair)) {
            Map<Pair<Column, Column>, Ellipse2D> map2 = this.mecs;
            Intrinsics.checkNotNull(map2);
            ellipse2D = map2.get(pair);
        } else {
            Ellipse2D.Double double_;
            double radius = 0.0;
            Spoint center = null;
            List<Spoint> points = this.getMECPoints(xVariable, yVariable);
            this.computeCHGraph(points);
            if (points.size() == 1) {
                center = points.get(0);
            } else if (points.size() > 1) {
                Spoint listHead;
                Spoint a;
                Spoint spoint = a = (listHead = points.get(0));
                Intrinsics.checkNotNull((Object)spoint);
                Spoint c = spoint.getChnext();
                Spoint b = null;
                if (points.size() == 2) {
                    b = null;
                } else {
                    while (true) {
                        b = null;
                        double bestTheta = 180.0;
                        Spoint looper = listHead;
                        do {
                            double thetaABC;
                            if (looper != a && looper != c && (thetaABC = Spoint.Companion.angleBetweenPoints(a, looper, c)) < bestTheta) {
                                bestTheta = thetaABC;
                                b = looper;
                            }
                            Intrinsics.checkNotNull((Object)looper.getChnext());
                        } while (looper != listHead);
                        if (bestTheta >= 90.0) {
                            b = null;
                            break;
                        }
                        if (Spoint.Companion.angleBetweenPoints(b, c, a) > 90.0) {
                            c = b;
                            continue;
                        }
                        if (Spoint.Companion.angleBetweenPoints(c, a, b) <= 90.0) break;
                        a = b;
                    }
                }
                if (b == null) {
                    Spoint spoint2 = a;
                    Intrinsics.checkNotNull((Object)spoint2);
                    Spoint spoint3 = c;
                    Intrinsics.checkNotNull((Object)spoint3);
                    center = spoint2.add(spoint3.subtract(a).scale(0.5));
                    radius = a.distance(center);
                } else {
                    Spoint ch1 = b.subtract(a).scale(0.5);
                    Spoint spoint4 = c;
                    Intrinsics.checkNotNull((Object)spoint4);
                    Spoint ch2 = spoint4.subtract(a).scale(0.5);
                    Spoint n1 = ch1.normalLeft();
                    Spoint n2 = ch2.normalLeft();
                    Spoint spoint5 = a;
                    Intrinsics.checkNotNull((Object)spoint5);
                    ch1 = spoint5.add(ch1);
                    ch2 = a.add(ch2);
                    center = Spoint.Companion.infiniteLineIntersection(ch1, n1, ch2, n2);
                    if (center != null) {
                        radius = center.distance(a);
                    }
                }
            }
            Ellipse2D.Double mec = null;
            if (center != null) {
                Number number = this.normalizedToWorld(center.getX() - radius, xVariable);
                Intrinsics.checkNotNull((Object)number);
                Number x1 = number;
                Number number2 = this.normalizedToWorld(center.getY() - radius, yVariable);
                Intrinsics.checkNotNull((Object)number2);
                Number y1 = number2;
                Number number3 = this.normalizedToWorld(center.getX() + radius, xVariable);
                Intrinsics.checkNotNull((Object)number3);
                Number x2 = number3;
                Number number4 = this.normalizedToWorld(center.getY() + radius, yVariable);
                Intrinsics.checkNotNull((Object)number4);
                Number y2 = number4;
                double_ = new Ellipse2D.Double(x1.doubleValue(), y1.doubleValue(), x2.doubleValue() - x1.doubleValue(), y2.doubleValue() - y1.doubleValue());
            } else {
                double_ = null;
            }
            mec = double_;
            Map<Pair<Column, Column>, Ellipse2D> map3 = this.mecs;
            Intrinsics.checkNotNull(map3);
            map3.put(pair, (Ellipse2D)mec);
            ellipse2D = (Ellipse2D)mec;
        }
        return ellipse2D;
    }

    @Nullable
    public final GeneralPath getCH(Column xVariable, Column yVariable) {
        GeneralPath generalPath;
        if (this.chs == null) {
            this.chs = new HashMap();
        }
        Column xColumnIndex = xVariable;
        Column yColumnIndex = yVariable;
        Pair<Column, Column> pair = Pair.Companion.create(xColumnIndex, yColumnIndex);
        Map<Pair<Column, Column>, GeneralPath> map = this.chs;
        Intrinsics.checkNotNull(map);
        if (map.containsKey(pair)) {
            Map<Pair<Column, Column>, GeneralPath> map2 = this.chs;
            Intrinsics.checkNotNull(map2);
            generalPath = map2.get(pair);
        } else {
            List<Spoint> points = this.getCHPoints(xVariable, yVariable);
            this.computeCHGraph(points);
            GeneralPath path = new GeneralPath();
            if (!((Collection)points).isEmpty()) {
                Spoint listHead;
                Spoint current = listHead = points.get(0);
                Number number = this.normalizedToWorld(listHead.getX(), xVariable);
                Intrinsics.checkNotNull((Object)number);
                double d = number.doubleValue();
                Number number2 = this.normalizedToWorld(listHead.getY(), yVariable);
                Intrinsics.checkNotNull((Object)number2);
                path.moveTo(d, number2.doubleValue());
                int c = 1;
                while (current.getChprev() != null && current.getChprev() != listHead) {
                    Intrinsics.checkNotNull((Object)current.getChprev());
                    Number number3 = this.normalizedToWorld(current.getX(), xVariable);
                    Intrinsics.checkNotNull((Object)number3);
                    double d2 = number3.doubleValue();
                    Number number4 = this.normalizedToWorld(current.getY(), yVariable);
                    Intrinsics.checkNotNull((Object)number4);
                    path.lineTo(d2, number4.doubleValue());
                    ++c;
                }
                path.closePath();
            }
            Map<Pair<Column, Column>, GeneralPath> map3 = this.chs;
            Intrinsics.checkNotNull(map3);
            map3.put(pair, path);
            generalPath = path;
        }
        return generalPath;
    }

    public final void computeCHGraph(@NotNull List<Spoint> points) {
        Spoint stacktop;
        Intrinsics.checkNotNullParameter(points, (String)"points");
        if (points.size() < 1) {
            return;
        }
        Spoint listHead = points.get(0);
        if (points.size() == 1) {
            listHead.setChprev(listHead);
            listHead.setChnext(listHead.getChprev());
            return;
        }
        if (points.size() == 2) {
            listHead.setChnext(listHead.getNext());
            listHead.setChprev(listHead.getNext());
            listHead.getNext().setChprev(listHead);
            listHead.getNext().setChnext(listHead);
            return;
        }
        int stacksize = 2;
        Spoint spoint = stacktop = listHead.getNext();
        Intrinsics.checkNotNull((Object)spoint);
        spoint.setChnext(null);
        stacktop.setChprev(listHead);
        listHead.setChnext(stacktop);
        listHead.setChprev(null);
        Spoint looper = null;
        for (looper = listHead.getNext().getNext(); looper != null; looper = looper.getNext()) {
            looper.setChprev(null);
            looper.setChnext(looper.getChprev());
            double turn = 0.0;
            do {
                Spoint spoint2 = stacktop.getChprev();
                Intrinsics.checkNotNull((Object)spoint2);
                double d = spoint2.getX() * (stacktop.getY() - looper.getY());
                double d2 = stacktop.getX();
                double d3 = looper.getY();
                Spoint spoint3 = stacktop.getChprev();
                Intrinsics.checkNotNull((Object)spoint3);
                double d4 = d + d2 * (d3 - spoint3.getY());
                double d5 = looper.getX();
                Spoint spoint4 = stacktop.getChprev();
                Intrinsics.checkNotNull((Object)spoint4);
                turn = d4 + d5 * (spoint4.getY() - stacktop.getY());
                if (!(turn > 0.0)) continue;
                Spoint spoint5 = stacktop = stacktop.getChprev();
                Intrinsics.checkNotNull((Object)spoint5);
                Spoint spoint6 = spoint5.getChnext();
                Intrinsics.checkNotNull((Object)spoint6);
                spoint6.setChprev(null);
                stacktop.setChnext(null);
                --stacksize;
            } while (turn > 0.0 && stacksize > 1);
            looper.setChprev(stacktop);
            stacktop.setChnext(looper);
            stacktop = looper;
            ++stacksize;
        }
        looper = listHead;
        while (looper.getChnext() != null) {
            looper = looper.getNext();
        }
        Spoint stackbottom = looper;
        stackbottom.setChnext(listHead);
        stackbottom.setChprev(null);
        listHead.setChprev(stackbottom);
        stacksize = 2;
        for (looper = stackbottom.getNext(); looper != null; looper = looper.getNext()) {
            if (looper.getChnext() != null) continue;
            double turn = 0.0;
            do {
                Spoint spoint7 = stackbottom.getChnext();
                Intrinsics.checkNotNull((Object)spoint7);
                double d = spoint7.getX() * (stackbottom.getY() - looper.getY());
                double d6 = stackbottom.getX();
                double d7 = looper.getY();
                Spoint spoint8 = stackbottom.getChnext();
                Intrinsics.checkNotNull((Object)spoint8);
                double d8 = d + d6 * (d7 - spoint8.getY());
                double d9 = looper.getX();
                Spoint spoint9 = stackbottom.getChnext();
                Intrinsics.checkNotNull((Object)spoint9);
                turn = d8 + d9 * (spoint9.getY() - stackbottom.getY());
                if (!(turn < 0.0)) continue;
                Intrinsics.checkNotNull((Object)stackbottom.getChnext());
                Spoint spoint10 = stackbottom.getChprev();
                Intrinsics.checkNotNull((Object)spoint10);
                spoint10.setChnext(null);
                stackbottom.setChprev(null);
                --stacksize;
            } while (turn < 0.0 && stacksize > 1);
            looper.setChnext(stackbottom);
            stackbottom.setChprev(looper);
            stackbottom = looper;
            ++stacksize;
        }
    }

    private final List<Spoint> getMECPoints(Column xVariable, Column yVariable) {
        List points = new ArrayList();
        Spoint treeRoot = null;
        for (AbstractTreeMapNode<Row, Column> pos : this.getChildren()) {
            Number x2;
            Number y2;
            Number y1;
            Number xc;
            Number yc;
            Number x1;
            if (pos.hasNoChildren()) {
                Number yValue;
                Number xValue;
                Object object = this.getModel().getAggregateValue(pos, xVariable);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
                Intrinsics.checkNotNull((Object)this.worldToNormalized((Number)object, xVariable));
                Object object2 = this.getModel().getAggregateValue(pos, yVariable);
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Number");
                Intrinsics.checkNotNull((Object)this.worldToNormalized((Number)object2, yVariable));
                treeRoot = this.addPoint(points, treeRoot, xValue, yValue);
                continue;
            }
            Intrinsics.checkNotNull(pos, (String)"null cannot be cast to non-null type com.treemap.ParentTreeMapNode<Row of com.treemap.ParentTreeMapNode, Column of com.treemap.ParentTreeMapNode>");
            Ellipse2D ellipse = ((ParentTreeMapNode)pos).getMEC(xVariable, yVariable);
            if (ellipse == null) continue;
            Intrinsics.checkNotNull((Object)this.worldToNormalized(ellipse.getMinX(), xVariable));
            Intrinsics.checkNotNull((Object)this.worldToNormalized(ellipse.getCenterX(), xVariable));
            Intrinsics.checkNotNull((Object)this.worldToNormalized(ellipse.getMaxX(), xVariable));
            Intrinsics.checkNotNull((Object)this.worldToNormalized(ellipse.getMinY(), yVariable));
            Intrinsics.checkNotNull((Object)this.worldToNormalized(ellipse.getCenterY(), yVariable));
            Intrinsics.checkNotNull((Object)this.worldToNormalized(ellipse.getMaxY(), yVariable));
            treeRoot = this.addPoint(points, treeRoot, x1, yc);
            treeRoot = this.addPoint(points, treeRoot, xc, y1);
            treeRoot = this.addPoint(points, treeRoot, xc, y2);
            treeRoot = this.addPoint(points, treeRoot, x2, yc);
        }
        return points;
    }

    @NotNull
    public final List<Spoint> getCHPoints(@Nullable Column xVariable, @Nullable Column yVariable) {
        List points = new ArrayList();
        Spoint treeRoot = null;
        for (AbstractTreeMapNode<Row, Column> pos : this.getChildren()) {
            if (pos.hasNoChildren()) {
                Number yValue;
                Number xValue;
                Object object = this.getModel().getAggregateValue(pos, xVariable);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
                Intrinsics.checkNotNull((Object)this.worldToNormalized((Number)object, xVariable));
                Object object2 = this.getModel().getAggregateValue(pos, yVariable);
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Number");
                Intrinsics.checkNotNull((Object)this.worldToNormalized((Number)object2, yVariable));
                treeRoot = this.addPoint(points, treeRoot, xValue, yValue);
                continue;
            }
            Intrinsics.checkNotNull(pos, (String)"null cannot be cast to non-null type com.treemap.ParentTreeMapNode<Row of com.treemap.ParentTreeMapNode, Column of com.treemap.ParentTreeMapNode>");
            List<Spoint> list = ((ParentTreeMapNode)pos).getCHPoints(xVariable, yVariable);
            for (Spoint spoint : list) {
                treeRoot = this.addPoint(points, treeRoot, spoint.getX(), spoint.getY());
            }
        }
        return points;
    }

    private final Spoint addPoint(List<Spoint> points, Spoint treeRoot, Number xValue, Number yValue) {
        if (xValue != null && yValue != null) {
            Spoint where = new Spoint(xValue.doubleValue(), yValue.doubleValue());
            if (treeRoot != null) {
                if (treeRoot.Insert(where)) {
                    if (where.getPrev() == null) {
                        points.add(0, where);
                    } else {
                        points.add(where);
                    }
                    return treeRoot;
                }
            } else {
                points.add(0, where);
                return where;
            }
        }
        return treeRoot;
    }
}

