/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mkui.geom.AffineTransform;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle2D;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 &2\u00020\u0001:\u0001&B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0007B)\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\t\u00a2\u0006\u0004\b\u0002\u0010\rJ\u000e\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005J\u000e\u0010\u001c\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0016\u0010!\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tJ\u0016\u0010\"\u001a\u00020 2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020\u0000R\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u001a\u0010\u0016\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0010\"\u0004\b\u0018\u0010\u0012R\u001a\u0010\u0019\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0010\"\u0004\b\u001b\u0010\u0012\u00a8\u0006'"}, d2={"Lcom/treemap/RectangularTransform;", "", "<init>", "()V", "oldRect", "Lorg/mkui/geom/Rectangle2D;", "newRect", "(Lorg/mkui/geom/Rectangle2D;Lorg/mkui/geom/Rectangle2D;)V", "sx", "", "sy", "tx", "ty", "(DDDD)V", "translateX", "getTranslateX", "()D", "setTranslateX", "(D)V", "translateY", "getTranslateY", "setTranslateY", "scaleX", "getScaleX", "setScaleX", "scaleY", "getScaleY", "setScaleY", "transform", "src", "Lorg/mkui/geom/Point2D;", "setTransform", "", "translate", "scale", "createAffineTransform", "Lorg/mkui/geom/AffineTransform;", "createInverse", "Companion", "treemap"})
@StabilityInferred(parameters=0)
public final class RectangularTransform {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double translateX;
    private double translateY;
    private double scaleX;
    private double scaleY;
    public static final int $stable = 8;

    public final double getTranslateX() {
        return this.translateX;
    }

    public final void setTranslateX(double d) {
        this.translateX = d;
    }

    public final double getTranslateY() {
        return this.translateY;
    }

    public final void setTranslateY(double d) {
        this.translateY = d;
    }

    public final double getScaleX() {
        return this.scaleX;
    }

    public final void setScaleX(double d) {
        this.scaleX = d;
    }

    public final double getScaleY() {
        return this.scaleY;
    }

    public final void setScaleY(double d) {
        this.scaleY = d;
    }

    public RectangularTransform() {
        this.scaleX = 1.0;
        this.scaleY = 1.0;
    }

    public RectangularTransform(@NotNull Rectangle2D oldRect, @NotNull Rectangle2D newRect) {
        Intrinsics.checkNotNullParameter((Object)oldRect, (String)"oldRect");
        Intrinsics.checkNotNullParameter((Object)newRect, (String)"newRect");
        this.scaleX = 1.0;
        this.scaleY = 1.0;
        this.setTransform(oldRect, newRect);
    }

    public RectangularTransform(double sx, double sy, double tx, double ty) {
        this.scaleX = 1.0;
        this.scaleY = 1.0;
        this.scaleX = sx;
        this.scaleY = sy;
        this.translateX = tx;
        this.translateY = ty;
    }

    @NotNull
    public final Rectangle2D transform(@NotNull Rectangle2D src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return (Rectangle2D)new Rectangle2D.Double(src.getX() * this.scaleX + this.translateX, src.getY() * this.scaleY + this.translateY, src.getWidth() * this.scaleX, src.getHeight() * this.scaleY);
    }

    @NotNull
    public final Point2D transform(@NotNull Point2D src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return (Point2D)new Point2D.Double(src.getX() * this.scaleX + this.translateX, src.getY() * this.scaleY + this.translateY);
    }

    public final void setTransform(@NotNull Rectangle2D oldRect, @NotNull Rectangle2D newRect) {
        Intrinsics.checkNotNullParameter((Object)oldRect, (String)"oldRect");
        Intrinsics.checkNotNullParameter((Object)newRect, (String)"newRect");
        this.scaleX = newRect.getWidth() / oldRect.getWidth();
        this.scaleY = newRect.getHeight() / oldRect.getHeight();
        this.translateX = -oldRect.getX() * this.scaleX + newRect.getX();
        this.translateY = -oldRect.getY() * this.scaleY + newRect.getY();
    }

    public final void translate(double tx, double ty) {
        this.translateX = tx * this.scaleX + this.translateX;
        this.translateY = ty * this.scaleY + this.translateY;
    }

    public final void scale(double sx, double sy) {
        this.scaleX *= sx;
        this.scaleY *= sy;
    }

    @NotNull
    public final AffineTransform createAffineTransform() {
        return new AffineTransform(this.scaleX, 0.0, 0.0, this.scaleY, this.translateX, this.translateY);
    }

    @NotNull
    public final RectangularTransform createInverse() {
        return new RectangularTransform(1.0 / this.scaleX, 1.0 / this.scaleY, -this.translateX / this.scaleX, -this.translateY / this.scaleY);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lcom/treemap/RectangularTransform$Companion;", "", "<init>", "()V", "create", "Lorg/mkui/geom/AffineTransform;", "oldRect", "Lorg/mkui/geom/Rectangle2D;", "newRect", "treemap"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AffineTransform create(@NotNull Rectangle2D oldRect, @NotNull Rectangle2D newRect) {
            Intrinsics.checkNotNullParameter((Object)oldRect, (String)"oldRect");
            Intrinsics.checkNotNullParameter((Object)newRect, (String)"newRect");
            double scaleX = newRect.getWidth() / oldRect.getWidth();
            double scaleY = newRect.getHeight() / oldRect.getHeight();
            double translateX = -oldRect.getX() * scaleX + newRect.getX();
            double translateY = -oldRect.getY() * scaleY + newRect.getY();
            return new AffineTransform(scaleX, 0.0, 0.0, scaleY, translateX, translateY);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

