/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.SimpleProperties;
import com.treemap.AbstractAlgorithm;
import com.treemap.TreeMapAccessor;
import com.treemap.TreeMapWorker;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0007\u0018\u0000 .2\u00020\u0001:\u0001.B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003Jm\u0010\f\u001a\u00020\r\"\u0004\b\u0000\u0010\u000e\"\u0004\b\u0001\u0010\u000f\"\u0004\b\u0002\u0010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u0002H\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eJQ\u0010\u001f\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u000e2\u000e\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u000e0\u00152\u0006\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u001bH\u0002\u00a2\u0006\u0002\u0010%J\u0018\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u000bH\u0002J\u0018\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u000bH\u0002J\u0012\u0010,\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010-\u001a\u00020\u0006H\u0016R\u001c\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/treemap/SquarifiedPlusAlgorithm;", "Lcom/treemap/AbstractAlgorithm;", "<init>", "()V", "properties", "Lcom/macrofocus/common/properties/MutableProperties;", "", "getProperties", "()Lcom/macrofocus/common/properties/MutableProperties;", "desiredAspectRatio", "Lcom/macrofocus/common/properties/MutableProperty;", "", "breadthFirstLayout", "", "N", "Row", "Column", "shape", "Lorg/mkui/geom/Shape;", "parent", "children", "", "sumSize", "horizontalVanishingPoint", "", "verticalVanishingPoint", "accessor", "Lcom/treemap/TreeMapAccessor;", "worker", "Lcom/treemap/TreeMapWorker;", "(Lorg/mkui/geom/Shape;Ljava/lang/Object;[Ljava/lang/Object;DIILcom/treemap/TreeMapAccessor;Lcom/treemap/TreeMapWorker;)Z", "bestAspectRatio", "nodes", "current", "last", "side", "sizeFactor", "([Ljava/lang/Object;IIDDLcom/treemap/TreeMapAccessor;)D", "computeAspectRatio", "area", "width", "willImprove", "actualAR", "expandedAR", "isCompatible", "toString", "Companion", "treemap"})
@StabilityInferred(parameters=0)
public final class SquarifiedPlusAlgorithm
extends AbstractAlgorithm {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MutableProperties<String> properties = (MutableProperties)new SimpleProperties();
    @NotNull
    private final MutableProperty<Double> desiredAspectRatio = this.getProperties().createProperty((Object)"desiredAspectRatio", (Object)1.0);
    public static final int $stable = 8;

    @Override
    @NotNull
    public MutableProperties<String> getProperties() {
        return this.properties;
    }

    @Override
    public <N, Row, Column> boolean breadthFirstLayout(@NotNull Shape shape, N parent, @NotNull N[] children, double sumSize, int horizontalVanishingPoint, int verticalVanishingPoint, @NotNull TreeMapAccessor<? super N> accessor, @Nullable TreeMapWorker worker) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter(accessor, (String)"accessor");
        Rectangle2D bounds = null;
        bounds = shape.getBounds2D();
        int hvp = 0;
        hvp = horizontalVanishingPoint == 0 ? 4 : horizontalVanishingPoint;
        int vvp = 0;
        vvp = verticalVanishingPoint == 0 ? 3 : verticalVanishingPoint;
        double sizeFactor = bounds.getWidth() * bounds.getHeight() / sumSize;
        int current = 0;
        while (current < children.length) {
            double longestSide;
            int last = 0;
            last = current;
            double totalArea = 0.0;
            double previousWorstAspectRatio = Double.POSITIVE_INFINITY;
            double desiredSize = 0.0;
            boolean horizontalSplit = false;
            horizontalSplit = bounds.getWidth() > bounds.getHeight() * ((Number)this.desiredAspectRatio.getValue()).doubleValue();
            double shortestSide = horizontalSplit ? bounds.getHeight() : bounds.getWidth();
            double d = longestSide = horizontalSplit ? bounds.getWidth() : bounds.getHeight();
            while (last < children.length) {
                int n;
                double lastArea = accessor.getSize(children[last]) * sizeFactor;
                desiredSize = (totalArea += lastArea) / shortestSide;
                double currentArea = accessor.getSize(children[current]) * sizeFactor;
                double lastWorstAspectRatio = this.computeAspectRatio(lastArea, desiredSize);
                double currentWorstAspectRatio = this.computeAspectRatio(currentArea, desiredSize);
                double worstAspectRatio = 0.0;
                double d2 = worstAspectRatio = !Double.isInfinite(currentWorstAspectRatio) ? Math.max(currentWorstAspectRatio, lastWorstAspectRatio) : lastWorstAspectRatio;
                if (worstAspectRatio > previousWorstAspectRatio) {
                    double alternativeAR;
                    desiredSize = (totalArea -= lastArea) / shortestSide;
                    n = last;
                    last = n + -1;
                    SquarifiedPlusAlgorithm $this$breadthFirstLayout_u24lambda_u240 = this;
                    boolean bl = false;
                    double alternativeDesiredSize = totalArea / longestSide;
                    double actualAR = $this$breadthFirstLayout_u24lambda_u240.bestAspectRatio(children, current, last, desiredSize, sizeFactor, accessor);
                    if (!$this$breadthFirstLayout_u24lambda_u240.willImprove(actualAR, alternativeAR = $this$breadthFirstLayout_u24lambda_u240.bestAspectRatio(children, current, last, alternativeDesiredSize, sizeFactor, accessor))) break;
                    desiredSize = alternativeDesiredSize;
                    horizontalSplit = !horizontalSplit;
                    break;
                }
                if (!Double.isNaN(worstAspectRatio)) {
                    previousWorstAspectRatio = worstAspectRatio;
                }
                n = last;
                last = n + 1;
            }
            if (last == children.length) {
                int n = last;
                last = n + -1;
            }
            SquarifiedPlusAlgorithm $this$breadthFirstLayout_u24lambda_u241 = this;
            boolean bl = false;
            double x = bounds.getX();
            double y = bounds.getY();
            int i = current;
            int n = last;
            if (i <= n) {
                while (true) {
                    double size = accessor.getSize(children[i]) * sizeFactor / desiredSize;
                    if (horizontalSplit) {
                        switch (hvp) {
                            case 2: {
                                accessor.setShape(children[i], (Shape)new Rectangle2D.Double(x + bounds.getWidth() - desiredSize, y, desiredSize, size));
                                break;
                            }
                            case 4: {
                                accessor.setShape(children[i], (Shape)new Rectangle2D.Double(x, y, desiredSize, size));
                            }
                        }
                        y += size;
                    } else {
                        block4 : switch (vvp) {
                            case 1: {
                                switch (hvp) {
                                    case 2: {
                                        accessor.setShape(children[i], (Shape)new Rectangle2D.Double(x + bounds.getWidth() - size, y + bounds.getHeight() - desiredSize, size, desiredSize));
                                        x -= size;
                                        break block4;
                                    }
                                    case 4: {
                                        accessor.setShape(children[i], (Shape)new Rectangle2D.Double(x, y + bounds.getHeight() - desiredSize, size, desiredSize));
                                        x += size;
                                        break block4;
                                    }
                                }
                                throw new IllegalArgumentException();
                            }
                            case 3: {
                                switch (hvp) {
                                    case 2: {
                                        accessor.setShape(children[i], (Shape)new Rectangle2D.Double(x + bounds.getWidth() - size, y, size, desiredSize));
                                        x -= size;
                                        break block4;
                                    }
                                    case 4: {
                                        accessor.setShape(children[i], (Shape)new Rectangle2D.Double(x, y, size, desiredSize));
                                        x += size;
                                        break block4;
                                    }
                                }
                                throw new IllegalArgumentException();
                            }
                            default: {
                                throw new IllegalArgumentException();
                            }
                        }
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            current = last + 1;
            if (horizontalSplit) {
                bounds = switch (hvp) {
                    case 2 -> new Rectangle2D.Double(bounds.getX(), bounds.getY(), Math.max(0.0, bounds.getWidth() - desiredSize), bounds.getHeight());
                    case 4 -> new Rectangle2D.Double(bounds.getX() + desiredSize, bounds.getY(), Math.max(0.0, bounds.getWidth() - desiredSize), bounds.getHeight());
                    default -> throw new IllegalArgumentException();
                };
                if (horizontalVanishingPoint != 0) continue;
                hvp = hvp == 2 ? 4 : 2;
                continue;
            }
            bounds = switch (vvp) {
                case 1 -> new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), Math.max(0.0, bounds.getHeight() - desiredSize));
                case 3 -> new Rectangle2D.Double(bounds.getX(), bounds.getY() + desiredSize, bounds.getWidth(), Math.max(0.0, bounds.getHeight() - desiredSize));
                default -> throw new IllegalArgumentException();
            };
            if (verticalVanishingPoint != 0) continue;
            vvp = vvp == 3 ? 1 : 3;
        }
        return false;
    }

    private final <N> double bestAspectRatio(N[] nodes, int current, int last, double side, double sizeFactor, TreeMapAccessor<? super N> accessor) {
        if (nodes == null || nodes.length == 0) {
            return Double.MAX_VALUE;
        }
        double max = 0.0;
        int i = current;
        if (i <= last) {
            while (true) {
                N node;
                double m;
                if ((m = this.computeAspectRatio(accessor.getSize(node = nodes[i]) * sizeFactor, side)) > max) {
                    max = m;
                }
                if (i == last) break;
                ++i;
            }
        }
        return max;
    }

    private final double computeAspectRatio(double area, double width) {
        double aspectRatio = area / (width * width * ((Number)this.desiredAspectRatio.getValue()).doubleValue());
        if (aspectRatio < 1.0) {
            aspectRatio = 1.0 / aspectRatio;
        }
        return aspectRatio;
    }

    private final boolean willImprove(double actualAR, double expandedAR) {
        double v2;
        if (actualAR == 0.0) {
            return true;
        }
        if (expandedAR == 0.0) {
            return false;
        }
        double v1 = Math.abs(actualAR - ((Number)this.desiredAspectRatio.getValue()).doubleValue());
        return v1 > (v2 = Math.abs(expandedAR - ((Number)this.desiredAspectRatio.getValue()).doubleValue()));
    }

    @Override
    public boolean isCompatible(@Nullable Shape shape) {
        return shape instanceof Rectangle2D;
    }

    @NotNull
    public String toString() {
        return SquarifiedPlusAlgorithm.Companion.getName();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lcom/treemap/SquarifiedPlusAlgorithm$Companion;", "", "<init>", "()V", "getName", "", "getAspectRatio", "", "shape", "Lorg/mkui/geom/Rectangle2D;", "treemap"})
    public static final class Companion {
        private Companion() {
        }

        private final String getName() {
            return "Squarified+";
        }

        private final double getAspectRatio(Rectangle2D shape) {
            return shape.getWidth() > shape.getHeight() ? shape.getWidth() / shape.getHeight() : shape.getHeight() / shape.getWidth();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

