/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.tagcloud;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.collection.StackKt;
import com.treemap.tagcloud.HierarchicalBoundingBox;
import com.treemap.tagcloud.HierarchicalBoundingBoxPair;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0000J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/treemap/tagcloud/HierarchicalBoundingBoxes;", "", "shape", "Lorg/mkui/geom/Shape;", "depth", "", "sizeFactor", "", "<init>", "(Lorg/mkui/geom/Shape;ID)V", "topBox", "Lcom/treemap/tagcloud/HierarchicalBoundingBox;", "intersects", "", "otherBoundingBoxes", "setTranslation", "", "xPos", "yPos", "treemap"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nHierarchicalBoundingBoxes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HierarchicalBoundingBoxes.kt\ncom/treemap/tagcloud/HierarchicalBoundingBoxes\n+ 2 Stack.kt\ncom/macrofocus/common/collection/StackKt\n*L\n1#1,66:1\n12#2:67\n12#2:68\n*S KotlinDebug\n*F\n+ 1 HierarchicalBoundingBoxes.kt\ncom/treemap/tagcloud/HierarchicalBoundingBoxes\n*L\n19#1:67\n32#1:68\n*E\n"})
public final class HierarchicalBoundingBoxes {
    @NotNull
    private final HierarchicalBoundingBox topBox;
    public static final int $stable = 8;

    public HierarchicalBoundingBoxes(@NotNull Shape shape, int depth, double sizeFactor) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Rectangle2D b = shape.getBounds2D();
        Rectangle2D bounds = (Rectangle2D)new Rectangle2D.Double(b.getX(), b.getY(), b.getWidth(), b.getHeight());
        double aspect = bounds.getWidth() / bounds.getHeight();
        double sizeIncrease = 0.0;
        sizeIncrease = aspect > 1.0 ? bounds.getWidth() * (sizeFactor - 1.0) : bounds.getHeight() * (sizeFactor - 1.0);
        bounds = (Rectangle2D)new Rectangle2D.Double(bounds.getX() - sizeIncrease / 2.0, bounds.getY() - sizeIncrease / 2.0, bounds.getWidth() + sizeIncrease, bounds.getHeight() + sizeIncrease);
        this.topBox = new HierarchicalBoundingBox((Rectangle2D)new Rectangle2D.Double(((Rectangle2D.Double)bounds).getX(), ((Rectangle2D.Double)bounds).getY(), ((Rectangle2D.Double)bounds).getWidth(), ((Rectangle2D.Double)bounds).getHeight()), shape, depth - 1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean intersects(@NotNull HierarchicalBoundingBoxes otherBoundingBoxes) {
        Intrinsics.checkNotNullParameter((Object)otherBoundingBoxes, (String)"otherBoundingBoxes");
        HierarchicalBoundingBox current = this.topBox;
        HierarchicalBoundingBox other = otherBoundingBoxes.topBox;
        if (current.getBounds().intersects(other.getBounds())) {
            void $this$push$iv;
            List boxes;
            List list = boxes = (List)new ArrayList();
            HierarchicalBoundingBox[] item$iv = new HierarchicalBoundingBoxPair(this.topBox, otherBoundingBoxes.topBox);
            int $i$f$push2 = 0;
            $this$push$iv.add(item$iv);
            do {
                HierarchicalBoundingBox[] currentChildren = null;
                if (!current.isLeaf()) {
                    currentChildren = current.getChildren();
                } else {
                    item$iv = new HierarchicalBoundingBox[]{current};
                    currentChildren = item$iv;
                }
                HierarchicalBoundingBox[] otherChildren = null;
                if (!other.isLeaf()) {
                    otherChildren = other.getChildren();
                } else {
                    HierarchicalBoundingBox[] $i$f$push2 = new HierarchicalBoundingBox[]{other};
                    otherChildren = $i$f$push2;
                }
                for (HierarchicalBoundingBox currentChild : currentChildren) {
                    if (currentChild == null) continue;
                    for (HierarchicalBoundingBox otherChild : otherChildren) {
                        void $this$push$iv2;
                        if (otherChild == null || !currentChild.getBounds().intersects(otherChild.getBounds())) continue;
                        if (currentChild.isLeaf() && otherChild.isLeaf()) {
                            return true;
                        }
                        List list2 = boxes;
                        HierarchicalBoundingBoxPair item$iv2 = new HierarchicalBoundingBoxPair(currentChild, otherChild);
                        boolean $i$f$push3 = false;
                        $this$push$iv2.add(item$iv2);
                    }
                }
                Object object = StackKt.pop((List)boxes);
                Intrinsics.checkNotNull((Object)object);
                HierarchicalBoundingBoxPair pair = (HierarchicalBoundingBoxPair)object;
                current = pair.getThisBox();
                other = pair.getOtherBox();
            } while (!boxes.isEmpty());
        }
        return false;
    }

    public final void setTranslation(double xPos, double yPos) {
        this.topBox.setTranslation(xPos, yPos);
    }
}

