/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.geom.Dimension;
import com.macrofocus.common.geom.PreferredSize;
import com.macrofocus.common.math.MathKt;
import com.treemap.AbstractLabeling;
import com.treemap.Algorithm;
import com.treemap.Depth;
import com.treemap.Labeling;
import com.treemap.RectangularTransform;
import com.treemap.Rendering;
import com.treemap.TreeMapColumnSettings;
import com.treemap.TreeMapLabelRenderer;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapView;
import com.treemap.crossplatform.TGraphics;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.font.MkFontKt;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;
import org.mkui.geom.TextShape;
import org.mkui.labeling.ContrastEnhancement;
import org.mkui.labeling.EnhancedLabel;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b'\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0007\"\u0004\b\u0002\u0010\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b0\nH\u0016JO\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00060\f\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0007\"\u0004\b\u0002\u0010\b2\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b0\u000e2\u0006\u0010\u000f\u001a\u0002H\u00062\u0006\u0010\u0010\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0011JO\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00060\f\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0007\"\u0004\b\u0002\u0010\b2\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b0\u000e2\u0006\u0010\u000f\u001a\u0002H\u00062\u0006\u0010\u0010\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0011Ja\u0010\u0013\u001a\u00020\u0014\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0007\"\u0004\b\u0002\u0010\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b0\u000e2\u0006\u0010\u0017\u001a\u0002H\u00062\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJc\u0010\u001d\u001a\u00020\u001b\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0007\"\u0004\b\u0002\u0010\b2\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b0\u000e2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b0\n2\u0006\u0010\u0017\u001a\u0002H\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a2\u0006\u0002\u0010\u001eJi\u0010\u001f\u001a\u00020\u0014\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0007\"\u0004\b\u0002\u0010\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b0\u000e2\u0006\u0010\u0017\u001a\u0002H\u00062\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a2\u0006\u0002\u0010!JI\u0010\"\u001a\n\u0018\u00010#j\u0004\u0018\u0001`$\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0007\"\u0004\b\u0002\u0010\b2\u0006\u0010\u0017\u001a\u0002H\u00062\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b0\nH\u0016\u00a2\u0006\u0002\u0010%J\u0010\u0010&\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002Ji\u0010'\u001a\u00020\u0014\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0007\"\u0004\b\u0002\u0010\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b0\u000e2\u0006\u0010\u0017\u001a\u0002H\u00062\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a2\u0006\u0002\u0010!JY\u0010(\u001a\u00020\u0014\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0007\"\u0004\b\u0002\u0010\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u0002H\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b0\nH\u0016\u00a2\u0006\u0002\u0010)Jc\u0010*\u001a\u00020\u0014\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0007\"\u0004\b\u0002\u0010\b2\u0006\u0010+\u001a\u00020\u00162\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b0\u000e2\u0006\u0010\u0017\u001a\u0002H\u00062\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016\u00a2\u0006\u0002\u0010\u001c\u00a8\u0006-"}, d2={"Lcom/treemap/AbstractRendering;", "Lcom/treemap/Rendering;", "<init>", "()V", "getPasses", "", "N", "Row", "Column", "model", "Lcom/treemap/TreeMapModel;", "getParentOrder", "", "view", "Lcom/treemap/TreeMapView;", "root", "pass", "(Lcom/treemap/TreeMapView;Ljava/lang/Object;I)Ljava/lang/Iterable;", "getOrder", "paintParent", "", "g", "Lcom/treemap/crossplatform/TGraphics;", "node", "bounds", "Lorg/mkui/geom/Rectangle;", "shape", "Lorg/mkui/geom/Shape;", "(Lcom/treemap/crossplatform/TGraphics;Lcom/treemap/TreeMapView;Ljava/lang/Object;ILorg/mkui/geom/Rectangle;Lorg/mkui/geom/Shape;)V", "getRenderedShape", "(Lcom/treemap/TreeMapView;Lcom/treemap/TreeMapModel;Ljava/lang/Object;Lorg/mkui/geom/Shape;)Lorg/mkui/geom/Shape;", "paintBackground", "passes", "(Lcom/treemap/crossplatform/TGraphics;Lcom/treemap/TreeMapView;Ljava/lang/Object;IILorg/mkui/geom/Rectangle;Lorg/mkui/geom/Shape;)V", "getNestingBackground", "Ljava/awt/Color;", "Lorg/mkui/color/MkColor;", "(Ljava/lang/Object;Lcom/treemap/TreeMapModel;)Ljava/awt/Color;", "computeBounds", "paintLabel", "paintParentBorder", "(Lcom/treemap/crossplatform/TGraphics;Ljava/lang/Object;Lorg/mkui/geom/Rectangle;Lorg/mkui/geom/Shape;Lcom/treemap/TreeMapModel;)V", "paintParentHighlight", "g2", "Companion", "treemap"})
@StabilityInferred(parameters=1)
public abstract class AbstractRendering
implements Rendering {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    protected static final float COLOR_SIMILARITY_THRESHOLD = 0.5f;

    @Override
    public <N, Row, Column> int getPasses(@NotNull TreeMapModel<N, Row, Column> model) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Column heightColumn = model.getSettings().getHeightColumn();
        return heightColumn != null && (model.isNumericType(heightColumn) || model.isTemporalType(heightColumn)) ? 2 : 1;
    }

    @Override
    @NotNull
    public <N, Row, Column> Iterable<N> getParentOrder(@NotNull TreeMapView<N, Row, Column> view, N root, int pass) {
        Iterable<N> iterable;
        Intrinsics.checkNotNullParameter(view, (String)"view");
        if (pass == 0) {
            TreeMapModel<N, Row, Column> treeMapModel = view.getModel();
            Intrinsics.checkNotNull(treeMapModel);
            iterable = treeMapModel.parentPreorderEnumeration(root);
        } else {
            iterable = CollectionsKt.emptyList();
        }
        return iterable;
    }

    @Override
    @NotNull
    public <N, Row, Column> Iterable<N> getOrder(@NotNull TreeMapView<N, Row, Column> view, N root, int pass) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter(view, (String)"view");
        TreeMapModel<N, Row, Column> treeMapModel = view.getModel();
        Intrinsics.checkNotNull(treeMapModel);
        TreeMapModel<N, Row, Column> model = treeMapModel;
        if (pass == 0) {
            iterable = model.preorderEnumeration(root);
        } else {
            List nodes = new ArrayList();
            for (N node : model.preorderEnumeration(root)) {
                if (!model.hasNoChildren(node)) continue;
                nodes.add(node);
            }
            CollectionsKt.sortedWith((Iterable)nodes, (Comparator)new Comparator<N>(view, model){
                final /* synthetic */ TreeMapView<N, Row, Column> $view;
                final /* synthetic */ TreeMapModel<N, Row, Column> $model;
                {
                    this.$view = $view;
                    this.$model = $model;
                }

                public int compare(N a, N b) {
                    int n;
                    Shape p1 = this.$view.worldToScreen(a);
                    Shape p2 = this.$view.worldToScreen(b);
                    if (p1 != null) {
                        if (p2 != null) {
                            Dimension dimension = this.$model.getSettings().getDimension();
                            if (dimension != null) {
                                double width = dimension.getWidth();
                                double height = dimension.getHeight();
                                double rx1 = p1.getBounds2D().getCenterX() / width;
                                double ry1 = p1.getBounds2D().getCenterY() / height;
                                double rx2 = p2.getBounds2D().getCenterX() / width;
                                double ry2 = p2.getBounds2D().getCenterY() / height;
                                n = MathKt.compare((double)(rx1 + ry1), (double)(rx2 + ry2));
                            } else {
                                n = MathKt.compare((double)(p1.getBounds2D().getCenterX() + p1.getBounds2D().getCenterY()), (double)(p2.getBounds2D().getCenterX() + p2.getBounds2D().getCenterY()));
                            }
                        } else {
                            n = 1;
                        }
                    } else {
                        n = p2 != null ? -1 : 0;
                    }
                    return n;
                }
            });
            iterable = nodes;
        }
        return iterable;
    }

    @Override
    public <N, Row, Column> void paintParent(@NotNull TGraphics g, @NotNull TreeMapView<N, Row, Column> view, N node, int pass, @NotNull Rectangle bounds, @NotNull Shape shape) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        TreeMapModel<N, Row, Column> treeMapModel = view.getModel();
        Intrinsics.checkNotNull(treeMapModel);
        TreeMapModel<N, Row, Column> model = treeMapModel;
        if (pass == 0 && !model.hasNoChildren(node)) {
            int n = model.getLevel(node);
            N n2 = model.getCurrentRoot();
            Intrinsics.checkNotNull(n2);
            int depth = n - model.getLevel(n2);
            Algorithm algorithm = model.getSettings().getColumnSettings(model.getGroupByColumn(node)).getAlgorithm();
            Depth depth2 = model.getSettings().getDepth();
            Intrinsics.checkNotNull((Object)depth2);
            if (depth2.display(depth + 1) && algorithm.isCompatible(model.getShape(node)) && !algorithm.isColorParent()) {
                Color color = this.getNestingBackground(node, model);
                if (color != null) {
                    g.setFill(color);
                } else {
                    g.setFill(view.getBackground());
                }
                g.fill(shape);
            } else if (model.getCurrentRoot() != node) {
                this.paintNode(g, view, node, pass, bounds, shape);
            }
        }
    }

    @Override
    @NotNull
    public <N, Row, Column> Shape getRenderedShape(@NotNull TreeMapView<N, Row, Column> view, @NotNull TreeMapModel<N, Row, Column> model, N node, @NotNull Shape shape) {
        Column heightColumn;
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        if (node != null && model.hasNoChildren(node) && (heightColumn = model.getSettings().getHeightColumn()) != null && (model.isNumericType(heightColumn) || model.isTemporalType(heightColumn))) {
            Double minHeight = model.getNumericMin(heightColumn);
            Double maxHeight = model.getNumericMax(heightColumn);
            Object value = model.getValueAt(node, heightColumn);
            if (value != null && maxHeight != null && minHeight != null) {
                double height = 0.0;
                height = value instanceof Number ? ((Number)value).doubleValue() : 0.0;
                double range = maxHeight - minHeight;
                double ratio = Math.abs((height - minHeight) / range);
                if (shape instanceof Rectangle2D) {
                    Rectangle2D top = (Rectangle2D)shape;
                    double d = (double)view.getZoomFactor() * -model.getSettings().getMaximumHeight();
                    Dimension dimension = model.getSettings().getDimension();
                    Intrinsics.checkNotNull((Object)dimension);
                    double d2 = dimension.getWidth();
                    Dimension dimension2 = model.getSettings().getDimension();
                    Intrinsics.checkNotNull((Object)dimension2);
                    double maxSize = d * Math.min(d2, dimension2.getHeight());
                    int shift = (int)(maxSize * ratio);
                    RectangularTransform at = new RectangularTransform();
                    at.translate(shift, shift);
                    return (Shape)at.transform(top);
                }
            }
        }
        return shape;
    }

    @Override
    public <N, Row, Column> void paintBackground(@NotNull TGraphics g, @NotNull TreeMapView<N, Row, Column> view, N node, int pass, int passes, @NotNull Rectangle bounds, @NotNull Shape shape) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Shape shape2 = shape;
        if (pass == passes - 1) {
            TreeMapModel<N, Row, Column> treeMapModel = view.getModel();
            Intrinsics.checkNotNull(treeMapModel);
            TreeMapModel<N, Row, Column> model = treeMapModel;
            shape2 = this.getRenderedShape(view, model, node, shape2);
            Rectangle bounds2 = this.computeBounds(shape2);
            g.save();
            g.clip(shape2);
            Column column = model.getSettings().getBackgroundColumn();
            if (column != null && bounds2.getWidth() > 1.0 && bounds2.getHeight() > 1.0) {
                TreeMapColumnSettings columnSettings = model.getSettings().getColumnSettings(column);
                Font font = columnSettings.getLabelingFont();
                if (bounds2.getWidth() > 5.0) {
                    double d = bounds2.getHeight();
                    Font font2 = font;
                    Intrinsics.checkNotNull((Object)font2);
                    if (d >= MkFontKt.getFontSize((Font)font2)) {
                        TreeMapLabelRenderer<N, Row, Column> treeMapLabelRenderer = view.getLabelRenderer();
                        Intrinsics.checkNotNull(treeMapLabelRenderer);
                        EnhancedLabel enhancedLabel = treeMapLabelRenderer.getTreeMapLabelRendererComponent(view, column, node, new Dimension(bounds2.getIwidth(), bounds2.getIheight()));
                        Intrinsics.checkNotNull((Object)enhancedLabel);
                        EnhancedLabel elabel = enhancedLabel;
                        PreferredSize pf = g.sizeLabel(elabel, bounds2.getIwidth(), bounds2.getIheight());
                        int innerWidth = bounds2.getIwidth() - elabel.getInsetRight() - elabel.getInsetLeft();
                        int innerHeight = bounds2.getIheight() - elabel.getInsetTop() - elabel.getInsetBottom();
                        Color background = model.getSettings().getColumnSettings(column).getLabelingEffectColor();
                        Color foreground = model.getSettings().getColumnSettings(column).getLabelingForeground();
                        Color nodeColor = model.getColor(node);
                        if (foreground != null && background == null && nodeColor != null) {
                            ContrastEnhancement contrastEnhancement = model.getSettings().getColumnSettings(column).getLabelingContrastEnhancement();
                            Intrinsics.checkNotNull((Object)contrastEnhancement);
                            foreground = contrastEnhancement.adjustLabelColor(foreground, nodeColor);
                        }
                        elabel.setFont(font);
                        Color color = foreground;
                        Intrinsics.checkNotNull((Object)color);
                        elabel.setForeground(color);
                        elabel.setBackground(background);
                        Dimension preferredSize = pf.getPreferredSize();
                        double fontSize = 0.0;
                        if (columnSettings.getLabelingRendering() != EnhancedLabel.Rendering.WordWrap) {
                            float scaleX = (float)innerWidth / (float)(preferredSize.getWidth() - (double)elabel.getInsetRight() - (double)elabel.getInsetLeft());
                            float scaleY = (float)innerHeight / (float)(preferredSize.getHeight() - (double)elabel.getInsetTop() - (double)elabel.getInsetBottom());
                            float scale = Math.min(scaleX, scaleY);
                            v7 = Math.max(MkFontKt.getFontSize((Font)font), MkFontKt.getFontSize((Font)font) * (double)scale * (double)1.0f);
                        } else {
                            v7 = fontSize = Math.max(MkFontKt.getFontSize((Font)font), g.fitTextInsideRectangle(elabel, pf, font, (Rectangle2D)new Rectangle(0, 0, innerWidth, innerHeight), 0.9, true));
                        }
                        if (fontSize >= MkFontKt.getFontSize((Font)font) / (double)4) {
                            Font scaledFont = MkFontKt.deriveFontSize((Font)font, (double)fontSize);
                            elabel.setFont(scaledFont);
                            if (columnSettings.getLabelingRendering() != EnhancedLabel.Rendering.WordWrap) {
                                scaledFont = Companion.scaleFontToFit(bounds2, font, elabel, pf, fontSize, false, true);
                                elabel.setFont(scaledFont);
                            }
                            preferredSize = pf.getPreferredSize();
                            int y = 0;
                            switch (model.getSettings().getColumnSettings(column).getLabelingVerticalAlignment()) {
                                case 1: {
                                    y = bounds2.getIy();
                                    break;
                                }
                                case 0: {
                                    y = (double)bounds2.getIheight() > preferredSize.getHeight() ? bounds2.getIy() + (bounds2.getIheight() - preferredSize.getIheight()) / 2 : bounds2.getIy();
                                    break;
                                }
                                case 3: {
                                    y = bounds2.getIheight() > preferredSize.getIheight() ? bounds2.getIy() + (bounds2.getIheight() - preferredSize.getIheight()) : bounds2.getIy();
                                }
                            }
                            Rectangle drawingArea = AbstractLabeling.Companion.findEnclosedRectangle(shape2, y, preferredSize.getIheight());
                            g.paintLabel(elabel, drawingArea.getIx(), drawingArea.getIy(), drawingArea.getIwidth(), drawingArea.getIheight());
                        }
                    }
                }
            }
            g.restore();
        }
    }

    @Override
    @Nullable
    public <N, Row, Column> Color getNestingBackground(N node, @NotNull TreeMapModel<N, Row, Column> model) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        return model.getSettings().getColumnSettings(model.getGroupByColumn(node)).getNestingBackground();
    }

    private final Rectangle computeBounds(Shape shape) {
        Rectangle rectangle;
        if (shape instanceof Rectangle2D) {
            Rectangle2D bounds = shape.getBounds2D();
            rectangle = new Rectangle((int)bounds.getX(), (int)bounds.getY(), (int)bounds.getWidth(), (int)bounds.getHeight());
        } else {
            Rectangle2D bounds = shape.getBounds2D();
            int halfWidth = (int)(bounds.getWidth() / Math.sqrt(2.0));
            int halfHeight = (int)(bounds.getHeight() / Math.sqrt(2.0));
            rectangle = new Rectangle((int)(bounds.getX() + (bounds.getWidth() - (double)halfWidth) / (double)2), (int)(bounds.getY() + (bounds.getHeight() - (double)halfHeight) / (double)2), halfWidth, halfHeight);
        }
        return rectangle;
    }

    @Override
    public <N, Row, Column> void paintLabel(@NotNull TGraphics g, @NotNull TreeMapView<N, Row, Column> view, N node, int pass, int passes, @NotNull Rectangle bounds, @NotNull Shape shape) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Rectangle bounds2 = bounds;
        Shape shape2 = shape;
        if (pass == passes - 1) {
            TreeMapModel<N, Row, Column> treeMapModel = view.getModel();
            Intrinsics.checkNotNull(treeMapModel);
            TreeMapModel<N, Row, Column> model = treeMapModel;
            Algorithm algorithm = null;
            N n = model.getParent(node);
            Intrinsics.checkNotNull(n);
            N parent = n;
            if (parent != null) {
                Column groupByColumn = model.getGroupByColumn(parent);
                if (groupByColumn != null) {
                    TreeMapColumnSettings columnSettings = model.getSettings().getColumnSettings(groupByColumn);
                    v2 = columnSettings.getAlgorithm();
                } else {
                    v2 = algorithm = model.getSettings().getDefaultColumnSettings().getAlgorithm();
                }
                if (algorithm.isRenderingLeafLabelsSupported()) {
                    shape2 = this.getRenderedShape(view, model, node, shape2);
                    g.save();
                    g.clip(shape2);
                    bounds2 = this.computeBounds(shape2);
                    Labeling labeling = model.getSettings().getColumnSettings(model.getGroupByColumn(node)).getLabeling();
                    Intrinsics.checkNotNull((Object)labeling);
                    labeling.paintLeaf(g, shape2, bounds2, node, view);
                    g.restore();
                }
            }
        }
    }

    @Override
    public <N, Row, Column> void paintParentBorder(@NotNull TGraphics g, N node, @NotNull Rectangle bounds, @NotNull Shape shape, @NotNull TreeMapModel<N, Row, Column> model) {
        float borderThickness;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        if (bounds.getWidth() > 1.0 && bounds.getHeight() > 1.0 && !model.isRoot(node) && !model.hasNoChildren(node) && !model.getFilter().isFiltered(node) && !model.getSearch().isFiltered(node) && (borderThickness = (float)model.getSettings().getColumnSettings(model.getGroupByColumn(node)).getBorderThickness()) > 0.0f && !(shape instanceof TextShape)) {
            g.save();
            g.setLineWidth(borderThickness);
            g.setStroke(model.getSettings().getColumnSettings(model.getGroupByColumn(node)).getBorderColor());
            g.stroke(shape);
            g.restore();
        }
    }

    @Override
    public <N, Row, Column> void paintParentHighlight(@NotNull TGraphics g2, @NotNull TreeMapView<N, Row, Column> view, N node, int pass, @NotNull Rectangle bounds, @Nullable Shape shape) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        TreeMapModel<N, Row, Column> treeMapModel = view.getModel();
        Intrinsics.checkNotNull(treeMapModel);
        TreeMapModel<N, Row, Column> model = treeMapModel;
        if (!model.isRoot(node) && !model.getFilter().isFiltered(node) && !model.getSearch().isFiltered(node) && model.getHighlighting().isActive() && model.getHighlighting().isSelected(node)) {
            g2.save();
            g2.setLineWidth(2.0);
            g2.setStroke(model.getSettings().getProbingColor());
            g2.stroke(shape);
            g2.restore();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JF\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/treemap/AbstractRendering$Companion;", "", "<init>", "()V", "COLOR_SIMILARITY_THRESHOLD", "", "scaleFontToFit", "Ljava/awt/Font;", "Lorg/mkui/font/MkFont;", "bounds", "Lorg/mkui/geom/Rectangle;", "font", "elabel", "Lorg/mkui/labeling/EnhancedLabel;", "pf", "Lcom/macrofocus/common/geom/PreferredSize;", "fontSize", "", "shrink", "", "expand", "treemap"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Font scaleFontToFit(@NotNull Rectangle bounds, @NotNull Font font, @NotNull EnhancedLabel elabel, @NotNull PreferredSize pf, double fontSize, boolean shrink, boolean expand) {
            Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            Intrinsics.checkNotNullParameter((Object)elabel, (String)"elabel");
            Intrinsics.checkNotNullParameter((Object)pf, (String)"pf");
            elabel.setFont(MkFontKt.deriveFontSize((Font)font, (double)fontSize));
            Dimension preferredSize = pf.getPreferredSize();
            double preferredWidth = preferredSize.getWidth() - (double)elabel.getInsetLeft() - (double)(-elabel.getInsetRight());
            double preferredHeight = preferredSize.getHeight() - (double)elabel.getInsetTop() - (double)(-elabel.getInsetBottom());
            float targetWidth = (float)bounds.getWidth();
            float targetheight = (float)bounds.getHeight();
            double s = Math.min((double)targetWidth * fontSize / (double)((float)preferredWidth), (double)targetheight * fontSize / (double)((float)preferredHeight)) * (double)0.9f;
            if (!shrink) {
                s = Math.max(fontSize, s);
            }
            if (!expand) {
                s = Math.min(fontSize, s);
            }
            return MkFontKt.deriveFontSize((Font)font, (double)s);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

