/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.filter.FilterEvent;
import com.macrofocus.common.filter.FilterListener;
import com.macrofocus.common.interval.BoundedInterval;
import com.macrofocus.common.interval.MutableBoundedInterval;
import com.macrofocus.common.interval.SimpleBoundedInterval;
import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.common.transform.MutableOneDScreenTransform;
import com.macrofocus.common.transform.OneDScreenTransform;
import com.macrofocus.common.transform.RangesScreenTransformCoordinator;
import com.macrofocus.common.transform.ScreenTransformEvent;
import com.macrofocus.common.transform.ScreenTransformListener;
import com.macrofocus.common.transform.SimpleOneDScreenTransform;
import com.treemap.Algorithm;
import com.treemap.BackgroundParentNodeRenderer;
import com.treemap.BackgroundRootNodeTreeMapRenderer;
import com.treemap.BorderParentNodeRenderer;
import com.treemap.DefaultTreeMapHeaderRenderer;
import com.treemap.DefaultTreeMapLabelRenderer;
import com.treemap.DefaultTreeMapToolTip;
import com.treemap.DefaultTreeMapTooltipRenderer;
import com.treemap.Depth;
import com.treemap.HighlightParentNodeRenderer;
import com.treemap.LeafNodeRenderer;
import com.treemap.NodesTreeMapRenderer;
import com.treemap.Progressive;
import com.treemap.Rendering;
import com.treemap.SelectionNodeRenderer;
import com.treemap.TextParentNodeRenderer;
import com.treemap.TreeMapEvent;
import com.treemap.TreeMapHeaderRenderer;
import com.treemap.TreeMapLabelRenderer;
import com.treemap.TreeMapListener;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapRenderer;
import com.treemap.TreeMapToolTip;
import com.treemap.TreeMapTooltipRenderer;
import com.treemap.TreeMapView;
import com.treemap.crossplatform.Headless;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.Point;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.ScreenTransformHelper;
import org.mkui.geom.Shape;
import org.mkui.geom.TextShape;
import org.mkui.rubberband.RubberBand;
import org.mkui.rubberband.ScreenTransformRubberBand;
import org.mkui.transform.MutableTwoDScreenTransform;
import org.mkui.transform.SimpleTwoDScreenTransform;
import org.mkui.transform.TwoDScreenTransform;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00f2\u0001\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0007\b'\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\"\u0010r\u001a\u00020s2\u0018\u0010;\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0017H\u0004J\"\u0010t\u001a\u00020s2\u0018\u0010;\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0017H\u0004J\"\u0010u\u001a\u00020s2\u0018\u0010;\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0017H\u0004J\"\u0010v\u001a\u00020s2\u0018\u0010;\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0017H\u0004J\u0006\u0010m\u001a\u00020sJ\u0006\u0010w\u001a\u00020sJ\u0019\u0010x\u001a\u0004\u0018\u00010\"2\b\u0010y\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010zJ\u0010\u0010x\u001a\u00020\"2\u0006\u0010{\u001a\u00020\"H\u0016J\u0015\u0010|\u001a\u00020\"2\u0006\u0010y\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010zJ\u0013\u0010\u007f\u001a\u00030\u0080\u00012\b\u0010\u0081\u0001\u001a\u00030\u0082\u0001H\u0016J\u0014\u0010\u0083\u0001\u001a\u00030\u0080\u00012\b\u0010\u0084\u0001\u001a\u00030\u0082\u0001H\u0016J\u0014\u0010\u0085\u0001\u001a\u00030\u0082\u00012\b\u0010\u0081\u0001\u001a\u00030\u0080\u0001H\u0016J\u0014\u0010\u0086\u0001\u001a\u00030\u0082\u00012\b\u0010\u0084\u0001\u001a\u00030\u0080\u0001H\u0016J\n\u0010\u0087\u0001\u001a\u00030\u0088\u0001H\u0002J\n\u0010\u0089\u0001\u001a\u00030\u0088\u0001H\u0002J:\u0010\u008a\u0001\u001a\u00020s2\u0007\u0010\u008b\u0001\u001a\u00020Y2\b\u0010\u008c\u0001\u001a\u00030\u0080\u00012\b\u0010\u008d\u0001\u001a\u00030\u0080\u00012\b\u0010\u008e\u0001\u001a\u00030\u0080\u00012\b\u0010\u008f\u0001\u001a\u00030\u0080\u0001H\u0016J\u001d\u0010\u0090\u0001\u001a\u0004\u0018\u00018\u00002\n\u0010\u0091\u0001\u001a\u0005\u0018\u00010\u0092\u0001H\u0016\u00a2\u0006\u0003\u0010\u0093\u0001J=\u0010\u0094\u0001\u001a\u0004\u0018\u00018\u00002\u0018\u00105\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002062\u0006\u0010y\u001a\u00028\u00002\b\u0010\u0091\u0001\u001a\u00030\u0092\u0001H\u0002\u00a2\u0006\u0003\u0010\u0095\u0001J\u001b\u0010\u0096\u0001\u001a\u00020Y2\b\u0010\u0091\u0001\u001a\u00030\u0092\u00012\u0006\u0010{\u001a\u00020\"H\u0016J\u001e\u0010\u0097\u0001\u001a\u000b\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0098\u00012\n\u0010\u0099\u0001\u001a\u0005\u0018\u00010\u009a\u0001H\u0016JL\u0010\u0094\u0001\u001a\u0004\u0018\u00018\u00002\u0018\u00105\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002062\u0006\u0010y\u001a\u00028\u00002\b\u0010\u0099\u0001\u001a\u00030\u009a\u00012\r\u0010\u009b\u0001\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0002\u00a2\u0006\u0003\u0010\u009c\u0001J\u0013\u0010\u009d\u0001\u001a\u00030\u009a\u00012\u0007\u0010\u009e\u0001\u001a\u00020oH\u0016J\u0012\u0010\u009f\u0001\u001a\u00020o2\u0007\u0010\u00a0\u0001\u001a\u00020oH\u0016J\t\u0010\u00a8\u0001\u001a\u00020sH\u0016J\u0013\u0010\u00a8\u0001\u001a\u00020s2\b\u0010\u00a9\u0001\u001a\u00030\u00aa\u0001H$J\t\u0010\u00ab\u0001\u001a\u00020sH$J\u001d\u0010\u00ac\u0001\u001a\u00020s2\b\u0010\u0081\u0001\u001a\u00030\u0082\u00012\b\u0010\u0084\u0001\u001a\u00030\u0082\u0001H\u0016J\t\u0010\u00ad\u0001\u001a\u00020sH\u0016J\t\u0010\u00ae\u0001\u001a\u00020sH\u0016J\t\u0010\u00af\u0001\u001a\u00020sH\u0016J\t\u0010\u00b0\u0001\u001a\u00020sH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R)\u0010\u0015\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R)\u0010\u001a\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R)\u0010\u001c\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0019R)\u0010\u001e\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0019R&\u0010 \u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0006\u0012\u0004\u0018\u00010\"\u0018\u00010!X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0019\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010100X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\b\u0012\u0004\u0012\u00028\u000003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00104\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010100X\u0082\u0004\u00a2\u0006\u0002\n\u0000RL\u00105\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u0001062\u001a\u00105\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u000106@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:RL\u0010=\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010<2\u001a\u0010;\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010<@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010ARL\u0010C\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010B2\u001a\u0010;\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010B@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GRL\u0010I\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010H2\u001a\u0010;\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010H@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR.\u0010N\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010OX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010Q\"\u0004\bR\u0010SRL\u0010U\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010O2\u001a\u0010T\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010O@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010Q\"\u0004\bW\u0010SR$\u0010Z\u001a\u00020Y2\u0006\u0010X\u001a\u00020Y@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bZ\u0010[\"\u0004\b\\\u0010]R\u001c\u0010^\u001a\u00020_8VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b`\u0010a\"\u0004\bb\u0010cR\u001a\u0010d\u001a\u00020YX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bd\u0010[\"\u0004\be\u0010]R\u001a\u0010f\u001a\u00020YX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bf\u0010[\"\u0004\bg\u0010]R\u0011\u0010h\u001a\u00020i\u00a2\u0006\b\n\u0000\u001a\u0004\bj\u0010kR\u001a\u0010l\u001a\u00020YX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bl\u0010[\"\u0004\bm\u0010]R\u0014\u0010n\u001a\u00020o8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bp\u0010qR\u0014\u0010}\u001a\u00020o8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b~\u0010qR\u0018\u0010\u00a1\u0001\u001a\u00030\u00a2\u00018VX\u0096\u0004\u00a2\u0006\b\u001a\u0006\b\u00a3\u0001\u0010\u00a4\u0001RO\u0010\u00a5\u0001\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010O2\u001a\u0010T\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010O8V@VX\u0096\u000e\u00a2\u0006\u000e\u001a\u0005\b\u00a6\u0001\u0010Q\"\u0005\b\u00a7\u0001\u0010S\u00a8\u0006\u00b1\u0001"}, d2={"Lcom/treemap/AbstractTreeMapView;", "N", "Row", "Column", "Lcom/treemap/TreeMapView;", "headless", "Lcom/treemap/crossplatform/Headless;", "<init>", "(Lcom/treemap/crossplatform/Headless;)V", "getHeadless", "()Lcom/treemap/crossplatform/Headless;", "xRangeModel", "Lcom/macrofocus/common/interval/MutableBoundedInterval;", "getXRangeModel", "()Lcom/macrofocus/common/interval/MutableBoundedInterval;", "yRangeModel", "getYRangeModel", "screenTransform", "Lorg/mkui/transform/MutableTwoDScreenTransform;", "getScreenTransform", "()Lorg/mkui/transform/MutableTwoDScreenTransform;", "preRenderers", "", "Lcom/treemap/TreeMapRenderer;", "getPreRenderers", "()Ljava/util/List;", "preProgressiveRenderers", "getPreProgressiveRenderers", "progressiveRenderers", "getProgressiveRenderers", "postRenderers", "getPostRenderers", "_shapes", "", "Lorg/mkui/geom/Shape;", "get_shapes", "()Ljava/util/Map;", "probingListener", "Lcom/macrofocus/common/selection/SingleSelectionListener;", "getProbingListener", "()Lcom/macrofocus/common/selection/SingleSelectionListener;", "selectionListener", "Lcom/macrofocus/common/selection/SelectionListener;", "getSelectionListener", "()Lcom/macrofocus/common/selection/SelectionListener;", "_treeMapListener", "Lcom/treemap/TreeMapListener;", "modelPropertyChangeListener", "Lcom/macrofocus/common/properties/PropertiesListener;", "", "filterListener", "Lcom/macrofocus/common/filter/FilterListener;", "propertyChangeListener", "model", "Lcom/treemap/TreeMapModel;", "getModel", "()Lcom/treemap/TreeMapModel;", "setModel", "(Lcom/treemap/TreeMapModel;)V", "renderer", "Lcom/treemap/TreeMapLabelRenderer;", "labelRenderer", "getLabelRenderer", "()Lcom/treemap/TreeMapLabelRenderer;", "setLabelRenderer", "(Lcom/treemap/TreeMapLabelRenderer;)V", "Lcom/treemap/TreeMapHeaderRenderer;", "headerRenderer", "getHeaderRenderer", "()Lcom/treemap/TreeMapHeaderRenderer;", "setHeaderRenderer", "(Lcom/treemap/TreeMapHeaderRenderer;)V", "Lcom/treemap/TreeMapTooltipRenderer;", "tooltipRenderer", "getTooltipRenderer", "()Lcom/treemap/TreeMapTooltipRenderer;", "setTooltipRenderer", "(Lcom/treemap/TreeMapTooltipRenderer;)V", "probingToolTip", "Lcom/treemap/TreeMapToolTip;", "getProbingToolTip", "()Lcom/treemap/TreeMapToolTip;", "setProbingToolTip", "(Lcom/treemap/TreeMapToolTip;)V", "tooltip", "selectionToolTip", "getSelectionToolTip", "setSelectionToolTip", "updateModelDimension", "", "isUpdateModelDimension", "()Z", "setUpdateModelDimension", "(Z)V", "progressive", "Lcom/treemap/Progressive;", "getProgressive", "()Lcom/treemap/Progressive;", "setProgressive", "(Lcom/treemap/Progressive;)V", "isShowTiming", "setShowTiming", "isSelectionMode", "setSelectionMode", "rubberBand", "Lorg/mkui/rubberband/RubberBand;", "getRubberBand", "()Lorg/mkui/rubberband/RubberBand;", "isDirty", "setDirty", "viewport", "Lorg/mkui/geom/Rectangle2D;", "getViewport", "()Lorg/mkui/geom/Rectangle2D;", "addPreRenderer", "", "addPreProgressiveRenderer", "addProgressiveRenderer", "addPostRenderer", "setDirtyShapes", "worldToScreen", "node", "(Ljava/lang/Object;)Lorg/mkui/geom/Shape;", "shape", "getRenderedShape", "world", "getWorld", "screenToWorldX", "", "x", "", "screenToWorldY", "y", "worldToScreenX", "worldToScreenY", "getXCoordinateAxis", "Lcom/macrofocus/common/transform/OneDScreenTransform;", "getYCoordinateAxis", "zoom", "animate", "x1", "x2", "y1", "y2", "getNode", "p", "Lorg/mkui/geom/Point;", "(Lorg/mkui/geom/Point;)Ljava/lang/Object;", "visit", "(Lcom/treemap/TreeMapModel;Ljava/lang/Object;Lorg/mkui/geom/Point;)Ljava/lang/Object;", "contains", "getNodes", "", "rect", "Lorg/mkui/geom/Rectangle;", "list", "(Lcom/treemap/TreeMapModel;Ljava/lang/Object;Lorg/mkui/geom/Rectangle;Ljava/util/List;)Ljava/lang/Object;", "worldToScreenRectangle", "rectangle", "worldToScreenPrecise", "r", "zoomFactor", "", "getZoomFactor", "()F", "toolTip", "getToolTip", "setToolTip", "repaint", "delay", "", "updateSize", "drill", "drillDown", "drillUp", "zoomIn", "zoomOut", "treemap"})
@StabilityInferred(parameters=0)
public abstract class AbstractTreeMapView<N, Row, Column>
implements TreeMapView<N, Row, Column> {
    @NotNull
    private final Headless headless;
    @NotNull
    private final MutableBoundedInterval xRangeModel;
    @NotNull
    private final MutableBoundedInterval yRangeModel;
    @NotNull
    private final MutableTwoDScreenTransform screenTransform;
    @NotNull
    private final List<TreeMapRenderer<N, Row, Column>> preRenderers;
    @NotNull
    private final List<TreeMapRenderer<N, Row, Column>> preProgressiveRenderers;
    @NotNull
    private final List<TreeMapRenderer<N, Row, Column>> progressiveRenderers;
    @NotNull
    private final List<TreeMapRenderer<N, Row, Column>> postRenderers;
    @Nullable
    private final Map<N, Shape> _shapes;
    @NotNull
    private final SingleSelectionListener<N> probingListener;
    @NotNull
    private final SelectionListener<N> selectionListener;
    @NotNull
    private final TreeMapListener _treeMapListener;
    @NotNull
    private final PropertiesListener<String> modelPropertyChangeListener;
    @NotNull
    private final FilterListener<N> filterListener;
    @NotNull
    private final PropertiesListener<String> propertyChangeListener;
    @Nullable
    private TreeMapModel<N, Row, Column> model;
    @Nullable
    private TreeMapLabelRenderer<N, Row, Column> labelRenderer;
    @Nullable
    private TreeMapHeaderRenderer<N, Row, Column> headerRenderer;
    @Nullable
    private TreeMapTooltipRenderer<N, Row, Column> tooltipRenderer;
    @Nullable
    private TreeMapToolTip<N, Row, Column> probingToolTip;
    @Nullable
    private TreeMapToolTip<N, Row, Column> selectionToolTip;
    private boolean isUpdateModelDimension;
    @NotNull
    private Progressive progressive;
    private boolean isShowTiming;
    private boolean isSelectionMode;
    @NotNull
    private final RubberBand rubberBand;
    private boolean isDirty;
    public static final int $stable = 8;

    public AbstractTreeMapView(@NotNull Headless headless) {
        Intrinsics.checkNotNullParameter((Object)headless, (String)"headless");
        this.headless = headless;
        this.probingListener = new SingleSelectionListener<N>(this){
            final /* synthetic */ AbstractTreeMapView<N, Row, Column> this$0;
            {
                this.this$0 = $receiver;
            }

            public void selectionChanged(SingleSelectionEvent<N> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                TreeMapToolTip<N, Row, Column> toolTip = this.this$0.getToolTip();
                if (toolTip != null) {
                    TreeMapModel<N, Row, Column> treeMapModel = this.this$0.getModel();
                    Intrinsics.checkNotNull(treeMapModel);
                    Object node = treeMapModel.getProbing().getSelected();
                    TreeMapToolTip<Object, Row, Column> treeMapToolTip = this.this$0.getProbingToolTip();
                    Intrinsics.checkNotNull(treeMapToolTip);
                    treeMapToolTip.showNode(node);
                }
                this.this$0.repaint();
            }
        };
        this.selectionListener = new SelectionListener<N>(this){
            final /* synthetic */ AbstractTreeMapView<N, Row, Column> this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * Unable to fully structure code
             */
            public void selectionChanged(SelectionEvent<N> event) {
                block2: {
                    Intrinsics.checkNotNullParameter(event, (String)"event");
                    toolTip = this.this$0.getSelectionToolTip();
                    if (toolTip == null) break block2;
                    v0 = this.this$0.getModel();
                    Intrinsics.checkNotNull(v0);
                    if (!v0.getSelection().isActive()) ** GOTO lbl-1000
                    v1 = this.this$0.getModel();
                    Intrinsics.checkNotNull(v1);
                    if (v1.getSelection().getSelectedCount() == 1) {
                        v2 = this.this$0.getModel();
                        Intrinsics.checkNotNull(v2);
                        node = v2.getSelection().iterator().next();
                        v3 = this.this$0.getSelectionToolTip();
                        Intrinsics.checkNotNull(v3);
                        v3.showNode(node);
                    } else lbl-1000:
                    // 2 sources

                    {
                        v4 = this.this$0.getSelectionToolTip();
                        Intrinsics.checkNotNull(v4);
                        v4.showNode(null);
                    }
                }
                this.this$0.repaint();
            }
        };
        this._treeMapListener = new TreeMapListener(this){
            final /* synthetic */ AbstractTreeMapView<N, Row, Column> this$0;
            {
                this.this$0 = $receiver;
            }

            public void tableModelChanged() {
            }

            public void treeMapChanged(TreeMapEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.isLayoutChanged()) {
                    this.this$0.setDirtyShapes();
                    this.this$0.repaint();
                } else {
                    this.this$0.setDirty();
                }
            }
        };
        this.modelPropertyChangeListener = (PropertiesListener)new PropertiesListener<String>(this){
            final /* synthetic */ AbstractTreeMapView<N, Row, Column> this$0;
            {
                this.this$0 = $receiver;
            }

            public void propertyChanged(String name, PropertyEvent<Object> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                if (!"progress".equals(name)) {
                    this.this$0.repaint();
                } else {
                    this.this$0.setDirtyShapes();
                    this.this$0.repaint(300L);
                }
            }
        };
        this.filterListener = new FilterListener<N>(this){
            final /* synthetic */ AbstractTreeMapView<N, Row, Column> this$0;
            {
                this.this$0 = $receiver;
            }

            public void filterChanged(FilterEvent<N> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.this$0.repaint(10L);
            }
        };
        this.propertyChangeListener = (PropertiesListener)new PropertiesListener<String>(this){
            final /* synthetic */ AbstractTreeMapView<N, Row, Column> this$0;
            {
                this.this$0 = $receiver;
            }

            public void propertyChanged(String name, PropertyEvent<Object> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                if ("dimension".equals(name) || "labeling".equals(name) || "heightField".equals(name) || "groupByField".equals(name)) {
                    this.this$0.updateSize();
                } else if ("dimensionFixed".equals(name)) {
                    this.this$0.updateModelDimension();
                }
                this.this$0.repaint();
            }
        };
        this.labelRenderer = new DefaultTreeMapLabelRenderer();
        this.headerRenderer = new DefaultTreeMapHeaderRenderer();
        this.tooltipRenderer = new DefaultTreeMapTooltipRenderer();
        this.probingToolTip = new DefaultTreeMapToolTip(this);
        this.isUpdateModelDimension = true;
        this.progressive = Progressive.Disabled;
        this.isSelectionMode = true;
        this.isDirty = true;
        this.preRenderers = new ArrayList();
        this.preProgressiveRenderers = new ArrayList();
        this.progressiveRenderers = new ArrayList();
        this.postRenderers = new ArrayList();
        this._shapes = new HashMap();
        ((ArrayList)this.preRenderers).add(new BackgroundRootNodeTreeMapRenderer());
        ((ArrayList)this.preRenderers).add(new NodesTreeMapRenderer(new BackgroundParentNodeRenderer(), 0));
        ((ArrayList)this.preProgressiveRenderers).add(new NodesTreeMapRenderer(new LeafNodeRenderer(false), 0));
        ((ArrayList)this.preProgressiveRenderers).add(new NodesTreeMapRenderer(new LeafNodeRenderer(false), 1));
        ((ArrayList)this.progressiveRenderers).add(new NodesTreeMapRenderer(new LeafNodeRenderer(true), 0));
        ((ArrayList)this.progressiveRenderers).add(new NodesTreeMapRenderer(new TextParentNodeRenderer(), 0));
        ((ArrayList)this.progressiveRenderers).add(new NodesTreeMapRenderer(new BorderParentNodeRenderer(), 0));
        ((ArrayList)this.progressiveRenderers).add(new NodesTreeMapRenderer(new HighlightParentNodeRenderer(), 0));
        ((ArrayList)this.postRenderers).add(new NodesTreeMapRenderer(new LeafNodeRenderer(true), 1));
        ((ArrayList)this.postRenderers).add(new NodesTreeMapRenderer(new TextParentNodeRenderer(), 1));
        ((ArrayList)this.postRenderers).add(new NodesTreeMapRenderer(new SelectionNodeRenderer()));
        this.setSelectionToolTip(null);
        int width = 0;
        int height = 0;
        this.xRangeModel = (MutableBoundedInterval)new SimpleBoundedInterval(0.0, (double)width, 0.0, (double)width);
        this.yRangeModel = (MutableBoundedInterval)new SimpleBoundedInterval(0.0, (double)height, 0.0, (double)height);
        this.screenTransform = (MutableTwoDScreenTransform)new SimpleTwoDScreenTransform((MutableOneDScreenTransform)new SimpleOneDScreenTransform((BoundedInterval)this.xRangeModel, width), (MutableOneDScreenTransform)new SimpleOneDScreenTransform((BoundedInterval)this.yRangeModel, height, true, true), width, height, 1.0);
        this.rubberBand = (RubberBand)new ScreenTransformRubberBand((TwoDScreenTransform)this.screenTransform);
        ((ScreenTransformRubberBand)this.rubberBand).getRubberBand().addSingleSelectionListener((SingleSelectionListener)new SingleSelectionListener<Rectangle2D>(){

            public void selectionChanged(SingleSelectionEvent<Rectangle2D> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.repaint();
            }
        });
        new RangesScreenTransformCoordinator(this.xRangeModel, this.yRangeModel);
        ((SimpleTwoDScreenTransform)this.screenTransform).addScreenTransformListener(new ScreenTransformListener(){

            public void transformChanged(ScreenTransformEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.setDirtyShapes();
                this.repaint();
            }
        });
        ((SimpleBoundedInterval)this.xRangeModel).setMinimumExtent(10.0);
        ((SimpleBoundedInterval)this.yRangeModel).setMinimumExtent(10.0);
    }

    @Override
    @NotNull
    public Headless getHeadless() {
        return this.headless;
    }

    @Override
    @NotNull
    public final MutableBoundedInterval getXRangeModel() {
        return this.xRangeModel;
    }

    @Override
    @NotNull
    public final MutableBoundedInterval getYRangeModel() {
        return this.yRangeModel;
    }

    @NotNull
    public final MutableTwoDScreenTransform getScreenTransform() {
        return this.screenTransform;
    }

    @Override
    @NotNull
    public final List<TreeMapRenderer<N, Row, Column>> getPreRenderers() {
        return this.preRenderers;
    }

    @Override
    @NotNull
    public final List<TreeMapRenderer<N, Row, Column>> getPreProgressiveRenderers() {
        return this.preProgressiveRenderers;
    }

    @Override
    @NotNull
    public final List<TreeMapRenderer<N, Row, Column>> getProgressiveRenderers() {
        return this.progressiveRenderers;
    }

    @Override
    @NotNull
    public final List<TreeMapRenderer<N, Row, Column>> getPostRenderers() {
        return this.postRenderers;
    }

    @Nullable
    protected final Map<N, Shape> get_shapes() {
        return this._shapes;
    }

    @NotNull
    public final SingleSelectionListener<N> getProbingListener() {
        return this.probingListener;
    }

    @NotNull
    public final SelectionListener<N> getSelectionListener() {
        return this.selectionListener;
    }

    @Override
    @Nullable
    public TreeMapModel<N, Row, Column> getModel() {
        return this.model;
    }

    @Override
    public void setModel(@Nullable TreeMapModel<N, Row, Column> model) {
        if (this.model != null) {
            TreeMapModel<N, Row, Column> treeMapModel = this.model;
            Intrinsics.checkNotNull(treeMapModel);
            treeMapModel.removeListener(this._treeMapListener);
            TreeMapModel<N, Row, Column> treeMapModel2 = this.model;
            Intrinsics.checkNotNull(treeMapModel2);
            treeMapModel2.getProperties().removePropertiesListener(this.modelPropertyChangeListener);
            TreeMapModel<N, Row, Column> treeMapModel3 = this.model;
            Intrinsics.checkNotNull(treeMapModel3);
            treeMapModel3.getFilter().removeFilterListener(this.filterListener);
            TreeMapModel<N, Row, Column> treeMapModel4 = this.model;
            Intrinsics.checkNotNull(treeMapModel4);
            treeMapModel4.getSearch().removeFilterListener(this.filterListener);
            TreeMapModel<N, Row, Column> treeMapModel5 = this.model;
            Intrinsics.checkNotNull(treeMapModel5);
            treeMapModel5.getSettings().getProperties().removePropertiesListener(this.propertyChangeListener);
            TreeMapModel<N, Row, Column> treeMapModel6 = this.model;
            Intrinsics.checkNotNull(treeMapModel6);
            treeMapModel6.getProbing().removeSingleSelectionListener(this.probingListener);
            TreeMapModel<N, Row, Column> treeMapModel7 = this.model;
            Intrinsics.checkNotNull(treeMapModel7);
            treeMapModel7.getSelection().removeSelectionListener(this.selectionListener);
        }
        this.model = model;
        this.setDirtyShapes();
        if (this.model != null) {
            TreeMapModel<N, Row, Column> treeMapModel = this.model;
            Intrinsics.checkNotNull(treeMapModel);
            treeMapModel.addListener(this._treeMapListener);
            TreeMapModel<N, Row, Column> treeMapModel8 = this.model;
            Intrinsics.checkNotNull(treeMapModel8);
            treeMapModel8.getProperties().addPropertiesListener(this.modelPropertyChangeListener);
            TreeMapModel<N, Row, Column> treeMapModel9 = this.model;
            Intrinsics.checkNotNull(treeMapModel9);
            treeMapModel9.getFilter().addFilterListener(this.filterListener);
            TreeMapModel<N, Row, Column> treeMapModel10 = this.model;
            Intrinsics.checkNotNull(treeMapModel10);
            treeMapModel10.getSearch().addFilterListener(this.filterListener);
            TreeMapModel<N, Row, Column> treeMapModel11 = this.model;
            Intrinsics.checkNotNull(treeMapModel11);
            treeMapModel11.getSettings().getProperties().addPropertiesListener(this.propertyChangeListener);
            TreeMapModel<N, Row, Column> treeMapModel12 = this.model;
            Intrinsics.checkNotNull(treeMapModel12);
            treeMapModel12.getProbing().addSingleSelectionListener(this.probingListener);
            TreeMapModel<N, Row, Column> treeMapModel13 = this.model;
            Intrinsics.checkNotNull(treeMapModel13);
            treeMapModel13.getSelection().addSelectionListener(this.selectionListener);
        }
        this.updateModelDimension();
        this.updateSize();
    }

    @Override
    @Nullable
    public TreeMapLabelRenderer<N, Row, Column> getLabelRenderer() {
        return this.labelRenderer;
    }

    @Override
    public void setLabelRenderer(@Nullable TreeMapLabelRenderer<N, Row, Column> renderer) {
        if (this.labelRenderer != renderer) {
            this.labelRenderer = renderer;
            this.repaint();
        }
    }

    @Override
    @Nullable
    public TreeMapHeaderRenderer<N, Row, Column> getHeaderRenderer() {
        return this.headerRenderer;
    }

    @Override
    public void setHeaderRenderer(@Nullable TreeMapHeaderRenderer<N, Row, Column> renderer) {
        if (this.headerRenderer != renderer) {
            this.headerRenderer = renderer;
            this.repaint();
        }
    }

    @Override
    @Nullable
    public TreeMapTooltipRenderer<N, Row, Column> getTooltipRenderer() {
        return this.tooltipRenderer;
    }

    @Override
    public void setTooltipRenderer(@Nullable TreeMapTooltipRenderer<N, Row, Column> renderer) {
        if (this.tooltipRenderer != renderer) {
            this.tooltipRenderer = renderer;
            this.repaint();
        }
    }

    @Nullable
    protected final TreeMapToolTip<N, Row, Column> getProbingToolTip() {
        return this.probingToolTip;
    }

    protected final void setProbingToolTip(@Nullable TreeMapToolTip<N, Row, Column> treeMapToolTip) {
        this.probingToolTip = treeMapToolTip;
    }

    @Override
    @Nullable
    public TreeMapToolTip<N, Row, Column> getSelectionToolTip() {
        return this.selectionToolTip;
    }

    @Override
    public void setSelectionToolTip(@Nullable TreeMapToolTip<N, Row, Column> tooltip) {
        if (this.selectionToolTip != tooltip) {
            this.selectionToolTip = tooltip;
            this.repaint();
        }
    }

    @Override
    public boolean isUpdateModelDimension() {
        return this.isUpdateModelDimension;
    }

    @Override
    public void setUpdateModelDimension(boolean updateModelDimension) {
        if (this.isUpdateModelDimension != updateModelDimension) {
            this.isUpdateModelDimension = updateModelDimension;
            this.updateModelDimension();
        }
    }

    @Override
    @NotNull
    public Progressive getProgressive() {
        Progressive progressive;
        TreeMapModel<N, Row, Column> model = this.getModel();
        if (model != null && model.getSettings().getProgressive() != null) {
            Progressive progressive2 = model.getSettings().getProgressive();
            progressive = progressive2;
            Intrinsics.checkNotNull((Object)((Object)progressive2));
        } else {
            progressive = this.progressive;
        }
        return progressive;
    }

    @Override
    public void setProgressive(@NotNull Progressive progressive) {
        Intrinsics.checkNotNullParameter((Object)((Object)progressive), (String)"<set-?>");
        this.progressive = progressive;
    }

    @Override
    public boolean isShowTiming() {
        return this.isShowTiming;
    }

    @Override
    public void setShowTiming(boolean bl) {
        this.isShowTiming = bl;
    }

    @Override
    public boolean isSelectionMode() {
        return this.isSelectionMode;
    }

    @Override
    public void setSelectionMode(boolean bl) {
        this.isSelectionMode = bl;
    }

    @Override
    @NotNull
    public final RubberBand getRubberBand() {
        return this.rubberBand;
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public void setDirty(boolean bl) {
        this.isDirty = bl;
    }

    @Override
    @NotNull
    public Rectangle2D getViewport() {
        return (Rectangle2D)Rectangle2D.Double.Companion.frameFromDiagonal(this.xRangeModel.getStart(), this.yRangeModel.getStart(), this.xRangeModel.getStart() + this.xRangeModel.getExtent(), this.yRangeModel.getStart() + this.yRangeModel.getExtent());
    }

    protected final void addPreRenderer(@NotNull TreeMapRenderer<N, Row, Column> renderer) {
        Intrinsics.checkNotNullParameter(renderer, (String)"renderer");
        this.preRenderers.add(renderer);
        this.repaint();
    }

    protected final void addPreProgressiveRenderer(@NotNull TreeMapRenderer<N, Row, Column> renderer) {
        Intrinsics.checkNotNullParameter(renderer, (String)"renderer");
        this.preProgressiveRenderers.add(renderer);
        this.setDirty();
    }

    protected final void addProgressiveRenderer(@NotNull TreeMapRenderer<N, Row, Column> renderer) {
        Intrinsics.checkNotNullParameter(renderer, (String)"renderer");
        this.progressiveRenderers.add(renderer);
        this.setDirty();
    }

    protected final void addPostRenderer(@NotNull TreeMapRenderer<N, Row, Column> renderer) {
        Intrinsics.checkNotNullParameter(renderer, (String)"renderer");
        this.postRenderers.add(renderer);
        this.repaint();
    }

    public final void setDirty() {
        this.setDirty(true);
        this.repaint();
    }

    public final void setDirtyShapes() {
        this.setDirty(true);
        if (this._shapes != null) {
            this._shapes.clear();
        }
    }

    @Override
    @Nullable
    public Shape worldToScreen(@Nullable N node) {
        Shape shape;
        Map<N, Shape> map = this._shapes;
        Shape shape2 = shape = map != null ? map.get(node) : null;
        if (this.getModel() != null && shape == null && node != null) {
            TreeMapModel<N, Row, Column> treeMapModel = this.getModel();
            Intrinsics.checkNotNull(treeMapModel);
            shape = treeMapModel.getShape(node);
            if (shape != null) {
                shape = this.worldToScreen(shape);
                Map<N, Shape> map2 = this._shapes;
                Intrinsics.checkNotNull(map2);
                map2.put(node, shape);
            }
        }
        return shape;
    }

    @Override
    @NotNull
    public Shape worldToScreen(@NotNull Shape shape) {
        Shape shape2;
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Shape shape3 = shape;
        if (shape3 instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)shape3;
            shape2 = (Shape)this.worldToScreenPrecise(r);
        } else if (shape3 instanceof TextShape) {
            at = ScreenTransformHelper.INSTANCE.worldToScreen((OneDScreenTransform)this.screenTransform.getX(), (OneDScreenTransform)this.screenTransform.getY());
            shape2 = ((TextShape)shape3).createTransformedShape(at);
        } else {
            at = ScreenTransformHelper.INSTANCE.worldToScreen((OneDScreenTransform)this.screenTransform.getX(), (OneDScreenTransform)this.screenTransform.getY());
            Shape shape4 = at.createTransformedShape(shape3);
            shape2 = shape4;
            Intrinsics.checkNotNull((Object)shape4);
        }
        shape3 = shape2;
        return shape3;
    }

    @Override
    @NotNull
    public Shape getRenderedShape(N node) {
        Shape screenShape = this.worldToScreen(node);
        if (screenShape != null) {
            TreeMapModel<N, Row, Column> treeMapModel = this.getModel();
            Intrinsics.checkNotNull(treeMapModel);
            Rendering rendering = treeMapModel.getSettings().getRendering();
            Intrinsics.checkNotNull((Object)rendering);
            TreeMapView treeMapView = this;
            TreeMapModel<N, Row, Column> treeMapModel2 = this.getModel();
            Intrinsics.checkNotNull(treeMapModel2);
            return rendering.getRenderedShape(treeMapView, treeMapModel2, node, screenShape);
        }
        return (Shape)new Rectangle(0, 0, 0, 0);
    }

    @Override
    @NotNull
    public Rectangle2D getWorld() {
        return (Rectangle2D)Rectangle2D.Double.Companion.frameFromDiagonal(this.xRangeModel.getMinimum(), this.yRangeModel.getMinimum(), this.xRangeModel.getMaximum(), this.yRangeModel.getMaximum());
    }

    @Override
    public double screenToWorldX(int x) {
        return this.getXCoordinateAxis().screenToWorld(x);
    }

    @Override
    public double screenToWorldY(int y) {
        return this.getYCoordinateAxis().screenToWorld(y);
    }

    @Override
    public int worldToScreenX(double x) {
        return this.getXCoordinateAxis().worldToScreen(x);
    }

    @Override
    public int worldToScreenY(double y) {
        return this.getYCoordinateAxis().worldToScreen(y);
    }

    private final OneDScreenTransform getXCoordinateAxis() {
        return (OneDScreenTransform)this.screenTransform.getX();
    }

    private final OneDScreenTransform getYCoordinateAxis() {
        return (OneDScreenTransform)this.screenTransform.getY();
    }

    @Override
    public void zoom(boolean animate, double x1, double x2, double y1, double y2) {
        this.xRangeModel.setValue(x1, x2 - x1);
        this.yRangeModel.setValue(y1, y2 - y1);
    }

    @Override
    @Nullable
    public N getNode(@Nullable Point p) {
        if (this.getModel() != null && p != null) {
            Shape rectangle;
            TreeMapModel<N, Row, Column> treeMapModel = this.getModel();
            Intrinsics.checkNotNull(treeMapModel);
            N currentRoot = treeMapModel.getCurrentRoot();
            if (currentRoot != null && (rectangle = this.getRenderedShape(currentRoot)) != null && this.contains(p, rectangle)) {
                TreeMapModel<N, Row, Column> treeMapModel2 = this.getModel();
                Intrinsics.checkNotNull(treeMapModel2);
                N node = this.visit(treeMapModel2, currentRoot, p);
                if (node != null && node != currentRoot) {
                    TreeMapModel<N, Row, Column> treeMapModel3 = this.getModel();
                    Intrinsics.checkNotNull(treeMapModel3);
                    if (!treeMapModel3.getFilter().isFiltered(node)) {
                        TreeMapModel<N, Row, Column> treeMapModel4 = this.getModel();
                        Intrinsics.checkNotNull(treeMapModel4);
                        if (!treeMapModel4.getSearch().isFiltered(node)) {
                            return node;
                        }
                    }
                }
            }
        }
        return null;
    }

    private final N visit(TreeMapModel<N, Row, Column> model, N node, Point p) {
        for (N child : model.getChildren(node)) {
            N visit;
            if (model.getFilter().isFiltered(child)) continue;
            Shape shape = this.getRenderedShape(child);
            int n = model.getLevel(node);
            N n2 = model.getCurrentRoot();
            Intrinsics.checkNotNull(n2);
            int depth = n - model.getLevel(n2);
            Algorithm algorithm = model.getSettings().getColumnSettings(model.getGroupByColumn(node)).getAlgorithm();
            Depth depth2 = model.getSettings().getDepth();
            Intrinsics.checkNotNull((Object)depth2);
            if (!depth2.display(depth + 1) || !algorithm.isCompatible(model.getShape(node))) continue;
            if (shape == null && !model.hasNoChildren(node)) {
                visit = this.visit(model, child, p);
                if (visit == child) continue;
                return visit;
            }
            if (this.contains(p, shape)) {
                return this.visit(model, child, p);
            }
            if (model.getSettings().getColumnSettings(model.getGroupByColumn(node)).getAlgorithm().isChildContained()) continue;
            if (this.contains(p, shape)) {
                return child;
            }
            visit = this.visit(model, child, p);
            if (visit == child) continue;
            return visit;
        }
        return node;
    }

    @Override
    public boolean contains(@NotNull Point p, @NotNull Shape shape) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        return shape instanceof TextShape ? ((TextShape)shape).getBounds2D().contains((Point2D)p) : shape.contains((Point2D)p);
    }

    @Override
    @Nullable
    public List<N> getNodes(@Nullable Rectangle rect) {
        if (this.getModel() != null && rect != null) {
            List list = new ArrayList();
            TreeMapModel<N, Row, Column> treeMapModel = this.getModel();
            Intrinsics.checkNotNull(treeMapModel);
            N n = treeMapModel.getCurrentRoot();
            Intrinsics.checkNotNull(n);
            N currentRoot = n;
            if (this.getRenderedShape(currentRoot).intersects((Rectangle2D)rect)) {
                TreeMapModel<N, Row, Column> treeMapModel2 = this.getModel();
                Intrinsics.checkNotNull(treeMapModel2);
                if (treeMapModel2.hasNoChildren(currentRoot)) {
                    N n2 = currentRoot;
                    Intrinsics.checkNotNull(n2);
                    list.add(n2);
                }
                TreeMapModel<N, Row, Column> treeMapModel3 = this.getModel();
                Intrinsics.checkNotNull(treeMapModel3);
                N n3 = currentRoot;
                Intrinsics.checkNotNull(n3);
                this.visit(treeMapModel3, n3, rect, list);
            }
            return list;
        }
        return null;
    }

    private final N visit(TreeMapModel<N, Row, Column> model, N node, Rectangle rect, List<N> list) {
        for (N child : model.getChildren(node)) {
            Shape shape = this.getRenderedShape(child);
            if (shape == null || !shape.intersects((Rectangle2D)rect)) continue;
            if (model.hasNoChildren(child)) {
                list.add(child);
            }
            this.visit(model, child, rect, list);
        }
        return node;
    }

    @Override
    @NotNull
    public Rectangle worldToScreenRectangle(@NotNull Rectangle2D rectangle) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        int x1 = (int)Math.rint(this.screenTransform.getX().worldToScreenPrecise(rectangle.getMinX()));
        int x2 = (int)Math.rint(this.screenTransform.getX().worldToScreenPrecise(rectangle.getMaxX()));
        int y1 = (int)Math.rint(this.screenTransform.getY().worldToScreenPrecise(rectangle.getMinY()));
        int y2 = (int)Math.rint(this.screenTransform.getY().worldToScreenPrecise(rectangle.getMaxY()));
        int width = x2 - x1;
        int height = y2 - y1;
        return width < 0 || height < 0 ? new Rectangle(x1, y1, 0, 0) : new Rectangle(x1, y1, width, height);
    }

    @Override
    @NotNull
    public Rectangle2D worldToScreenPrecise(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        double x1 = this.screenTransform.getX().worldToScreenPrecise(r.getMinX());
        double x2 = this.screenTransform.getX().worldToScreenPrecise(r.getMaxX());
        double y1 = this.screenTransform.getY().worldToScreenPrecise(r.getMinY());
        double y2 = this.screenTransform.getY().worldToScreenPrecise(r.getMaxY());
        double width = x2 - x1;
        double height = y2 - y1;
        return width < 0.0 || height < 0.0 ? (Rectangle2D)new Rectangle2D.Double(x1, y1, 0.0, 0.0) : (Rectangle2D)new Rectangle2D.Double(x1, y1, width, height);
    }

    @Override
    public float getZoomFactor() {
        float zoomFactorX = (float)(this.xRangeModel.getMaximumExtent() / this.xRangeModel.getExtent());
        float zoomFactorY = (float)(this.yRangeModel.getMaximumExtent() / this.yRangeModel.getExtent());
        return Math.min(zoomFactorX, zoomFactorY);
    }

    @Override
    @Nullable
    public TreeMapToolTip<N, Row, Column> getToolTip() {
        return this.probingToolTip;
    }

    @Override
    public void setToolTip(@Nullable TreeMapToolTip<N, Row, Column> tooltip) {
        if (this.probingToolTip != tooltip) {
            this.probingToolTip = tooltip;
            this.repaint();
        }
    }

    @Override
    public void repaint() {
        this.repaint(0L);
    }

    protected abstract void repaint(long var1);

    protected abstract void updateSize();

    @Override
    public void drill(int x, int y) {
        TreeMapModel<Object, Row, Column> treeMapModel = this.getModel();
        Intrinsics.checkNotNull(treeMapModel);
        TreeMapModel<Object, Row, Column> model = treeMapModel;
        N n = model.getCurrentRoot();
        Intrinsics.checkNotNull(n);
        N root = n;
        model.getProbing().clearSelection();
        Point location = new Point(x, y);
        List v = new ArrayList();
        for (N treeMapNode : model.breadthFirstIterator(root)) {
            if (!this.contains(location, this.getRenderedShape(treeMapNode))) continue;
            if (model.hasNoChildren(treeMapNode)) {
                Rectangle2D world = this.getWorld();
                this.zoom(false, world.getMinX(), world.getMaxX(), world.getMinY(), world.getMaxY());
                model.setCurrentRoot(model.getRoot());
                break;
            }
            v.add(treeMapNode);
            if (v.size() <= 1) continue;
            Rectangle2D world = this.getWorld();
            this.zoom(false, world.getMinX(), world.getMaxX(), world.getMinY(), world.getMaxY());
            model.setCurrentRoot(v.get(1));
            break;
        }
    }

    @Override
    public void drillDown() {
        TreeMapModel<Object, Row, Column> treeMapModel = this.getModel();
        Intrinsics.checkNotNull(treeMapModel);
        TreeMapModel<Object, Row, Column> model = treeMapModel;
        Object node = model.getProbing().getSelected();
        if (node != null) {
            while (model.getParent(node) != model.getCurrentRoot() && (node = model.getParent(node)) != null) {
            }
        }
        if (node != null && !model.hasNoChildren(node)) {
            BoundedInterval xRange = (BoundedInterval)this.xRangeModel;
            BoundedInterval yRange = (BoundedInterval)this.yRangeModel;
            this.zoom(false, xRange.getMinimum(), xRange.getMaximum(), yRange.getMinimum(), yRange.getMaximum());
            model.setCurrentRoot(node);
        }
    }

    @Override
    public void drillUp() {
        TreeMapModel<N, Row, Column> treeMapModel = this.getModel();
        Intrinsics.checkNotNull(treeMapModel);
        TreeMapModel<N, Row, Column> model = treeMapModel;
        model.getProbing().clearSelection();
        N n = model.getCurrentRoot();
        Intrinsics.checkNotNull(n);
        if (!model.isRoot(n)) {
            N root;
            BoundedInterval xRange = (BoundedInterval)this.xRangeModel;
            BoundedInterval yRange = (BoundedInterval)this.yRangeModel;
            this.zoom(false, xRange.getMinimum(), xRange.getMaximum(), yRange.getMinimum(), yRange.getMaximum());
            N n2 = model.getCurrentRoot();
            Intrinsics.checkNotNull(n2);
            N n3 = root = model.getParent(n2);
            Intrinsics.checkNotNull(n3);
            model.setCurrentRoot(n3);
        }
    }

    @Override
    public void zoomIn() {
        TreeMapModel<Object, Row, Column> treeMapModel = this.getModel();
        Intrinsics.checkNotNull(treeMapModel);
        TreeMapModel<Object, Row, Column> model = treeMapModel;
        Object node = model.getProbing().getSelected();
        if (node != null) {
            while (model.getParent(node) != model.getCurrentRoot() && (node = model.getParent(node)) != null) {
            }
        }
        if (node != null && !model.hasNoChildren(node)) {
            Rectangle2D rect = model.getBounds(node);
            Rectangle2D world = this.getWorld();
            double xExtent = rect.getWidth();
            double yExtent = rect.getHeight();
            double xRangeRatio = xExtent / world.getWidth();
            double yRangeRatio = yExtent / world.getHeight();
            double rangeRatio = Math.max(xRangeRatio, yRangeRatio);
            xExtent = rangeRatio * world.getWidth();
            yExtent = rangeRatio * world.getHeight();
            double x1 = rect.getX();
            double x2 = x1 + xExtent;
            double y1 = world.getMaxY() - (rect.getY() + yExtent);
            double y2 = world.getMaxY() - rect.getY();
            if (x1 < world.getMinX()) {
                x1 = world.getMinX();
                x2 = x1 + xExtent;
            }
            if (x2 > world.getMaxX()) {
                x1 = world.getMaxX() - xExtent;
                x2 = world.getMaxX();
            }
            if (y1 < world.getMinY()) {
                y1 = world.getMinY();
                y2 = y1 + yExtent;
            }
            if (y2 > world.getMaxY()) {
                y1 = world.getMaxY() - yExtent;
                y2 = world.getMaxY();
            }
            this.zoom(true, x1, x2, y1, y2);
        }
    }

    @Override
    public void zoomOut() {
        Rectangle2D world = this.getWorld();
        this.zoom(true, world.getMinX(), world.getMaxX(), world.getMinY(), world.getMaxY());
    }
}

