/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.treemap.CombinationGenerator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u00050\u0005\"\u0004\b\u0000\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\u00052\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00050\u00052\u0006\u0010\u000b\u001a\u00020\tJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\tJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fJ\u0016\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\t\u00a8\u0006\u0014"}, d2={"Lcom/treemap/PermutationGenerator;", "", "<init>", "()V", "generatePermutations", "", "T", "list", "r", "", "permutations", "n", "factorial", "", "generateNextProduct", "", "curr", "max", "generateNextPermutation", "temp", "treemap"})
@StabilityInferred(parameters=1)
public final class PermutationGenerator {
    @NotNull
    public static final PermutationGenerator INSTANCE = new PermutationGenerator();
    public static final int $stable;

    private PermutationGenerator() {
    }

    @NotNull
    public final <T> List<List<T>> generatePermutations(@NotNull List<? extends T> list, int r) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        List result = new ArrayList();
        List tempList = null;
        List<List<Integer>> mappings = CombinationGenerator.INSTANCE.combination(r, list.size());
        List<List<Integer>> rPermutations = this.permutations(r);
        for (List<Integer> combination : mappings) {
            for (List<Integer> permutation : rPermutations) {
                tempList = new ArrayList();
                Iterator<Integer> iterator2 = permutation.iterator();
                while (iterator2.hasNext()) {
                    int a = ((Number)iterator2.next()).intValue();
                    ((ArrayList)tempList).add(list.get(((Number)combination.get(a - 1)).intValue() - 1));
                }
                result.add(tempList);
            }
        }
        return result;
    }

    @NotNull
    public final List<List<Integer>> permutations(int n) {
        List result = new ArrayList();
        int nfact = (int)this.factorial(n);
        List tempList = null;
        int[] temp = new int[n];
        for (int i = 0; i < n; ++i) {
            temp[i] = i + 1;
        }
        tempList = new ArrayList();
        int x = 0;
        for (int i = 0; i < n; ++i) {
            x = temp[i];
            ((ArrayList)tempList).add(x);
        }
        result.add(tempList);
        int m = 0;
        int k = 0;
        for (int i = 1; i < nfact; ++i) {
            m = n - 1;
            while (temp[m - 1] > temp[m]) {
                --m;
            }
            k = n;
            while (temp[m - 1] > temp[k - 1]) {
                --k;
            }
            int swapVar = 0;
            swapVar = temp[m - 1];
            temp[m - 1] = temp[k - 1];
            temp[k - 1] = swapVar;
            int p = m + 1;
            for (int q = n; p < q; ++p, --q) {
                swapVar = temp[p - 1];
                temp[p - 1] = temp[q - 1];
                temp[q - 1] = swapVar;
            }
            tempList = new ArrayList();
            for (int j = 0; j < n; ++j) {
                x = temp[j];
                ((ArrayList)tempList).add(x);
            }
            result.add(tempList);
        }
        return result;
    }

    public final double factorial(int n) {
        int nfact = 1;
        int i = 1;
        if (i <= n) {
            while (true) {
                nfact *= i;
                if (i == n) break;
                ++i;
            }
        }
        return nfact;
    }

    @NotNull
    public final int[] generateNextProduct(@NotNull int[] curr, @NotNull int[] max) {
        Intrinsics.checkNotNullParameter((Object)curr, (String)"curr");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        int n = curr.length - 1;
        int n2 = curr[n];
        curr[n] = n2 + 1;
        for (int i = n; 0 < i; --i) {
            if (curr[i] <= max[i]) continue;
            curr[i] = 1;
            int n3 = i - 1;
            int n4 = curr[n3];
            curr[n3] = n4 + 1;
        }
        return curr;
    }

    @NotNull
    public final int[] generateNextPermutation(@NotNull int[] temp, int n) {
        Intrinsics.checkNotNullParameter((Object)temp, (String)"temp");
        int m = n - 1;
        while (temp[m - 1] > temp[m]) {
            --m;
        }
        int k = n;
        while (temp[m - 1] > temp[k - 1]) {
            --k;
        }
        int swapVar = 0;
        swapVar = temp[m - 1];
        temp[m - 1] = temp[k - 1];
        temp[k - 1] = swapVar;
        int p = m + 1;
        for (int q = n; p < q; ++p, --q) {
            swapVar = temp[p - 1];
            temp[p - 1] = temp[q - 1];
            temp[q - 1] = swapVar;
        }
        return temp;
    }
}

