/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.scale.NumericTransform;
import com.treemap.AbsScale;
import com.treemap.Exp10Scale;
import com.treemap.ExpScale;
import com.treemap.InverseScale;
import com.treemap.Log1pScale;
import com.treemap.LogScale;
import com.treemap.MaxScale;
import com.treemap.MinScale;
import com.treemap.NumericTransformScale;
import com.treemap.OriginalScale;
import com.treemap.Scale;
import com.treemap.XPlus1Scale;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001d\b\u0002\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004J\u0013\u0010\u0012\u001a\u00020\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0086\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lcom/treemap/ScaleFactory;", "", "entries", "", "Lcom/treemap/Scale;", "<init>", "([Lcom/treemap/Scale;)V", "", "add", "", "entry", "default", "getDefault", "()Lcom/treemap/Scale;", "scales", "", "getScales", "()Ljava/util/List;", "get", "name", "", "Companion", "treemap"})
@StabilityInferred(parameters=0)
public final class ScaleFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Scale> entries = new ArrayList();
    public static final int $stable = 8;
    @NotNull
    private static final Scale ORIGINAL = new OriginalScale();
    @NotNull
    private static final Scale ABS = new AbsScale();
    @NotNull
    private static final Scale EXP10 = new Exp10Scale();
    @NotNull
    private static final Scale EXP = new ExpScale();
    @NotNull
    private static final Scale INVERSE = new InverseScale();
    @NotNull
    private static final Scale LOG = new LogScale();
    @NotNull
    private static final Scale LOG1P = new Log1pScale();
    @NotNull
    private static final Scale MIN = new MinScale();
    @NotNull
    private static final Scale MAX = new MaxScale();
    @NotNull
    private static final Scale XPLUS1 = new XPlus1Scale();
    @NotNull
    private static final ScaleFactory instance;

    private ScaleFactory(Scale ... entries) {
        CollectionsKt.addAll((Collection)this.entries, (Object[])entries);
    }

    public final void add(@NotNull Scale entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.entries.add(entry);
    }

    @NotNull
    public final Scale getDefault() {
        return ABS;
    }

    @NotNull
    public final List<Scale> getScales() {
        return this.entries;
    }

    @NotNull
    public final Scale get(@Nullable String name) {
        for (Scale scale : this.entries) {
            if (!scale.toString().equals(name)) continue;
            return scale;
        }
        for (NumericTransform transform : NumericTransform.getEntries()) {
            NumericTransformScale scale = new NumericTransformScale(transform);
            if (!Intrinsics.areEqual((Object)scale.toString(), (Object)name)) continue;
            return scale;
        }
        return this.getDefault();
    }

    static {
        Scale[] scaleArray = new Scale[]{ORIGINAL, ABS, XPLUS1, EXP10, EXP, INVERSE, LOG, LOG1P, new NumericTransformScale(NumericTransform.PSEUDO_LOG), MIN, MAX, new NumericTransformScale(NumericTransform.SQRT)};
        instance = new ScaleFactory(scaleArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u0011\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R\u0011\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/treemap/ScaleFactory$Companion;", "", "<init>", "()V", "ORIGINAL", "Lcom/treemap/Scale;", "getORIGINAL", "()Lcom/treemap/Scale;", "ABS", "getABS", "EXP10", "getEXP10", "EXP", "getEXP", "INVERSE", "getINVERSE", "LOG", "getLOG", "LOG1P", "getLOG1P", "MIN", "getMIN", "MAX", "getMAX", "XPLUS1", "getXPLUS1", "instance", "Lcom/treemap/ScaleFactory;", "getInstance", "()Lcom/treemap/ScaleFactory;", "treemap"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Scale getORIGINAL() {
            return ORIGINAL;
        }

        @NotNull
        public final Scale getABS() {
            return ABS;
        }

        @NotNull
        public final Scale getEXP10() {
            return EXP10;
        }

        @NotNull
        public final Scale getEXP() {
            return EXP;
        }

        @NotNull
        public final Scale getINVERSE() {
            return INVERSE;
        }

        @NotNull
        public final Scale getLOG() {
            return LOG;
        }

        @NotNull
        public final Scale getLOG1P() {
            return LOG1P;
        }

        @NotNull
        public final Scale getMIN() {
            return MIN;
        }

        @NotNull
        public final Scale getMAX() {
            return MAX;
        }

        @NotNull
        public final Scale getXPLUS1() {
            return XPLUS1;
        }

        @NotNull
        public final ScaleFactory getInstance() {
            return instance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

