/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.command.Future;
import com.macrofocus.common.geom.Dimension;
import com.macrofocus.common.geom.PreferredSize;
import com.treemap.DefaultTreeMapTooltipRenderer;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapTooltipRenderer;
import com.treemap.TreeMapView;
import com.treemap.crossplatform.TGraphics;
import java.awt.Color;
import java.awt.Font;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.font.MkFontKt;
import org.mkui.font.Weight;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Shape;
import org.mkui.labeling.EnhancedLabel;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001f*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u00020\u0004:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J]\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0017\u00a2\u0006\u0002\u0010\u0018Js\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00102\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u001c2\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u001d\u00a2\u0006\u0002\u0010\u001eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006 "}, d2={"Lcom/treemap/ToolTipTreeMapRenderer;", "N", "Row", "Column", "", "<init>", "()V", "labelRenderer", "Lorg/mkui/labeling/EnhancedLabel;", "getLabelRenderer", "()Lorg/mkui/labeling/EnhancedLabel;", "paint", "", "g", "Lcom/treemap/crossplatform/TGraphics;", "view", "Lcom/treemap/TreeMapView;", "node", "width", "", "leftShift", "topShift", "progress", "Lcom/macrofocus/common/command/Future;", "(Lcom/treemap/crossplatform/TGraphics;Lcom/treemap/TreeMapView;Ljava/lang/Object;IIILcom/macrofocus/common/command/Future;)V", "drawToolTip", "Lorg/mkui/geom/Rectangle;", "model", "Lcom/treemap/TreeMapModel;", "", "(Lcom/treemap/crossplatform/TGraphics;Lcom/treemap/TreeMapView;Lcom/treemap/TreeMapModel;Ljava/lang/Object;IIIZ)Lorg/mkui/geom/Rectangle;", "Companion", "treemap"})
@StabilityInferred(parameters=0)
public final class ToolTipTreeMapRenderer<N, Row, Column> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EnhancedLabel labelRenderer = new EnhancedLabel();
    public static final int $stable = EnhancedLabel.$stable;
    private static final int leftMargin = 2;
    private static final int rightMargin = 1;

    public ToolTipTreeMapRenderer() {
        this.labelRenderer.setInsets(DefaultTreeMapTooltipRenderer.Companion.getDEFAULT_BORDER().getTop(), DefaultTreeMapTooltipRenderer.Companion.getDEFAULT_BORDER().getLeft(), DefaultTreeMapTooltipRenderer.Companion.getDEFAULT_BORDER().getBottom(), DefaultTreeMapTooltipRenderer.Companion.getDEFAULT_BORDER().getRight());
    }

    @NotNull
    public final EnhancedLabel getLabelRenderer() {
        return this.labelRenderer;
    }

    public final void paint(@NotNull TGraphics g, @NotNull TreeMapView<N, Row, Column> view, @Nullable N node, int width, int leftShift, int topShift, @Nullable Future<?> progress) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter(view, (String)"view");
        TreeMapModel<N, Row, Column> treeMapModel = view.getModel();
        Intrinsics.checkNotNull(treeMapModel);
        TreeMapModel<N, Row, Column> model = treeMapModel;
        if (node != null) {
            N n = model.getCurrentRoot();
            Intrinsics.checkNotNull(n);
            Shape shape = view.getRenderedShape(n);
            if (shape != null) {
                this.drawToolTip(g, view, model, node, width, leftShift, topShift, true);
            }
        }
    }

    @Nullable
    public final Rectangle drawToolTip(@Nullable TGraphics g, @NotNull TreeMapView<N, Row, Column> view, @NotNull TreeMapModel<N, Row, Column> model, N node, int width, int leftShift, int topShift, boolean paint2) {
        Rectangle rectangle;
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        List<Column> labelColumn = model.getSettings().getToolTipColumns();
        if (labelColumn != null && labelColumn.size() >= 0) {
            int height = 0;
            for (Column column : labelColumn) {
                Font font;
                if (column == null) continue;
                TreeMapTooltipRenderer<N, Row, Column> treeMapTooltipRenderer = view.getTooltipRenderer();
                Intrinsics.checkNotNull(treeMapTooltipRenderer);
                EnhancedLabel valueLabel = treeMapTooltipRenderer.getTooltipRendererComponent(view, column, node, new Dimension(width, 1000));
                if (valueLabel == null) continue;
                Intrinsics.checkNotNull((Object)model.getSettings().getColumnSettings(column).getTooltipFont());
                Font boldFont = MkFontKt.deriveFontWeight((Font)font, (Weight)Weight.BOLD);
                valueLabel.setFont(boldFont);
                Color color = model.getSettings().getColumnSettings(column).getTooltipForeground();
                Intrinsics.checkNotNull((Object)color);
                valueLabel.setForeground(color);
                valueLabel.setBackground(null);
                int valueWidth = width - 2 - 1;
                Dimension labelSize = null;
                if (model.getSettings().getColumnSettings(column).getShowLabel() && model.getSettings().getColumnSettings(column).getTooltipRendering() == EnhancedLabel.Rendering.WordWrap) {
                    this.labelRenderer.setFont(font);
                    Color color2 = model.getSettings().getColumnSettings(column).getTooltipForeground();
                    Intrinsics.checkNotNull((Object)color2);
                    this.labelRenderer.setForeground(color2);
                    this.labelRenderer.setBackground(null);
                    this.labelRenderer.setText(model.getColumnName(column) + ": ");
                    labelSize = view.getHeadless().sizeLabel(this.labelRenderer, g, valueWidth, 1000).getPreferredSize();
                } else {
                    labelSize = new Dimension(0, 0);
                }
                PreferredSize pf = view.getHeadless().sizeLabel(valueLabel, g, valueWidth - labelSize.getIwidth(), 1000);
                height += (int)pf.getPreferredHeight();
            }
            Rectangle bounds = new Rectangle(0, 0, width, height);
            if (height <= 0) {
                return null;
            }
            int top = bounds.getIy();
            for (Column column : labelColumn) {
                Rectangle rect;
                Font font;
                if (column == null) continue;
                TreeMapTooltipRenderer<N, Row, Column> treeMapTooltipRenderer = view.getTooltipRenderer();
                Intrinsics.checkNotNull(treeMapTooltipRenderer);
                EnhancedLabel valueLabel = treeMapTooltipRenderer.getTooltipRendererComponent(view, column, node, new Dimension(width, 1000));
                if (valueLabel == null) continue;
                Intrinsics.checkNotNull((Object)model.getSettings().getColumnSettings(column).getTooltipFont());
                Font boldFont = MkFontKt.deriveFontWeight((Font)font, (Weight)Weight.BOLD);
                valueLabel.setFont(boldFont);
                Color color = model.getSettings().getColumnSettings(column).getTooltipForeground();
                Intrinsics.checkNotNull((Object)color);
                valueLabel.setForeground(color);
                valueLabel.setBackground(null);
                int valueWidth = bounds.getIwidth() - 2 - 1;
                Dimension labelSize = null;
                if (model.getSettings().getColumnSettings(column).getShowLabel()) {
                    this.labelRenderer.setFont(font);
                    Color color3 = model.getSettings().getColumnSettings(column).getTooltipForeground();
                    Intrinsics.checkNotNull((Object)color3);
                    this.labelRenderer.setForeground(color3);
                    this.labelRenderer.setBackground(null);
                    this.labelRenderer.setText(model.getColumnName(column) + ": ");
                    labelSize = view.getHeadless().sizeLabel(this.labelRenderer, g, valueWidth, 1000).getPreferredSize();
                } else {
                    labelSize = new Dimension(0, 0);
                }
                PreferredSize pf = view.getHeadless().sizeLabel(valueLabel, g, valueWidth - labelSize.getIwidth(), 1000);
                Dimension valueSize = pf.getPreferredSize();
                if (!((double)top + valueSize.getHeight() <= bounds.getY() + bounds.getHeight())) break;
                int x = bounds.getIx() + 2;
                if (model.getSettings().getColumnSettings(column).getShowLabel()) {
                    rect = new Rectangle(x, top, labelSize.getIwidth(), labelSize.getIheight());
                    if (paint2 && g != null) {
                        g.paintLabel(this.labelRenderer, rect.getIx(), rect.getIy(), rect.getIwidth(), rect.getIheight());
                    }
                    if (model.isNumericType(column)) {
                        x += labelSize.getIwidth();
                        valueWidth -= labelSize.getIwidth();
                    } else {
                        x += labelSize.getIwidth();
                        valueWidth -= labelSize.getIwidth();
                    }
                }
                rect = new Rectangle(x, top, valueWidth, valueSize.getIheight());
                if (paint2 && g != null) {
                    g.paintLabel(valueLabel, rect.getIx(), rect.getIy(), rect.getIwidth(), rect.getIheight());
                }
                top += valueSize.getIheight();
            }
            rectangle = bounds;
        } else {
            rectangle = null;
        }
        return rectangle;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/treemap/ToolTipTreeMapRenderer$Companion;", "", "<init>", "()V", "leftMargin", "", "rightMargin", "treemap"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

