/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.trenddisplay.timeseriesplot;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.interval.MutableBoundedInterval;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.trenddisplay.timeseriesplot.TimeSeriesPlotController;
import com.macrofocus.trenddisplay.timeseriesplot.TimeSeriesPlotModel;
import com.macrofocus.trenddisplay.timeseriesplot.TimeSeriesPlotView;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.canvas.KeyEvent;
import org.mkui.canvas.KeyListener;
import org.mkui.canvas.MouseEvent;
import org.mkui.canvas.MouseListener;
import org.mkui.canvas.MouseMotionListener;
import org.mkui.canvas.MouseWheelEvent;
import org.mkui.canvas.MouseWheelListener;
import org.mkui.geom.Point;
import org.mkui.geom.Rectangle2D;
import org.mkui.rubberband.RubberBand;
import org.mkui.transform.MutableTwoDScreenTransform;
import org.mkui.visual.Visual;
import org.molap.aggregates.cube.Group;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b'\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003:\u0003\u001f !B\u001d\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\u0012\u001a\u00020\u00132\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0005H\u0016J \u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0002R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u00120\u000fR\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001c\u00a8\u0006\""}, d2={"Lcom/macrofocus/trenddisplay/timeseriesplot/AbstractTimeSeriesPlotController;", "Row", "Column", "Lcom/macrofocus/trenddisplay/timeseriesplot/TimeSeriesPlotController;", "view", "Lcom/macrofocus/trenddisplay/timeseriesplot/TimeSeriesPlotView;", "<init>", "(Lcom/macrofocus/trenddisplay/timeseriesplot/TimeSeriesPlotView;)V", "mode", "Lcom/macrofocus/trenddisplay/timeseriesplot/AbstractTimeSeriesPlotController$Mode;", "multipleSelectionEnabled", "", "selectOnPopupTrigger", "improvedBorderZooming", "mouseListener", "Lcom/macrofocus/trenddisplay/timeseriesplot/AbstractTimeSeriesPlotController$DefaultMouseListener;", "keyListener", "Lorg/mkui/canvas/KeyListener;", "setView", "", "zoom", "amount", "", "xCenter", "yCenter", "viewport", "Lorg/mkui/geom/Rectangle2D;", "getViewport", "()Lorg/mkui/geom/Rectangle2D;", "world", "getWorld", "Mode", "Range", "DefaultMouseListener", "trenddisplay"})
@StabilityInferred(parameters=0)
public abstract class AbstractTimeSeriesPlotController<Row, Column>
implements TimeSeriesPlotController<Row, Column> {
    @Nullable
    private TimeSeriesPlotView<Row, Column> view;
    @NotNull
    private Mode mode = Mode.Selection;
    private final boolean multipleSelectionEnabled;
    private final boolean selectOnPopupTrigger;
    private final boolean improvedBorderZooming;
    @NotNull
    private final DefaultMouseListener mouseListener = new DefaultMouseListener();
    @NotNull
    private final KeyListener keyListener = new KeyListener(this){
        private Mode oldMode;
        final /* synthetic */ AbstractTimeSeriesPlotController<Row, Column> this$0;
        {
            this.this$0 = $receiver;
        }

        public final Mode getOldMode() {
            return this.oldMode;
        }

        public final void setOldMode(Mode mode) {
            this.oldMode = mode;
        }

        public void keyTyped(KeyEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        }

        public void keyPressed(KeyEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.getKeyCode() == 83) {
                if (this.oldMode == null) {
                    this.oldMode = AbstractTimeSeriesPlotController.access$getMode$p(this.this$0);
                }
                AbstractTimeSeriesPlotController.access$setMode$p(this.this$0, Mode.Selection);
            }
            if (event.getKeyCode() == 90 || event.getKeyCode() == 16) {
                if (this.oldMode == null) {
                    this.oldMode = AbstractTimeSeriesPlotController.access$getMode$p(this.this$0);
                }
                AbstractTimeSeriesPlotController.access$setMode$p(this.this$0, Mode.Zooming);
            }
            if (event.getKeyCode() == 80 || event.getKeyCode() == 32) {
                if (this.oldMode == null) {
                    this.oldMode = AbstractTimeSeriesPlotController.access$getMode$p(this.this$0);
                }
                AbstractTimeSeriesPlotController.access$setMode$p(this.this$0, Mode.Panning);
            }
        }

        public void keyReleased(KeyEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (this.oldMode != null) {
                Mode mode = this.oldMode;
                Intrinsics.checkNotNull((Object)((Object)mode));
                AbstractTimeSeriesPlotController.access$setMode$p(this.this$0, mode);
                this.oldMode = null;
            }
        }
    };
    public static final int $stable = 8;

    public AbstractTimeSeriesPlotController(@Nullable TimeSeriesPlotView<Row, Column> view) {
        this.multipleSelectionEnabled = true;
        this.setView(view);
    }

    @Override
    public void setView(@Nullable TimeSeriesPlotView<Row, Column> view) {
        if (this.view != null) {
            // empty if block
        }
        this.view = view;
        if (view != null) {
            view.addKeyListener(this.keyListener);
            view.addMouseListener(this.mouseListener);
            view.addMouseMotionListener(this.mouseListener);
            view.addMouseWheelListener(this.mouseListener);
        }
    }

    private final void zoom(double amount, double xCenter, double yCenter) {
        block1: {
            Rectangle2D viewport = this.getViewport();
            Rectangle2D world = this.getWorld();
            Double d = xCenter;
            double d2 = viewport.getMinX();
            double d3 = viewport.getWidth();
            double d4 = world.getMinX();
            double d5 = world.getMaxX();
            TimeSeriesPlotView<Row, Column> timeSeriesPlotView = this.view;
            Intrinsics.checkNotNull(timeSeriesPlotView);
            MutableBoundedInterval mutableBoundedInterval = timeSeriesPlotView.getXRangeModel();
            Intrinsics.checkNotNull((Object)mutableBoundedInterval);
            Range xRange = new Range(amount, d, d2, d3, d4, d5, mutableBoundedInterval.getMaximumExtent()).invoke();
            double xMin = xRange.getMin();
            double xMax = xRange.getMax();
            Double d6 = yCenter;
            double d7 = viewport.getMinY();
            double d8 = viewport.getHeight();
            double d9 = world.getMinY();
            double d10 = world.getMaxY();
            TimeSeriesPlotView<Row, Column> timeSeriesPlotView2 = this.view;
            Intrinsics.checkNotNull(timeSeriesPlotView2);
            MutableBoundedInterval mutableBoundedInterval2 = timeSeriesPlotView2.getYRangeModel();
            Intrinsics.checkNotNull((Object)mutableBoundedInterval2);
            Range yRange = new Range(amount, d6, d7, d8, d9, d10, mutableBoundedInterval2.getMaximumExtent()).invoke();
            double yMin = yRange.getMin();
            double yMax = yRange.getMax();
            if (!(xMin < xMax) || !(yMin < yMax)) break block1;
            TimeSeriesPlotView<Row, Column> timeSeriesPlotView3 = this.view;
            if (timeSeriesPlotView3 != null) {
                timeSeriesPlotView3.zoom(false, xMin, xMax, yMin, yMax);
            }
        }
    }

    @NotNull
    public final Rectangle2D getViewport() {
        TimeSeriesPlotView<Row, Column> timeSeriesPlotView = this.view;
        Intrinsics.checkNotNull(timeSeriesPlotView);
        MutableBoundedInterval mutableBoundedInterval = timeSeriesPlotView.getXRangeModel();
        Intrinsics.checkNotNull((Object)mutableBoundedInterval);
        double d = mutableBoundedInterval.getStart();
        TimeSeriesPlotView<Row, Column> timeSeriesPlotView2 = this.view;
        Intrinsics.checkNotNull(timeSeriesPlotView2);
        MutableBoundedInterval mutableBoundedInterval2 = timeSeriesPlotView2.getYRangeModel();
        Intrinsics.checkNotNull((Object)mutableBoundedInterval2);
        double d2 = mutableBoundedInterval2.getStart();
        TimeSeriesPlotView<Row, Column> timeSeriesPlotView3 = this.view;
        Intrinsics.checkNotNull(timeSeriesPlotView3);
        MutableBoundedInterval mutableBoundedInterval3 = timeSeriesPlotView3.getXRangeModel();
        Intrinsics.checkNotNull((Object)mutableBoundedInterval3);
        double d3 = mutableBoundedInterval3.getExtent();
        TimeSeriesPlotView<Row, Column> timeSeriesPlotView4 = this.view;
        Intrinsics.checkNotNull(timeSeriesPlotView4);
        MutableBoundedInterval mutableBoundedInterval4 = timeSeriesPlotView4.getYRangeModel();
        Intrinsics.checkNotNull((Object)mutableBoundedInterval4);
        Rectangle2D.Double r = new Rectangle2D.Double(d, d2, d3, mutableBoundedInterval4.getExtent());
        return (Rectangle2D)r;
    }

    @NotNull
    public final Rectangle2D getWorld() {
        TimeSeriesPlotView<Row, Column> timeSeriesPlotView = this.view;
        Intrinsics.checkNotNull(timeSeriesPlotView);
        MutableBoundedInterval mutableBoundedInterval = timeSeriesPlotView.getXRangeModel();
        Intrinsics.checkNotNull((Object)mutableBoundedInterval);
        double d = mutableBoundedInterval.getMinimum();
        TimeSeriesPlotView<Row, Column> timeSeriesPlotView2 = this.view;
        Intrinsics.checkNotNull(timeSeriesPlotView2);
        MutableBoundedInterval mutableBoundedInterval2 = timeSeriesPlotView2.getYRangeModel();
        Intrinsics.checkNotNull((Object)mutableBoundedInterval2);
        double d2 = mutableBoundedInterval2.getMinimum();
        TimeSeriesPlotView<Row, Column> timeSeriesPlotView3 = this.view;
        Intrinsics.checkNotNull(timeSeriesPlotView3);
        MutableBoundedInterval mutableBoundedInterval3 = timeSeriesPlotView3.getXRangeModel();
        Intrinsics.checkNotNull((Object)mutableBoundedInterval3);
        double d3 = mutableBoundedInterval3.getMaximum();
        TimeSeriesPlotView<Row, Column> timeSeriesPlotView4 = this.view;
        Intrinsics.checkNotNull(timeSeriesPlotView4);
        MutableBoundedInterval mutableBoundedInterval4 = timeSeriesPlotView4.getXRangeModel();
        Intrinsics.checkNotNull((Object)mutableBoundedInterval4);
        double d4 = d3 - mutableBoundedInterval4.getMinimum();
        TimeSeriesPlotView<Row, Column> timeSeriesPlotView5 = this.view;
        Intrinsics.checkNotNull(timeSeriesPlotView5);
        MutableBoundedInterval mutableBoundedInterval5 = timeSeriesPlotView5.getYRangeModel();
        Intrinsics.checkNotNull((Object)mutableBoundedInterval5);
        double d5 = mutableBoundedInterval5.getMaximum();
        TimeSeriesPlotView<Row, Column> timeSeriesPlotView6 = this.view;
        Intrinsics.checkNotNull(timeSeriesPlotView6);
        MutableBoundedInterval mutableBoundedInterval6 = timeSeriesPlotView6.getYRangeModel();
        Intrinsics.checkNotNull((Object)mutableBoundedInterval6);
        Rectangle2D.Double r = new Rectangle2D.Double(d, d2, d4, d5 - mutableBoundedInterval6.getMinimum());
        return (Rectangle2D)r;
    }

    public static final /* synthetic */ Mode access$getMode$p(AbstractTimeSeriesPlotController $this) {
        return $this.mode;
    }

    public static final /* synthetic */ void access$setMode$p(AbstractTimeSeriesPlotController $this, Mode mode) {
        $this.mode = mode;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0018H\u0016J\u0015\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0017\u0010\u001c\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010\u001d\u001a\u00020\u000f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001fH\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/macrofocus/trenddisplay/timeseriesplot/AbstractTimeSeriesPlotController$DefaultMouseListener;", "Lorg/mkui/canvas/MouseListener;", "Lorg/mkui/canvas/MouseMotionListener;", "Lorg/mkui/canvas/MouseWheelListener;", "<init>", "(Lcom/macrofocus/trenddisplay/timeseriesplot/AbstractTimeSeriesPlotController;)V", "last", "Lorg/mkui/canvas/MouseEvent;", "selectOnRelease", "Ljava/lang/Object;", "zoomOnRelease", "Lorg/mkui/geom/Point;", "zoomingPoint", "pressedPoint", "mouseClicked", "", "event", "mousePressed", "mouseReleased", "mouseEntered", "mouseExited", "mouseDragged", "mouseMoved", "mouseWheelMoved", "Lorg/mkui/canvas/MouseWheelEvent;", "removeFromSelection", "observation", "(Ljava/lang/Object;)V", "setSelection", "addToSelection", "newSelection", "", "trenddisplay"})
    public final class DefaultMouseListener
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        @Nullable
        private MouseEvent last;
        @Nullable
        private Row selectOnRelease;
        @Nullable
        private Point zoomOnRelease;
        @Nullable
        private final Point zoomingPoint;
        @Nullable
        private Point pressedPoint;

        public void mouseClicked(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        }

        public void mousePressed(@NotNull MouseEvent event) {
            block4: {
                block5: {
                    Object bestrow;
                    block6: {
                        block7: {
                            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                            if (AbstractTimeSeriesPlotController.this.view == null) break block4;
                            this.pressedPoint = new Point(event.getX(), event.getY());
                            TimeSeriesPlotView timeSeriesPlotView = AbstractTimeSeriesPlotController.this.view;
                            Intrinsics.checkNotNull((Object)timeSeriesPlotView);
                            bestrow = timeSeriesPlotView.getClosestRow(event.getX(), event.getY());
                            if (bestrow == null) break block5;
                            if (event.isMultipleSelectionKey()) break block6;
                            TimeSeriesPlotView timeSeriesPlotView2 = AbstractTimeSeriesPlotController.this.view;
                            Intrinsics.checkNotNull((Object)timeSeriesPlotView2);
                            TimeSeriesPlotModel timeSeriesPlotModel = timeSeriesPlotView2.getModel();
                            Intrinsics.checkNotNull(timeSeriesPlotModel);
                            MutableSelection mutableSelection = timeSeriesPlotModel.getSelection();
                            Intrinsics.checkNotNull(mutableSelection);
                            if (!mutableSelection.isSelected(bestrow)) break block7;
                            TimeSeriesPlotView timeSeriesPlotView3 = AbstractTimeSeriesPlotController.this.view;
                            Intrinsics.checkNotNull((Object)timeSeriesPlotView3);
                            TimeSeriesPlotModel timeSeriesPlotModel2 = timeSeriesPlotView3.getModel();
                            Intrinsics.checkNotNull(timeSeriesPlotModel2);
                            MutableSelection mutableSelection2 = timeSeriesPlotModel2.getSelection();
                            Intrinsics.checkNotNull(mutableSelection2);
                            if (mutableSelection2.getSelectedCount() <= 1) break block4;
                        }
                        TimeSeriesPlotView timeSeriesPlotView = AbstractTimeSeriesPlotController.this.view;
                        Intrinsics.checkNotNull((Object)timeSeriesPlotView);
                        TimeSeriesPlotModel timeSeriesPlotModel = timeSeriesPlotView.getModel();
                        Intrinsics.checkNotNull(timeSeriesPlotModel);
                        MutableSelection mutableSelection = timeSeriesPlotModel.getSelection();
                        Intrinsics.checkNotNull(mutableSelection);
                        mutableSelection.clearSelection();
                        TimeSeriesPlotView timeSeriesPlotView4 = AbstractTimeSeriesPlotController.this.view;
                        Intrinsics.checkNotNull((Object)timeSeriesPlotView4);
                        TimeSeriesPlotModel timeSeriesPlotModel3 = timeSeriesPlotView4.getModel();
                        Intrinsics.checkNotNull(timeSeriesPlotModel3);
                        MutableSelection mutableSelection3 = timeSeriesPlotModel3.getSelection();
                        Intrinsics.checkNotNull(mutableSelection3);
                        mutableSelection3.setSelectedElement(bestrow);
                        TimeSeriesPlotView timeSeriesPlotView5 = AbstractTimeSeriesPlotController.this.view;
                        Intrinsics.checkNotNull((Object)timeSeriesPlotView5);
                        TimeSeriesPlotView timeSeriesPlotView6 = AbstractTimeSeriesPlotController.this.view;
                        Intrinsics.checkNotNull((Object)timeSeriesPlotView6);
                        TimeSeriesPlotModel timeSeriesPlotModel4 = timeSeriesPlotView6.getModel();
                        Intrinsics.checkNotNull(timeSeriesPlotModel4);
                        MutableSelection mutableSelection4 = timeSeriesPlotModel4.getSelection();
                        Intrinsics.checkNotNull(mutableSelection4);
                        timeSeriesPlotView5.setSelectionMode(mutableSelection4.isSelected(bestrow));
                        break block4;
                    }
                    TimeSeriesPlotView timeSeriesPlotView = AbstractTimeSeriesPlotController.this.view;
                    Intrinsics.checkNotNull((Object)timeSeriesPlotView);
                    TimeSeriesPlotView timeSeriesPlotView7 = AbstractTimeSeriesPlotController.this.view;
                    Intrinsics.checkNotNull((Object)timeSeriesPlotView7);
                    TimeSeriesPlotModel timeSeriesPlotModel = timeSeriesPlotView7.getModel();
                    Intrinsics.checkNotNull(timeSeriesPlotModel);
                    MutableSelection mutableSelection = timeSeriesPlotModel.getSelection();
                    Intrinsics.checkNotNull(mutableSelection);
                    timeSeriesPlotView.setSelectionMode(!mutableSelection.isSelected(bestrow));
                    TimeSeriesPlotView timeSeriesPlotView8 = AbstractTimeSeriesPlotController.this.view;
                    Intrinsics.checkNotNull((Object)timeSeriesPlotView8);
                    if (timeSeriesPlotView8.isSelectionMode()) {
                        TimeSeriesPlotView timeSeriesPlotView9 = AbstractTimeSeriesPlotController.this.view;
                        Intrinsics.checkNotNull((Object)timeSeriesPlotView9);
                        TimeSeriesPlotModel timeSeriesPlotModel5 = timeSeriesPlotView9.getModel();
                        Intrinsics.checkNotNull(timeSeriesPlotModel5);
                        MutableSelection mutableSelection5 = timeSeriesPlotModel5.getSelection();
                        Intrinsics.checkNotNull(mutableSelection5);
                        mutableSelection5.setSelectedState(bestrow, true);
                    } else {
                        TimeSeriesPlotView timeSeriesPlotView10 = AbstractTimeSeriesPlotController.this.view;
                        Intrinsics.checkNotNull((Object)timeSeriesPlotView10);
                        TimeSeriesPlotModel timeSeriesPlotModel6 = timeSeriesPlotView10.getModel();
                        Intrinsics.checkNotNull(timeSeriesPlotModel6);
                        MutableSelection mutableSelection6 = timeSeriesPlotModel6.getSelection();
                        Intrinsics.checkNotNull(mutableSelection6);
                        mutableSelection6.setSelectedState(bestrow, false);
                    }
                    break block4;
                }
                TimeSeriesPlotView timeSeriesPlotView = AbstractTimeSeriesPlotController.this.view;
                Intrinsics.checkNotNull((Object)timeSeriesPlotView);
                TimeSeriesPlotModel timeSeriesPlotModel = timeSeriesPlotView.getModel();
                Intrinsics.checkNotNull(timeSeriesPlotModel);
                MutableSelection mutableSelection = timeSeriesPlotModel.getSelection();
                Intrinsics.checkNotNull(mutableSelection);
                mutableSelection.clearSelection();
            }
        }

        public void mouseReleased(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (AbstractTimeSeriesPlotController.this.view != null) {
                if (!event.isPopupTrigger()) {
                    if (this.selectOnRelease != null && event.isLeftMouseButton()) {
                        TimeSeriesPlotView timeSeriesPlotView = AbstractTimeSeriesPlotController.this.view;
                        Intrinsics.checkNotNull((Object)timeSeriesPlotView);
                        TimeSeriesPlotModel timeSeriesPlotModel = timeSeriesPlotView.getModel();
                        Intrinsics.checkNotNull(timeSeriesPlotModel);
                        MutableSelection mutableSelection = timeSeriesPlotModel.getSelection();
                        Intrinsics.checkNotNull(mutableSelection);
                        mutableSelection.clearSelection();
                        if (AbstractTimeSeriesPlotController.this.multipleSelectionEnabled) {
                            Object Row = this.selectOnRelease;
                            Intrinsics.checkNotNull(Row);
                            this.addToSelection(Row);
                        } else {
                            this.setSelection(this.selectOnRelease);
                        }
                        this.selectOnRelease = null;
                    }
                    if (this.zoomOnRelease != null) {
                        if (event.isLeftMouseButton()) {
                            // empty if block
                        }
                        this.zoomOnRelease = null;
                    }
                    TimeSeriesPlotView timeSeriesPlotView = AbstractTimeSeriesPlotController.this.view;
                    Intrinsics.checkNotNull((Object)timeSeriesPlotView);
                    RubberBand rubberBand = timeSeriesPlotView.getRubberBand();
                    if (rubberBand != null) {
                        rubberBand.stopRubberBand();
                    }
                } else if (AbstractTimeSeriesPlotController.this.selectOnPopupTrigger) {
                    TimeSeriesPlotView timeSeriesPlotView = AbstractTimeSeriesPlotController.this.view;
                    Intrinsics.checkNotNull((Object)timeSeriesPlotView);
                    Object node = timeSeriesPlotView.getClosestRow(event.getX(), event.getY());
                    this.setSelection(node);
                }
                this.last = null;
            }
        }

        public void mouseEntered(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (AbstractTimeSeriesPlotController.this.view != null) {
                TimeSeriesPlotView timeSeriesPlotView = AbstractTimeSeriesPlotController.this.view;
                Intrinsics.checkNotNull((Object)timeSeriesPlotView);
                if (timeSeriesPlotView.getModel() != null) {
                    TimeSeriesPlotView timeSeriesPlotView2 = AbstractTimeSeriesPlotController.this.view;
                    Intrinsics.checkNotNull((Object)timeSeriesPlotView2);
                    TimeSeriesPlotModel timeSeriesPlotModel = timeSeriesPlotView2.getModel();
                    Intrinsics.checkNotNull(timeSeriesPlotModel);
                    MutableSingleSelection mutableSingleSelection = timeSeriesPlotModel.getProbing();
                    Intrinsics.checkNotNull(mutableSingleSelection);
                    TimeSeriesPlotView timeSeriesPlotView3 = AbstractTimeSeriesPlotController.this.view;
                    Intrinsics.checkNotNull((Object)timeSeriesPlotView3);
                    mutableSingleSelection.setSelected(timeSeriesPlotView3.getClosestRow(event.getX(), event.getY()));
                }
            }
        }

        public void mouseExited(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (AbstractTimeSeriesPlotController.this.view != null) {
                TimeSeriesPlotView timeSeriesPlotView = AbstractTimeSeriesPlotController.this.view;
                Intrinsics.checkNotNull((Object)timeSeriesPlotView);
                if (timeSeriesPlotView.getModel() != null) {
                    TimeSeriesPlotView timeSeriesPlotView2 = AbstractTimeSeriesPlotController.this.view;
                    Intrinsics.checkNotNull((Object)timeSeriesPlotView2);
                    TimeSeriesPlotModel timeSeriesPlotModel = timeSeriesPlotView2.getModel();
                    Intrinsics.checkNotNull(timeSeriesPlotModel);
                    MutableSingleSelection mutableSingleSelection = timeSeriesPlotModel.getProbing();
                    Intrinsics.checkNotNull(mutableSingleSelection);
                    mutableSingleSelection.clearSelection();
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        public void mouseDragged(@NotNull MouseEvent event) {
            block21: {
                block22: {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (AbstractTimeSeriesPlotController.access$getView$p(AbstractTimeSeriesPlotController.this) == null) break block21;
                    v0 = AbstractTimeSeriesPlotController.access$getView$p(AbstractTimeSeriesPlotController.this);
                    Intrinsics.checkNotNull((Object)v0);
                    if (v0.getModel() == null) break block21;
                    if (this.last == null) break block22;
                    switch (WhenMappings.$EnumSwitchMapping$0[AbstractTimeSeriesPlotController.access$getMode$p(AbstractTimeSeriesPlotController.this).ordinal()]) {
                        case 1: {
                            if (!event.isLeftMouseButton()) break;
                            if (event.isAltKeyDown() || event.isShiftKeyDown()) {
                                v1 = AbstractTimeSeriesPlotController.access$getView$p(AbstractTimeSeriesPlotController.this);
                                Intrinsics.checkNotNull((Object)v1);
                                v2 = v1.getModel();
                                Intrinsics.checkNotNull(v2);
                                v3 = v2.getProbing();
                                Intrinsics.checkNotNull(v3);
                                v3.clearSelection();
                                if (!AbstractTimeSeriesPlotController.access$getMultipleSelectionEnabled$p(AbstractTimeSeriesPlotController.this)) break;
                                v4 = AbstractTimeSeriesPlotController.access$getView$p(AbstractTimeSeriesPlotController.this);
                                Intrinsics.checkNotNull((Object)v4);
                                v5 = v4.getRubberBand();
                                Intrinsics.checkNotNull((Object)v5);
                                if (!v5.getRubberBand().isActive()) {
                                    v6 = AbstractTimeSeriesPlotController.access$getView$p(AbstractTimeSeriesPlotController.this);
                                    Intrinsics.checkNotNull((Object)v6);
                                    v7 = v6.getRubberBand();
                                    Intrinsics.checkNotNull((Object)v7);
                                    v8 = this.pressedPoint;
                                    Intrinsics.checkNotNull((Object)v8);
                                    v9 = (int)v8.getX();
                                    v10 = this.pressedPoint;
                                    Intrinsics.checkNotNull((Object)v10);
                                    v7.startRubberBand(v9, (int)v10.getY());
                                }
                                v11 = AbstractTimeSeriesPlotController.access$getView$p(AbstractTimeSeriesPlotController.this);
                                Intrinsics.checkNotNull((Object)v11);
                                v12 = v11.getRubberBand();
                                Intrinsics.checkNotNull((Object)v12);
                                v12.stretchRubberBand(event.getX(), event.getY());
                                v13 = AbstractTimeSeriesPlotController.access$getView$p(AbstractTimeSeriesPlotController.this);
                                v14 = v13 != null && (v13 = v13.getRubberBand()) != null ? v13.getRubberBandScreen() : (rect = null);
                                if (rect == null) break;
                                v15 = AbstractTimeSeriesPlotController.access$getView$p(AbstractTimeSeriesPlotController.this);
                                Intrinsics.checkNotNull((Object)v15);
                                toSelect = v15.getRows(rect);
                                if (event.isMultipleSelectionKey()) {
                                    this.addToSelection(toSelect);
                                } else {
                                    v16 = AbstractTimeSeriesPlotController.access$getView$p(AbstractTimeSeriesPlotController.this);
                                    Intrinsics.checkNotNull((Object)v16);
                                    v17 = v16.getModel();
                                    Intrinsics.checkNotNull(v17);
                                    v18 = v17.getSelection();
                                    Intrinsics.checkNotNull(v18);
                                    v18.setSelectedIterable((Iterable)toSelect);
                                }
                                this.selectOnRelease = null;
                                break;
                            }
                            v19 = AbstractTimeSeriesPlotController.access$getView$p(AbstractTimeSeriesPlotController.this);
                            Intrinsics.checkNotNull((Object)v19);
                            observation = v19.getClosestRow(event.getX(), event.getY());
                            v20 = AbstractTimeSeriesPlotController.access$getView$p(AbstractTimeSeriesPlotController.this);
                            Intrinsics.checkNotNull((Object)v20);
                            v21 = v20.getModel();
                            Intrinsics.checkNotNull(v21);
                            v22 = v21.getProbing();
                            Intrinsics.checkNotNull(v22);
                            v22.setSelected(observation);
                            this.selectOnRelease = null;
                            v23 = AbstractTimeSeriesPlotController.access$getView$p(AbstractTimeSeriesPlotController.this);
                            Intrinsics.checkNotNull((Object)v23);
                            v24 = v23.getModel();
                            Intrinsics.checkNotNull(v24);
                            if (v24.getSelection() == null) ** GOTO lbl-1000
                            v25 = AbstractTimeSeriesPlotController.access$getView$p(AbstractTimeSeriesPlotController.this);
                            Intrinsics.checkNotNull((Object)v25);
                            v26 = v25.getModel();
                            Intrinsics.checkNotNull(v26);
                            v27 = v26.getSelection();
                            Intrinsics.checkNotNull(v27);
                            if (v27.isSelected(observation)) {
                                v28 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v28 = isAlreadySelected = false;
                            }
                            if (!isAlreadySelected && !event.isMenuShortcutKeyDown()) {
                                v29 = AbstractTimeSeriesPlotController.access$getView$p(AbstractTimeSeriesPlotController.this);
                                Intrinsics.checkNotNull((Object)v29);
                                v30 = v29.getModel();
                                Intrinsics.checkNotNull(v30);
                                v31 = v30.getSelection();
                                Intrinsics.checkNotNull(v31);
                                v31.clearSelection();
                            }
                            if (event.isMenuShortcutKeyDown()) {
                                if (AbstractTimeSeriesPlotController.access$getMultipleSelectionEnabled$p(AbstractTimeSeriesPlotController.this)) {
                                    v32 = observation;
                                    Intrinsics.checkNotNull(v32);
                                    this.addToSelection(v32);
                                    break;
                                }
                                this.setSelection(observation);
                                break;
                            }
                            if (isAlreadySelected) {
                                this.selectOnRelease = observation;
                                break;
                            }
                            if (AbstractTimeSeriesPlotController.access$getMultipleSelectionEnabled$p(AbstractTimeSeriesPlotController.this)) {
                                v33 = observation;
                                Intrinsics.checkNotNull(v33);
                                this.addToSelection(v33);
                                break;
                            }
                            this.setSelection(observation);
                            break;
                        }
                        case 2: {
                            if (!event.isLeftMouseButton()) break;
                            v34 = AbstractTimeSeriesPlotController.access$getView$p(AbstractTimeSeriesPlotController.this);
                            Intrinsics.checkNotNull((Object)v34);
                            v35 = v34.getScreenTransform();
                            Intrinsics.checkNotNull((Object)v35);
                            v36 = v35.getX();
                            v37 = this.last;
                            Intrinsics.checkNotNull((Object)v37);
                            x1 = v36.screenToWorld(v37.getX());
                            v38 = AbstractTimeSeriesPlotController.access$getView$p(AbstractTimeSeriesPlotController.this);
                            Intrinsics.checkNotNull((Object)v38);
                            v39 = v38.getScreenTransform();
                            Intrinsics.checkNotNull((Object)v39);
                            x2 = v39.getX().screenToWorld(event.getX());
                            worldDiffX = x1 - x2;
                            xMin = AbstractTimeSeriesPlotController.this.getViewport().getMinX() + worldDiffX;
                            xMax = AbstractTimeSeriesPlotController.this.getViewport().getMaxX() + worldDiffX;
                            v40 = AbstractTimeSeriesPlotController.access$getView$p(AbstractTimeSeriesPlotController.this);
                            Intrinsics.checkNotNull((Object)v40);
                            v41 = v40.getScreenTransform();
                            Intrinsics.checkNotNull((Object)v41);
                            v42 = v41.getY();
                            v43 = this.last;
                            Intrinsics.checkNotNull((Object)v43);
                            y1 = v42.screenToWorld(v43.getY());
                            v44 = AbstractTimeSeriesPlotController.access$getView$p(AbstractTimeSeriesPlotController.this);
                            Intrinsics.checkNotNull((Object)v44);
                            v45 = v44.getScreenTransform();
                            Intrinsics.checkNotNull((Object)v45);
                            y2 = v45.getY().screenToWorld(event.getY());
                            worldDiffY = y1 - y2;
                            yMin = AbstractTimeSeriesPlotController.this.getViewport().getMinY() + worldDiffY;
                            yMax = AbstractTimeSeriesPlotController.this.getViewport().getMaxY() + worldDiffY;
                            if (xMin < AbstractTimeSeriesPlotController.this.getWorld().getMinX()) {
                                xMax += AbstractTimeSeriesPlotController.this.getWorld().getMinX() - xMin;
                                xMin = AbstractTimeSeriesPlotController.this.getWorld().getMinX();
                            }
                            if (xMax > AbstractTimeSeriesPlotController.this.getWorld().getMaxX()) {
                                xMin -= xMax - AbstractTimeSeriesPlotController.this.getWorld().getMaxX();
                                xMax = AbstractTimeSeriesPlotController.this.getWorld().getMaxX();
                            }
                            xMin = Math.max(AbstractTimeSeriesPlotController.this.getWorld().getMinX(), xMin);
                            xMax = Math.min(AbstractTimeSeriesPlotController.this.getWorld().getMaxX(), xMax);
                            if (yMin < AbstractTimeSeriesPlotController.this.getWorld().getMinY()) {
                                yMax += AbstractTimeSeriesPlotController.this.getWorld().getMinY() - yMin;
                                yMin = AbstractTimeSeriesPlotController.this.getWorld().getMinY();
                            }
                            if (yMax > AbstractTimeSeriesPlotController.this.getWorld().getMaxY()) {
                                yMin -= yMax - AbstractTimeSeriesPlotController.this.getWorld().getMaxY();
                                yMax = AbstractTimeSeriesPlotController.this.getWorld().getMaxY();
                            }
                            yMin = Math.max(AbstractTimeSeriesPlotController.this.getWorld().getMinY(), yMin);
                            yMax = Math.min(AbstractTimeSeriesPlotController.this.getWorld().getMaxY(), yMax);
                            if (!(xMin < xMax) || !(yMin < yMax)) break;
                            v46 = AbstractTimeSeriesPlotController.access$getView$p(AbstractTimeSeriesPlotController.this);
                            if (v46 != null) {
                                v46.zoom(false, xMin, xMax, yMin, yMax);
                            }
                            break;
                        }
                        case 3: {
                            if (!event.isMiddleMouseButton()) break;
                            v47 = event.getY();
                            v48 = this.last;
                            Intrinsics.checkNotNull((Object)v48);
                            v49 = v47 - (double)v48.getY() / 100.0;
                            v50 = AbstractTimeSeriesPlotController.access$getView$p(AbstractTimeSeriesPlotController.this);
                            Intrinsics.checkNotNull((Object)v50);
                            v51 = v50.getScreenTransform();
                            Intrinsics.checkNotNull((Object)v51);
                            v52 = v51.getX().screenToWorld(event.getX());
                            v53 = AbstractTimeSeriesPlotController.access$getView$p(AbstractTimeSeriesPlotController.this);
                            Intrinsics.checkNotNull((Object)v53);
                            v54 = v53.getScreenTransform();
                            Intrinsics.checkNotNull((Object)v54);
                            AbstractTimeSeriesPlotController.access$zoom(AbstractTimeSeriesPlotController.this, v49, v52, v54.getY().screenToWorld(event.getY()));
                            this.zoomOnRelease = null;
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                this.last = event;
            }
        }

        public void mouseMoved(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            TimeSeriesPlotView timeSeriesPlotView = AbstractTimeSeriesPlotController.this.view;
            Intrinsics.checkNotNull((Object)timeSeriesPlotView);
            Group closest = timeSeriesPlotView.getClosestGroup(event.getX(), event.getY());
            TimeSeriesPlotView timeSeriesPlotView2 = AbstractTimeSeriesPlotController.this.view;
            Intrinsics.checkNotNull((Object)timeSeriesPlotView2);
            TimeSeriesPlotModel timeSeriesPlotModel = timeSeriesPlotView2.getModel();
            Intrinsics.checkNotNull(timeSeriesPlotModel);
            Visual<Group, String> visual = timeSeriesPlotModel.getMasterVisual();
            Intrinsics.checkNotNull(visual);
            MutableSingleSelection mutableSingleSelection = visual.getProbing();
            Intrinsics.checkNotNull((Object)mutableSingleSelection);
            mutableSingleSelection.setSelected((Object)closest);
        }

        public void mouseWheelMoved(@NotNull MouseWheelEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (AbstractTimeSeriesPlotController.this.view != null) {
                double amount = event.getWheelRotation();
                double d = amount / 20.0;
                TimeSeriesPlotView timeSeriesPlotView = AbstractTimeSeriesPlotController.this.view;
                Intrinsics.checkNotNull((Object)timeSeriesPlotView);
                MutableTwoDScreenTransform mutableTwoDScreenTransform = timeSeriesPlotView.getScreenTransform();
                Intrinsics.checkNotNull((Object)mutableTwoDScreenTransform);
                double d2 = mutableTwoDScreenTransform.getX().screenToWorld(event.getX());
                TimeSeriesPlotView timeSeriesPlotView2 = AbstractTimeSeriesPlotController.this.view;
                Intrinsics.checkNotNull((Object)timeSeriesPlotView2);
                MutableTwoDScreenTransform mutableTwoDScreenTransform2 = timeSeriesPlotView2.getScreenTransform();
                Intrinsics.checkNotNull((Object)mutableTwoDScreenTransform2);
                AbstractTimeSeriesPlotController.this.zoom(d, d2, mutableTwoDScreenTransform2.getY().screenToWorld(event.getY()));
            }
        }

        private final void removeFromSelection(Row observation) {
            TimeSeriesPlotView timeSeriesPlotView = AbstractTimeSeriesPlotController.this.view;
            Intrinsics.checkNotNull((Object)timeSeriesPlotView);
            TimeSeriesPlotModel timeSeriesPlotModel = timeSeriesPlotView.getModel();
            Intrinsics.checkNotNull(timeSeriesPlotModel);
            MutableSelection mutableSelection = timeSeriesPlotModel.getSelection();
            Intrinsics.checkNotNull(mutableSelection);
            mutableSelection.setSelectedState(observation, false);
        }

        private final void setSelection(Row observation) {
            if (observation != null) {
                TimeSeriesPlotView timeSeriesPlotView = AbstractTimeSeriesPlotController.this.view;
                Intrinsics.checkNotNull((Object)timeSeriesPlotView);
                TimeSeriesPlotModel timeSeriesPlotModel = timeSeriesPlotView.getModel();
                Intrinsics.checkNotNull(timeSeriesPlotModel);
                MutableSelection mutableSelection = timeSeriesPlotModel.getSelection();
                Intrinsics.checkNotNull(mutableSelection);
                Object[] objectArray = new Object[]{observation};
                mutableSelection.setSelectedElements(objectArray);
            } else {
                TimeSeriesPlotView timeSeriesPlotView = AbstractTimeSeriesPlotController.this.view;
                Intrinsics.checkNotNull((Object)timeSeriesPlotView);
                TimeSeriesPlotModel timeSeriesPlotModel = timeSeriesPlotView.getModel();
                Intrinsics.checkNotNull(timeSeriesPlotModel);
                MutableSelection mutableSelection = timeSeriesPlotModel.getSelection();
                Intrinsics.checkNotNull(mutableSelection);
                mutableSelection.clearSelection();
            }
        }

        private final void addToSelection(Row observation) {
            TimeSeriesPlotView timeSeriesPlotView = AbstractTimeSeriesPlotController.this.view;
            Intrinsics.checkNotNull((Object)timeSeriesPlotView);
            TimeSeriesPlotModel timeSeriesPlotModel = timeSeriesPlotView.getModel();
            Intrinsics.checkNotNull(timeSeriesPlotModel);
            MutableSelection mutableSelection = timeSeriesPlotModel.getSelection();
            Intrinsics.checkNotNull(mutableSelection);
            mutableSelection.setSelectedState(observation, true);
        }

        private final void addToSelection(List<? extends Row> newSelection) {
            TimeSeriesPlotView timeSeriesPlotView = AbstractTimeSeriesPlotController.this.view;
            Intrinsics.checkNotNull((Object)timeSeriesPlotView);
            TimeSeriesPlotModel timeSeriesPlotModel = timeSeriesPlotView.getModel();
            Intrinsics.checkNotNull(timeSeriesPlotModel);
            MutableSelection mutableSelection = timeSeriesPlotModel.getSelection();
            Intrinsics.checkNotNull(mutableSelection);
            mutableSelection.setSelectedIterableState((Iterable)newSelection, true);
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Mode.values().length];
                try {
                    nArray[Mode.Selection.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Mode.Panning.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Mode.Zooming.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/macrofocus/trenddisplay/timeseriesplot/AbstractTimeSeriesPlotController$Mode;", "", "<init>", "(Ljava/lang/String;I)V", "Selection", "Zooming", "Panning", "trenddisplay"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode Selection = new Mode();
        public static final /* enum */ Mode Zooming = new Mode();
        public static final /* enum */ Mode Panning = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        @NotNull
        public static EnumEntries<Mode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.Selection, Mode.Zooming, Mode.Panning};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\u0013\u001a\u00120\u0000R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lcom/macrofocus/trenddisplay/timeseriesplot/AbstractTimeSeriesPlotController$Range;", "", "_amount", "", "_center", "_start", "_extent", "_minRange", "_maxRange", "_maxExtent", "<init>", "(Lcom/macrofocus/trenddisplay/timeseriesplot/AbstractTimeSeriesPlotController;DLjava/lang/Double;DDDDD)V", "Ljava/lang/Double;", "value", "min", "getMin", "()D", "max", "getMax", "invoke", "Lcom/macrofocus/trenddisplay/timeseriesplot/AbstractTimeSeriesPlotController;", "trenddisplay"})
    private final class Range {
        private final double _amount;
        @Nullable
        private final Double _center;
        private final double _start;
        private final double _extent;
        private final double _minRange;
        private final double _maxRange;
        private final double _maxExtent;
        private double min;
        private double max;

        public Range(@Nullable double _amount, Double _center, double _start, double _extent, double _minRange, double _maxRange, double _maxExtent) {
            this._amount = _amount;
            this._center = _center;
            this._start = _start;
            this._extent = _extent;
            this._minRange = _minRange;
            this._maxRange = _maxRange;
            this._maxExtent = _maxExtent;
        }

        public final double getMin() {
            return this.min;
        }

        public final double getMax() {
            return this.max;
        }

        @NotNull
        public final Range invoke() {
            double range = this._extent;
            double newRange = Math.min(this._maxExtent, range + range * this._amount);
            if (this._center != null) {
                this.min = this._center - newRange * ((this._center - this._start) / range);
                this.max = this._center + newRange * ((this._start + this._extent - this._center) / range);
            } else {
                this.min = this._start;
                this.max = this._start + newRange;
            }
            if (this.min < this._minRange) {
                this.max += this._minRange - this.min;
                this.min = this._minRange;
            }
            if (this.max > this._maxRange) {
                this.min -= this.max - this._maxRange;
                this.max = this._maxRange;
            }
            this.min = Math.max(this._minRange, this.min);
            this.max = Math.min(this._maxRange, this.max);
            return this;
        }
    }
}

