/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.trenddisplay.timeseriesplot;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.trenddisplay.timeseriesplot.TimeSeriesPlotConfiguration;
import com.macrofocus.trenddisplay.timeseriesplot.TimeSeriesPlotRenderer;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.GeneralPath;
import org.mkui.geom.Path2D;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;
import org.mkui.graphics.IGraphics;
import org.mkui.transform.TwoDScreenTransform;
import org.molap.series.TimeSeries;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J@\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0002\b\u0003\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016JL\u0010\u0011\u001a\u00020\u00122\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0002\b\u0003\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/macrofocus/trenddisplay/timeseriesplot/GeneralPathTimeSeriesRenderer;", "TimeMode", "Lcom/macrofocus/trenddisplay/timeseriesplot/TimeSeriesPlotRenderer;", "<init>", "()V", "getShape", "Lkotlin/Pair;", "Lorg/mkui/geom/Path2D$Double;", "timeSeries", "Lorg/molap/series/TimeSeries;", "", "screenTransform", "Lorg/mkui/transform/TwoDScreenTransform;", "mode", "Lorg/molap/series/TimeSeries$TimeMode;", "configuration", "Lcom/macrofocus/trenddisplay/timeseriesplot/TimeSeriesPlotConfiguration;", "draw", "", "g2", "Lorg/mkui/graphics/IGraphics;", "probed", "", "selected", "RangePoint", "trenddisplay"})
@StabilityInferred(parameters=2)
public final class GeneralPathTimeSeriesRenderer<TimeMode>
implements TimeSeriesPlotRenderer {
    public static final int $stable;

    @NotNull
    public Pair<Path2D.Double, Path2D.Double> getShape(@Nullable TimeSeries<Integer, ?> timeSeries, @NotNull TwoDScreenTransform screenTransform, @NotNull TimeSeries.TimeMode mode, @NotNull TimeSeriesPlotConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)screenTransform, (String)"screenTransform");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        GeneralPath markerPath = new GeneralPath();
        GeneralPath linePath = new GeneralPath();
        boolean isNumerical = true;
        if (timeSeries != null) {
            RangePoint previous = null;
            Iterable iterable = timeSeries.keys();
            Intrinsics.checkNotNull((Object)iterable);
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                int i = ((Number)iterator.next()).intValue();
                int x = screenTransform.xWorldToScreen((double)timeSeries.getTime(mode, (Object)i));
                Object yValue = timeSeries.get((Object)i);
                if (yValue != null) {
                    int y = screenTransform.yWorldToScreen(((Number)yValue).doubleValue());
                    if (previous != null) {
                        if (x != previous.getX()) {
                            if (previous.getYMin() != previous.getYMax() && configuration.getLineType() != TimeSeriesPlotConfiguration.LineType.None) {
                                linePath.lineTo((double)previous.getX(), (double)previous.getYMin());
                                linePath.lineTo((double)previous.getX(), (double)previous.getYMax());
                                linePath.lineTo((double)previous.getX(), (double)previous.getY());
                            }
                            if (configuration.getLineType() != TimeSeriesPlotConfiguration.LineType.None) {
                                if (configuration.getLineType() == TimeSeriesPlotConfiguration.LineType.Step) {
                                    linePath.lineTo((double)x, (double)previous.getY());
                                }
                                linePath.lineTo((double)x, (double)y);
                            }
                        }
                        previous.setValue(x, y);
                    } else {
                        previous = new RangePoint();
                        previous.setValue(x, y);
                        linePath.moveTo((double)x, (double)y);
                        linePath.lineTo((double)x, (double)y);
                    }
                    if (configuration.getMarkerType() == TimeSeriesPlotConfiguration.MarkerType.None) continue;
                    double size = configuration.getMarkerSize();
                    double halfSize = size / 2.0;
                    Shape shape = (Shape)new Rectangle2D.Double((double)x - halfSize, (double)y - halfSize, size, size);
                    markerPath.append(Shape.getPathIterator$default((Shape)shape, null, (int)1, null), false);
                    continue;
                }
                previous = null;
            }
        }
        return new Pair((Object)markerPath, (Object)linePath);
    }

    @Override
    public void draw(@Nullable TimeSeries<Integer, ?> timeSeries, @NotNull TwoDScreenTransform screenTransform, @NotNull IGraphics g2, @NotNull TimeSeries.TimeMode mode, @NotNull TimeSeriesPlotConfiguration configuration, boolean probed, boolean selected) {
        Intrinsics.checkNotNullParameter((Object)screenTransform, (String)"screenTransform");
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Pair<Path2D.Double, Path2D.Double> pair = this.getShape(timeSeries, screenTransform, mode, configuration);
        Path2D.Double markerPath = (Path2D.Double)pair.component1();
        Path2D.Double linePath = (Path2D.Double)pair.component2();
        g2.setColor(configuration.getLineColor());
        g2.setLineWidth((double)configuration.getLineWidth());
        g2.pickDraw((Shape)linePath, null, null, null);
        g2.setColor(configuration.getMarkerColor());
        g2.pickDraw((Shape)markerPath, null, null, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/macrofocus/trenddisplay/timeseriesplot/GeneralPathTimeSeriesRenderer$RangePoint;", "", "<init>", "(Lcom/macrofocus/trenddisplay/timeseriesplot/GeneralPathTimeSeriesRenderer;)V", "x", "", "getX", "()I", "setX", "(I)V", "y", "getY", "setY", "yMin", "getYMin", "setYMin", "yMax", "getYMax", "setYMax", "setValue", "", "trenddisplay"})
    private final class RangePoint {
        private int x;
        private int y;
        private int yMin;
        private int yMax;

        public final int getX() {
            return this.x;
        }

        public final void setX(int n) {
            this.x = n;
        }

        public final int getY() {
            return this.y;
        }

        public final void setY(int n) {
            this.y = n;
        }

        public final int getYMin() {
            return this.yMin;
        }

        public final void setYMin(int n) {
            this.yMin = n;
        }

        public final int getYMax() {
            return this.yMax;
        }

        public final void setYMax(int n) {
            this.yMax = n;
        }

        public final void setValue(int x, int y) {
            if (this.x == x) {
                if (y < this.yMin) {
                    this.yMin = y;
                }
                if (y > this.yMax) {
                    this.yMax = y;
                }
                this.y = y;
            } else {
                this.x = x;
                this.y = y;
                this.yMin = y;
                this.yMax = y;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TimeSeriesPlotConfiguration.MarkerType.values().length];
            try {
                nArray[TimeSeriesPlotConfiguration.MarkerType.VerticalLine.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimeSeriesPlotConfiguration.MarkerType.Point.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimeSeriesPlotConfiguration.MarkerType.None.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

