/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.trenddisplay.timeseriesplot;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.trenddisplay.timeseriesplot.TimeSeriesPlotConfiguration;
import com.macrofocus.trenddisplay.timeseriesplot.TimeSeriesPlotRenderer;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.GeneralPath;
import org.mkui.geom.Path2D;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;
import org.mkui.graphics.IGraphics;
import org.mkui.palette.Palette;
import org.mkui.palette.PaletteFactory;
import org.mkui.transform.TwoDScreenTransform;
import org.molap.series.TimeSeries;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J@\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0002\b\u0003\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016JL\u0010\u0016\u001a\u00020\u00172\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0002\b\u0003\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/macrofocus/trenddisplay/timeseriesplot/HeatmapTimeSeriesRenderer;", "Lcom/macrofocus/trenddisplay/timeseriesplot/TimeSeriesPlotRenderer;", "paletteFactory", "Lorg/mkui/palette/PaletteFactory;", "<init>", "(Lorg/mkui/palette/PaletteFactory;)V", "normalColormap", "Lorg/mkui/palette/Palette;", "probedColormap", "selectedColormap", "getShape", "Lkotlin/Pair;", "Lorg/mkui/geom/Path2D$Double;", "timeSeries", "Lorg/molap/series/TimeSeries;", "", "screenTransform", "Lorg/mkui/transform/TwoDScreenTransform;", "mode", "Lorg/molap/series/TimeSeries$TimeMode;", "configuration", "Lcom/macrofocus/trenddisplay/timeseriesplot/TimeSeriesPlotConfiguration;", "draw", "", "g2", "Lorg/mkui/graphics/IGraphics;", "probed", "", "selected", "RangePoint", "trenddisplay"})
@StabilityInferred(parameters=0)
public final class HeatmapTimeSeriesRenderer
implements TimeSeriesPlotRenderer {
    @NotNull
    private final Palette normalColormap;
    @NotNull
    private final Palette probedColormap;
    @NotNull
    private final Palette selectedColormap;
    public static final int $stable = 8;

    public HeatmapTimeSeriesRenderer(@NotNull PaletteFactory paletteFactory) {
        Intrinsics.checkNotNullParameter((Object)paletteFactory, (String)"paletteFactory");
        PaletteFactory.Entry entry = paletteFactory.get("lingrey");
        Intrinsics.checkNotNull((Object)entry);
        this.normalColormap = (Palette)entry.getPalette();
        PaletteFactory.Entry entry2 = paletteFactory.get("Blues");
        Intrinsics.checkNotNull((Object)entry2);
        this.probedColormap = (Palette)entry2.getPalette();
        PaletteFactory.Entry entry3 = paletteFactory.get("linred");
        Intrinsics.checkNotNull((Object)entry3);
        this.selectedColormap = (Palette)entry3.getPalette();
    }

    @NotNull
    public Pair<Path2D.Double, Path2D.Double> getShape(@Nullable TimeSeries<Integer, ?> timeSeries, @NotNull TwoDScreenTransform screenTransform, @NotNull TimeSeries.TimeMode mode, @NotNull TimeSeriesPlotConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)screenTransform, (String)"screenTransform");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        GeneralPath markerPath = new GeneralPath();
        GeneralPath linePath = new GeneralPath();
        boolean isNumerical = true;
        if (timeSeries != null) {
            RangePoint previous = null;
            Iterable iterable = timeSeries.keys();
            Intrinsics.checkNotNull((Object)iterable);
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                int i = ((Number)iterator.next()).intValue();
                int x = screenTransform.xWorldToScreen((double)timeSeries.getTime(mode, (Object)i));
                Object yValue = timeSeries.get((Object)i);
                if (yValue != null) {
                    int y = screenTransform.yWorldToScreen(((Number)yValue).doubleValue());
                    if (previous != null) {
                        if (x != previous.getX()) {
                            if (!(previous.getYMin() == previous.getYMax()) && configuration.getLineType() != TimeSeriesPlotConfiguration.LineType.None) {
                                linePath.lineTo((double)previous.getX(), previous.getYMin());
                                linePath.lineTo((double)previous.getX(), previous.getYMax());
                                linePath.lineTo((double)previous.getX(), previous.getY());
                            }
                            if (configuration.getLineType() != TimeSeriesPlotConfiguration.LineType.None) {
                                if (configuration.getLineType() == TimeSeriesPlotConfiguration.LineType.Step) {
                                    linePath.lineTo((double)x, previous.getY());
                                }
                                linePath.lineTo((double)x, (double)y);
                            }
                        }
                        previous.setValue(x, y);
                    } else {
                        previous = new RangePoint();
                        previous.setValue(x, y);
                        linePath.moveTo((double)x, (double)y);
                        linePath.lineTo((double)x, (double)y);
                    }
                    if (configuration.getMarkerType() == TimeSeriesPlotConfiguration.MarkerType.None) continue;
                    double size = configuration.getMarkerSize();
                    double halfSize = size / 2.0;
                    Shape shape = (Shape)new Rectangle2D.Double((double)x - halfSize, (double)y - halfSize, size, size);
                    markerPath.append(Shape.getPathIterator$default((Shape)shape, null, (int)1, null), false);
                    continue;
                }
                previous = null;
            }
        }
        return new Pair((Object)markerPath, (Object)linePath);
    }

    @Override
    public void draw(@Nullable TimeSeries<Integer, ?> timeSeries, @NotNull TwoDScreenTransform screenTransform, @NotNull IGraphics g2, @NotNull TimeSeries.TimeMode mode, @NotNull TimeSeriesPlotConfiguration configuration, boolean probed, boolean selected) {
        Palette colormap;
        Intrinsics.checkNotNullParameter((Object)screenTransform, (String)"screenTransform");
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        g2.setColor(configuration.getLineColor());
        boolean isNumerical = true;
        Palette palette = selected ? this.selectedColormap : (colormap = probed ? this.probedColormap : this.normalColormap);
        if (timeSeries != null) {
            RangePoint previous = null;
            Iterable iterable = timeSeries.keys();
            Intrinsics.checkNotNull((Object)iterable);
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                int i = ((Number)iterator.next()).intValue();
                int x = screenTransform.xWorldToScreen((double)timeSeries.getTime(mode, (Object)i));
                Object yValue = timeSeries.get((Object)i);
                if (yValue == null) continue;
                int y = screenTransform.yWorldToScreen(((Number)yValue).doubleValue());
                if (previous != null) {
                    if (x != previous.getX() && configuration.getLineType() != TimeSeriesPlotConfiguration.LineType.None) {
                        int entry = (Integer)((double)(colormap.getColorCount() - 1) * Math.max((double)y, previous.getYMax()));
                        if (entry < 0) {
                            entry = 0;
                        }
                        if (entry >= colormap.getColorCount()) {
                            entry = colormap.getColorCount() - 1;
                        }
                        g2.setColor(colormap.getColorAt(entry));
                        g2.fillRectangle(previous.getX(), 0, x - previous.getX(), screenTransform.getScreenHeight());
                    }
                    previous.setValue(x, y);
                } else {
                    previous = new RangePoint();
                    previous.setValue(x, y);
                    int entry = (colormap.getColorCount() - 1) * y;
                    g2.setColor(colormap.getColorAt(entry));
                    g2.drawLine(x, 0, x, screenTransform.getScreenHeight());
                }
                if (configuration.getMarkerType() == TimeSeriesPlotConfiguration.MarkerType.None) continue;
                float size = configuration.getMarkerSize();
                float halfSize = size / 2.0f;
                g2.drawLine(x, 0, x, screenTransform.getScreenHeight());
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lcom/macrofocus/trenddisplay/timeseriesplot/HeatmapTimeSeriesRenderer$RangePoint;", "", "<init>", "(Lcom/macrofocus/trenddisplay/timeseriesplot/HeatmapTimeSeriesRenderer;)V", "x", "", "getX", "()I", "setX", "(I)V", "y", "", "getY", "()D", "setY", "(D)V", "yMin", "getYMin", "setYMin", "yMax", "getYMax", "setYMax", "setValue", "", "trenddisplay"})
    private final class RangePoint {
        private int x;
        private double y;
        private double yMin;
        private double yMax;

        public final int getX() {
            return this.x;
        }

        public final void setX(int n) {
            this.x = n;
        }

        public final double getY() {
            return this.y;
        }

        public final void setY(double d) {
            this.y = d;
        }

        public final double getYMin() {
            return this.yMin;
        }

        public final void setYMin(double d) {
            this.yMin = d;
        }

        public final double getYMax() {
            return this.yMax;
        }

        public final void setYMax(double d) {
            this.yMax = d;
        }

        public final void setValue(int x, double y) {
            if (this.x == x) {
                if (y < this.yMin) {
                    this.yMin = y;
                }
                if (y > this.yMax) {
                    this.yMax = y;
                }
                this.y = y;
            } else {
                this.x = x;
                this.y = y;
                this.yMin = y;
                this.yMax = y;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TimeSeriesPlotConfiguration.MarkerType.values().length];
            try {
                nArray[TimeSeriesPlotConfiguration.MarkerType.VerticalLine.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimeSeriesPlotConfiguration.MarkerType.Point.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimeSeriesPlotConfiguration.MarkerType.None.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

