/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.trenddisplay;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.colormapping.implementation.SimpleColorMapping;
import com.macrofocus.common.crossplatform.CPHelper;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.trenddisplay.TrendDisplaySettings;
import com.macrofocus.trenddisplay.timeseriesplot.DefaultTimeSeriesPlotModel;
import com.macrofocus.trenddisplay.timeseriesplot.TimeSeriesPlotModel;
import com.macrofocus.visual.SimpleVisual;
import com.macrofocus.visual.SimpleVisualObjects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.mkui.colormap.ColorMapFactory;
import org.mkui.colormapping.MutableColorMapping;
import org.mkui.component.CPFactory;
import org.mkui.visual.Visual;
import org.mkui.visual.VisualObjects;
import org.molap.aggregates.AggregateDataFrame;
import org.molap.aggregates.aggregation.Aggregation;
import org.molap.aggregates.aggregation.FirstAggregation;
import org.molap.aggregates.aggregation.TimeSeriesAggregation;
import org.molap.aggregates.cube.Group;
import org.molap.dataframe.DataFrame;
import org.molap.dataframe.DataFrameAggKt;
import org.molap.dataframe.DataFrameExtKt;
import org.molap.dataframe.DelegatedDataFrame;
import org.molap.dataframe.SingleSortKey;
import org.molap.dataframe.SortKey;
import org.molap.dataframe.SortOrder;
import org.molap.series.Series;
import org.molap.series.TimeSeries;
import org.molap.subset.SubsetDataFrame;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u00020\u0004B?\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0018\u001a\u00020\u0019H\u0002J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00010\bJ\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0006J\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0010J\u0013\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00028\u0001\u00a2\u0006\u0002\u0010#J\u0013\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00028\u0001\u00a2\u0006\u0002\u0010&J\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0010J\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010)R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\u001d\u001a\u0016\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006*"}, d2={"Lcom/macrofocus/trenddisplay/TrendDisplayLogic;", "Row", "Column", "Value", "", "dataFrame", "Lorg/molap/dataframe/DataFrame;", "settings", "Lcom/macrofocus/trenddisplay/TrendDisplaySettings;", "cpFactory", "Lorg/mkui/component/CPFactory;", "colorMapFactory", "Lorg/mkui/colormap/ColorMapFactory;", "<init>", "(Lorg/molap/dataframe/DataFrame;Lcom/macrofocus/trenddisplay/TrendDisplaySettings;Lorg/mkui/component/CPFactory;Lorg/mkui/colormap/ColorMapFactory;)V", "visual", "Lorg/mkui/visual/Visual;", "delegatedDataFrame", "Lorg/molap/dataframe/DelegatedDataFrame;", "Lorg/molap/aggregates/cube/Group;", "", "masterVisual", "subsetDataFrame", "Lorg/molap/subset/SubsetDataFrame;", "updateCache", "", "getSettings", "getDataFrame", "getVisual", "masterDataFrame", "getMasterDataFrame", "()Lorg/molap/subset/SubsetDataFrame;", "getMaxDuration", "", "column", "(Ljava/lang/Object;)J", "getMaxEvents", "", "(Ljava/lang/Object;)I", "getMasterVisual", "createTimeSeriesPlotModel", "Lcom/macrofocus/trenddisplay/timeseriesplot/TimeSeriesPlotModel;", "trenddisplay"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nTrendDisplayLogic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrendDisplayLogic.kt\ncom/macrofocus/trenddisplay/TrendDisplayLogic\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,159:1\n37#2:160\n36#2,3:161\n*S KotlinDebug\n*F\n+ 1 TrendDisplayLogic.kt\ncom/macrofocus/trenddisplay/TrendDisplayLogic\n*L\n99#1:160\n99#1:161,3\n*E\n"})
public final class TrendDisplayLogic<Row, Column, Value> {
    @NotNull
    private final DataFrame<Row, Column, Value> dataFrame;
    @NotNull
    private final TrendDisplaySettings<Column> settings;
    @NotNull
    private final CPFactory cpFactory;
    @NotNull
    private final ColorMapFactory colorMapFactory;
    @NotNull
    private final Visual<Row, Column> visual;
    @NotNull
    private final DelegatedDataFrame<Group, String, Object> delegatedDataFrame;
    @NotNull
    private final Visual<Group, String> masterVisual;
    @NotNull
    private final SubsetDataFrame<Group, String, Object> subsetDataFrame;
    public static final int $stable = 8;

    public TrendDisplayLogic(@NotNull DataFrame<Row, Column, Value> dataFrame, @NotNull TrendDisplaySettings<Column> settings, @NotNull CPFactory cpFactory, @NotNull ColorMapFactory colorMapFactory) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        Intrinsics.checkNotNullParameter(settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)cpFactory, (String)"cpFactory");
        Intrinsics.checkNotNullParameter((Object)colorMapFactory, (String)"colorMapFactory");
        this.dataFrame = dataFrame;
        this.settings = settings;
        this.cpFactory = cpFactory;
        this.colorMapFactory = colorMapFactory;
        this.visual = (Visual)new SimpleVisual((VisualObjects)new SimpleVisualObjects(this.dataFrame), (MutableColorMapping)new SimpleColorMapping(this.colorMapFactory, this.dataFrame));
        this.delegatedDataFrame = new DelegatedDataFrame(null, 1, null);
        this.masterVisual = (Visual)new SimpleVisual((VisualObjects)new SimpleVisualObjects((DataFrame)this.delegatedDataFrame), (MutableColorMapping)new SimpleColorMapping(this.colorMapFactory, (DataFrame)this.delegatedDataFrame));
        this.updateCache();
        this.delegatedDataFrame.printSchema();
        this.subsetDataFrame = new SubsetDataFrame((DataFrame)this.delegatedDataFrame, ((SimpleVisual)this.masterVisual).getFilter(), ((SimpleVisual)this.masterVisual).getSelection());
        this.settings.getTime().addPropertyListener(new PropertyListener<Column>(){

            public void propertyChanged(PropertyEvent<Column> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.updateCache();
            }
        });
        this.settings.getId().addPropertyListener(new PropertyListener<Column>(){

            public void propertyChanged(PropertyEvent<Column> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                System.out.println((Object)("Id " + event.getOldValue() + " -> " + event.getOldValue() + " " + settings.getId().getValue()));
                this.updateCache();
            }
        });
    }

    private final void updateCache() {
        if (this.settings.getTime().getValue() != null) {
            SortKey[] sortKeys = null;
            if (this.settings.getId().getValue() != null) {
                var2_2 = new SortKey[2];
                Object object = this.settings.getId().getValue();
                Intrinsics.checkNotNull((Object)object);
                var2_2[0] = new SingleSortKey(object, SortOrder.ASCENDING);
                Object object2 = this.settings.getTime().getValue();
                Intrinsics.checkNotNull((Object)object2);
                var2_2[1] = new SingleSortKey(object2, SortOrder.ASCENDING);
                sortKeys = var2_2;
            } else {
                var2_2 = new SortKey[1];
                Object object = this.settings.getTime().getValue();
                Intrinsics.checkNotNull((Object)object);
                var2_2[0] = new SingleSortKey(object, SortOrder.ASCENDING);
                sortKeys = var2_2;
            }
            DataFrame<Row, Column, Value> dataFrame = this.dataFrame;
            Intrinsics.checkNotNull(dataFrame);
            DataFrame dataFrame2 = DataFrameExtKt.orderRows(dataFrame, (SortKey[])Arrays.copyOf(sortKeys, sortKeys.length));
            Intrinsics.checkNotNull((Object)dataFrame2);
            DataFrame sorted = dataFrame2;
            List aggregations = new ArrayList();
            if (this.settings.getId().getValue() != null) {
                Object object = this.settings.getId().getValue();
                Intrinsics.checkNotNull((Object)object);
                FirstAggregation firstAggregation = DataFrameAggKt.getFirst((DataFrame)sorted, (Object)object);
                Object object3 = this.settings.getId().getValue();
                Intrinsics.checkNotNull((Object)object3);
                aggregations.add(firstAggregation.as(this.dataFrame.getColumnName(object3)));
            }
            Object object = this.settings.getTime().getValue();
            Intrinsics.checkNotNull((Object)object);
            aggregations.add(DataFrameAggKt.getMin((DataFrame)sorted, (Object)object));
            Object object4 = this.settings.getTime().getValue();
            Intrinsics.checkNotNull((Object)object4);
            aggregations.add(DataFrameAggKt.getMax((DataFrame)sorted, (Object)object4));
            aggregations.add(DataFrameAggKt.getDataFrameAggregation((DataFrame)sorted));
            for (Object key : this.dataFrame.getColumnIndex().keys()) {
                if (!CPHelper.Companion.getInstance().isNumericType(this.dataFrame.getColumnClass(key))) continue;
                Object object5 = this.settings.getTime().getValue();
                Intrinsics.checkNotNull((Object)object5);
                Series series = sorted.getColumn(object5);
                Intrinsics.checkNotNull((Object)series);
                Series series2 = this.dataFrame.getColumn(key);
                Intrinsics.checkNotNull((Object)series2);
                aggregations.add(new TimeSeriesAggregation(series, series2));
            }
            Collection $this$toTypedArray$iv = aggregations;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new Aggregation[0]);
            AggregateDataFrame aggregated = sorted.aggregate(true, Arrays.copyOf(objectArray, objectArray.length));
            if (this.settings.getId().getValue() != null) {
                objectArray = new Object[1];
                Intrinsics.checkNotNull((Object)this.settings.getId().getValue());
                aggregated = aggregated.drillDown(objectArray);
            }
            System.out.println((Object)("Setting aggregation: " + aggregated + " " + this.settings.getId().getValue()));
            AggregateDataFrame aggregateDataFrame = aggregated;
            Intrinsics.checkNotNull((Object)aggregateDataFrame, (String)"null cannot be cast to non-null type org.molap.dataframe.DataFrame<org.molap.aggregates.cube.Group, kotlin.String, kotlin.Any?>");
            this.delegatedDataFrame.setDelegate((DataFrame)aggregateDataFrame);
        }
    }

    @NotNull
    public final TrendDisplaySettings<Column> getSettings() {
        return this.settings;
    }

    @NotNull
    public final DataFrame<Row, Column, Value> getDataFrame() {
        return this.dataFrame;
    }

    @NotNull
    public final Visual<Row, Column> getVisual() {
        return this.visual;
    }

    @NotNull
    public final SubsetDataFrame<Group, String, Object> getMasterDataFrame() {
        return this.subsetDataFrame;
    }

    public final long getMaxDuration(Column column) {
        long maxDuration = 0L;
        for (Group o : this.getMasterDataFrame().rows()) {
            SubsetDataFrame<Group, String, Object> subsetDataFrame = this.getMasterDataFrame();
            Intrinsics.checkNotNull(column, (String)"null cannot be cast to non-null type kotlin.String");
            Object object = subsetDataFrame.getValueAt((Object)o, (Object)((String)column));
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.molap.series.TimeSeries<*, *>");
            TimeSeries valueAt = (TimeSeries)object;
            long duration = valueAt.getMaxTime() - valueAt.getMinTime();
            if (duration <= maxDuration) continue;
            maxDuration = duration;
        }
        return maxDuration;
    }

    public final int getMaxEvents(Column column) {
        int maxEvents = 0;
        for (Group o : this.getMasterDataFrame().rows()) {
            SubsetDataFrame<Group, String, Object> subsetDataFrame = this.getMasterDataFrame();
            Intrinsics.checkNotNull(column, (String)"null cannot be cast to non-null type kotlin.String");
            Object object = subsetDataFrame.getValueAt((Object)o, (Object)((String)column));
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.molap.series.TimeSeries<*, *>");
            TimeSeries valueAt = (TimeSeries)object;
            int events = valueAt.size();
            if (events <= maxEvents) continue;
            maxEvents = events;
        }
        return maxEvents;
    }

    @NotNull
    public final Visual<Group, String> getMasterVisual() {
        return this.masterVisual;
    }

    @NotNull
    public final TimeSeriesPlotModel<Row, Column> createTimeSeriesPlotModel() {
        return new DefaultTimeSeriesPlotModel(this.cpFactory, this.colorMapFactory, this);
    }
}

