/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.trenddisplay.timeseriesplot;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.command.Future;
import com.macrofocus.common.concurrent.Callable;
import com.macrofocus.common.concurrent.ExecutorService;
import com.macrofocus.common.crossplatform.CPHelper;
import com.macrofocus.common.filter.Filter;
import com.macrofocus.common.interval.BoundedInterval;
import com.macrofocus.common.interval.BoundedIntervalEvent;
import com.macrofocus.common.interval.BoundedIntervalListener;
import com.macrofocus.common.interval.MutableBoundedInterval;
import com.macrofocus.common.interval.SimpleBoundedInterval;
import com.macrofocus.common.properties.EnumProperties;
import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.Property;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.Selection;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.common.timer.CPTimer;
import com.macrofocus.common.timer.CPTimerListener;
import com.macrofocus.common.transform.ComplexOneDScreenTransform;
import com.macrofocus.common.transform.MutableOneDScreenTransform;
import com.macrofocus.common.transform.OneDScreenTransform;
import com.macrofocus.common.transform.RangesScreenTransformCoordinator;
import com.macrofocus.common.transform.ScreenTransformEvent;
import com.macrofocus.common.transform.ScreenTransformListener;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.plot.guide.Guide;
import com.macrofocus.plot.guide.XNumberOneDScreenTransformAxisGuide;
import com.macrofocus.plot.guide.YNumberOneDScreenTransformAxisGuide;
import com.macrofocus.trenddisplay.timeseriesplot.AbstractTimeSeriesPlotView;
import com.macrofocus.trenddisplay.timeseriesplot.CardinalSplineTimeSeriesRenderer;
import com.macrofocus.trenddisplay.timeseriesplot.GeneralPathTimeSeriesRenderer;
import com.macrofocus.trenddisplay.timeseriesplot.HeatmapTimeSeriesRenderer;
import com.macrofocus.trenddisplay.timeseriesplot.TimeSeriesPlotConfiguration;
import com.macrofocus.trenddisplay.timeseriesplot.TimeSeriesPlotListener;
import com.macrofocus.trenddisplay.timeseriesplot.TimeSeriesPlotModel;
import com.macrofocus.trenddisplay.timeseriesplot.TimeSeriesPlotRenderer;
import com.macrofocus.trenddisplay.timeseriesplot.TimeSeriesPlotView;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.canvas.CPCanvas;
import org.mkui.canvas.CanvasListener;
import org.mkui.canvas.KeyListener;
import org.mkui.canvas.MouseListener;
import org.mkui.canvas.MouseMotionListener;
import org.mkui.canvas.MouseWheelListener;
import org.mkui.canvas.PaletteProvider;
import org.mkui.canvas.Rendering;
import org.mkui.color.MkColorKt;
import org.mkui.coloring.MutableColoring;
import org.mkui.colormapping.MutableColorMapping;
import org.mkui.component.CPFactory;
import org.mkui.geom.GeneralPath;
import org.mkui.geom.Line2D;
import org.mkui.geom.PathIterator;
import org.mkui.geom.Point;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;
import org.mkui.graphics.AbstractIDrawing;
import org.mkui.graphics.IDrawing;
import org.mkui.graphics.IGraphics;
import org.mkui.graphics.colortheme.ColorTheme;
import org.mkui.graphics.colortheme.LightColorTheme;
import org.mkui.graphics.pressure.LinearPressure;
import org.mkui.graphics.pressure.Pressure;
import org.mkui.palette.FixedPalette;
import org.mkui.palette.PaletteFactory;
import org.mkui.rubberband.RubberBand;
import org.mkui.rubberband.RubberbandDrawing;
import org.mkui.rubberband.ScreenTransformRubberBand;
import org.mkui.transform.MutableTwoDScreenTransform;
import org.mkui.transform.SimpleTwoDScreenTransform;
import org.mkui.transform.TwoDScreenTransform;
import org.mkui.visual.Visual;
import org.mkui.visual.VisualLayer;
import org.mkui.visual.VisualListener;
import org.molap.aggregates.cube.Group;
import org.molap.dataframe.DataFrame;
import org.molap.dataframe.DataFrameEvent;
import org.molap.dataframe.DataFrameListener;
import org.molap.series.TimeSeries;
import org.molap.subset.SubsetDataFrame;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b'\u0018\u0000 \u00b5\u0001*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003:\n\u00b2\u0001\u00b3\u0001\u00b4\u0001\u00b5\u0001\u00b6\u0001B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010P\u001a\u00020QH$J\b\u0010R\u001a\u00020QH$J\b\u0010S\u001a\u00020QH$J\u0010\u0010T\u001a\u00020Q2\u0006\u0010U\u001a\u00020VH\u0016J\u0010\u0010W\u001a\u00020Q2\u0006\u0010U\u001a\u00020XH\u0016J\u0010\u0010Y\u001a\u00020Q2\u0006\u0010U\u001a\u00020ZH\u0016J\u0010\u0010[\u001a\u00020Q2\u0006\u0010C\u001a\u00020\\H\u0016J\u0006\u0010]\u001a\u00020QJ\b\u0010^\u001a\u00020QH\u0004J\u001c\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020b2\n\u0010c\u001a\u00060dj\u0002`eH\u0002J\u0006\u0010f\u001a\u00020QJ\u0006\u0010g\u001a\u00020QJ0\u0010h\u001a\u00020Q2\u0006\u0010i\u001a\u0002092\u0006\u0010j\u001a\u00020k2\u0006\u0010l\u001a\u00020k2\u0006\u0010m\u001a\u00020k2\u0006\u0010n\u001a\u00020kH\u0016J\b\u0010o\u001a\u00020QH\u0004J\b\u0010p\u001a\u00020QH$J\u001a\u0010q\u001a\u0004\u0018\u00010r2\u0006\u0010s\u001a\u00020K2\u0006\u0010t\u001a\u00020KH\u0016J\u001f\u0010u\u001a\u0004\u0018\u00018\u00002\u0006\u0010s\u001a\u00020K2\u0006\u0010t\u001a\u00020KH\u0016\u00a2\u0006\u0002\u0010vJ\u0016\u0010w\u001a\b\u0012\u0004\u0012\u00028\u00000x2\u0006\u0010y\u001a\u00020zH\u0016J0\u0010\u00a3\u0001\u001a\u0005\u0018\u00010\u00a4\u00012\u0007\u0010\u00a5\u0001\u001a\u00020K2\u0007\u0010\u00a6\u0001\u001a\u00020r2\b\u0010\u009c\u0001\u001a\u00030\u009d\u00012\b\u0010\u00a7\u0001\u001a\u00030\u00a8\u0001J$\u0010\u00a9\u0001\u001a\u0005\u0018\u00010\u00aa\u00012\u0007\u0010\u00a5\u0001\u001a\u00020K2\u0007\u0010\u00ab\u0001\u001a\u00028\u0000H\u0007\u00a2\u0006\u0003\u0010\u00ac\u0001J!\u0010\u00ad\u0001\u001a\u0004\u0018\u00010K2\u0007\u0010\u00a5\u0001\u001a\u00020K2\u0007\u0010\u00ab\u0001\u001a\u00028\u0000\u00a2\u0006\u0003\u0010\u00ae\u0001J!\u0010\u00af\u0001\u001a\u0004\u0018\u00010K2\u0007\u0010\u00a5\u0001\u001a\u00020K2\u0007\u0010\u00ab\u0001\u001a\u00028\u0000\u00a2\u0006\u0003\u0010\u00ae\u0001J!\u0010\u0095\u0001\u001a\u00020K2\u0007\u0010\u00a5\u0001\u001a\u00020K2\u0007\u0010\u00ab\u0001\u001a\u00028\u0000H\u0002\u00a2\u0006\u0003\u0010\u00b0\u0001J'\u0010\u00b1\u0001\u001a\u00020k2\u0006\u0010j\u001a\u00020k2\u0006\u0010m\u001a\u00020k2\u0006\u0010l\u001a\u00020k2\u0006\u0010n\u001a\u00020kR\u001a\u0010\u0004\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R@\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00112\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0011@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\"R\u0014\u0010%\u001a\u00020&X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001c\u0010)\u001a\u0004\u0018\u00010*X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u0010/\u001a\u000200X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001a\u00105\u001a\u000200X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00102\"\u0004\b7\u00104R\u001a\u00108\u001a\u000209X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010:\"\u0004\b;\u0010<R\u0014\u0010=\u001a\u00020>X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@R\u0014\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00180BX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020DX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020FX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010G\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010I0HX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010J\u001a\u00020KX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\bL\u0010MR\u0012\u0010N\u001a\u00020KX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\bO\u0010MR1\u0010{\u001a\b\u0012\u0004\u0012\u0002090|2\f\u0010{\u001a\b\u0012\u0004\u0012\u0002090|8V@VX\u0096\u000e\u00a2\u0006\r\u001a\u0004\b}\u0010~\"\u0005\b\u007f\u0010\u0080\u0001R\u001c\u0010\u0081\u0001\u001a\b\u0012\u0004\u0012\u0002090|8VX\u0096\u0004\u00a2\u0006\u0007\u001a\u0005\b\u0082\u0001\u0010~R5\u0010\u0083\u0001\u001a\b\u0012\u0004\u0012\u0002090|2\r\u0010\u0083\u0001\u001a\b\u0012\u0004\u0012\u0002090|8V@VX\u0096\u000e\u00a2\u0006\u000f\u001a\u0005\b\u0084\u0001\u0010~\"\u0006\b\u0085\u0001\u0010\u0080\u0001R7\u0010\u0086\u0001\u001a\t\u0012\u0005\u0012\u00030\u0087\u00010|2\u000e\u0010\u0086\u0001\u001a\t\u0012\u0005\u0012\u00030\u0087\u00010|8V@VX\u0096\u000e\u00a2\u0006\u000f\u001a\u0005\b\u0088\u0001\u0010~\"\u0006\b\u0089\u0001\u0010\u0080\u0001R\u001c\u0010\u008a\u0001\u001a\b\u0012\u0004\u0012\u00020k0|8VX\u0096\u0004\u00a2\u0006\u0007\u001a\u0005\b\u008b\u0001\u0010~R\u001d\u0010\u008c\u0001\u001a\t\u0012\u0005\u0012\u00030\u008d\u00010|8VX\u0096\u0004\u00a2\u0006\u0007\u001a\u0005\b\u008e\u0001\u0010~R\u001f\u0010\u008f\u0001\u001a\u000b\u0012\u0007\u0012\u0005\u0018\u00010\u0090\u00010|8VX\u0096\u0004\u00a2\u0006\u0007\u001a\u0005\b\u0091\u0001\u0010~R\u001c\u0010\u0092\u0001\u001a\b\u0012\u0004\u0012\u0002090|8VX\u0096\u0004\u00a2\u0006\u0007\u001a\u0005\b\u0093\u0001\u0010~R\u001c\u0010\u0094\u0001\u001a\b\u0012\u0004\u0012\u00020k0|8VX\u0096\u0004\u00a2\u0006\u0007\u001a\u0005\b\u0095\u0001\u0010~R7\u0010\u0096\u0001\u001a\t\u0012\u0005\u0012\u00030\u0097\u00010|2\u000e\u0010\u0096\u0001\u001a\t\u0012\u0005\u0012\u00030\u0097\u00010|8V@VX\u0096\u000e\u00a2\u0006\u000f\u001a\u0005\b\u0098\u0001\u0010~\"\u0006\b\u0099\u0001\u0010\u0080\u0001R\u001c\u0010\u009a\u0001\u001a\b\u0012\u0004\u0012\u0002090|8VX\u0096\u0004\u00a2\u0006\u0007\u001a\u0005\b\u009b\u0001\u0010~R\u001d\u0010\u009c\u0001\u001a\t\u0012\u0005\u0012\u00030\u009d\u00010|8VX\u0096\u0004\u00a2\u0006\u0007\u001a\u0005\b\u009e\u0001\u0010~R\u001d\u0010\u009f\u0001\u001a\t\u0012\u0005\u0012\u00030\u00a0\u00010|8VX\u0096\u0004\u00a2\u0006\u0007\u001a\u0005\b\u00a1\u0001\u0010~R\u001b\u0010a\u001a\b\u0012\u0004\u0012\u00020b0|8VX\u0096\u0004\u00a2\u0006\u0007\u001a\u0005\b\u00a2\u0001\u0010~\u00a8\u0006\u00b7\u0001"}, d2={"Lcom/macrofocus/trenddisplay/timeseriesplot/AbstractTimeSeriesPlotView;", "Row", "Column", "Lcom/macrofocus/trenddisplay/timeseriesplot/TimeSeriesPlotView;", "canvas", "Lorg/mkui/canvas/CPCanvas;", "factory", "Lorg/mkui/component/CPFactory;", "paletteFactory", "Lorg/mkui/palette/PaletteFactory;", "<init>", "(Lorg/mkui/canvas/CPCanvas;Lorg/mkui/component/CPFactory;Lorg/mkui/palette/PaletteFactory;)V", "getCanvas", "()Lorg/mkui/canvas/CPCanvas;", "setCanvas", "(Lorg/mkui/canvas/CPCanvas;)V", "model", "Lcom/macrofocus/trenddisplay/timeseriesplot/TimeSeriesPlotModel;", "getModel", "()Lcom/macrofocus/trenddisplay/timeseriesplot/TimeSeriesPlotModel;", "setModel", "(Lcom/macrofocus/trenddisplay/timeseriesplot/TimeSeriesPlotModel;)V", "properties", "Lcom/macrofocus/common/properties/MutableProperties;", "Lcom/macrofocus/trenddisplay/timeseriesplot/TimeSeriesPlotView$PropertyType;", "getProperties", "()Lcom/macrofocus/common/properties/MutableProperties;", "timer", "Lcom/macrofocus/common/timer/CPTimer;", "getTimer", "()Lcom/macrofocus/common/timer/CPTimer;", "xRangeModel", "Lcom/macrofocus/common/interval/MutableBoundedInterval;", "getXRangeModel", "()Lcom/macrofocus/common/interval/MutableBoundedInterval;", "yRangeModel", "getYRangeModel", "screenTransform", "Lorg/mkui/transform/MutableTwoDScreenTransform;", "getScreenTransform", "()Lorg/mkui/transform/MutableTwoDScreenTransform;", "rangesScreenTransformCoordinator", "Lcom/macrofocus/common/transform/RangesScreenTransformCoordinator;", "getRangesScreenTransformCoordinator", "()Lcom/macrofocus/common/transform/RangesScreenTransformCoordinator;", "setRangesScreenTransformCoordinator", "(Lcom/macrofocus/common/transform/RangesScreenTransformCoordinator;)V", "xGuide", "Lcom/macrofocus/plot/guide/Guide;", "getXGuide", "()Lcom/macrofocus/plot/guide/Guide;", "setXGuide", "(Lcom/macrofocus/plot/guide/Guide;)V", "yGuide", "getYGuide", "setYGuide", "isSelectionMode", "", "()Z", "setSelectionMode", "(Z)V", "rubberBand", "Lorg/mkui/rubberband/RubberBand;", "getRubberBand", "()Lorg/mkui/rubberband/RubberBand;", "propertiesListener", "Lcom/macrofocus/common/properties/PropertiesListener;", "listener", "Lcom/macrofocus/trenddisplay/timeseriesplot/TimeSeriesPlotListener;", "intervalListener", "Lcom/macrofocus/common/interval/BoundedIntervalListener;", "axisSelectionListener", "Lcom/macrofocus/common/selection/SingleSelectionListener;", "Lcom/macrofocus/high_d/axis/AxisModel;", "width", "", "getWidth", "()I", "height", "getHeight", "refresh", "", "repaint", "scheduleUpdate", "addMouseListener", "l", "Lorg/mkui/canvas/MouseListener;", "addMouseMotionListener", "Lorg/mkui/canvas/MouseMotionListener;", "addMouseWheelListener", "Lorg/mkui/canvas/MouseWheelListener;", "addKeyListener", "Lorg/mkui/canvas/KeyListener;", "createOverplots", "populateOverplots", "getTimeSeriesPlotConfiguration", "Lcom/macrofocus/trenddisplay/timeseriesplot/TimeSeriesPlotConfiguration;", "style", "Lcom/macrofocus/trenddisplay/timeseriesplot/TimeSeriesPlotView$Style;", "color", "Ljava/awt/Color;", "Lorg/mkui/color/MkColor;", "resetXAxis", "resetYAxis", "zoom", "animate", "x1", "", "x2", "y1", "y2", "updateIntervals", "updateAxisType", "getClosestGroup", "Lorg/molap/aggregates/cube/Group;", "x", "y", "getClosestRow", "(II)Ljava/lang/Object;", "getRows", "", "rect", "Lorg/mkui/geom/Rectangle2D;", "showFiltered", "Lcom/macrofocus/common/properties/MutableProperty;", "getShowFiltered", "()Lcom/macrofocus/common/properties/MutableProperty;", "setShowFiltered", "(Lcom/macrofocus/common/properties/MutableProperty;)V", "showGrid", "getShowGrid", "antialiasing", "getAntialiasing", "setAntialiasing", "rendering", "Lorg/mkui/canvas/Rendering;", "getRendering", "setRendering", "lineWidth", "getLineWidth", "gridThickness", "", "getGridThickness", "showColor", "", "getShowColor", "regression", "getRegression", "markerSize", "getMarkerSize", "colorTheme", "Lorg/mkui/graphics/colortheme/ColorTheme;", "getColorTheme", "setColorTheme", "displayLabels", "getDisplayLabels", "mode", "Lorg/molap/series/TimeSeries$TimeMode;", "getMode", "layout", "Lcom/macrofocus/trenddisplay/timeseriesplot/TimeSeriesPlotView$Layout;", "getLayout", "getStyle", "getTimeSeries", "Lorg/mkui/geom/GeneralPath;", "layer", "group", "lineType", "Lcom/macrofocus/trenddisplay/timeseriesplot/TimeSeriesPlotConfiguration$LineType;", "getPoint", "Lorg/mkui/geom/Point;", "row", "(ILjava/lang/Object;)Lorg/mkui/geom/Point;", "getXLine", "(ILjava/lang/Object;)Ljava/lang/Integer;", "getYLine", "(ILjava/lang/Object;)I", "distance", "AbstractMasterVisualLayerIDrawing", "AbstractVisualLayerIDrawing", "AnnotationIDrawing", "Companion", "RangePoint", "trenddisplay"})
@StabilityInferred(parameters=0)
public abstract class AbstractTimeSeriesPlotView<Row, Column>
implements TimeSeriesPlotView<Row, Column> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private CPCanvas canvas;
    @NotNull
    private final CPFactory factory;
    @NotNull
    private final PaletteFactory paletteFactory;
    @Nullable
    private TimeSeriesPlotModel<Row, Column> model;
    @NotNull
    private final MutableProperties<TimeSeriesPlotView.PropertyType> properties;
    @NotNull
    private final CPTimer timer;
    @NotNull
    private final MutableBoundedInterval xRangeModel;
    @NotNull
    private final MutableBoundedInterval yRangeModel;
    @NotNull
    private final MutableTwoDScreenTransform screenTransform;
    @Nullable
    private RangesScreenTransformCoordinator rangesScreenTransformCoordinator;
    @NotNull
    private Guide xGuide;
    @NotNull
    private Guide yGuide;
    private boolean isSelectionMode;
    @NotNull
    private final RubberBand rubberBand;
    @NotNull
    private final PropertiesListener<TimeSeriesPlotView.PropertyType> propertiesListener;
    @NotNull
    private final TimeSeriesPlotListener listener;
    @NotNull
    private final BoundedIntervalListener intervalListener;
    @NotNull
    private final SingleSelectionListener<AxisModel<Row, Column>> axisSelectionListener;
    public static final int $stable = 8;
    private static final int MARGIN = 8;
    private static final boolean MULTITHREADED = true;
    @Nullable
    private static final ExecutorService executor = CPHelper.Companion.getInstance().visualizationExecutorService();

    public AbstractTimeSeriesPlotView(@NotNull CPCanvas canvas, @NotNull CPFactory factory, @NotNull PaletteFactory paletteFactory) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)paletteFactory, (String)"paletteFactory");
        this.canvas = canvas;
        this.factory = factory;
        this.paletteFactory = paletteFactory;
        this.properties = (MutableProperties)new EnumProperties((Enum[])TimeSeriesPlotView.PropertyType.values());
        this.xRangeModel = (MutableBoundedInterval)new SimpleBoundedInterval(0.0, 1.0, 0.0, 1.0);
        this.yRangeModel = (MutableBoundedInterval)new SimpleBoundedInterval(0.0, 1.0, 0.0, 1.0);
        this.screenTransform = (MutableTwoDScreenTransform)new SimpleTwoDScreenTransform((BoundedInterval)this.getXRangeModel(), (BoundedInterval)this.getYRangeModel(), 0, 0, 0.0, 28, null);
        this.xGuide = (Guide)new XNumberOneDScreenTransformAxisGuide(Guide.Type.Bottom, (OneDScreenTransform)this.getScreenTransform().getX());
        this.yGuide = (Guide)new YNumberOneDScreenTransformAxisGuide(Guide.Type.Left, (OneDScreenTransform)this.getScreenTransform().getY());
        this.isSelectionMode = true;
        this.rubberBand = (RubberBand)new ScreenTransformRubberBand((TwoDScreenTransform)this.getScreenTransform());
        this.propertiesListener = (PropertiesListener)new PropertiesListener<TimeSeriesPlotView.PropertyType>(this){
            final /* synthetic */ AbstractTimeSeriesPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
            }

            public void propertyChanged(TimeSeriesPlotView.PropertyType name, PropertyEvent<Object> event) {
                Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.this$0.createOverplots();
                this.this$0.scheduleUpdate();
            }
        };
        this.listener = new TimeSeriesPlotListener(this){
            final /* synthetic */ AbstractTimeSeriesPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
            }

            public void timeSeriesPlotChanged() {
                this.this$0.resetXAxis();
                this.this$0.resetYAxis();
                this.this$0.scheduleUpdate();
            }
        };
        this.intervalListener = new BoundedIntervalListener(this){
            final /* synthetic */ AbstractTimeSeriesPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
            }

            public void boundedIntervalChanged(BoundedIntervalEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.this$0.updateIntervals();
            }
        };
        this.axisSelectionListener = new SingleSelectionListener<AxisModel<Row, Column>>(this){
            final /* synthetic */ AbstractTimeSeriesPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
            }

            public void selectionChanged(SingleSelectionEvent<AxisModel<Row, Column>> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                if (event.getPreviousSelection() != null) {
                    AxisModel axisModel = (AxisModel)event.getPreviousSelection();
                    if ((axisModel != null ? axisModel.getInterval() : null) != null) {
                        Object object = event.getPreviousSelection();
                        Intrinsics.checkNotNull((Object)object);
                        ((AxisModel)object).getInterval().removeBoundedIntervalListener(AbstractTimeSeriesPlotView.access$getIntervalListener$p(this.this$0));
                    }
                }
                if (event.getCurrentSelection() != null) {
                    AxisModel axisModel = (AxisModel)event.getCurrentSelection();
                    if ((axisModel != null ? axisModel.getInterval() : null) != null) {
                        Object object = event.getCurrentSelection();
                        Intrinsics.checkNotNull((Object)object);
                        ((AxisModel)object).getInterval().addBoundedIntervalListener(AbstractTimeSeriesPlotView.access$getIntervalListener$p(this.this$0));
                    }
                }
                this.this$0.updateAxisType();
                this.this$0.updateIntervals();
            }
        };
        this.getProperties().createProperty((Object)TimeSeriesPlotView.PropertyType.ShowFiltered, (Object)true);
        this.getProperties().createProperty((Object)TimeSeriesPlotView.PropertyType.ShowGrid, (Object)true);
        this.getProperties().createProperty((Object)TimeSeriesPlotView.PropertyType.Antialiasing, (Object)true);
        this.getProperties().createProperty((Object)TimeSeriesPlotView.PropertyType.Rendering, (Object)Rendering.AlphaBlended);
        this.getProperties().createProperty((Object)TimeSeriesPlotView.PropertyType.LineWidth, (Object)1.0);
        this.getProperties().createProperty((Object)TimeSeriesPlotView.PropertyType.GridThickness, (Object)Float.valueOf(0.1f));
        this.getProperties().createProperty((Object)TimeSeriesPlotView.PropertyType.ShowColor, (Object)MkColorKt.colorOf((int)128, (int)128, (int)128));
        this.getProperties().createProperty((Object)TimeSeriesPlotView.PropertyType.Regression, (Object)true);
        this.getProperties().createProperty((Object)TimeSeriesPlotView.PropertyType.MarkerSize, (Object)8.0);
        this.getProperties().createProperty((Object)TimeSeriesPlotView.PropertyType.ColorTheme, (Object)new LightColorTheme());
        this.getProperties().createProperty((Object)TimeSeriesPlotView.PropertyType.DisplayLabels, (Object)true);
        this.getProperties().createProperty((Object)TimeSeriesPlotView.PropertyType.Style, (Object)TimeSeriesPlotView.Style.Straight);
        this.getProperties().createProperty((Object)TimeSeriesPlotView.PropertyType.Mode, (Object)TimeSeries.TimeMode.Absolute);
        this.getProperties().createProperty((Object)TimeSeriesPlotView.PropertyType.Layout, (Object)TimeSeriesPlotView.Layout.Overlay);
        this.getProperties().addPropertiesListener(this.propertiesListener);
        this.timer = CPHelper.Companion.getInstance().createTimer("TimeSeriesPlotPlotResizer", 50, true, new CPTimerListener(){

            public void timerTriggered() {
                if (this.getWidth() > 0 && this.getHeight() > 0) {
                    this.refresh();
                }
            }
        });
        this.getScreenTransform().getX().setScreenMargins(8);
        this.getScreenTransform().getY().setScreenMargins(8);
        this.getMode().addPropertyListener((PropertyListener)new PropertyListener<TimeSeries.TimeMode>(){

            public void propertyChanged(PropertyEvent<TimeSeries.TimeMode> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.resetXAxis();
            }
        });
        this.getLayout().addPropertyListener((PropertyListener)new PropertyListener<TimeSeriesPlotView.Layout>(){

            public void propertyChanged(PropertyEvent<TimeSeriesPlotView.Layout> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.resetYAxis();
            }
        });
        this.canvas.addCanvasListener(new CanvasListener(){

            public void sizeChange(int width, int height) {
                this.getScreenTransform().setScreenSize(width, height);
            }
        });
        this.getScreenTransform().addScreenTransformListener(new ScreenTransformListener(){

            public void transformChanged(ScreenTransformEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.getTimer().restart();
            }
        });
    }

    @NotNull
    protected final CPCanvas getCanvas() {
        return this.canvas;
    }

    protected final void setCanvas(@NotNull CPCanvas cPCanvas) {
        Intrinsics.checkNotNullParameter((Object)cPCanvas, (String)"<set-?>");
        this.canvas = cPCanvas;
    }

    @Override
    @Nullable
    public TimeSeriesPlotModel<Row, Column> getModel() {
        return this.model;
    }

    @Override
    public void setModel(@Nullable TimeSeriesPlotModel<Row, Column> model) {
        if (this.model != null) {
            TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel = this.model;
            Intrinsics.checkNotNull(timeSeriesPlotModel);
            timeSeriesPlotModel.removeTimeSeriesPlotListener(this.listener);
            TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel2 = this.model;
            if ((timeSeriesPlotModel2 != null ? timeSeriesPlotModel2.getTime() : null) != null) {
                TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel3 = this.model;
                Intrinsics.checkNotNull(timeSeriesPlotModel3);
                timeSeriesPlotModel3.getTime().removeSingleSelectionListener(this.axisSelectionListener);
            }
            TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel4 = this.model;
            if ((timeSeriesPlotModel4 != null ? timeSeriesPlotModel4.getY() : null) != null) {
                TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel5 = this.model;
                Intrinsics.checkNotNull(timeSeriesPlotModel5);
                timeSeriesPlotModel5.getY().removeSingleSelectionListener(this.axisSelectionListener);
            }
        }
        this.model = model;
        this.createOverplots();
        if (this.model != null) {
            TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel = this.model;
            Intrinsics.checkNotNull(timeSeriesPlotModel);
            timeSeriesPlotModel.addTimeSeriesPlotListener(this.listener);
            TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel6 = this.model;
            if ((timeSeriesPlotModel6 != null ? timeSeriesPlotModel6.getTime() : null) != null) {
                TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel7 = this.model;
                Intrinsics.checkNotNull(timeSeriesPlotModel7);
                MutableSingleSelection<AxisModel<Row, Column>> x = timeSeriesPlotModel7.getTime();
                x.addSingleSelectionListener(this.axisSelectionListener);
                if (x.isActive()) {
                    AxisModel axisModel = (AxisModel)x.getSelected();
                    if ((axisModel != null ? axisModel.getInterval() : null) != null) {
                        Object object = x.getSelected();
                        Intrinsics.checkNotNull((Object)object);
                        ((AxisModel)object).getInterval().addBoundedIntervalListener(this.intervalListener);
                    }
                }
            }
            TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel8 = this.model;
            if ((timeSeriesPlotModel8 != null ? timeSeriesPlotModel8.getY() : null) != null) {
                TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel9 = this.model;
                Intrinsics.checkNotNull(timeSeriesPlotModel9);
                MutableSingleSelection<AxisModel<Row, Column>> y = timeSeriesPlotModel9.getY();
                y.addSingleSelectionListener(this.axisSelectionListener);
                if (y.isActive()) {
                    AxisModel axisModel = (AxisModel)y.getSelected();
                    if ((axisModel != null ? axisModel.getInterval() : null) != null) {
                        Object object = y.getSelected();
                        Intrinsics.checkNotNull((Object)object);
                        ((AxisModel)object).getInterval().addBoundedIntervalListener(this.intervalListener);
                    }
                }
            }
        }
        this.updateIntervals();
        this.updateAxisType();
        this.resetXAxis();
        this.resetYAxis();
        this.timer.restart();
    }

    @Override
    @NotNull
    public MutableProperties<TimeSeriesPlotView.PropertyType> getProperties() {
        return this.properties;
    }

    @NotNull
    protected final CPTimer getTimer() {
        return this.timer;
    }

    @Override
    @NotNull
    public MutableBoundedInterval getXRangeModel() {
        return this.xRangeModel;
    }

    @Override
    @NotNull
    public MutableBoundedInterval getYRangeModel() {
        return this.yRangeModel;
    }

    @Override
    @NotNull
    public MutableTwoDScreenTransform getScreenTransform() {
        return this.screenTransform;
    }

    @Nullable
    protected final RangesScreenTransformCoordinator getRangesScreenTransformCoordinator() {
        return this.rangesScreenTransformCoordinator;
    }

    protected final void setRangesScreenTransformCoordinator(@Nullable RangesScreenTransformCoordinator rangesScreenTransformCoordinator) {
        this.rangesScreenTransformCoordinator = rangesScreenTransformCoordinator;
    }

    @Override
    @NotNull
    public Guide getXGuide() {
        return this.xGuide;
    }

    public void setXGuide(@NotNull Guide guide) {
        Intrinsics.checkNotNullParameter((Object)guide, (String)"<set-?>");
        this.xGuide = guide;
    }

    @Override
    @NotNull
    public Guide getYGuide() {
        return this.yGuide;
    }

    public void setYGuide(@NotNull Guide guide) {
        Intrinsics.checkNotNullParameter((Object)guide, (String)"<set-?>");
        this.yGuide = guide;
    }

    @Override
    public boolean isSelectionMode() {
        return this.isSelectionMode;
    }

    @Override
    public void setSelectionMode(boolean bl) {
        this.isSelectionMode = bl;
    }

    @Override
    @NotNull
    public RubberBand getRubberBand() {
        return this.rubberBand;
    }

    protected abstract int getWidth();

    protected abstract int getHeight();

    protected abstract void refresh();

    protected abstract void repaint();

    protected abstract void scheduleUpdate();

    @Override
    public void addMouseListener(@NotNull MouseListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.canvas.addMouseListener(l);
    }

    @Override
    public void addMouseMotionListener(@NotNull MouseMotionListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.canvas.addMouseMotionListener(l);
    }

    @Override
    public void addMouseWheelListener(@NotNull MouseWheelListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.canvas.addMouseWheelListener(l);
    }

    @Override
    public void addKeyListener(@NotNull KeyListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.canvas.addKeyListener(listener2);
    }

    public final void createOverplots() {
        if (this.getModel() != null) {
            this.canvas.removeAllLayers();
            this.populateOverplots();
        }
    }

    protected final void populateOverplots() {
        TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel = this.getModel();
        Intrinsics.checkNotNull(timeSeriesPlotModel);
        Visual<Group, String> visual = timeSeriesPlotModel.getMasterVisual();
        Intrinsics.checkNotNull(visual);
        VisualLayer visualLayer = visual.getFiltered();
        TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel2 = this.getModel();
        Intrinsics.checkNotNull(timeSeriesPlotModel2);
        VisualLayer visualLayer2 = timeSeriesPlotModel2.getMasterDataFrame();
        Intrinsics.checkNotNull(visualLayer2);
        VisualLayer visualLayer3 = visualLayer2;
        IDrawing timeSeriesFilteredDrawing2 = (IDrawing)new AbstractMasterVisualLayerIDrawing(this, (VisualLayer<Group>)visualLayer, (SubsetDataFrame<Group, String, Object>)visualLayer3){
            private TimeSeriesPlotConfiguration configuration;
            final /* synthetic */ AbstractTimeSeriesPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, (DataFrame<Group, String, Object>)((DataFrame)$super_call_param$2));
                Object object = $receiver.getStyle().getValue();
                Intrinsics.checkNotNull((Object)object);
                this.configuration = AbstractTimeSeriesPlotView.access$getTimeSeriesPlotConfiguration($receiver, (TimeSeriesPlotView.Style)((Object)object), (Color)CollectionsKt.first((List)((ColorTheme)$receiver.getColorTheme().getValue()).getGhostedPalette().getColors()));
                this.configuration.setLineWidth((float)((Number)$receiver.getLineWidth().getValue()).doubleValue() / 2.0f);
            }

            public final TimeSeriesPlotConfiguration getConfiguration() {
                return this.configuration;
            }

            public final void setConfiguration(TimeSeriesPlotConfiguration timeSeriesPlotConfiguration) {
                Intrinsics.checkNotNullParameter((Object)timeSeriesPlotConfiguration, (String)"<set-?>");
                this.configuration = timeSeriesPlotConfiguration;
            }

            public boolean isActive() {
                Object object = this.this$0.getShowFiltered().getValue();
                Intrinsics.checkNotNull((Object)object);
                return (Boolean)object != false && super.isActive();
            }

            public void draw(IGraphics g, Group group, double width, double height) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Intrinsics.checkNotNullParameter((Object)group, (String)"group");
                TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel = this.this$0.getModel();
                Intrinsics.checkNotNull(timeSeriesPlotModel);
                SubsetDataFrame<Group, String, Object> subsetDataFrame = timeSeriesPlotModel.getMasterDataFrame();
                Intrinsics.checkNotNull(subsetDataFrame);
                TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel2 = this.this$0.getModel();
                Intrinsics.checkNotNull(timeSeriesPlotModel2);
                Object object = timeSeriesPlotModel2.getY().getSelected();
                Intrinsics.checkNotNull((Object)object);
                TimeSeries timeSeries = (TimeSeries)subsetDataFrame.getValueAt((Object)group, (Object)String.valueOf(((AxisModel)object).getColumn()));
                if (timeSeries != null) {
                    this.configuration.getRenderer().draw(timeSeries, (TwoDScreenTransform)this.this$0.getScreenTransform(), g, (TimeSeries.TimeMode)this.this$0.getMode().getValue(), this.configuration, false, false);
                }
            }
        };
        TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel3 = this.getModel();
        Intrinsics.checkNotNull(timeSeriesPlotModel3);
        Visual<Row, Column> visual2 = timeSeriesPlotModel3.getVisual();
        Intrinsics.checkNotNull(visual2);
        visualLayer3 = visual2.getFiltered();
        IDrawing filteredDrawing2 = (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer3){
            final /* synthetic */ AbstractTimeSeriesPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public boolean isActive() {
                Object object = this.this$0.getShowFiltered().getValue();
                Intrinsics.checkNotNull((Object)object);
                return (Boolean)object != false && super.isActive();
            }

            public void draw(IGraphics g, Row row, double width, double height) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Point mp = this.this$0.getPoint(0, row);
                if (mp != null) {
                    TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel = this.this$0.getModel();
                    Intrinsics.checkNotNull(timeSeriesPlotModel);
                    if (timeSeriesPlotModel.getSizeAxisModel() != null) {
                        int size = AbstractTimeSeriesPlotView.access$getMarkerSize(this.this$0, 0, row);
                        double radius = (double)size / 2.0;
                        g.fillCircle((Rectangle2D)new Rectangle((int)(mp.getX() - radius), (int)(mp.getY() - radius), size, size));
                    } else {
                        int size = (int)Math.max(1.0, (double)(AbstractTimeSeriesPlotView.access$getMarkerSize(this.this$0, 0, row) / 2));
                        double radius = (double)size / 2.0;
                        g.fillCircle((Rectangle2D)new Rectangle((int)(mp.getX() - radius), (int)(mp.getY() - radius), size, size));
                    }
                }
            }
        };
        TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel4 = this.getModel();
        Intrinsics.checkNotNull(timeSeriesPlotModel4);
        Visual<Row, Column> visual3 = timeSeriesPlotModel4.getVisual();
        Intrinsics.checkNotNull(visual3);
        VisualLayer visualLayer4 = visual3.getVisible();
        IDrawing visibleDrawing2 = (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer4){
            final /* synthetic */ AbstractTimeSeriesPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void draw(IGraphics g, Row row, double width, double height) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Point mp = this.this$0.getPoint(0, row);
                if (mp != null) {
                    int size = AbstractTimeSeriesPlotView.access$getMarkerSize(this.this$0, 0, row);
                    int radius = size / 2;
                    g.fillCircle((Rectangle2D)new Rectangle((int)(mp.getX() - (double)radius), (int)(mp.getY() - (double)radius), size, size));
                }
            }
        };
        TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel5 = this.getModel();
        Intrinsics.checkNotNull(timeSeriesPlotModel5);
        Visual<Row, Column> visual4 = timeSeriesPlotModel5.getVisual();
        Intrinsics.checkNotNull(visual4);
        VisualLayer visualLayer5 = visual4.getColorMapped();
        IDrawing colorMappedDrawing2 = (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer5){
            final /* synthetic */ AbstractTimeSeriesPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void draw(IGraphics g, Row row, double width, double height) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Point mp = this.this$0.getPoint(0, row);
                if (mp != null) {
                    TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel = this.this$0.getModel();
                    Intrinsics.checkNotNull(timeSeriesPlotModel);
                    MutableColorMapping<Row, Column> mutableColorMapping = timeSeriesPlotModel.getColorMapping();
                    Intrinsics.checkNotNull(mutableColorMapping);
                    Color color = mutableColorMapping.getColor(row);
                    Intrinsics.checkNotNull((Object)color);
                    g.setColor(color);
                    int size = AbstractTimeSeriesPlotView.access$getMarkerSize(this.this$0, 0, row);
                    double radius = (double)size / 2.0;
                    g.fillCircle((Rectangle2D)new Rectangle((int)(mp.getX() - radius), (int)(mp.getY() - radius), size, size));
                }
            }
        };
        TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel6 = this.getModel();
        Intrinsics.checkNotNull(timeSeriesPlotModel6);
        Visual<Row, Column> visual5 = timeSeriesPlotModel6.getVisual();
        Intrinsics.checkNotNull(visual5);
        VisualLayer visualLayer6 = visual5.getColored();
        IDrawing coloredDrawing2 = (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer6){
            final /* synthetic */ AbstractTimeSeriesPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void draw(IGraphics g, Row row, double width, double height) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Point mp = this.this$0.getPoint(0, row);
                if (mp != null) {
                    TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel = this.this$0.getModel();
                    Intrinsics.checkNotNull(timeSeriesPlotModel);
                    MutableColoring<Row> mutableColoring = timeSeriesPlotModel.getColoring();
                    Intrinsics.checkNotNull(mutableColoring);
                    Color color = mutableColoring.getColor(row);
                    Intrinsics.checkNotNull((Object)color);
                    g.setColor(color);
                    int size = AbstractTimeSeriesPlotView.access$getMarkerSize(this.this$0, 0, row);
                    double radius = (double)size / 2.0;
                    g.fillCircle((Rectangle2D)new Rectangle((int)(mp.getX() - radius), (int)(mp.getY() - radius), size, size));
                }
            }
        };
        TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel7 = this.getModel();
        Intrinsics.checkNotNull(timeSeriesPlotModel7);
        Visual<Row, Column> visual6 = timeSeriesPlotModel7.getVisual();
        Intrinsics.checkNotNull(visual6);
        VisualLayer visualLayer7 = visual6.getSingleSelected();
        IDrawing singleSelectedDrawing2 = (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer7){
            final /* synthetic */ AbstractTimeSeriesPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void draw(IGraphics g, Row row, double width, double height) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Point mp = this.this$0.getPoint(0, row);
                if (mp != null) {
                    g.setColor(((ColorTheme)this.this$0.getColorTheme().getValue()).getSelection());
                    TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel = this.this$0.getModel();
                    if ((timeSeriesPlotModel != null ? timeSeriesPlotModel.getSizeAxisModel() : null) != null) {
                        int size = AbstractTimeSeriesPlotView.access$getMarkerSize(this.this$0, 0, row) + 2;
                        double radius = (double)size / 2.0;
                        g.fillCircle((Rectangle2D)new Rectangle((int)(mp.getX() - radius), (int)(mp.getY() - radius), size, size));
                    } else {
                        int size = AbstractTimeSeriesPlotView.access$getMarkerSize(this.this$0, 0, row) + 2;
                        double radius = (double)size / 2.0;
                        g.fillCircle((Rectangle2D)new Rectangle((int)(mp.getX() - radius), (int)(mp.getY() - radius), size, size));
                    }
                }
            }
        };
        TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel8 = this.getModel();
        Intrinsics.checkNotNull(timeSeriesPlotModel8);
        Visual<Row, Column> visual7 = timeSeriesPlotModel8.getVisual();
        Intrinsics.checkNotNull(visual7);
        VisualLayer visualLayer8 = visual7.getMultipleSelected();
        IDrawing multiSelectedDrawing2 = (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer8){
            final /* synthetic */ AbstractTimeSeriesPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void draw(IGraphics g, Row row, double width, double height) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Point mp = this.this$0.getPoint(0, row);
                if (mp != null) {
                    g.setColor(((ColorTheme)this.this$0.getColorTheme().getValue()).getSelection());
                    TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel = this.this$0.getModel();
                    if ((timeSeriesPlotModel != null ? timeSeriesPlotModel.getSizeAxisModel() : null) != null) {
                        int size = AbstractTimeSeriesPlotView.access$getMarkerSize(this.this$0, 0, row) + 2;
                        double radius = (double)size / 2.0;
                        g.fillCircle((Rectangle2D)new Rectangle((int)(mp.getX() - radius), (int)(mp.getY() - radius), size, size));
                    } else {
                        int size = AbstractTimeSeriesPlotView.access$getMarkerSize(this.this$0, 0, row) + 2;
                        double radius = (double)size / 2.0;
                        g.fillCircle((Rectangle2D)new Rectangle((int)(mp.getX() - radius), (int)(mp.getY() - radius), size, size));
                    }
                }
            }
        };
        TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel9 = this.getModel();
        Intrinsics.checkNotNull(timeSeriesPlotModel9);
        Visual<Group, String> visual8 = timeSeriesPlotModel9.getMasterVisual();
        Intrinsics.checkNotNull(visual8);
        VisualLayer visualLayer9 = visual8.getProbed();
        TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel10 = this.getModel();
        Intrinsics.checkNotNull(timeSeriesPlotModel10);
        VisualLayer visualLayer10 = timeSeriesPlotModel10.getMasterDataFrame();
        Intrinsics.checkNotNull(visualLayer10);
        VisualLayer visualLayer11 = visualLayer10;
        IDrawing timeSeriesProbedDrawing2 = (IDrawing)new AbstractMasterVisualLayerIDrawing(this, (VisualLayer<Group>)visualLayer9, (SubsetDataFrame<Group, String, Object>)visualLayer11){
            private TimeSeriesPlotConfiguration configuration;
            final /* synthetic */ AbstractTimeSeriesPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, (DataFrame<Group, String, Object>)((DataFrame)$super_call_param$2));
                this.configuration = AbstractTimeSeriesPlotView.access$getTimeSeriesPlotConfiguration($receiver, (TimeSeriesPlotView.Style)((Object)$receiver.getStyle().getValue()), ((ColorTheme)$receiver.getColorTheme().getValue()).getProbing());
                this.configuration.setLineWidth((float)((Number)$receiver.getLineWidth().getValue()).doubleValue() * 1.5f);
            }

            public final TimeSeriesPlotConfiguration getConfiguration() {
                return this.configuration;
            }

            public final void setConfiguration(TimeSeriesPlotConfiguration timeSeriesPlotConfiguration) {
                Intrinsics.checkNotNullParameter((Object)timeSeriesPlotConfiguration, (String)"<set-?>");
                this.configuration = timeSeriesPlotConfiguration;
            }

            public void draw(IGraphics g, Group group, double width, double height) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Intrinsics.checkNotNullParameter((Object)group, (String)"group");
                TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel = this.this$0.getModel();
                Intrinsics.checkNotNull(timeSeriesPlotModel);
                SubsetDataFrame<Group, String, Object> subsetDataFrame = timeSeriesPlotModel.getMasterDataFrame();
                Intrinsics.checkNotNull(subsetDataFrame);
                TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel2 = this.this$0.getModel();
                Intrinsics.checkNotNull(timeSeriesPlotModel2);
                Object object = timeSeriesPlotModel2.getY().getSelected();
                Intrinsics.checkNotNull((Object)object);
                TimeSeries timeSeries = (TimeSeries)subsetDataFrame.getValueAt((Object)group, (Object)String.valueOf(((AxisModel)object).getColumn()));
                if (timeSeries != null) {
                    this.configuration.getRenderer().draw(timeSeries, (TwoDScreenTransform)this.this$0.getScreenTransform(), g, (TimeSeries.TimeMode)this.this$0.getMode().getValue(), this.configuration, true, false);
                }
            }
        };
        TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel11 = this.getModel();
        Intrinsics.checkNotNull(timeSeriesPlotModel11);
        Visual<Row, Column> visual9 = timeSeriesPlotModel11.getVisual();
        Intrinsics.checkNotNull(visual9);
        visualLayer11 = visual9.getProbed();
        IDrawing probedDrawing2 = (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer11){
            final /* synthetic */ AbstractTimeSeriesPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void draw(IGraphics g, Row row, double width, double height) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Point mp = this.this$0.getPoint(0, row);
                if (mp != null) {
                    TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel = this.this$0.getModel();
                    Intrinsics.checkNotNull(timeSeriesPlotModel);
                    if (timeSeriesPlotModel.getSizeAxisModel() != null) {
                        populateOverplots.probedDrawing.1 var8_6 = this;
                        AbstractTimeSeriesPlotView<Row, Column> abstractTimeSeriesPlotView = this.this$0;
                        populateOverplots.probedDrawing.1 $this$draw_u24lambda_u240 = var8_6;
                        boolean bl = false;
                        g.setColor(((ColorTheme)abstractTimeSeriesPlotView.getColorTheme().getValue()).getProbing());
                        int size = AbstractTimeSeriesPlotView.access$getMarkerSize(abstractTimeSeriesPlotView, 0, row) + 2;
                        double radius = (double)size / 2.0;
                        g.fillCircle((Rectangle2D)new Rectangle((int)(mp.getX() - radius), (int)(mp.getY() - radius), size, size));
                        TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel2 = this.this$0.getModel();
                        Intrinsics.checkNotNull(timeSeriesPlotModel2);
                        MutableSelection<Row> mutableSelection = timeSeriesPlotModel2.getSelection();
                        Intrinsics.checkNotNull(mutableSelection);
                        if (mutableSelection.isSelected(row)) {
                            g.setColor(((ColorTheme)this.this$0.getColorTheme().getValue()).getSelection());
                            int size2 = AbstractTimeSeriesPlotView.access$getMarkerSize(this.this$0, 0, row);
                            double radius2 = (double)size2 / 2.0;
                            g.fillCircle((Rectangle2D)new Rectangle((int)(mp.getX() - radius2), (int)(mp.getY() - radius2), size2, size2));
                        }
                    } else {
                        populateOverplots.probedDrawing.1 size2 = this;
                        AbstractTimeSeriesPlotView<Row, Column> radius2 = this.this$0;
                        populateOverplots.probedDrawing.1 $this$draw_u24lambda_u241 = size2;
                        boolean bl = false;
                        g.setColor(((ColorTheme)radius2.getColorTheme().getValue()).getProbing());
                        int size = AbstractTimeSeriesPlotView.access$getMarkerSize(radius2, 0, row) + 2;
                        double radius = (double)size / 2.0;
                        g.fillCircle((Rectangle2D)new Rectangle((int)(mp.getX() - radius), (int)(mp.getY() - radius), size, size));
                        TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel3 = this.this$0.getModel();
                        Intrinsics.checkNotNull(timeSeriesPlotModel3);
                        MutableSelection<Row> mutableSelection = timeSeriesPlotModel3.getSelection();
                        Intrinsics.checkNotNull(mutableSelection);
                        if (mutableSelection.isSelected(row)) {
                            g.setColor(((ColorTheme)this.this$0.getColorTheme().getValue()).getSelection());
                            int size3 = AbstractTimeSeriesPlotView.access$getMarkerSize(this.this$0, 0, row);
                            double radius3 = (double)size3 / 2.0;
                            g.fillCircle((Rectangle2D)new Rectangle((int)(mp.getX() - radius3), (int)(mp.getY() - radius3), size3, size3));
                        }
                    }
                }
            }
        };
        this.canvas.addLayer((IDrawing)new AbstractIDrawing(this){
            final /* synthetic */ AbstractTimeSeriesPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
            }

            public void draw(IGraphics g, Point2D point, double width, double height, Rectangle clipBounds) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Intrinsics.checkNotNullParameter((Object)clipBounds, (String)"clipBounds");
                Color background = ((ColorTheme)this.this$0.getColorTheme().getValue()).getBackground();
                if (background != null) {
                    g.setColor(background);
                    g.fillRectangle2D((Rectangle2D)new Rectangle2D.Double(0.0, 0.0, width, height));
                }
            }
        });
        if (((Boolean)this.getShowFiltered().getValue()).booleanValue()) {
            MutableProperty<Rendering> mutableProperty = this.getRendering();
            Intrinsics.checkNotNull(mutableProperty);
            Object object = mutableProperty.getValue();
            Intrinsics.checkNotNull((Object)object);
            this.canvas.addDensityLayer((Rendering)object, timeSeriesFilteredDrawing2, (Pressure)new LinearPressure(), new PaletteProvider(this){
                final /* synthetic */ AbstractTimeSeriesPlotView<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                }

                public FixedPalette getPalette() {
                    return ((ColorTheme)this.this$0.getColorTheme().getValue()).getGhostedPalette();
                }
            });
        }
        TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel12 = this.getModel();
        Intrinsics.checkNotNull(timeSeriesPlotModel12);
        Visual<Group, String> visual10 = timeSeriesPlotModel12.getMasterVisual();
        Intrinsics.checkNotNull(visual10);
        VisualLayer visualLayer12 = visual10.getVisible();
        TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel13 = this.getModel();
        Intrinsics.checkNotNull(timeSeriesPlotModel13);
        VisualLayer visualLayer13 = timeSeriesPlotModel13.getMasterDataFrame();
        Intrinsics.checkNotNull(visualLayer13);
        VisualLayer visualLayer14 = visualLayer13;
        AbstractMasterVisualLayerIDrawing timeSeriesVisibleDrawing2 = new AbstractMasterVisualLayerIDrawing(this, (VisualLayer<Group>)visualLayer12, (SubsetDataFrame<Group, String, Object>)visualLayer14){
            private TimeSeriesPlotConfiguration configuration;
            final /* synthetic */ AbstractTimeSeriesPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, (DataFrame<Group, String, Object>)((DataFrame)$super_call_param$2));
                this.configuration = AbstractTimeSeriesPlotView.access$getTimeSeriesPlotConfiguration($receiver, (TimeSeriesPlotView.Style)((Object)$receiver.getStyle().getValue()), MkColorKt.colorOf((int)112, (int)120, (int)135));
                this.configuration.setLineWidth((float)((Number)$receiver.getLineWidth().getValue()).doubleValue());
            }

            public final TimeSeriesPlotConfiguration getConfiguration() {
                return this.configuration;
            }

            public final void setConfiguration(TimeSeriesPlotConfiguration timeSeriesPlotConfiguration) {
                Intrinsics.checkNotNullParameter((Object)timeSeriesPlotConfiguration, (String)"<set-?>");
                this.configuration = timeSeriesPlotConfiguration;
            }

            public void draw(IGraphics g, Group group, double width, double height) {
                AxisModel axisModel;
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Intrinsics.checkNotNullParameter((Object)group, (String)"group");
                TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel = this.this$0.getModel();
                TimeSeries timeSeries = (TimeSeries)(timeSeriesPlotModel != null && (timeSeriesPlotModel = timeSeriesPlotModel.getMasterDataFrame()) != null ? timeSeriesPlotModel.getValueAt(group, String.valueOf((axisModel = this.this$0.getModel()) != null && (axisModel = axisModel.getY()) != null && (axisModel = (AxisModel)axisModel.getSelected()) != null ? axisModel.getColumn() : null)) : null);
                if (timeSeries != null) {
                    int y1 = 0;
                    int y2 = 0;
                    double worldY1 = 0.0;
                    double worldY2 = 0.0;
                    TwoDScreenTransform st = null;
                    switch (populateOverplots.timeSeriesVisibleDrawing.WhenMappings.$EnumSwitchMapping$0[((TimeSeriesPlotView.Layout)((Object)this.this$0.getLayout().getValue())).ordinal()]) {
                        case 1: {
                            y1 = 0;
                            y2 = this.this$0.getScreenTransform().getScreenHeight();
                            worldY1 = this.this$0.getScreenTransform().getY().getWorldInterval().getStart();
                            worldY2 = this.this$0.getScreenTransform().getY().getWorldInterval().getEnd();
                            break;
                        }
                        case 2: {
                            TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel2 = this.this$0.getModel();
                            Intrinsics.checkNotNull(timeSeriesPlotModel2);
                            SubsetDataFrame<Group, String, Object> subsetDataFrame = timeSeriesPlotModel2.getMasterDataFrame();
                            Intrinsics.checkNotNull(subsetDataFrame);
                            int i = subsetDataFrame.getRowAddress((Object)group);
                            TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel3 = this.this$0.getModel();
                            Intrinsics.checkNotNull(timeSeriesPlotModel3);
                            SubsetDataFrame<Group, String, Object> subsetDataFrame2 = timeSeriesPlotModel3.getMasterDataFrame();
                            Intrinsics.checkNotNull(subsetDataFrame2);
                            int count = subsetDataFrame2.getRowCount();
                            y1 = this.this$0.getScreenTransform().yWorldToScreen((double)(count - i));
                            y2 = this.this$0.getScreenTransform().yWorldToScreen((double)(count - i - 1));
                            TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel4 = this.this$0.getModel();
                            Intrinsics.checkNotNull(timeSeriesPlotModel4);
                            AxisModel<Row, Column> axisModel2 = timeSeriesPlotModel4.getYAxisModel();
                            Intrinsics.checkNotNull(axisModel2);
                            worldY1 = axisModel2.getMaximum();
                            TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel5 = this.this$0.getModel();
                            Intrinsics.checkNotNull(timeSeriesPlotModel5);
                            AxisModel<Row, Column> axisModel3 = timeSeriesPlotModel5.getYAxisModel();
                            Intrinsics.checkNotNull(axisModel3);
                            worldY2 = axisModel3.getMinimum();
                            break;
                        }
                        default: {
                            TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel6 = this.this$0.getModel();
                            Intrinsics.checkNotNull(timeSeriesPlotModel6);
                            SubsetDataFrame<Group, String, Object> subsetDataFrame = timeSeriesPlotModel6.getMasterDataFrame();
                            Intrinsics.checkNotNull(subsetDataFrame);
                            int i = subsetDataFrame.getRowAddress((Object)group);
                            TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel7 = this.this$0.getModel();
                            Intrinsics.checkNotNull(timeSeriesPlotModel7);
                            SubsetDataFrame<Group, String, Object> subsetDataFrame3 = timeSeriesPlotModel7.getMasterDataFrame();
                            Intrinsics.checkNotNull(subsetDataFrame3);
                            int count = subsetDataFrame3.getRowCount();
                            y1 = this.this$0.getScreenTransform().yWorldToScreen((double)(count - i));
                            y2 = this.this$0.getScreenTransform().yWorldToScreen((double)(count - i - 1));
                            TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel8 = this.this$0.getModel();
                            Intrinsics.checkNotNull(timeSeriesPlotModel8);
                            AxisModel<Row, Column> axisModel4 = timeSeriesPlotModel8.getYAxisModel();
                            Intrinsics.checkNotNull(axisModel4);
                            worldY1 = axisModel4.getMaximum();
                            TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel9 = this.this$0.getModel();
                            Intrinsics.checkNotNull(timeSeriesPlotModel9);
                            AxisModel<Row, Column> axisModel5 = timeSeriesPlotModel9.getYAxisModel();
                            Intrinsics.checkNotNull(axisModel5);
                            worldY2 = axisModel5.getMinimum();
                        }
                    }
                    int screenWidth = this.this$0.getScreenTransform().getScreenWidth();
                    int screenHeight = y2 - y1;
                    MutableOneDScreenTransform yTransform = (MutableOneDScreenTransform)new ComplexOneDScreenTransform((BoundedInterval)new SimpleBoundedInterval(worldY1, worldY2 - worldY1, 0.0, 0.0, 12, null), y1, y2, true, false);
                    yTransform.setScreenMargins(8);
                    st = (TwoDScreenTransform)new SimpleTwoDScreenTransform(this.this$0.getScreenTransform().getX(), yTransform, screenWidth, screenHeight, 1.0);
                    this.configuration.getRenderer().draw(timeSeries, st, g, (TimeSeries.TimeMode)this.this$0.getMode().getValue(), this.configuration, false, false);
                }
            }
        };
        this.canvas.addDensityLayer((Rendering)this.getRendering().getValue(), (IDrawing)timeSeriesVisibleDrawing2, (Pressure)new LinearPressure(), new PaletteProvider(this){
            final /* synthetic */ AbstractTimeSeriesPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
            }

            public FixedPalette getPalette() {
                return ((ColorTheme)this.this$0.getColorTheme().getValue()).getVisiblePalette();
            }
        });
        TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel14 = this.getModel();
        Intrinsics.checkNotNull(timeSeriesPlotModel14);
        Visual<Group, String> visual11 = timeSeriesPlotModel14.getMasterVisual();
        Intrinsics.checkNotNull(visual11);
        visualLayer14 = visual11.getSelected();
        TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel15 = this.getModel();
        Intrinsics.checkNotNull(timeSeriesPlotModel15);
        SubsetDataFrame<Group, String, Object> subsetDataFrame = timeSeriesPlotModel15.getMasterDataFrame();
        Intrinsics.checkNotNull(subsetDataFrame);
        SubsetDataFrame<Group, String, Object> subsetDataFrame2 = subsetDataFrame;
        AbstractMasterVisualLayerIDrawing timeSeriesSelectedDrawing2 = new AbstractMasterVisualLayerIDrawing(this, (VisualLayer<Group>)visualLayer14, subsetDataFrame2){
            private TimeSeriesPlotConfiguration configuration;
            final /* synthetic */ AbstractTimeSeriesPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, (DataFrame<Group, String, Object>)((DataFrame)$super_call_param$2));
                this.configuration = AbstractTimeSeriesPlotView.access$getTimeSeriesPlotConfiguration($receiver, (TimeSeriesPlotView.Style)((Object)$receiver.getStyle().getValue()), ((ColorTheme)$receiver.getColorTheme().getValue()).getSelection());
                this.configuration.setLineWidth((float)((Number)$receiver.getLineWidth().getValue()).doubleValue() * 2.0f);
            }

            public final TimeSeriesPlotConfiguration getConfiguration() {
                return this.configuration;
            }

            public final void setConfiguration(TimeSeriesPlotConfiguration timeSeriesPlotConfiguration) {
                Intrinsics.checkNotNullParameter((Object)timeSeriesPlotConfiguration, (String)"<set-?>");
                this.configuration = timeSeriesPlotConfiguration;
            }

            public void draw(IGraphics g, Group group, double width, double height) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Intrinsics.checkNotNullParameter((Object)group, (String)"group");
                TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel = this.this$0.getModel();
                Intrinsics.checkNotNull(timeSeriesPlotModel);
                SubsetDataFrame<Group, String, Object> subsetDataFrame = timeSeriesPlotModel.getMasterDataFrame();
                Intrinsics.checkNotNull(subsetDataFrame);
                TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel2 = this.this$0.getModel();
                Intrinsics.checkNotNull(timeSeriesPlotModel2);
                Object object = timeSeriesPlotModel2.getY().getSelected();
                Intrinsics.checkNotNull((Object)object);
                TimeSeries timeSeries = (TimeSeries)subsetDataFrame.getValueAt((Object)group, (Object)String.valueOf(((AxisModel)object).getColumn()));
                if (timeSeries != null) {
                    g.setLineWidth(((Number)this.this$0.getLineWidth().getValue()).doubleValue());
                    this.configuration.getRenderer().draw(timeSeries, (TwoDScreenTransform)this.this$0.getScreenTransform(), g, (TimeSeries.TimeMode)this.this$0.getMode().getValue(), this.configuration, false, true);
                }
            }
        };
        this.canvas.addLayer((IDrawing)timeSeriesSelectedDrawing2);
        this.canvas.addLayer(timeSeriesProbedDrawing2);
        visualLayer14 = this.getRubberBand();
        this.canvas.addLayer((IDrawing)new RubberbandDrawing(this, (RubberBand)visualLayer14){
            final /* synthetic */ AbstractTimeSeriesPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            protected Property<ColorTheme> getColorTheme() {
                return (Property)this.this$0.getColorTheme();
            }
        });
    }

    private final TimeSeriesPlotConfiguration getTimeSeriesPlotConfiguration(TimeSeriesPlotView.Style style, Color color) {
        TimeSeriesPlotConfiguration configuration = null;
        switch (WhenMappings.$EnumSwitchMapping$0[style.ordinal()]) {
            case 1: {
                TimeSeriesPlotRenderer renderer = new GeneralPathTimeSeriesRenderer();
                configuration = new TimeSeriesPlotConfiguration(renderer, color, TimeSeriesPlotConfiguration.LineType.Step, TimeSeriesPlotConfiguration.MarkerType.Point, false);
                break;
            }
            case 2: {
                TimeSeriesPlotRenderer renderer = new GeneralPathTimeSeriesRenderer();
                configuration = new TimeSeriesPlotConfiguration(renderer, color, TimeSeriesPlotConfiguration.LineType.Straight, TimeSeriesPlotConfiguration.MarkerType.Point, false);
                break;
            }
            case 3: {
                TimeSeriesPlotRenderer renderer = new CardinalSplineTimeSeriesRenderer();
                configuration = new TimeSeriesPlotConfiguration(renderer, color, TimeSeriesPlotConfiguration.LineType.Straight, TimeSeriesPlotConfiguration.MarkerType.Point, false);
                break;
            }
            default: {
                TimeSeriesPlotRenderer renderer = new HeatmapTimeSeriesRenderer(this.paletteFactory);
                configuration = new TimeSeriesPlotConfiguration(renderer, color, TimeSeriesPlotConfiguration.LineType.Straight, TimeSeriesPlotConfiguration.MarkerType.Point, false);
            }
        }
        return configuration;
    }

    public final void resetXAxis() {
        TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel = this.getModel();
        if ((timeSeriesPlotModel != null ? timeSeriesPlotModel.getTimeAxisModel() : null) != null) {
            switch (WhenMappings.$EnumSwitchMapping$1[((TimeSeries.TimeMode)this.getMode().getValue()).ordinal()]) {
                case 1: {
                    TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel2 = this.getModel();
                    Intrinsics.checkNotNull(timeSeriesPlotModel2);
                    AxisModel<Row, Column> axisModel = timeSeriesPlotModel2.getTimeAxisModel();
                    Intrinsics.checkNotNull(axisModel);
                    double min = axisModel.getMinimum();
                    TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel3 = this.getModel();
                    Intrinsics.checkNotNull(timeSeriesPlotModel3);
                    AxisModel<Row, Column> axisModel2 = timeSeriesPlotModel3.getTimeAxisModel();
                    Intrinsics.checkNotNull(axisModel2);
                    double max = axisModel2.getMaximum();
                    this.getXRangeModel().setMinMax(min, max);
                    this.getXRangeModel().setValue(min, max - min);
                    break;
                }
                case 2: {
                    double min = 0.0;
                    TimeSeriesPlotModel<Row, Object> timeSeriesPlotModel4 = this.getModel();
                    Intrinsics.checkNotNull(timeSeriesPlotModel4);
                    TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel5 = this.getModel();
                    Intrinsics.checkNotNull(timeSeriesPlotModel5);
                    Object object = timeSeriesPlotModel5.getY().getSelected();
                    Intrinsics.checkNotNull((Object)object);
                    double max = timeSeriesPlotModel4.getMaxDuration(((AxisModel)object).getColumn());
                    this.getXRangeModel().setMinMax(min, max);
                    this.getXRangeModel().setValue(min, max - min);
                    break;
                }
                case 3: {
                    double min = 0.0;
                    TimeSeriesPlotModel<Row, Object> timeSeriesPlotModel6 = this.getModel();
                    Intrinsics.checkNotNull(timeSeriesPlotModel6);
                    TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel7 = this.getModel();
                    Intrinsics.checkNotNull(timeSeriesPlotModel7);
                    Object object = timeSeriesPlotModel7.getY().getSelected();
                    Intrinsics.checkNotNull((Object)object);
                    double max = timeSeriesPlotModel6.getMaxEvents(((AxisModel)object).getColumn());
                    this.getXRangeModel().setMinMax(min, max);
                    this.getXRangeModel().setValue(min, max - min);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    public final void resetYAxis() {
        TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel = this.getModel();
        if ((timeSeriesPlotModel != null ? timeSeriesPlotModel.getYAxisModel() : null) != null) {
            switch (WhenMappings.$EnumSwitchMapping$2[((TimeSeriesPlotView.Layout)((Object)this.getLayout().getValue())).ordinal()]) {
                case 1: {
                    TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel2 = this.getModel();
                    Intrinsics.checkNotNull(timeSeriesPlotModel2);
                    AxisModel<Row, Column> axisModel = timeSeriesPlotModel2.getYAxisModel();
                    Intrinsics.checkNotNull(axisModel);
                    double min = axisModel.getMinimum();
                    TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel3 = this.getModel();
                    Intrinsics.checkNotNull(timeSeriesPlotModel3);
                    AxisModel<Row, Column> axisModel2 = timeSeriesPlotModel3.getYAxisModel();
                    Intrinsics.checkNotNull(axisModel2);
                    double max = axisModel2.getMaximum();
                    this.getYRangeModel().setMinMax(min, max);
                    this.getYRangeModel().setValue(min, max - min);
                    break;
                }
                case 2: {
                    double min = 0.0;
                    TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel4 = this.getModel();
                    Intrinsics.checkNotNull(timeSeriesPlotModel4);
                    SubsetDataFrame<Group, String, Object> subsetDataFrame = timeSeriesPlotModel4.getMasterDataFrame();
                    Intrinsics.checkNotNull(subsetDataFrame);
                    double max = subsetDataFrame.getRowCount();
                    this.getYRangeModel().setMinMax(min, max);
                    this.getYRangeModel().setValue(min, max - min);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    @Override
    public void zoom(boolean animate, double x1, double x2, double y1, double y2) {
        this.getXRangeModel().setValue(x1, x2 - x1);
        this.getYRangeModel().setValue(y1, y2 - y1);
    }

    protected final void updateIntervals() {
        TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel = this.getModel();
        MutableSingleSelection<AxisModel<Row, Column>> x = timeSeriesPlotModel != null ? timeSeriesPlotModel.getTime() : null;
        TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel2 = this.getModel();
        MutableSingleSelection<AxisModel<Row, Column>> y = timeSeriesPlotModel2 != null ? timeSeriesPlotModel2.getY() : null;
        this.resetXAxis();
        this.resetYAxis();
        if (this.rangesScreenTransformCoordinator != null) {
            RangesScreenTransformCoordinator rangesScreenTransformCoordinator = this.rangesScreenTransformCoordinator;
            Intrinsics.checkNotNull((Object)rangesScreenTransformCoordinator);
            rangesScreenTransformCoordinator.setRanges(this.getXRangeModel(), this.getYRangeModel());
        }
        this.scheduleUpdate();
    }

    protected abstract void updateAxisType();

    @Override
    @Nullable
    public Group getClosestGroup(int x, int y) {
        double bestdistance = Double.MAX_VALUE;
        Group bestrow = null;
        if (this.getModel() != null) {
            TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel = this.getModel();
            Intrinsics.checkNotNull(timeSeriesPlotModel);
            SubsetDataFrame<Group, String, Object> subsetDataFrame = timeSeriesPlotModel.getMasterDataFrame();
            Intrinsics.checkNotNull(subsetDataFrame);
            int n = subsetDataFrame.getRowCount();
            for (int row = 0; row < n; ++row) {
                TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel2 = this.getModel();
                Intrinsics.checkNotNull(timeSeriesPlotModel2);
                SubsetDataFrame<Group, String, Object> subsetDataFrame2 = timeSeriesPlotModel2.getMasterDataFrame();
                Intrinsics.checkNotNull(subsetDataFrame2);
                Group rowObject = (Group)subsetDataFrame2.getRowKey(row);
                TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel3 = this.getModel();
                Intrinsics.checkNotNull(timeSeriesPlotModel3);
                Visual<Group, String> visual = timeSeriesPlotModel3.getMasterVisual();
                Intrinsics.checkNotNull(visual);
                Filter filter = (Filter)visual.getFilter();
                if (filter.isFiltered((Object)rowObject)) continue;
                TimeSeriesPlotConfiguration configuration = this.getTimeSeriesPlotConfiguration((TimeSeriesPlotView.Style)((Object)this.getStyle().getValue()), ((ColorTheme)this.getColorTheme().getValue()).getSelection());
                TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel4 = this.getModel();
                Intrinsics.checkNotNull(timeSeriesPlotModel4);
                SubsetDataFrame<Group, String, Object> subsetDataFrame3 = timeSeriesPlotModel4.getMasterDataFrame();
                Intrinsics.checkNotNull(subsetDataFrame3);
                Group group = rowObject;
                Intrinsics.checkNotNull((Object)group);
                TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel5 = this.getModel();
                Intrinsics.checkNotNull(timeSeriesPlotModel5);
                Object object = timeSeriesPlotModel5.getY().getSelected();
                Intrinsics.checkNotNull((Object)object);
                TimeSeries timeSeries = (TimeSeries)subsetDataFrame3.getValueAt((Object)group, (Object)String.valueOf(((AxisModel)object).getColumn()));
                Pair<Shape, Shape> pair = configuration.getRenderer().getShape(timeSeries, (TwoDScreenTransform)this.getScreenTransform(), (TimeSeries.TimeMode)this.getMode().getValue(), configuration);
                Shape marker = (Shape)pair.component1();
                Shape line = (Shape)pair.component2();
                if (line == null) continue;
                PathIterator pi = Shape.getPathIterator$default((Shape)line, null, (int)1, null);
                float[] data = new float[6];
                int previousX = 0;
                int previousY = 0;
                double lastdistance = Double.MAX_VALUE;
                boolean willNotImprove = false;
                while (!pi.isDone()) {
                    int segType = pi.currentSegment(data);
                    switch (segType) {
                        case 0: {
                            previousX = (int)data[0];
                            previousY = (int)data[1];
                            double distance = this.distance(previousX, previousY, x, y);
                            if (distance < bestdistance) {
                                bestdistance = distance;
                                bestrow = rowObject;
                            }
                            if (distance > lastdistance) {
                                // empty if block
                            }
                            lastdistance = distance;
                            break;
                        }
                        case 1: {
                            int currentX = (int)data[0];
                            int currentY = (int)data[1];
                            double distance = Line2D.Companion.ptSegDist((double)previousX, (double)previousY, (double)currentX, (double)currentY, (double)x, (double)y);
                            if (distance < bestdistance) {
                                bestdistance = distance;
                                bestrow = rowObject;
                            }
                            if (distance > lastdistance) {
                                // empty if block
                            }
                            lastdistance = distance;
                            previousX = currentX;
                            previousY = currentY;
                            break;
                        }
                        default: {
                            throw new Error("Segmented type unsupported");
                        }
                    }
                    pi.next();
                }
            }
        }
        return bestrow;
    }

    @Override
    @Nullable
    public Row getClosestRow(int x, int y) {
        double bestdistance = Double.MAX_VALUE;
        Row bestrow = null;
        TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel = this.getModel();
        Intrinsics.checkNotNull(timeSeriesPlotModel);
        Visual<Row, Column> visual = timeSeriesPlotModel.getVisual();
        Intrinsics.checkNotNull(visual);
        VisualLayer visible = visual.getActive();
        for (Object row : visible) {
            double distance;
            Point2D p = (Point2D)this.getPoint(0, row);
            if (p == null || !((distance = Point2D.Companion.distance(p.getX(), p.getY(), (double)x, (double)y)) < bestdistance)) continue;
            bestdistance = distance;
            bestrow = (Row)row;
        }
        return bestrow;
    }

    @Override
    @NotNull
    public List<Row> getRows(@NotNull Rectangle2D rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel = this.getModel();
        Intrinsics.checkNotNull(timeSeriesPlotModel);
        Visual<Row, Column> visual = timeSeriesPlotModel.getVisual();
        Intrinsics.checkNotNull(visual);
        VisualLayer visible = visual.getActive();
        List list = new ArrayList();
        for (Object row : visible) {
            Point2D p = (Point2D)this.getPoint(0, row);
            if (p == null || !rect.contains(p)) continue;
            list.add(row);
        }
        return list;
    }

    @Override
    @NotNull
    public MutableProperty<Boolean> getShowFiltered() {
        MutableProperty mutableProperty = this.getProperties().getProperty((Object)TimeSeriesPlotView.PropertyType.ShowFiltered);
        Intrinsics.checkNotNull((Object)mutableProperty, (String)"null cannot be cast to non-null type com.macrofocus.common.properties.MutableProperty<kotlin.Boolean>");
        return mutableProperty;
    }

    @Override
    public void setShowFiltered(@NotNull MutableProperty<Boolean> showFiltered) {
        Intrinsics.checkNotNullParameter(showFiltered, (String)"showFiltered");
        this.getProperties().replaceProperty((Object)TimeSeriesPlotView.PropertyType.ShowFiltered, showFiltered);
    }

    @Override
    @NotNull
    public MutableProperty<Boolean> getShowGrid() {
        MutableProperty mutableProperty = this.getProperties().getProperty((Object)TimeSeriesPlotView.PropertyType.ShowGrid);
        Intrinsics.checkNotNull((Object)mutableProperty, (String)"null cannot be cast to non-null type com.macrofocus.common.properties.MutableProperty<kotlin.Boolean>");
        return mutableProperty;
    }

    @Override
    @NotNull
    public MutableProperty<Boolean> getAntialiasing() {
        MutableProperty mutableProperty = this.getProperties().getProperty((Object)TimeSeriesPlotView.PropertyType.Antialiasing);
        Intrinsics.checkNotNull((Object)mutableProperty, (String)"null cannot be cast to non-null type com.macrofocus.common.properties.MutableProperty<kotlin.Boolean>");
        return mutableProperty;
    }

    @Override
    public void setAntialiasing(@NotNull MutableProperty<Boolean> antialiasing) {
        Intrinsics.checkNotNullParameter(antialiasing, (String)"antialiasing");
        this.getProperties().replaceProperty((Object)TimeSeriesPlotView.PropertyType.Antialiasing, antialiasing);
    }

    @Override
    @NotNull
    public MutableProperty<Rendering> getRendering() {
        MutableProperty mutableProperty = this.getProperties().getProperty((Object)TimeSeriesPlotView.PropertyType.Rendering);
        Intrinsics.checkNotNull((Object)mutableProperty, (String)"null cannot be cast to non-null type com.macrofocus.common.properties.MutableProperty<org.mkui.canvas.Rendering>");
        return mutableProperty;
    }

    @Override
    public void setRendering(@NotNull MutableProperty<Rendering> rendering) {
        Intrinsics.checkNotNullParameter(rendering, (String)"rendering");
        this.getProperties().replaceProperty((Object)TimeSeriesPlotView.PropertyType.Rendering, rendering);
    }

    @Override
    @NotNull
    public MutableProperty<Double> getLineWidth() {
        MutableProperty mutableProperty = this.getProperties().getProperty((Object)TimeSeriesPlotView.PropertyType.LineWidth);
        Intrinsics.checkNotNull((Object)mutableProperty, (String)"null cannot be cast to non-null type com.macrofocus.common.properties.MutableProperty<kotlin.Double>");
        return mutableProperty;
    }

    @Override
    @NotNull
    public MutableProperty<Float> getGridThickness() {
        MutableProperty mutableProperty = this.getProperties().getProperty((Object)TimeSeriesPlotView.PropertyType.GridThickness);
        Intrinsics.checkNotNull((Object)mutableProperty, (String)"null cannot be cast to non-null type com.macrofocus.common.properties.MutableProperty<kotlin.Float>");
        return mutableProperty;
    }

    @Override
    @NotNull
    public MutableProperty<Object> getShowColor() {
        return this.getProperties().getProperty((Object)TimeSeriesPlotView.PropertyType.ShowColor);
    }

    @Override
    @NotNull
    public MutableProperty<Boolean> getRegression() {
        MutableProperty mutableProperty = this.getProperties().getProperty((Object)TimeSeriesPlotView.PropertyType.Regression);
        Intrinsics.checkNotNull((Object)mutableProperty, (String)"null cannot be cast to non-null type com.macrofocus.common.properties.MutableProperty<kotlin.Boolean>");
        return mutableProperty;
    }

    @Override
    @NotNull
    public MutableProperty<Double> getMarkerSize() {
        MutableProperty mutableProperty = this.getProperties().getProperty((Object)TimeSeriesPlotView.PropertyType.MarkerSize);
        Intrinsics.checkNotNull((Object)mutableProperty, (String)"null cannot be cast to non-null type com.macrofocus.common.properties.MutableProperty<kotlin.Double>");
        return mutableProperty;
    }

    @Override
    @NotNull
    public MutableProperty<ColorTheme> getColorTheme() {
        MutableProperty mutableProperty = this.getProperties().getProperty((Object)TimeSeriesPlotView.PropertyType.ColorTheme);
        Intrinsics.checkNotNull((Object)mutableProperty, (String)"null cannot be cast to non-null type com.macrofocus.common.properties.MutableProperty<org.mkui.graphics.colortheme.ColorTheme>");
        return mutableProperty;
    }

    @Override
    public void setColorTheme(@NotNull MutableProperty<ColorTheme> colorTheme) {
        Intrinsics.checkNotNullParameter(colorTheme, (String)"colorTheme");
        this.getProperties().replaceProperty((Object)TimeSeriesPlotView.PropertyType.ColorTheme, colorTheme);
    }

    @Override
    @NotNull
    public MutableProperty<Boolean> getDisplayLabels() {
        MutableProperty mutableProperty = this.getProperties().getProperty((Object)TimeSeriesPlotView.PropertyType.DisplayLabels);
        Intrinsics.checkNotNull((Object)mutableProperty, (String)"null cannot be cast to non-null type com.macrofocus.common.properties.MutableProperty<kotlin.Boolean>");
        return mutableProperty;
    }

    @Override
    @NotNull
    public MutableProperty<TimeSeries.TimeMode> getMode() {
        MutableProperty mutableProperty = this.getProperties().getProperty((Object)TimeSeriesPlotView.PropertyType.Mode);
        Intrinsics.checkNotNull((Object)mutableProperty, (String)"null cannot be cast to non-null type com.macrofocus.common.properties.MutableProperty<org.molap.series.TimeSeries.TimeMode>");
        return mutableProperty;
    }

    @Override
    @NotNull
    public MutableProperty<TimeSeriesPlotView.Layout> getLayout() {
        MutableProperty mutableProperty = this.getProperties().getProperty((Object)TimeSeriesPlotView.PropertyType.Layout);
        Intrinsics.checkNotNull((Object)mutableProperty, (String)"null cannot be cast to non-null type com.macrofocus.common.properties.MutableProperty<com.macrofocus.trenddisplay.timeseriesplot.TimeSeriesPlotView.Layout>");
        return mutableProperty;
    }

    @Override
    @NotNull
    public MutableProperty<TimeSeriesPlotView.Style> getStyle() {
        MutableProperty mutableProperty = this.getProperties().getProperty((Object)TimeSeriesPlotView.PropertyType.Style);
        Intrinsics.checkNotNull((Object)mutableProperty, (String)"null cannot be cast to non-null type com.macrofocus.common.properties.MutableProperty<com.macrofocus.trenddisplay.timeseriesplot.TimeSeriesPlotView.Style>");
        return mutableProperty;
    }

    @Nullable
    public final GeneralPath getTimeSeries(int layer, @NotNull Group group, @NotNull TimeSeries.TimeMode mode, @NotNull TimeSeriesPlotConfiguration.LineType lineType) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)((Object)lineType), (String)"lineType");
        TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel = this.getModel();
        if ((timeSeriesPlotModel != null ? timeSeriesPlotModel.getTimeAxisModel() : null) != null) {
            TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel2 = this.getModel();
            if ((timeSeriesPlotModel2 != null ? timeSeriesPlotModel2.getYAxisModel() : null) != null) {
                TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel3 = this.getModel();
                Intrinsics.checkNotNull(timeSeriesPlotModel3);
                SubsetDataFrame<Group, String, Object> subsetDataFrame = timeSeriesPlotModel3.getMasterDataFrame();
                Intrinsics.checkNotNull(subsetDataFrame);
                TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel4 = this.getModel();
                Intrinsics.checkNotNull(timeSeriesPlotModel4);
                Object object = timeSeriesPlotModel4.getY().getSelected();
                Intrinsics.checkNotNull((Object)object);
                TimeSeries timeSeries = (TimeSeries)subsetDataFrame.getValueAt((Object)group, (Object)String.valueOf(((AxisModel)object).getColumn()));
                if (timeSeries != null) {
                    GeneralPath linePath = new GeneralPath();
                    RangePoint previous = null;
                    Iterable iterable = timeSeries.keys();
                    Intrinsics.checkNotNull((Object)iterable);
                    Iterator iterator = iterable.iterator();
                    while (iterator.hasNext()) {
                        int i = ((Number)iterator.next()).intValue();
                        int x = this.getScreenTransform().xWorldToScreen((double)timeSeries.getTime(mode, (Object)i));
                        Object yValue = timeSeries.get((Object)i);
                        if (yValue != null) {
                            int y = this.getScreenTransform().yWorldToScreen(((Number)yValue).doubleValue());
                            if (previous != null) {
                                if (x != previous.getX()) {
                                    if (previous.getYMin() != previous.getYMax() && lineType != TimeSeriesPlotConfiguration.LineType.None) {
                                        linePath.lineTo((double)previous.getX(), (double)previous.getYMin());
                                        linePath.lineTo((double)previous.getX(), (double)previous.getYMax());
                                        linePath.lineTo((double)previous.getX(), (double)previous.getY());
                                    }
                                    if (lineType != TimeSeriesPlotConfiguration.LineType.None) {
                                        if (lineType == TimeSeriesPlotConfiguration.LineType.Step) {
                                            linePath.lineTo((double)x, (double)previous.getY());
                                        }
                                        linePath.lineTo((double)x, (double)y);
                                    }
                                }
                                previous.setValue(x, y);
                                continue;
                            }
                            previous = new RangePoint();
                            previous.setValue(x, y);
                            linePath.moveTo((double)x, (double)y);
                            linePath.lineTo((double)x, (double)y);
                            continue;
                        }
                        previous = null;
                    }
                    return linePath;
                }
                return null;
            }
        }
        return null;
    }

    @Deprecated(message="Use getTimeSeries instead")
    @Nullable
    public final Point getPoint(int layer, Row row) {
        TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel = this.getModel();
        if ((timeSeriesPlotModel != null ? timeSeriesPlotModel.getTimeAxisModel() : null) != null) {
            TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel2 = this.getModel();
            if ((timeSeriesPlotModel2 != null ? timeSeriesPlotModel2.getYAxisModel() : null) != null) {
                TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel3 = this.getModel();
                Number v1 = timeSeriesPlotModel3 != null && (timeSeriesPlotModel3 = timeSeriesPlotModel3.getTimeAxisModel()) != null ? (Number)timeSeriesPlotModel3.getValue(layer, row) : (Number)null;
                TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel4 = this.getModel();
                Number v2 = timeSeriesPlotModel4 != null && (timeSeriesPlotModel4 = timeSeriesPlotModel4.getYAxisModel()) != null ? (Number)timeSeriesPlotModel4.getValue(layer, row) : (Number)null;
                return v1 != null && v2 != null ? new Point(this.getScreenTransform().getX().worldToScreen(v1.doubleValue()), this.getScreenTransform().getY().worldToScreen(v2.doubleValue())) : null;
            }
        }
        return null;
    }

    @Nullable
    public final Integer getXLine(int layer, Row row) {
        TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel = this.getModel();
        if ((timeSeriesPlotModel != null ? timeSeriesPlotModel.getTimeAxisModel() : null) != null) {
            TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel2 = this.getModel();
            Number v1 = timeSeriesPlotModel2 != null && (timeSeriesPlotModel2 = timeSeriesPlotModel2.getTimeAxisModel()) != null ? (Number)timeSeriesPlotModel2.getValue(layer, row) : (Number)null;
            return v1 != null ? Integer.valueOf(this.getScreenTransform().getX().worldToScreen(v1.doubleValue())) : null;
        }
        return null;
    }

    @Nullable
    public final Integer getYLine(int layer, Row row) {
        TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel = this.getModel();
        if ((timeSeriesPlotModel != null ? timeSeriesPlotModel.getYAxisModel() : null) != null) {
            TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel2 = this.getModel();
            Number v2 = timeSeriesPlotModel2 != null && (timeSeriesPlotModel2 = timeSeriesPlotModel2.getYAxisModel()) != null ? (Number)timeSeriesPlotModel2.getValue(layer, row) : (Number)null;
            return v2 != null ? Integer.valueOf(this.getScreenTransform().getY().worldToScreen(v2.doubleValue())) : null;
        }
        return null;
    }

    private final int getMarkerSize(int layer, Row row) {
        TimeSeriesPlotModel<Row, Column> timeSeriesPlotModel = this.getModel();
        Intrinsics.checkNotNull(timeSeriesPlotModel);
        AxisModel<Row, Column> sizeAxisModel = timeSeriesPlotModel.getSizeAxisModel();
        if (sizeAxisModel != null) {
            Number v1 = sizeAxisModel.getValue(layer, row);
            if (v1 != null) {
                double range = (double)2 * Math.sqrt((sizeAxisModel.getMaximum() - sizeAxisModel.getMinimum()) / (double)((float)Math.PI));
                double v = (double)2 * Math.sqrt((v1.doubleValue() - sizeAxisModel.getMinimum()) / (double)((float)Math.PI));
                Object object = this.getMarkerSize().getValue();
                Intrinsics.checkNotNull((Object)object);
                return (int)(v * ((double)((int)((Number)object).doubleValue()) - 1.0) / range) + 1;
            }
            return 0;
        }
        Object object = this.getMarkerSize().getValue();
        Intrinsics.checkNotNull((Object)object);
        return (int)((Number)object).doubleValue();
    }

    public final double distance(double x1, double y1, double x2, double y2) {
        double x12 = x1;
        double y12 = y1;
        return Math.sqrt((x12 -= x2) * x12 + (y12 -= y2) * y12);
    }

    public static final /* synthetic */ TimeSeriesPlotConfiguration access$getTimeSeriesPlotConfiguration(AbstractTimeSeriesPlotView $this, TimeSeriesPlotView.Style style, Color color) {
        return $this.getTimeSeriesPlotConfiguration(style, color);
    }

    public static final /* synthetic */ BoundedIntervalListener access$getIntervalListener$p(AbstractTimeSeriesPlotView $this) {
        return $this.intervalListener;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00a6\u0004\u0018\u00002\u00020\u0001B3\b\u0004\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u001a\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006\u00a2\u0006\u0004\b\t\u0010\nJ2\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0015H&R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\r\u00a8\u0006\u001c"}, d2={"Lcom/macrofocus/trenddisplay/timeseriesplot/AbstractTimeSeriesPlotView$AbstractMasterVisualLayerIDrawing;", "Lorg/mkui/graphics/AbstractIDrawing;", "visualLayer", "Lorg/mkui/visual/VisualLayer;", "Lorg/molap/aggregates/cube/Group;", "dataFrame", "Lorg/molap/dataframe/DataFrame;", "", "", "<init>", "(Lcom/macrofocus/trenddisplay/timeseriesplot/AbstractTimeSeriesPlotView;Lorg/mkui/visual/VisualLayer;Lorg/molap/dataframe/DataFrame;)V", "isActive", "", "()Z", "draw", "", "g", "Lorg/mkui/graphics/IGraphics;", "point", "Lorg/mkui/geom/Point2D;", "gw", "", "gh", "clipBounds", "Lorg/mkui/geom/Rectangle;", "row", "width", "height", "trenddisplay"})
    public abstract class AbstractMasterVisualLayerIDrawing
    extends AbstractIDrawing {
        @NotNull
        private final VisualLayer<Group> visualLayer;

        protected AbstractMasterVisualLayerIDrawing(@NotNull VisualLayer<Group> visualLayer, DataFrame<Group, String, Object> dataFrame) {
            Intrinsics.checkNotNullParameter(visualLayer, (String)"visualLayer");
            Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
            this.visualLayer = visualLayer;
            visualLayer.addVisualListener(new VisualListener(){

                public void visualChanged() {
                    this.notifyIDrawingChanged();
                }
            });
            dataFrame.addDataFrameListener((DataFrameListener)new DataFrameListener<Group, String>(){

                public void dataFrameChanged(DataFrameEvent<Group, String> event) {
                    Intrinsics.checkNotNullParameter(event, (String)"event");
                    System.out.println(event);
                    this.notifyIDrawingChanged();
                }
            });
        }

        public boolean isActive() {
            return this.visualLayer.isActive();
        }

        public void draw(@NotNull IGraphics g, @Nullable Point2D point, double gw, double gh, @NotNull Rectangle clipBounds) {
            block7: {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Intrinsics.checkNotNullParameter((Object)clipBounds, (String)"clipBounds");
                if (this.visualLayer.getObjectCount() <= 0) break block7;
                if (!g.isThreadSafe()) {
                    for (Group row : this.visualLayer) {
                        this.draw(g, row, gw, gh);
                    }
                } else {
                    ExecutorService executorService = executor;
                    Intrinsics.checkNotNull((Object)executorService);
                    int nTasks = Math.min(executorService.getAvailableProcessors(), this.visualLayer.getObjectCount());
                    int nRowsPerTask = this.visualLayer.getObjectCount() / nTasks;
                    List todo = new ArrayList(nTasks);
                    for (int nTask = 0; nTask < nTasks; ++nTask) {
                        int fromRow = nTask * nRowsPerTask;
                        int toRow = nTask < nTasks - 1 ? fromRow + nRowsPerTask : this.visualLayer.getObjectCount();
                        todo.add(new Callable<Object>(fromRow, toRow, this, g, gw, gh){
                            private final int from;
                            private final int to;
                            final /* synthetic */ AbstractMasterVisualLayerIDrawing this$0;
                            final /* synthetic */ IGraphics $g;
                            final /* synthetic */ double $gw;
                            final /* synthetic */ double $gh;
                            {
                                this.this$0 = $receiver;
                                this.$g = $g;
                                this.$gw = $gw;
                                this.$gh = $gh;
                                this.from = $fromRow;
                                this.to = $toRow;
                            }

                            public Object call() {
                                for (Group row : AbstractMasterVisualLayerIDrawing.access$getVisualLayer$p(this.this$0).iterable(this.from, this.to - 1)) {
                                    this.this$0.draw(this.$g, row, this.$gw, this.$gh);
                                }
                                return null;
                            }
                        });
                    }
                    try {
                        ExecutorService executorService2 = executor;
                        Intrinsics.checkNotNull((Object)executorService2);
                        List answers = executorService2.invokeAll((Collection)todo);
                        for (Future answer : answers) {
                            answer.get();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public abstract void draw(@NotNull IGraphics var1, @NotNull Group var2, double var3, double var5);

        public static final /* synthetic */ VisualLayer access$getVisualLayer$p(AbstractMasterVisualLayerIDrawing $this) {
            return $this.visualLayer;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00a6\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0004\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J2\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J-\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0010H&\u00a2\u0006\u0002\u0010\u0017R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/macrofocus/trenddisplay/timeseriesplot/AbstractTimeSeriesPlotView$AbstractVisualLayerIDrawing;", "Lorg/mkui/graphics/AbstractIDrawing;", "visualLayer", "Lorg/mkui/visual/VisualLayer;", "<init>", "(Lcom/macrofocus/trenddisplay/timeseriesplot/AbstractTimeSeriesPlotView;Lorg/mkui/visual/VisualLayer;)V", "isActive", "", "()Z", "draw", "", "g", "Lorg/mkui/graphics/IGraphics;", "point", "Lorg/mkui/geom/Point2D;", "gw", "", "gh", "clipBounds", "Lorg/mkui/geom/Rectangle;", "row", "width", "height", "(Lorg/mkui/graphics/IGraphics;Ljava/lang/Object;DD)V", "trenddisplay"})
    public abstract class AbstractVisualLayerIDrawing
    extends AbstractIDrawing {
        @NotNull
        private final VisualLayer<Row> visualLayer;

        protected AbstractVisualLayerIDrawing(VisualLayer<Row> visualLayer) {
            Intrinsics.checkNotNullParameter(visualLayer, (String)"visualLayer");
            this.visualLayer = visualLayer;
            visualLayer.addVisualListener(new VisualListener(){

                public void visualChanged() {
                    this.notifyIDrawingChanged();
                }
            });
        }

        public boolean isActive() {
            return this.visualLayer.isActive();
        }

        public void draw(@NotNull IGraphics g, @Nullable Point2D point, double gw, double gh, @NotNull Rectangle clipBounds) {
            block7: {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Intrinsics.checkNotNullParameter((Object)clipBounds, (String)"clipBounds");
                if (this.visualLayer.getObjectCount() <= 0) break block7;
                if (!g.isThreadSafe()) {
                    for (Object row : this.visualLayer) {
                        this.draw(g, row, gw, gh);
                    }
                } else {
                    ExecutorService executorService = executor;
                    Intrinsics.checkNotNull((Object)executorService);
                    int nTasks = Math.min(executorService.getAvailableProcessors(), this.visualLayer.getObjectCount());
                    int nRowsPerTask = this.visualLayer.getObjectCount() / nTasks;
                    List todo = new ArrayList(nTasks);
                    for (int nTask = 0; nTask < nTasks; ++nTask) {
                        int fromRow = nTask * nRowsPerTask;
                        int toRow = nTask < nTasks - 1 ? fromRow + nRowsPerTask : this.visualLayer.getObjectCount();
                        todo.add(new Callable<Object>(fromRow, toRow, this, g, gw, gh){
                            private final int from;
                            private final int to;
                            final /* synthetic */ AbstractVisualLayerIDrawing this$0;
                            final /* synthetic */ IGraphics $g;
                            final /* synthetic */ double $gw;
                            final /* synthetic */ double $gh;
                            {
                                this.this$0 = $receiver;
                                this.$g = $g;
                                this.$gw = $gw;
                                this.$gh = $gh;
                                this.from = $fromRow;
                                this.to = $toRow;
                            }

                            public Object call() {
                                for (T row : AbstractVisualLayerIDrawing.access$getVisualLayer$p(this.this$0).iterable(this.from, this.to - 1)) {
                                    this.this$0.draw(this.$g, row, this.$gw, this.$gh);
                                }
                                return null;
                            }
                        });
                    }
                    try {
                        ExecutorService executorService2 = executor;
                        Intrinsics.checkNotNull((Object)executorService2);
                        List answers = executorService2.invokeAll((Collection)todo);
                        for (Future answer : answers) {
                            answer.get();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public abstract void draw(@NotNull IGraphics var1, Row var2, double var3, double var5);

        public static final /* synthetic */ VisualLayer access$getVisualLayer$p(AbstractVisualLayerIDrawing $this) {
            return $this.visualLayer;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0004\b\b\u0010\tJ2\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/macrofocus/trenddisplay/timeseriesplot/AbstractTimeSeriesPlotView$AnnotationIDrawing;", "Lorg/mkui/graphics/AbstractIDrawing;", "selection", "Lcom/macrofocus/common/selection/Selection;", "", "color", "Ljava/awt/Color;", "Lorg/mkui/color/MkColor;", "<init>", "(Lcom/macrofocus/trenddisplay/timeseriesplot/AbstractTimeSeriesPlotView;Lcom/macrofocus/common/selection/Selection;Ljava/awt/Color;)V", "selectionListener", "Lcom/macrofocus/common/selection/SelectionListener;", "isActive", "", "()Z", "draw", "", "g", "Lorg/mkui/graphics/IGraphics;", "point", "Lorg/mkui/geom/Point2D;", "width", "", "height", "clipBounds", "Lorg/mkui/geom/Rectangle;", "trenddisplay"})
    private final class AnnotationIDrawing
    extends AbstractIDrawing {
        @NotNull
        private final Selection<Object> selection;
        @NotNull
        private final Color color;
        @NotNull
        private final SelectionListener<Object> selectionListener;

        public AnnotationIDrawing(@NotNull Selection<Object> selection, Color color) {
            Intrinsics.checkNotNullParameter(selection, (String)"selection");
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            this.selection = selection;
            this.color = color;
            this.selectionListener = (SelectionListener)new SelectionListener<Object>(this){
                final /* synthetic */ AnnotationIDrawing this$0;
                {
                    this.this$0 = $receiver;
                }

                public void selectionChanged(SelectionEvent<Object> event) {
                    Intrinsics.checkNotNullParameter(event, (String)"event");
                    AnnotationIDrawing.access$notifyIDrawingChanged(this.this$0);
                }
            };
            this.selection.addWeakSelectionListener(this.selectionListener);
        }

        public boolean isActive() {
            return true;
        }

        public void draw(@NotNull IGraphics g, @Nullable Point2D point, double width, double height, @NotNull Rectangle clipBounds) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)clipBounds, (String)"clipBounds");
            g.setColor(this.color);
            for (Object row : this.selection) {
                Point mp = AbstractTimeSeriesPlotView.this.getPoint(1, row);
                if (mp != null) {
                    g.drawLine(mp.getX(), 0.0, mp.getX(), height);
                    g.drawLine(0.0, mp.getY(), width, mp.getY());
                    TimeSeriesPlotModel timeSeriesPlotModel = AbstractTimeSeriesPlotView.this.getModel();
                    if ((timeSeriesPlotModel != null ? timeSeriesPlotModel.getSizeAxisModel() : null) != null) {
                        int size = AbstractTimeSeriesPlotView.this.getMarkerSize(1, row);
                        double radius = (double)size / 2.0;
                        g.fillCircle((Rectangle2D)new Rectangle((int)(mp.getX() - radius), (int)(mp.getY() - radius), size, size));
                        continue;
                    }
                    int size = AbstractTimeSeriesPlotView.this.getMarkerSize(1, row) + 2;
                    double radius = (double)size / 2.0;
                    g.fillCircle((Rectangle2D)new Rectangle((int)(mp.getX() - radius), (int)(mp.getY() - radius), size, size));
                    continue;
                }
                Integer y = AbstractTimeSeriesPlotView.this.getYLine(1, row);
                if (y != null) {
                    g.drawLine(0, y.intValue(), (int)width, y.intValue());
                    continue;
                }
                Integer x = AbstractTimeSeriesPlotView.this.getXLine(1, row);
                if (x == null) continue;
                g.drawLine(x.intValue(), 0, x.intValue(), (int)height);
            }
        }

        public static final /* synthetic */ void access$notifyIDrawingChanged(AnnotationIDrawing $this) {
            $this.notifyIDrawingChanged();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/macrofocus/trenddisplay/timeseriesplot/AbstractTimeSeriesPlotView$Companion;", "", "<init>", "()V", "MARGIN", "", "MULTITHREADED", "", "executor", "Lcom/macrofocus/common/concurrent/ExecutorService;", "trenddisplay"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/macrofocus/trenddisplay/timeseriesplot/AbstractTimeSeriesPlotView$RangePoint;", "", "<init>", "(Lcom/macrofocus/trenddisplay/timeseriesplot/AbstractTimeSeriesPlotView;)V", "x", "", "getX", "()I", "setX", "(I)V", "y", "getY", "setY", "yMin", "getYMin", "setYMin", "yMax", "getYMax", "setYMax", "setValue", "", "trenddisplay"})
    private final class RangePoint {
        private int x;
        private int y;
        private int yMin;
        private int yMax;

        public final int getX() {
            return this.x;
        }

        public final void setX(int n) {
            this.x = n;
        }

        public final int getY() {
            return this.y;
        }

        public final void setY(int n) {
            this.y = n;
        }

        public final int getYMin() {
            return this.yMin;
        }

        public final void setYMin(int n) {
            this.yMin = n;
        }

        public final int getYMax() {
            return this.yMax;
        }

        public final void setYMax(int n) {
            this.yMax = n;
        }

        public final void setValue(int x, int y) {
            if (this.x == x) {
                if (y < this.yMin) {
                    this.yMin = y;
                }
                if (y > this.yMax) {
                    this.yMax = y;
                }
                this.y = y;
            } else {
                this.x = x;
                this.y = y;
                this.yMin = y;
                this.yMax = y;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[TimeSeriesPlotView.Style.values().length];
            try {
                nArray[TimeSeriesPlotView.Style.Step.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimeSeriesPlotView.Style.Straight.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimeSeriesPlotView.Style.Curved.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TimeSeries.TimeMode.values().length];
            try {
                nArray[TimeSeries.TimeMode.Absolute.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimeSeries.TimeMode.Relative.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimeSeries.TimeMode.Sequential.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[TimeSeriesPlotView.Layout.values().length];
            try {
                nArray[TimeSeriesPlotView.Layout.Overlay.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimeSeriesPlotView.Layout.Stack.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

