/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.trenddisplay.timeseriesplot;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.trenddisplay.timeseriesplot.TimeSeriesPlotConfiguration;
import com.macrofocus.trenddisplay.timeseriesplot.TimeSeriesPlotRenderer;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.GeneralPath;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;
import org.mkui.geom.curve.CatmullRomSpline;
import org.mkui.geom.curve.ControlPath;
import org.mkui.geom.curve.Curve;
import org.mkui.geom.curve.GroupIterator;
import org.mkui.geom.curve.MultiPath;
import org.mkui.geom.curve.Point;
import org.mkui.geom.curve.ShapeMultiPath;
import org.mkui.graphics.IGraphics;
import org.mkui.transform.TwoDScreenTransform;
import org.molap.series.TimeSeries;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0002\u0017\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016JL\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/macrofocus/trenddisplay/timeseriesplot/CardinalSplineTimeSeriesRenderer;", "Lcom/macrofocus/trenddisplay/timeseriesplot/TimeSeriesPlotRenderer;", "<init>", "()V", "getShape", "Lkotlin/Pair;", "Lorg/mkui/geom/Shape;", "timeSeries", "Lorg/molap/series/TimeSeries;", "", "screenTransform", "Lorg/mkui/transform/TwoDScreenTransform;", "mode", "Lorg/molap/series/TimeSeries$TimeMode;", "configuration", "Lcom/macrofocus/trenddisplay/timeseriesplot/TimeSeriesPlotConfiguration;", "draw", "", "g2", "Lorg/mkui/graphics/IGraphics;", "probed", "", "selected", "RangePoint", "Companion", "trenddisplay"})
@StabilityInferred(parameters=1)
public final class CardinalSplineTimeSeriesRenderer
implements TimeSeriesPlotRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;

    @Override
    @NotNull
    public Pair<Shape, Shape> getShape(@Nullable TimeSeries<Integer, ?> timeSeries, @NotNull TwoDScreenTransform screenTransform, @NotNull TimeSeries.TimeMode mode, @NotNull TimeSeriesPlotConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)screenTransform, (String)"screenTransform");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        GeneralPath markerPath = new GeneralPath();
        ShapeMultiPath linePath = new ShapeMultiPath(2);
        boolean isNumerical = true;
        if (timeSeries != null) {
            ControlPath curves = new ControlPath();
            RangePoint previous = null;
            ControlPath cp = null;
            Iterable iterable = timeSeries.keys();
            Intrinsics.checkNotNull((Object)iterable);
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                int i = ((Number)iterator.next()).intValue();
                int x = screenTransform.xWorldToScreen((double)timeSeries.getTime(mode, (Object)i));
                Object yValue = timeSeries.get((Object)i);
                if (yValue != null) {
                    int y = screenTransform.yWorldToScreen(((Number)yValue).doubleValue());
                    if (cp != null) {
                        if (previous != null) {
                            cp.addPoint(CardinalSplineTimeSeriesRenderer.Companion.createPoint2(x, y));
                        } else {
                            System.out.println((Object)"Error");
                        }
                    } else {
                        cp = new ControlPath();
                        cp.addPoint(CardinalSplineTimeSeriesRenderer.Companion.createPoint2(x, y));
                        cp.addPoint(CardinalSplineTimeSeriesRenderer.Companion.createPoint2(x, y));
                    }
                    if (previous != null) {
                        previous.setValue(x, y);
                    } else {
                        previous = new RangePoint();
                        previous.setValue(x, y);
                    }
                    if (configuration.getMarkerType() == TimeSeriesPlotConfiguration.MarkerType.None) continue;
                    double size = configuration.getMarkerSize();
                    double halfSize = size / 2.0;
                    Shape shape = (Shape)new Rectangle2D.Double((double)x - halfSize, (double)y - halfSize, size, size);
                    markerPath.append(Shape.getPathIterator$default((Shape)shape, null, (int)1, null), false);
                    continue;
                }
                if (cp != null) {
                    double d = x;
                    RangePoint rangePoint = previous;
                    Intrinsics.checkNotNull((Object)rangePoint);
                    cp.addPoint(CardinalSplineTimeSeriesRenderer.Companion.createPoint2(d, rangePoint.getY()));
                    int[] nArray = new int[]{0, cp.numPoints() - 1};
                    CatmullRomSpline cardinalSpline = new CatmullRomSpline(cp, new GroupIterator(nArray));
                    curves.addCurve((Curve)cardinalSpline);
                }
                cp = null;
                previous = null;
            }
            if (cp != null) {
                RangePoint rangePoint = previous;
                Intrinsics.checkNotNull(rangePoint);
                cp.addPoint(CardinalSplineTimeSeriesRenderer.Companion.createPoint2(rangePoint.getX(), previous.getY()));
                int[] i = new int[]{0, cp.numPoints() - 1};
                CatmullRomSpline cardinalSpline = new CatmullRomSpline(cp, new GroupIterator(i));
                curves.addCurve((Curve)cardinalSpline);
            }
            int dimension = 2;
            ShapeMultiPath mp = new ShapeMultiPath(dimension);
            mp.setFlatness(1.0);
            int n = curves.numCurves();
            for (int i = 0; i < n; ++i) {
                Curve curve = curves.getCurve(i);
                curve.appendTo((MultiPath)mp);
            }
        }
        return new Pair((Object)markerPath, (Object)linePath);
    }

    @Override
    public void draw(@Nullable TimeSeries<Integer, ?> timeSeries, @NotNull TwoDScreenTransform screenTransform, @NotNull IGraphics g2, @NotNull TimeSeries.TimeMode mode, @NotNull TimeSeriesPlotConfiguration configuration, boolean probed, boolean selected) {
        Intrinsics.checkNotNullParameter((Object)screenTransform, (String)"screenTransform");
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Pair<Shape, Shape> pair = this.getShape(timeSeries, screenTransform, mode, configuration);
        Shape markerPath = (Shape)pair.component1();
        Shape linePath = (Shape)pair.component2();
        g2.setColor(configuration.getLineColor());
        g2.pickDraw(linePath, null, null, null);
        g2.setColor(configuration.getMarkerColor());
        g2.pickDraw(markerPath, null, null, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a8\u0006\n"}, d2={"Lcom/macrofocus/trenddisplay/timeseriesplot/CardinalSplineTimeSeriesRenderer$Companion;", "", "<init>", "()V", "createPoint", "Lorg/mkui/geom/curve/Point;", "x", "", "y", "createPoint2", "trenddisplay"})
    public static final class Companion {
        private Companion() {
        }

        private final Point createPoint(double x, double y) {
            double[] dArray = new double[]{x, y};
            double[] location = dArray;
            return new Point(location){
                final /* synthetic */ double[] $location;
                {
                    this.$location = $location;
                }

                public double[] getLocation() {
                    return this.$location;
                }
            };
        }

        private final Point createPoint2(double x, double y) {
            double[] dArray = new double[]{x, y};
            double[] location = dArray;
            return new Point(location){
                final /* synthetic */ double[] $location;
                {
                    this.$location = $location;
                }

                public double[] getLocation() {
                    return this.$location;
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/macrofocus/trenddisplay/timeseriesplot/CardinalSplineTimeSeriesRenderer$RangePoint;", "", "<init>", "(Lcom/macrofocus/trenddisplay/timeseriesplot/CardinalSplineTimeSeriesRenderer;)V", "x", "", "getX", "()I", "setX", "(I)V", "y", "getY", "setY", "yMin", "getYMin", "setYMin", "yMax", "getYMax", "setYMax", "setValue", "", "trenddisplay"})
    private final class RangePoint {
        private int x;
        private int y;
        private int yMin;
        private int yMax;

        public final int getX() {
            return this.x;
        }

        public final void setX(int n) {
            this.x = n;
        }

        public final int getY() {
            return this.y;
        }

        public final void setY(int n) {
            this.y = n;
        }

        public final int getYMin() {
            return this.yMin;
        }

        public final void setYMin(int n) {
            this.yMin = n;
        }

        public final int getYMax() {
            return this.yMax;
        }

        public final void setYMax(int n) {
            this.yMax = n;
        }

        public final void setValue(int x, int y) {
            if (this.x == x) {
                if (y < this.yMin) {
                    this.yMin = y;
                }
                if (y > this.yMax) {
                    this.yMax = y;
                }
                this.y = y;
            } else {
                this.x = x;
                this.y = y;
                this.yMin = y;
                this.yMax = y;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TimeSeriesPlotConfiguration.MarkerType.values().length];
            try {
                nArray[TimeSeriesPlotConfiguration.MarkerType.VerticalLine.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimeSeriesPlotConfiguration.MarkerType.Point.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimeSeriesPlotConfiguration.MarkerType.None.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

