/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.trenddisplay.timeseriesplot;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.dataframe.DataFrame;
import org.molap.series.AbstractTimeSeries;
import org.molap.series.TimeSeries;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0000\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005B1\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0007\u0012\u0006\u0010\b\u001a\u00028\u0001\u0012\u0006\u0010\t\u001a\u00028\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0015\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0015\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010 \u001a\u00028\u00022\u0006\u0010\u0014\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010!J\u0015\u0010\"\u001a\u00028\u00002\u0006\u0010#\u001a\u00020$H\u0016\u00a2\u0006\u0002\u0010%J\b\u0010&\u001a\u00020$H\u0016J\u0015\u0010'\u001a\u00020$2\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010(J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000*H\u0016R\u0010\u0010\b\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0010\u0010\t\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\r@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\r@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0018\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006+"}, d2={"Lcom/macrofocus/trenddisplay/timeseriesplot/DataFrameTimeSeries;", "R", "C", "V", "Lorg/molap/series/AbstractTimeSeries;", "Lorg/molap/series/TimeSeries;", "dataFrame", "Lorg/molap/dataframe/DataFrame;", "time", "value", "<init>", "(Lorg/molap/dataframe/DataFrame;Ljava/lang/Object;Ljava/lang/Object;)V", "Ljava/lang/Object;", "", "minTime", "getMinTime", "()J", "maxTime", "getMaxTime", "getAbsoluteTime", "key", "(Ljava/lang/Object;)J", "getRelativeTime", "getSequantialTime", "name", "", "getName", "()Ljava/lang/Object;", "type", "Lkotlin/reflect/KClass;", "getType", "()Lkotlin/reflect/KClass;", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "getKey", "i", "", "(I)Ljava/lang/Object;", "size", "getAddress", "(Ljava/lang/Object;)I", "keys", "", "trenddisplay"})
@StabilityInferred(parameters=0)
public final class DataFrameTimeSeries<R, C, V>
extends AbstractTimeSeries<R, V>
implements TimeSeries<R, V> {
    private final C time;
    private final C value;
    @NotNull
    private final DataFrame<R, C, V> dataFrame;
    private long minTime;
    private long maxTime;
    public static final int $stable = 8;

    public DataFrameTimeSeries(@NotNull DataFrame<R, C, V> dataFrame, C time, C value) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        this.time = time;
        this.value = value;
        this.dataFrame = dataFrame;
        for (Object row : dataFrame.rows()) {
            long t = this.getAbsoluteTime(row);
            if (t > this.getMaxTime()) {
                this.maxTime = t;
            }
            if (this.getMinTime() != 0L && t >= this.getMinTime()) continue;
            this.minTime = t;
        }
    }

    public long getMinTime() {
        return this.minTime;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public long getAbsoluteTime(R key) {
        long l;
        Object v = this.dataFrame.getValueAt(key, this.time);
        if (v instanceof Instant) {
            l = ((Instant)v).toEpochMilliseconds();
        } else if (v instanceof LocalDateTime) {
            l = TimeZoneKt.toInstant((LocalDateTime)((LocalDateTime)v), (TimeZone)TimeZone.Companion.currentSystemDefault()).toEpochMilliseconds();
        } else if (v instanceof LocalDate) {
            l = TimeZoneKt.atStartOfDayIn((LocalDate)((LocalDate)v), (TimeZone)((TimeZone)TimeZone.Companion.getUTC())).toEpochMilliseconds();
        } else {
            Intrinsics.checkNotNull((Object)v, (String)"null cannot be cast to non-null type kotlin.Number");
            l = ((Number)v).longValue();
        }
        return l;
    }

    public long getRelativeTime(R key) {
        return this.getAbsoluteTime(key) - this.getMinTime();
    }

    public long getSequantialTime(R key) {
        return this.dataFrame.getRowIndex().getAddress(key);
    }

    @Nullable
    public Object getName() {
        return this.value;
    }

    @NotNull
    public KClass<?> getType() {
        return this.dataFrame.getColumnClass(this.value);
    }

    public V get(R key) {
        return (V)this.dataFrame.getValueAt(key, this.value);
    }

    public R getKey(int i) {
        return (R)this.dataFrame.getRowIndex().getKey(i);
    }

    public int size() {
        return this.dataFrame.getRowIndex().getSize();
    }

    public int getAddress(R key) {
        return this.dataFrame.getRowIndex().getAddress(key);
    }

    @NotNull
    public Iterable<R> keys() {
        return this.dataFrame.getRowIndex().keys();
    }
}

