/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.visflux.chord;

import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.visflux.chord.AbstractChordModel;
import com.macrofocus.visflux.chord.Arc;
import com.macrofocus.visflux.chord.ChordModel;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.legacy.Math;
import org.mkui.visual.Visual;
import org.molap.network.NetworkListener;
import org.molap.network.WeightedNetwork;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001c\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0011\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004BK\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0002\u0018\u00010\t\u0012\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020$H\u0002J\u0017\u0010&\u001a\u0004\u0018\u00010\u00142\u0006\u0010'\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010(J\u001f\u0010&\u001a\u0004\u0018\u00010\u00142\u0006\u0010)\u001a\u00028\u00002\u0006\u0010*\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010+J\u0015\u0010,\u001a\u00028\u00002\u0006\u0010-\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010.J\u0015\u0010/\u001a\u00020\r2\u0006\u0010-\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u00100J\u001b\u00101\u001a\b\u0012\u0004\u0012\u00028\u00010\u001d2\u0006\u0010'\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00102J\u0015\u00103\u001a\u00020\r2\u0006\u0010'\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00100J\u0015\u00104\u001a\u00028\u00002\u0006\u0010-\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010.R\u001a\u0010\f\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R(\u0010\u0012\u001a\u001c\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00140\u0013\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\u0010\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R,\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00070\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\"\u0010\b\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0002\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0016R\u0011\u0010!\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u000f\u00a8\u00065"}, d2={"Lcom/macrofocus/visflux/chord/DefaultChordModel;", "Node", "Link", "Column", "Lcom/macrofocus/visflux/chord/AbstractChordModel;", "network", "Lorg/molap/network/WeightedNetwork;", "", "nodesVisual", "Lorg/mkui/visual/Visual;", "linksVisual", "(Lorg/molap/network/WeightedNetwork;Lorg/mkui/visual/Visual;Lorg/mkui/visual/Visual;)V", "arcPadding", "", "getArcPadding", "()D", "setArcPadding", "(D)V", "linkChord", "", "Lcom/macrofocus/visflux/chord/Arc;", "getLinksVisual", "()Lorg/mkui/visual/Visual;", "getNetwork", "()Lorg/molap/network/WeightedNetwork;", "setNetwork", "(Lorg/molap/network/WeightedNetwork;)V", "nodeChord", "nodes", "", "getNodes", "()Ljava/lang/Iterable;", "getNodesVisual", "totalNodesSize", "getTotalNodesSize", "buildArcs", "", "buildLinksArcs", "getArc", "node", "(Ljava/lang/Object;)Lcom/macrofocus/visflux/chord/Arc;", "from", "to", "(Ljava/lang/Object;Ljava/lang/Object;)Lcom/macrofocus/visflux/chord/Arc;", "getFrom", "link", "(Ljava/lang/Object;)Ljava/lang/Object;", "getLinkSize", "(Ljava/lang/Object;)D", "getLinks", "(Ljava/lang/Object;)Ljava/lang/Iterable;", "getNodeSize", "getTo", "visflux"})
public final class DefaultChordModel<Node, Link, Column>
extends AbstractChordModel<Node, Link, Column> {
    @Nullable
    private final Visual<Node, Column> nodesVisual;
    @Nullable
    private final Visual<Link, Column> linksVisual;
    private double arcPadding;
    @NotNull
    private WeightedNetwork<Node, Link, Object> network;
    @Nullable
    private Map<Node, Arc> nodeChord;
    @Nullable
    private Map<Node, Map<Node, Arc>> linkChord;

    public DefaultChordModel(@NotNull WeightedNetwork<Node, Link, Object> network, @Nullable Visual<Node, Column> nodesVisual, @Nullable Visual<Link, Column> linksVisual) {
        Intrinsics.checkNotNullParameter(network, (String)"network");
        this.nodesVisual = nodesVisual;
        this.linksVisual = linksVisual;
        this.arcPadding = 0.5;
        this.network = network;
        network.addNetworkListener(new NetworkListener(){

            public void networkChanged() {
                this.buildArcs();
                this.buildLinksArcs();
                this.notifyChordChanged();
            }
        });
        this.getProperties().addPropertiesListener((PropertiesListener)new PropertiesListener<ChordModel.PropertyType>(){

            public void propertyChanged(@NotNull ChordModel.PropertyType name, @NotNull PropertyEvent<Object> event) {
                Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.buildArcs();
                this.buildLinksArcs();
                this.notifyChordChanged();
            }
        });
        this.buildArcs();
        this.buildLinksArcs();
    }

    @Override
    @Nullable
    public Visual<Node, Column> getNodesVisual() {
        return this.nodesVisual;
    }

    @Override
    @Nullable
    public Visual<Link, Column> getLinksVisual() {
        return this.linksVisual;
    }

    @Override
    public double getArcPadding() {
        return this.arcPadding;
    }

    public void setArcPadding(double d) {
        this.arcPadding = d;
    }

    @NotNull
    public final WeightedNetwork<Node, Link, Object> getNetwork() {
        return this.network;
    }

    public final void setNetwork(@NotNull WeightedNetwork<Node, Link, Object> weightedNetwork) {
        Intrinsics.checkNotNullParameter(weightedNetwork, (String)"<set-?>");
        this.network = weightedNetwork;
    }

    private final void buildArcs() {
        this.nodeChord = new HashMap();
        int nodeCount = 0;
        for (Node node : this.getNodes()) {
            double nodeSize = this.getNodeSize(node);
            ++nodeCount;
        }
        this.setArcPadding(72.0 / (double)nodeCount);
        double usableAngle = 360.0 - (double)nodeCount * this.getArcPadding();
        double totalNodesSize = this.getTotalNodesSize();
        double currentAngle = 0.0;
        for (Node node : this.getNodes()) {
            double nodeSize = this.getNodeSize(node);
            double angle = 0.0;
            angle = nodeSize > 0.0 ? nodeSize * usableAngle / totalNodesSize : 0.0;
            System.out.println((Object)("Creating arc " + node + ", " + currentAngle + ", " + angle));
            Arc chord = new Arc(currentAngle, angle);
            Map<Node, Arc> map = this.nodeChord;
            Intrinsics.checkNotNull(map);
            map.put(node, chord);
            currentAngle += angle + this.getArcPadding();
        }
    }

    private final void buildLinksArcs() {
        this.linkChord = new HashMap();
        for (Node from : this.getNodes()) {
            Arc nodeChord;
            double nodeSize = this.getNodeSize(from);
            Map<Node, Arc> map = this.nodeChord;
            Intrinsics.checkNotNull(map);
            Arc arc = nodeChord = map.get(from);
            Intrinsics.checkNotNull((Object)arc);
            double currentAngle = arc.getStartAngle();
            double usableAngle = nodeChord.getExtent();
            Iterable links = null;
            Object object = this.network.getDirectedSelection().getSelected();
            Intrinsics.checkNotNull((Object)object);
            links = (Boolean)object != false ? this.network.getDirectedLinks(from) : this.network.getLinks(from);
            if (links == null) continue;
            if (((Boolean)this.getMinimizedCrossing().getValue()).booleanValue()) {
                double angle = nodeChord.getStartAngle() + nodeChord.getExtent() / (double)2;
                List sortedLinks = CollectionsKt.toMutableList((Iterable)links);
                CollectionsKt.sortedWith((Iterable)sortedLinks, (Comparator)new Comparator<Link>(this, angle){
                    final /* synthetic */ DefaultChordModel<Node, Link, Column> this$0;
                    final /* synthetic */ double $angle;
                    {
                        this.this$0 = $receiver;
                        this.$angle = $angle;
                    }

                    public int compare(Link a, Link b) {
                        Arc chord1 = this.this$0.getArc(this.this$0.getTo(a));
                        Arc chord2 = this.this$0.getArc(this.this$0.getTo(b));
                        if (chord1 == null) {
                            return chord2 == null ? 0 : -1;
                        }
                        if (chord2 == null) {
                            return 1;
                        }
                        double a1 = chord1.getStartAngle() + chord1.getExtent() / (double)2;
                        double a2 = chord2.getStartAngle() + chord2.getExtent() / (double)2;
                        double c1 = a1 - this.$angle;
                        double c2 = a2 - this.$angle;
                        if (c1 > 180.0) {
                            c1 -= (double)360;
                        } else if (c1 < -180.0) {
                            c1 += (double)360;
                        }
                        if (c2 > 180.0) {
                            c2 -= (double)360;
                        } else if (c2 < -180.0) {
                            c2 += (double)360;
                        }
                        c1 = c1 >= 0.0 ? (double)180 - c1 : (double)-180 - c1;
                        c2 = c2 >= 0.0 ? (double)180 - c2 : (double)-180 - c2;
                        return Double.compare(c1, c2);
                    }
                });
                links = sortedLinks;
            }
            for (Object link : links) {
                Object to;
                double extent = 0.0;
                extent = nodeSize > 0.0 ? this.getLinkSize(link) * usableAngle / nodeSize : 0.0;
                Arc chord = new Arc(currentAngle, extent);
                Map<Node, Map<Node, Arc>> map2 = this.linkChord;
                Intrinsics.checkNotNull(map2);
                Map nodeChordMap = map2.get(from);
                if (nodeChordMap == null) {
                    nodeChordMap = new HashMap();
                    Map<Node, Map<Node, Arc>> map3 = this.linkChord;
                    Intrinsics.checkNotNull(map3);
                    map3.put(from, nodeChordMap);
                }
                if (from == (to = this.network.getTo(link)) && this.network.getFrom(link) != to) {
                    to = this.network.getFrom(link);
                }
                nodeChordMap.put(to, chord);
                currentAngle += extent;
            }
        }
    }

    public final double getTotalNodesSize() {
        double size = 0.0;
        for (Node node : this.getNodes()) {
            size += this.getNodeSize(node);
        }
        return size;
    }

    @Override
    public double getNodeSize(Node node) {
        Iterable links;
        double size = 0.0;
        Object object = this.network.getDirectedSelection().getSelected();
        Intrinsics.checkNotNull((Object)object);
        Iterable iterable = links = (Boolean)object != false ? this.network.getDirectedLinks(node) : this.network.getLinks(node);
        if (links != null) {
            for (Object link : links) {
                size += this.getLinkSize(link);
            }
        }
        return size;
    }

    @Override
    public double getLinkSize(Link link) {
        double v;
        Object value;
        double v2;
        double size = 0.0;
        DefaultChordModel $this$getLinkSize_u24lambda_u240 = this;
        boolean bl = false;
        Object value2 = $this$getLinkSize_u24lambda_u240.network.getWeight(link);
        if (value2 instanceof Number && !Math.INSTANCE.isNaN(v2 = ((Number)value2).doubleValue())) {
            size += v2;
        }
        Object object = this.network.getDirectedSelection().getSelected();
        Intrinsics.checkNotNull((Object)object);
        if (!((Boolean)object).booleanValue() && (value = this.network.getWeight(this.network.getReverse(link))) instanceof Number && !Math.INSTANCE.isNaN(v = ((Number)value).doubleValue())) {
            size += v;
        }
        return size;
    }

    @Override
    @NotNull
    public Iterable<Node> getNodes() {
        return this.network.getNodes();
    }

    @Override
    @NotNull
    public Iterable<Link> getLinks(Node node) {
        return this.network.getLinks(node);
    }

    @Override
    @Nullable
    public Arc getArc(Node node) {
        Map<Node, Arc> map = this.nodeChord;
        Intrinsics.checkNotNull(map);
        return map.get(node);
    }

    @Override
    @Nullable
    public Arc getArc(Node from, Node to) {
        Map<Node, Arc> nodeChordMap;
        Map<Node, Map<Node, Arc>> map = this.linkChord;
        Intrinsics.checkNotNull(map);
        Map<Node, Arc> map2 = nodeChordMap = map.get(from);
        return map2 != null ? map2.get(to) : null;
    }

    @Override
    public Node getFrom(Link link) {
        return (Node)this.network.getFrom(link);
    }

    @Override
    public Node getTo(Link link) {
        return (Node)this.network.getTo(link);
    }
}

