/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.visflux.layout;

import com.macrofocus.common.math.MathKt;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 62\u00020\u0001:\u00016B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0015\b\u0016\u0012\n\u0010\u0006\u001a\u00020\u0007\"\u00020\b\u00a2\u0006\u0004\b\u0004\u0010\tB\u0019\b\u0016\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\n\u00a2\u0006\u0004\b\u0004\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0004\u0010\rJ\u0006\u0010\u0010\u001a\u00020\u0003J\u0016\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0003J\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0003J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\bJ\u0016\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0003J\u0006\u0010\u0019\u001a\u00020\bJ\u000e\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0003J\u000e\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0003J\u0006\u0010\u001b\u001a\u00020\bJ\u0006\u0010\u001d\u001a\u00020\bJ\u0006\u0010\u001e\u001a\u00020\u0000J\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020\u00002\b\u0010\"\u001a\u0004\u0018\u00010\u0000J\u0010\u0010#\u001a\u00020\u00002\b\u0010$\u001a\u0004\u0018\u00010\u0000J\u0010\u0010%\u001a\u00020\u00002\b\u0010$\u001a\u0004\u0018\u00010\u0000J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\bJ\u000e\u0010(\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\bJ\u0006\u0010)\u001a\u00020\u0000J\u000e\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020\u0000J\u0006\u0010,\u001a\u00020 J\u0006\u0010-\u001a\u00020 J\b\u0010.\u001a\u00020/H\u0016J\u0006\u00100\u001a\u00020/J\b\u00101\u001a\u00020\u0003H\u0016J\u0013\u00102\u001a\u00020 2\b\u00103\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u000e\u00104\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u00067"}, d2={"Lcom/macrofocus/visflux/layout/Vector;", "", "dimensions", "", "<init>", "(I)V", "coordinates", "", "", "([D)V", "", "(Ljava/util/List;)V", "copy", "(Lcom/macrofocus/visflux/layout/Vector;)V", "distanceCache", "Ljava/lang/Double;", "getDimensions", "setCoordinate", "coordinate", "dimension", "getCoordinate", "setDistance", "distance", "setAngularComponent", "angle", "getDistance", "getAngularComponent", "getNorm", "order", "getNormInfinity", "normalize", "isOrigin", "", "calculateRelativeTo", "absolutePoint", "add", "pointToAdd", "subtract", "multiply", "scalar", "divide", "negate", "dotProduct", "operand", "isNaN", "isInfinite", "toString", "", "toStringHypersphere", "hashCode", "equals", "compareWithObject", "clone", "array", "Companion", "visflux"})
public final class Vector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final double[] coordinates;
    @Nullable
    private Double distanceCache;
    private static final long serialVersionUID = -1488734312355605257L;
    @NotNull
    private static final String DIMENSIONS_BELOW_ONE = "dimensions can not be less than or equal to zero";

    public Vector(int dimensions) {
        if (dimensions <= 0) {
            throw new IllegalArgumentException(DIMENSIONS_BELOW_ONE);
        }
        this.coordinates = new double[dimensions];
    }

    public Vector(double ... coordinates) {
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        if (coordinates.length <= 0) {
            throw new IllegalArgumentException("coordinates must have atleast one member, 0 dimensions isnt valid!");
        }
        this.coordinates = this.clone(coordinates);
    }

    public Vector(@Nullable List<Double> coordinates) {
        if (coordinates == null) {
            throw new IllegalArgumentException("coordinates can not be null!");
        }
        if (coordinates.size() <= 0) {
            throw new IllegalArgumentException("coordinates must have atleast one member, 0 dimensions isnt valid!");
        }
        this.coordinates = new double[coordinates.size()];
        int coordinatesIndex = 0;
        Iterator<Double> iterator = coordinates.iterator();
        while (iterator.hasNext()) {
            double coordinate = ((Number)iterator.next()).doubleValue();
            this.coordinates[coordinatesIndex++] = coordinate;
        }
    }

    public Vector(@NotNull Vector copy) {
        Intrinsics.checkNotNullParameter((Object)copy, (String)"copy");
        this.coordinates = this.clone(copy.coordinates);
    }

    public final int getDimensions() {
        return this.coordinates.length;
    }

    @NotNull
    public final Vector setCoordinate(double coordinate, int dimension) {
        if (dimension <= 0) {
            throw new IllegalArgumentException(DIMENSIONS_BELOW_ONE);
        }
        if (dimension > this.coordinates.length) {
            throw new IllegalArgumentException("dimensions is larger than the dimensionality of this point");
        }
        double[] coords = this.clone(this.coordinates);
        coords[dimension - 1] = coordinate;
        return new Vector(Arrays.copyOf(coords, coords.length));
    }

    public final double getCoordinate(int dimension) {
        if (dimension <= 0) {
            throw new IllegalArgumentException(DIMENSIONS_BELOW_ONE);
        }
        if (dimension > this.coordinates.length) {
            throw new IllegalArgumentException("dimensions is larger than the dimensionality of this point");
        }
        return this.coordinates[dimension - 1];
    }

    @NotNull
    public final Vector setDistance(double distance) {
        double[] dArray = this.coordinates;
        Vector newVector = new Vector(Arrays.copyOf(dArray, dArray.length));
        double[] newCoords = newVector.coordinates;
        double oldDistance = this.getDistance();
        double scalar = distance / oldDistance;
        int newCoordsIndex = 0;
        int n = newCoords.length;
        while (newCoordsIndex < n) {
            int n2 = newCoordsIndex++;
            newCoords[n2] = newCoords[n2] * scalar;
        }
        return newVector;
    }

    @NotNull
    public final Vector setAngularComponent(double angle, int dimension) {
        if (dimension <= 0) {
            throw new IllegalArgumentException(DIMENSIONS_BELOW_ONE);
        }
        if (dimension - 1 > this.coordinates.length) {
            throw new IllegalArgumentException("dimensions is larger than the dimensionality (minus 1) of this point");
        }
        Vector newVector = new Vector(this);
        double[] newCoords = newVector.coordinates;
        int cartesianDimension = 1;
        int n = this.getDimensions();
        if (cartesianDimension <= n) {
            while (true) {
                int n2;
                double sphericalProducts = this.getDistance();
                int angleDimension = 1;
                int n3 = n2 = cartesianDimension >= this.getDimensions() ? this.getDimensions() - 1 : cartesianDimension;
                if (angleDimension <= n2) {
                    while (true) {
                        sphericalProducts = angleDimension < cartesianDimension ? (angleDimension == dimension ? (sphericalProducts *= Math.INSTANCE.sin(angle)) : (sphericalProducts *= Math.INSTANCE.sin(this.getAngularComponent(angleDimension)))) : (angleDimension == dimension ? (sphericalProducts *= Math.INSTANCE.cos(angle)) : (sphericalProducts *= Math.INSTANCE.cos(this.getAngularComponent(angleDimension))));
                        if (angleDimension == n2) break;
                        ++angleDimension;
                    }
                }
                newCoords[cartesianDimension - 1] = sphericalProducts;
                if (cartesianDimension == n) break;
                ++cartesianDimension;
            }
        }
        return newVector;
    }

    public final double getDistance() {
        if (this.distanceCache == null) {
            double[] currentCoords = this.clone(this.coordinates);
            double squaredSum = 0.0;
            for (double coordinate : currentCoords) {
                squaredSum += Math.INSTANCE.pow(coordinate, 2.0);
            }
            this.distanceCache = Math.INSTANCE.sqrt(squaredSum);
        }
        Double d = this.distanceCache;
        Intrinsics.checkNotNull((Object)d);
        return d;
    }

    public final double getAngularComponent(int dimension) {
        if (dimension <= 0) {
            throw new IllegalArgumentException(DIMENSIONS_BELOW_ONE);
        }
        if (dimension - 1 > this.coordinates.length) {
            throw new IllegalArgumentException("dimensions is larger than the dimensionality (minus 1) of this point");
        }
        double[] currentCoords = this.clone(this.coordinates);
        double squaredSum = 0.0;
        int coordinateIndex = currentCoords.length - 1;
        if (dimension <= coordinateIndex) {
            while (true) {
                squaredSum += Math.INSTANCE.pow(currentCoords[coordinateIndex], 2.0);
                if (coordinateIndex == dimension) break;
                --coordinateIndex;
            }
        }
        return dimension == this.getDimensions() - 1 ? Math.INSTANCE.atan2(Math.INSTANCE.sqrt(squaredSum), currentCoords[dimension - 1]) : (currentCoords[dimension - 1] == 0.0 ? 1.5707963705062866 : java.lang.Math.atan(Math.INSTANCE.sqrt(squaredSum) / currentCoords[dimension - 1]));
    }

    public final double getNorm(int order) {
        double poweredSum = 0.0;
        for (double coordinate : this.coordinates) {
            poweredSum += Math.INSTANCE.pow(Math.INSTANCE.abs(coordinate), (double)order);
        }
        return Math.INSTANCE.pow(poweredSum, 1.0 / (double)order);
    }

    public final double getNorm() {
        return this.getNorm(2);
    }

    public final double getNormInfinity() {
        double maximum = 0.0;
        for (double coordinate : this.coordinates) {
            if (!(maximum < coordinate)) continue;
            maximum = coordinate;
        }
        return maximum;
    }

    @NotNull
    public final Vector normalize() {
        if (this.isOrigin()) {
            throw new ArithmeticException("cant normalize a 0 vector");
        }
        double norm = this.getNorm();
        return this.multiply(1.0 / norm);
    }

    public final boolean isOrigin() {
        for (double coordinate : this.coordinates) {
            if (coordinate == 0.0) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final Vector calculateRelativeTo(@Nullable Vector absolutePoint) {
        if (absolutePoint == null) {
            throw new IllegalArgumentException("absolutePoint can not be null!");
        }
        double[] currentCoords = this.clone(this.coordinates);
        double[] absoluteCoords = this.clone(absolutePoint.coordinates);
        if (absoluteCoords.length != currentCoords.length) {
            throw new IllegalArgumentException("absolutePoint must have the same dimensions as this point");
        }
        double[] relativeCoords = new double[currentCoords.length];
        int n = currentCoords.length;
        for (int coordIndex = 0; coordIndex < n; ++coordIndex) {
            relativeCoords[coordIndex] = currentCoords[coordIndex] - absoluteCoords[coordIndex];
        }
        return new Vector(Arrays.copyOf(relativeCoords, relativeCoords.length));
    }

    @NotNull
    public final Vector add(@Nullable Vector pointToAdd) {
        if (pointToAdd == null) {
            throw new IllegalArgumentException("pointToAdd can not be null!");
        }
        double[] currentCoords = this.clone(this.coordinates);
        double[] addCoords = this.clone(pointToAdd.coordinates);
        if (addCoords.length != currentCoords.length) {
            throw new IllegalArgumentException("pointToAdd must have the same dimensions as this point");
        }
        double[] relativeCoords = new double[currentCoords.length];
        int n = currentCoords.length;
        for (int coordIndex = 0; coordIndex < n; ++coordIndex) {
            relativeCoords[coordIndex] = currentCoords[coordIndex] + addCoords[coordIndex];
        }
        return new Vector(Arrays.copyOf(relativeCoords, relativeCoords.length));
    }

    @NotNull
    public final Vector subtract(@Nullable Vector pointToAdd) {
        if (pointToAdd == null) {
            throw new IllegalArgumentException("pointToAdd can not be null!");
        }
        double[] currentCoords = this.clone(this.coordinates);
        double[] addCoords = this.clone(pointToAdd.coordinates);
        if (addCoords.length != currentCoords.length) {
            throw new IllegalArgumentException("pointToAdd must have the same dimensions as this point");
        }
        double[] relativeCoords = new double[currentCoords.length];
        int n = currentCoords.length;
        for (int coordIndex = 0; coordIndex < n; ++coordIndex) {
            relativeCoords[coordIndex] = currentCoords[coordIndex] - addCoords[coordIndex];
        }
        return new Vector(Arrays.copyOf(relativeCoords, relativeCoords.length));
    }

    @NotNull
    public final Vector multiply(double scalar) {
        return this.setDistance(this.getDistance() * scalar);
    }

    @NotNull
    public final Vector divide(double scalar) {
        return this.setDistance(this.getDistance() / scalar);
    }

    @NotNull
    public final Vector negate() {
        return this.multiply(-1.0);
    }

    public final double dotProduct(@NotNull Vector operand) {
        Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
        if (this.coordinates.length != operand.coordinates.length) {
            throw new IllegalArgumentException("operand must have the same number of dimensions as this vector.");
        }
        double result = 0.0;
        int n = this.coordinates.length;
        for (int coordIndex = 0; coordIndex < n; ++coordIndex) {
            result += this.coordinates[coordIndex] * operand.coordinates[coordIndex];
        }
        return result;
    }

    public final boolean isNaN() {
        for (double coordinate : this.coordinates) {
            if (!MathKt.isNaN((double)coordinate)) continue;
            return true;
        }
        return false;
    }

    public final boolean isInfinite() {
        for (double coordinate : this.coordinates) {
            if (!MathKt.isInfinite((double)coordinate)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public String toString() {
        double[] currentCoords = this.clone(this.coordinates);
        StringBuilder stringValue = new StringBuilder(currentCoords.length * 5 + 2);
        stringValue.append('{');
        int n = currentCoords.length;
        for (int dimension = 0; dimension < n; ++dimension) {
            stringValue.append(currentCoords[dimension]);
            if (dimension >= currentCoords.length - 1) continue;
            stringValue.append(',');
        }
        stringValue.append('}');
        String string = stringValue.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String toStringHypersphere() {
        StringBuilder retString = new StringBuilder(this.getDimensions() * 6);
        retString.append(this.getDistance());
        retString.append('@');
        int n = this.getDimensions();
        for (int angleDimension = 1; angleDimension < n; ++angleDimension) {
            retString.append(this.getAngularComponent(angleDimension));
            if (angleDimension >= this.getDimensions() - 1) continue;
            retString.append(',');
        }
        String string = retString.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public int hashCode() {
        double[] currentCoords = this.clone(this.coordinates);
        int hashcode = 0;
        for (double coordinate : currentCoords) {
            hashcode += hashcode ^ Double.hashCode(coordinate);
        }
        return hashcode;
    }

    public boolean equals(@Nullable Object compareWithObject) {
        if (!(compareWithObject instanceof Vector)) {
            return false;
        }
        double[] currentCoords = this.coordinates;
        double[] otherCoords = ((Vector)compareWithObject).coordinates;
        if (currentCoords.length != otherCoords.length) {
            return false;
        }
        int dimension = 0;
        int n = currentCoords.length;
        if (dimension <= n) {
            while (true) {
                if (!(currentCoords[dimension] == otherCoords[dimension])) {
                    return false;
                }
                if (dimension == n) break;
                ++dimension;
            }
        }
        return true;
    }

    @NotNull
    public final double[] clone(@NotNull double[] array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        double[] clone = new double[array.length];
        for (double clone[i] : array) {
        }
        return clone;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/macrofocus/visflux/layout/Vector$Companion;", "", "<init>", "()V", "serialVersionUID", "", "DIMENSIONS_BELOW_ONE", "", "visflux"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

