package deckgl.util

import kotlin.math.PI
import kotlin.math.abs
import kotlin.math.ln
import kotlin.math.log2
import kotlin.math.min
import kotlin.math.sin

fun calculateZoomLevel(
    minLon: Double,
    minLat: Double,
    maxLon: Double,
    maxLat: Double,
    width: Int,
    height: Int,
    margin: Double = 0.0 // e.g., 0.1 for 10% margin
): Double {
    val TILE_SIZE = 512.0

    // Expand the bounds by margin
    val lonMargin = (maxLon - minLon) * margin
    val latMargin = (maxLat - minLat) * margin

    val expandedMinLon = minLon - lonMargin
    val expandedMaxLon = maxLon + lonMargin
    val expandedMinLat = minLat - latMargin
    val expandedMaxLat = maxLat + latMargin

    // Convert lat/lon to Web Mercator Y
    fun latToY(lat: Double): Double {
        val sinLat = sin(lat * PI / 180.0)
        return 0.5 - ln((1 + sinLat) / (1 - sinLat)) / (4 * PI)
    }

    val latFraction = abs(latToY(expandedMaxLat) - latToY(expandedMinLat))
    val lonFraction = abs(expandedMaxLon - expandedMinLon) / 360.0

    val latZoom = log2(height / TILE_SIZE / latFraction)
    val lonZoom = log2(width / TILE_SIZE / lonFraction)

    return min(latZoom, lonZoom)
}
