@file:JsModule("@deck.gl/aggregation-layers")
@file:JsNonModule

package deckgl

external interface AggregationLayerProps<D> : LayerProps<D> {
}

external interface HeatmapLayerProps<D> : AggregationLayerProps<D> {
    //Render Options
    var radiusPixels: Number?
    var colorRange: dynamic // ColorRange?
    var intensity: Number;
    var threshold: Number;
    var colorDomain: dynamic // ColorDomain?
    var aggregation: String? // 'SUM' | 'MEAN';

    //Data Accessors
    var getPosition: (d: D) -> dynamic // Position
    var getWeight: (d: D) -> Number?
}

external class HeatmapLayer<D>(props: HeatmapLayerProps<D>) : Layer {
}

external interface HexagonLayerProps<D> : AggregationLayerProps<D> {
    /**
     * Radius of hexagon bin in meters. The hexagons are pointy-topped (rather than flat-topped).
     * @default 1000
     */
    var radius: Number?

    /**
     * Function to aggregate data into hexagonal bins.
     * @default d3-hexbin
     */
    var hexagonAggregator: dynamic // (props: any, params: any) => any;

    /**
     * Color scale input domain.
     * @default [min(colorWeight), max(colorWeight)]
     */
    var colorDomain: dynamic // [number, number] | null;

    /**
     * Specified as an array of colors [color1, color2, ...].
     * @default `6-class YlOrRd` - [colorbrewer](http://colorbrewer2.org/#type=sequential&scheme=YlOrRd&n=6)
     */
    var colorRange: dynamic // Color[];

    /**
     * Hexagon radius multiplier, clamped between 0 - 1.
     * @default 1
     */
    var coverage: Double

    /**
     * Elevation scale input domain. The elevation scale is a linear scale that maps number of counts to elevation.
     * @default [0, max(elevationWeight)]
     */
    var elevationDomain: dynamic // [number, number] | null;

    /**
     * Elevation scale output range.
     * @default [0, 1000]
     */
    var elevationRange: dynamic // [number, number];

    /**
     * Hexagon elevation multiplier.
     * @default 1
     */
    var elevationScale: Double

    /**
     * Whether to enable cell elevation. If set to false, all cell will be flat.
     * @default false
     */
    var extruded: Boolean

    /**
     * Filter bins and re-calculate color by `upperPercentile`.
     * Hexagons with color value larger than the `upperPercentile` will be hidden.
     * @default 100
     */
    var upperPercentile: Double

    /**
     * Filter bins and re-calculate color by `lowerPercentile`.
     * Hexagons with color value smaller than the `lowerPercentile` will be hidden.
     * @default 0
     */
    var lowerPercentile: Double

    /**
     * Filter bins and re-calculate elevation by `elevationUpperPercentile`.
     * Hexagons with elevation value larger than the `elevationUpperPercentile` will be hidden.
     * @default 100
     */
    var elevationUpperPercentile: Double

    /**
     * Filter bins and re-calculate elevation by `elevationLowerPercentile`.
     * Hexagons with elevation value larger than the `elevationLowerPercentile` will be hidden.
     * @default 0
     */
    var elevationLowerPercentile: Double

    /**
     * Scaling function used to determine the color of the grid cell, default value is 'quantize'.
     * Supported Values are 'quantize', 'quantile' and 'ordinal'.
     * @default 'quantize'
     */
    var colorScaleType: dynamic //  'quantize' | 'quantile' | 'ordinal';

    /**
     * Scaling function used to determine the elevation of the grid cell, only supports 'linear'.
     */
    var elevationScaleType: dynamic // 'linear';

    /**
     * Material settings for lighting effect. Applies if `extruded: true`.
     *
     * @default true
     * @see https://deck.gl/docs/developer-guide/using-lighting
     */
    var material: dynamic // Material;

    /**
     * Defines the operation used to aggregate all data object weights to calculate a cell's color value.
     * @default 'SUM'
     */
    var colorAggregation: dynamic // 'SUM' | 'MEAN' | 'MIN' | 'MAX';

    /**
     * Defines the operation used to aggregate all data object weights to calculate a cell's elevation value.
     * @default 'SUM'
     */
    var elevationAggregation: dynamic // 'SUM' | 'MEAN' | 'MIN' | 'MAX';

    /**
     * Method called to retrieve the position of each object.
     * @default object => object.position
     */
    var getPosition: dynamic // AccessorFunction<DataT, Position>;

    /**
     * The weight of a data object used to calculate the color value for a bin.
     * @default 1
     */
    var getColorWeight: dynamic // Accessor<DataT, number>;

    /**
     * After data objects are aggregated into bins, this accessor is called on each cell to get the value that its color is based on.
     * @default null
     */
    var getColorValue: dynamic // AggregateAccessor<DataT> | null;

    /**
     * The weight of a data object used to calculate the elevation value for a bin.
     * @default 1
     */
    var getElevationWeight: dynamic // Accessor<DataT, number>;

    /**
     * After data objects are aggregated into bins, this accessor is called on each cell to get the value that its elevation is based on.
     * @default null
     */
    var getElevationValue: dynamic // AggregateAccessor<DataT> | null;

    /**
     * This callback will be called when cell color domain has been calculated.
     * @default () => {}
     */
    var onSetColorDomain: dynamic // (minMax: [number, number]) => void;

    /**
     * This callback will be called when cell elevation domain has been calculated.
     * @default () => {}
     */
    var onSetElevationDomain: dynamic // (minMax: [number, number]) => void;
}

external class HexagonLayer<D>(props: HexagonLayerProps<D>) : Layer {
}
