package deckgl

external interface DashedPathLayerProps<D> : PathLayerProps<D> {
    /**
     * The dash array to draw each path with: [dashSize, gapSize] relative to the width of the path.
     */
    var getDashArray: dynamic

    /**
     * Only effective if getDashArray is specified. If true, adjust gaps for the dashes to align at both ends. Overrides the effect of highPrecisionDash.
     */
    var dashJustified: Boolean

    /**
     * The offset to draw each path with, relative to the width of the path. Negative offset is to the left hand side, and positive offset is to the right hand side. 0 extrudes the path so that it is centered at the specified coordinates.
     */
    var getOffset: dynamic

    /**
     * Only effective if getDashArray is specified. If true, gaps between solid strokes are pickable. If false, only the solid strokes are pickable.
     */
    var dashGapPickable: dynamic

    var dashStart: dynamic
}

class DashedPathLayer<D>(props: DashedPathLayerProps<D>) : PathLayer<D>(props) {
    override fun getShaders(): dynamic {
        val shaders = super.getShaders()
        shaders.inject["vs:#decl"] += """
            uniform float dashStart;"""
        shaders.inject["vs:#main-end"] += """
            vDashOffset += dashStart;"""
        return shaders
    }

    override fun draw(opts: dynamic) {
        val dashStart = this.asDynamic().props?.dashStart ?: 0
        opts.uniforms.dashStart = dashStart
        super.draw(opts);
    }
}