@file:JsModule("@deck.gl/layers")
@file:JsNonModule

package deckgl

external interface LayerProps<D> {
    //https://deck.gl/#/documentation/deckgl-api-reference/layers/layer?section=properties
    var id: String?
    var data: dynamic // D | DataSet<D> | Promise<DataSet<D>> | string;
    var visible: Boolean?
    var opacity: Number?
    var extensions: Array<Any>

    //Interaction Properties
    var pickable: Boolean?
    var onHover: (info: dynamic) -> Unit
//    var onHover: LayerInputHandler<D>?
    var onClick: (info: dynamic) -> Unit
//    var onClick: LayerInputHandler<D>?
//    var onDragStart: LayerInputHandler<D>?
//    var onDrag: LayerInputHandler<D>?
//    var onDragEnd: LayerInputHandler<D>?
    var highlightColor: dynamic // RGBAColor | ((pickInfo: PickInfo<D>) => RGBAColor)
    var highlightedObjectIndex: Number?
    var autoHighlight: Boolean?

    //Coordinate System Properties
    var coordinateSystem: Number?
    var coordinateOrigin: dynamic // Position?
    var wrapLongitude: Boolean?
    var modelMatrix: Array<Number>?

    //Data Properties
    var dataComparator: ((newData: D, oldData: D) -> Boolean)?
    var dataTransform: (() -> dynamic)? // ?: () => D[] | Iterable<D>;
    var _dataDiff: dynamic // ((newData: D, oldData: D) -> ( startRow: Number, endRow: Number ))
    var positionFormat: String? // 'XYZ' | 'XY';
    var colorFormat: String? // 'RGBA' | 'RGB';
    var numInstances: Number?
    var updateTriggers: Any?
    var loaders: Array<Any>?
    var loadOptions: Any?
    var onDataLoad: dynamic // ((value: D[] | Iterable<D>, context: { layer: Layer<D> }) => void)?;

    //Render Properties
    var parameters: Any?;
    var getPolygonOffset: dynamic // ((uniform: any) => [number, number])?
    var transitions: Any? // { [attributeGetter: string]: TransitionTiming };
    var filterEnabled: Boolean?
    var filterTransformSize: Boolean?
    var filterTransformColor: Boolean?
}

open external class Layer {
    open fun getShaders(): dynamic

    open fun draw(opts: dynamic)
}

external interface BitmapLayerProps : LayerProps<Nothing> {
}

external class BitmapLayer(props: BitmapLayerProps) : Layer {
}

external interface LineLayerProps<D> : LayerProps<D> {
    var widthUnits: dynamic // WidthUnits?
    var widthScale: Number?
    var widthMinPixels: Number?;
    var widthMaxPixels: Number?

    //Data Accessors
    var getSourcePosition: dynamic // ((d: D) -> Position)?
    var getTargetPosition: dynamic //  ((d: D) -> Position)?
    var getColor: dynamic // (((d: D) -> RGBAColor) | RGBAColor)?
    var getWidth: dynamic // (((d: D) -> Number) | Number)?
}

external class LineLayer<D>(props: LineLayerProps<D>) : Layer {
}

external interface ArcLayerProps<D> : LayerProps<D> {
    var widthUnits: dynamic // WidthUnits?
    var widthScale: Number?
    var widthMinPixels: Number?;
    var widthMaxPixels: Number?

    //Data Accessors
    var getSourcePosition: dynamic // ((d: D) -> Position)?
    var getTargetPosition: dynamic //  ((d: D) -> Position)?
    var getSourceColor: dynamic // (((d: D) -> RGBAColor) | RGBAColor)?
    var getTargetColor: dynamic // (((d: D) -> RGBAColor) | RGBAColor)?
    var getWidth: dynamic // (((d: D) -> Number) | Number)?
    var getHeight: dynamic // (((d: D) -> Number) | Number)?
    var getTilt: dynamic // (((d: D) -> Number) | Number)?
}

external class ArcLayer<D>(props: ArcLayerProps<D>) : Layer {
}

external interface ScatterplotLayerProps<D> : LayerProps<D> {
    var getPosition: dynamic // ((d: D) -> Position)?
    var getRadius: dynamic // ((d: D) -> Position)?
}

external class ScatterplotLayer<D>(props: ScatterplotLayerProps<D>) : Layer {
}

external class GeoJsonLayer(props: dynamic) : Layer {
}

external interface PathLayerProps<D> : LayerProps<D> {
    var widthUnits: String?
    var widthScale: Number?
    var widthMinPixels: Number?
    var widthMaxPixels: Number?
    var capRounded: Boolean?
    var jointRounded: Boolean?;
    var billboard: Boolean?;
    var miterLimit: Number?;
    var _pathType: String? // 'loop' | 'open';

    //Data Accessors
    var getPath: dynamic // (d: D) => Position[] | TypedArray;
    var getColor: dynamic // (((d: D) -> RGBAColor) | RGBAColor)?
    var getWidth: dynamic // (((d: D) -> Number) | Number)?
}

open external class PathLayer<D>(props: PathLayerProps<D>) : Layer {
    val WebGLRenderingContext: dynamic
}

open external class PolygonLayer<D>(props: PolygonLayerProps<D>) : Layer {
}

external interface PolygonLayerProps<D> : LayerProps<D> {
}

external interface TextLayerProps<D> : LayerProps<D> {
}

open external class TextLayer<D>(props: TextLayerProps<D>) : Layer {
}
