/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.geom.CurveLink;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0003J\u0012\u0010 \u001a\u0004\u0018\u00010\u00032\b\u0010!\u001a\u0004\u0018\u00010\u0000J\u0010\u0010\"\u001a\u00020\u001e2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0007\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0007\"\u0004\b\u0018\u0010\u0011R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006#"}, d2={"Lorg/kamaeleo/geom/ChainEnd;", "", "first", "Lorg/kamaeleo/geom/CurveLink;", "partner", "chain", "getChain", "()Lorg/kamaeleo/geom/CurveLink;", "etag", "", "getEtag", "()I", "setEtag", "(I)V", "head", "getHead", "setHead", "(Lorg/kamaeleo/geom/CurveLink;)V", "getPartner", "()Lorg/kamaeleo/geom/ChainEnd;", "setPartner", "(Lorg/kamaeleo/geom/ChainEnd;)V", "tail", "getTail", "setTail", "x", "", "getX", "()D", "addLink", "", "newlink", "linkTo", "that", "setOtherEnd", "kamaeleo"})
@StabilityInferred(parameters=0)
public final class ChainEnd {
    @NotNull
    private CurveLink head;
    @NotNull
    private CurveLink tail;
    @Nullable
    private ChainEnd partner;
    private int etag;
    public static final int $stable = 8;

    public ChainEnd(@NotNull CurveLink first, @Nullable ChainEnd partner) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        this.head = first;
        this.tail = first;
        this.partner = partner;
        this.etag = first.getEdgeTag();
    }

    @NotNull
    public final CurveLink getHead() {
        return this.head;
    }

    public final void setHead(@NotNull CurveLink curveLink) {
        Intrinsics.checkNotNullParameter((Object)curveLink, (String)"<set-?>");
        this.head = curveLink;
    }

    @NotNull
    public final CurveLink getTail() {
        return this.tail;
    }

    public final void setTail(@NotNull CurveLink curveLink) {
        Intrinsics.checkNotNullParameter((Object)curveLink, (String)"<set-?>");
        this.tail = curveLink;
    }

    @Nullable
    public final ChainEnd getPartner() {
        return this.partner;
    }

    public final void setPartner(@Nullable ChainEnd chainEnd) {
        this.partner = chainEnd;
    }

    public final int getEtag() {
        return this.etag;
    }

    public final void setEtag(int n) {
        this.etag = n;
    }

    @Nullable
    public final CurveLink getChain() {
        return this.head;
    }

    public final void setOtherEnd(@Nullable ChainEnd partner) {
        this.partner = partner;
    }

    @Nullable
    public final CurveLink linkTo(@Nullable ChainEnd that) {
        block10: {
            block9: {
                if (this.etag == 0) break block9;
                Intrinsics.checkNotNull((Object)that);
                if (that.etag != 0) break block10;
            }
            throw new UnsupportedOperationException("ChainEnd linked more than once!");
        }
        if (this.etag == that.etag) {
            throw new UnsupportedOperationException("Linking chains of the same type!");
        }
        ChainEnd enter = null;
        ChainEnd exit = null;
        if (this.etag == 1) {
            enter = this;
            exit = that;
        } else {
            enter = that;
            exit = this;
        }
        this.etag = 0;
        that.etag = 0;
        Intrinsics.checkNotNull((Object)enter);
        CurveLink curveLink = enter.tail;
        Intrinsics.checkNotNull((Object)exit);
        curveLink.setNext(exit.head);
        enter.tail = exit.tail;
        if (Intrinsics.areEqual((Object)this.partner, (Object)that)) {
            return enter.head;
        }
        ChainEnd otherenter = exit.partner;
        ChainEnd otherexit = enter.partner;
        Intrinsics.checkNotNull((Object)otherenter);
        otherenter.partner = otherexit;
        Intrinsics.checkNotNull((Object)otherexit);
        otherexit.partner = otherenter;
        if (enter.head.getYTop() < otherenter.head.getYTop()) {
            enter.tail.setNext(otherenter.head);
            otherenter.head = enter.head;
        } else {
            otherexit.tail.setNext(enter.head);
            otherexit.tail = enter.tail;
        }
        return null;
    }

    public final void addLink(@NotNull CurveLink newlink) {
        Intrinsics.checkNotNullParameter((Object)newlink, (String)"newlink");
        if (this.etag == 1) {
            this.tail.setNext(newlink);
            this.tail = newlink;
        } else {
            newlink.setNext(this.head);
            this.head = newlink;
        }
    }

    public final double getX() {
        return this.etag == 1 ? this.tail.getXBot() : this.head.getXBot();
    }
}

