/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kamaeleo.geom.AbstractRectangle2D;
import org.kamaeleo.geom.Path;
import org.kamaeleo.geom.Point2D;
import org.kamaeleo.geom.Rectangle2D;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0002\b\u0016B\n\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0000B\"\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u0003\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\bH\u0016J\u0018\u0010\"\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\bH\u0016J(\u0010\"\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b2\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\bH\u0016J\u0011\u0010\"\u001a\u00020\u00112\u0006\u0010%\u001a\u00020&H\u0096\u0002J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0000J(\u0010)\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b2\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\bH\u0016J\b\u0010*\u001a\u00020!H\u0016J\u000e\u0010+\u001a\u00020,2\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010-\u001a\u00020.J\b\u0010/\u001a\u000200H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0012R\u001a\u0010\u0014\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\r\"\u0004\b\u0016\u0010\u000fR\u001a\u0010\u0017\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\r\"\u0004\b\u0019\u0010\u000fR\u001a\u0010\u001a\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\r\"\u0004\b\u001c\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\nR\u0014\u0010\u0003\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\nR\u0014\u0010\u0005\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\n\u00a8\u00061"}, d2={"Lorg/kamaeleo/geom/Rectangle;", "Lorg/kamaeleo/geom/AbstractRectangle2D;", "rectangle", "x", "", "y", "width", "height", "", "getHeight", "()D", "iheight", "getIheight", "()I", "setIheight", "(I)V", "isEmpty", "", "()Z", "isNormalized", "iwidth", "getIwidth", "setIwidth", "ix", "getIx", "setIx", "iy", "getIy", "setIy", "getWidth", "getX", "getY", "add", "Lorg/kamaeleo/geom/Rectangle2D;", "contains", "w", "h", "point", "Lorg/kamaeleo/geom/Point2D;", "intersection", "r", "intersects", "normalize", "setX", "", "toPath", "Lorg/kamaeleo/geom/Path;", "toString", "", "kamaeleo"})
@StabilityInferred(parameters=0)
public final class Rectangle
extends AbstractRectangle2D {
    private int ix;
    private int iy;
    private int iwidth;
    private int iheight;
    public static final int $stable = 8;

    public final int getIx() {
        return this.ix;
    }

    public final void setIx(int n) {
        this.ix = n;
    }

    public final int getIy() {
        return this.iy;
    }

    public final void setIy(int n) {
        this.iy = n;
    }

    public final int getIwidth() {
        return this.iwidth;
    }

    public final void setIwidth(int n) {
        this.iwidth = n;
    }

    public final int getIheight() {
        return this.iheight;
    }

    public final void setIheight(int n) {
        this.iheight = n;
    }

    public Rectangle() {
    }

    public Rectangle(@NotNull Rectangle rectangle) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        this.ix = rectangle.ix;
        this.iy = rectangle.iy;
        this.iwidth = rectangle.iwidth;
        this.iheight = rectangle.iheight;
    }

    public Rectangle(int x, int y, int width, int height) {
        this.ix = x;
        this.iy = y;
        this.iwidth = width;
        this.iheight = height;
    }

    @Override
    @NotNull
    public Rectangle2D add(double x, double y) {
        double d = this.getMinX();
        boolean bl = false;
        double x1 = Math.min(d, x);
        double d2 = this.getMaxX();
        boolean bl2 = false;
        double x2 = Math.max(d2, x);
        double d3 = this.getMinY();
        boolean bl3 = false;
        double y1 = Math.min(d3, y);
        double d4 = this.getMaxY();
        boolean bl4 = false;
        double y2 = Math.max(d4, y);
        return new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
    }

    @NotNull
    public final Path toPath() {
        Path path = new Path();
        path.moveTo(this.getX(), this.getY());
        path.lineTo(this.getX() + this.getWidth(), this.getY());
        path.lineTo(this.getX() + this.getWidth(), this.getY() + this.getHeight());
        path.lineTo(this.getX(), this.getY() + this.getHeight());
        path.close();
        return path;
    }

    @NotNull
    public final Rectangle intersection(@NotNull Rectangle r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        int tx1 = this.ix;
        int ty1 = this.iy;
        int rx1 = r.ix;
        int ry1 = r.iy;
        int tx2 = tx1;
        tx2 += this.iwidth;
        int ty2 = ty1;
        ty2 += this.iheight;
        int rx2 = rx1;
        rx2 += r.iwidth;
        int ry2 = ry1;
        ry2 += r.iheight;
        if (tx1 < rx1) {
            tx1 = rx1;
        }
        if (ty1 < ry1) {
            ty1 = ry1;
        }
        if (tx2 > rx2) {
            tx2 = rx2;
        }
        if (ty2 > ry2) {
            ty2 = ry2;
        }
        ty2 -= ty1;
        if ((tx2 -= tx1) < Integer.MIN_VALUE) {
            tx2 = Integer.MIN_VALUE;
        }
        if (ty2 < Integer.MIN_VALUE) {
            ty2 = Integer.MIN_VALUE;
        }
        return new Rectangle(tx1, ty1, tx2, ty2);
    }

    public final void setX(int x) {
        this.ix = x;
    }

    @NotNull
    public String toString() {
        return "Rectangle{x=" + this.getX() + ", y=" + this.getY() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + '}';
    }

    @Override
    public double getX() {
        return this.ix;
    }

    @Override
    public double getY() {
        return this.iy;
    }

    @Override
    public double getWidth() {
        return this.iwidth;
    }

    @Override
    public double getHeight() {
        return this.iheight;
    }

    @Override
    public boolean contains(@NotNull Point2D point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return point.getY() >= this.getY() && point.getY() <= this.getY() + this.getHeight() && point.getX() >= this.getX() && point.getX() <= this.getX() + this.getWidth();
    }

    @Override
    @NotNull
    public Rectangle2D normalize() {
        if (this.isNormalized()) {
            return this;
        }
        int normalizedX = this.ix;
        int normalizedY = this.iy;
        int normalizedWidth = this.iwidth;
        int normalizedHeight = this.iheight;
        if (normalizedWidth < 0) {
            normalizedWidth = -normalizedWidth;
            normalizedX -= normalizedWidth;
        }
        if (normalizedHeight < 0) {
            normalizedHeight = -normalizedHeight;
            normalizedY -= this.iheight;
        }
        return new Rectangle(normalizedX, normalizedY, normalizedWidth, normalizedHeight);
    }

    private final boolean isNormalized() {
        return this.getWidth() >= 0.0 && this.getHeight() >= 0.0;
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.intersects(new Rectangle2D.Double(x, y, w, h));
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        if (this.isEmpty() || w <= 0.0 || h <= 0.0) {
            return false;
        }
        double x0 = x;
        double y0 = y;
        return x >= x0 && y >= y0 && x + w <= x0 + this.getWidth() && y + h <= y0 + this.getHeight();
    }

    @Override
    public boolean contains(double x, double y) {
        return this.contains(new Point2D.Double(x, y));
    }

    public final boolean isEmpty() {
        return this.getWidth() <= 0.0 || this.getHeight() <= 0.0;
    }
}

