/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.geom.AbstractRectangle2D;
import org.kamaeleo.geom.AffineTransform;
import org.kamaeleo.geom.PathIterator;
import org.kamaeleo.geom.Rectangle2D;
import org.kamaeleo.geom.RoundRectIterator;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001:\u0001#B\u0002\b\u0004J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J(\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0013\u0010\u0016\u001a\u00020\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010\u001d\u001a\u00020\fH\u0016J(\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J&\u0010\u001f\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003J8\u0010!\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u0000H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\u00a8\u0006$"}, d2={"Lorg/kamaeleo/geom/RoundRectangle2D;", "Lorg/kamaeleo/geom/AbstractRectangle2D;", "arcHeight", "", "getArcHeight", "()D", "arcWidth", "getArcWidth", "isEmpty", "", "()Z", "classify", "", "coord", "left", "right", "arcsize", "contains", "x", "y", "w", "h", "equals", "obj", "", "getPathIterator", "Lorg/kamaeleo/geom/PathIterator;", "at", "Lorg/kamaeleo/geom/AffineTransform;", "hashCode", "intersects", "setFrame", "", "setRoundRect", "rr", "Double", "kamaeleo"})
@StabilityInferred(parameters=0)
public abstract class RoundRectangle2D
extends AbstractRectangle2D {
    public static final int $stable;

    protected RoundRectangle2D() {
    }

    public void setRoundRect(@NotNull RoundRectangle2D rr) {
        Intrinsics.checkNotNullParameter((Object)rr, (String)"rr");
        this.setRoundRect(rr.getX(), rr.getY(), rr.getWidth(), rr.getHeight(), rr.getArcWidth(), rr.getArcHeight());
    }

    public abstract double getArcWidth();

    public abstract double getArcHeight();

    public abstract void setRoundRect(double var1, double var3, double var5, double var7, double var9, double var11);

    public final void setFrame(double x, double y, double w, double h) {
        this.setRoundRect(x, y, w, h, this.getArcWidth(), this.getArcHeight());
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        double x2 = x;
        double y2 = y;
        if (this.isEmpty() || w <= 0.0 || h <= 0.0) {
            return false;
        }
        double rrx0 = x2;
        double rry0 = y2;
        double rrx1 = rrx0 + this.getWidth();
        double rry1 = rry0 + this.getHeight();
        if (x2 + w <= rrx0 || x2 >= rrx1 || y2 + h <= rry0 || y2 >= rry1) {
            return false;
        }
        double d = this.getWidth();
        double d2 = this.getArcWidth();
        boolean bl = false;
        d2 = Math.abs(d2);
        bl = false;
        double aw = Math.min(d, d2) / 2.0;
        d2 = this.getHeight();
        double d3 = this.getArcHeight();
        boolean bl2 = false;
        d3 = Math.abs(d3);
        bl2 = false;
        double ah = Math.min(d2, d3) / 2.0;
        int x0class = this.classify(x2, rrx0, rrx1, aw);
        int x1class = this.classify(x2 + w, rrx0, rrx1, aw);
        int y0class = this.classify(y2, rry0, rry1, ah);
        int y1class = this.classify(y2 + h, rry0, rry1, ah);
        if (x0class == 2 || x1class == 2 || y0class == 2 || y1class == 2) {
            return true;
        }
        if (x0class < 2 && x1class > 2 || y0class < 2 && y1class > 2) {
            return true;
        }
        x2 = x1class == 1 ? x2 + w - (rrx0 + aw) : x2 - (rrx1 - aw);
        y2 = y1class == 1 ? y2 + h - (rry0 + ah) : y2 - (rry1 - ah);
        return (x2 /= aw) * x2 + (y2 /= ah) * y2 <= 1.0;
    }

    private final int classify(double coord, double left, double right, double arcsize) {
        return coord < left ? 0 : (coord < left + arcsize ? 1 : (coord < right - arcsize ? 2 : (coord < right ? 3 : 4)));
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.isEmpty() || w <= 0.0 || h <= 0.0 ? false : this.contains(x, y) && this.contains(x + w, y) && this.contains(x, y + h) && this.contains(x + w, y + h);
    }

    @Override
    public boolean contains(double x, double y) {
        Unit unit;
        double it;
        double x2 = x;
        double y2 = y;
        if (this.isEmpty()) {
            return false;
        }
        double rrx0 = 0.0;
        rrx0 = x2;
        double rry0 = 0.0;
        rry0 = y2;
        double rrx1 = rrx0 + this.getWidth();
        double rry1 = rry0 + this.getHeight();
        if (x2 < rrx0 || y2 < rry0 || x2 >= rrx1 || y2 >= rry1) {
            return false;
        }
        double d = this.getWidth();
        double d2 = this.getArcWidth();
        boolean bl = false;
        d2 = Math.abs(d2);
        bl = false;
        double aw = Math.min(d, d2) / 2.0;
        d2 = this.getHeight();
        double d3 = this.getArcHeight();
        boolean bl2 = false;
        d3 = Math.abs(d3);
        bl2 = false;
        double ah = Math.min(d2, d3) / 2.0;
        d2 = aw;
        boolean bl3 = false;
        boolean bl4 = false;
        double d4 = d2;
        double d5 = x2;
        boolean bl5 = false;
        double d6 = rrx0 += it;
        if (d5 >= d6) {
            d2 = aw;
            bl3 = false;
            bl4 = false;
            it = d2;
            d6 = rrx1;
            d5 = x2;
            boolean bl6 = false;
            rrx0 = it;
            unit = Unit.INSTANCE;
            if (d5 < d6 - d2) {
                return true;
            }
        }
        d2 = ah;
        bl3 = false;
        bl4 = false;
        it = d2;
        d5 = y2;
        boolean bl7 = false;
        d6 = rry0 += it;
        if (d5 >= d6) {
            d2 = ah;
            bl3 = false;
            bl4 = false;
            it = d2;
            d6 = rry1;
            d5 = y2;
            boolean bl8 = false;
            rry0 = it;
            unit = Unit.INSTANCE;
            if (d5 < d6 - d2) {
                return true;
            }
        }
        return (x2 = (x2 - rrx0) / aw) * x2 + (y2 = (y2 - rry0) / ah) * y2 <= 1.0;
    }

    public abstract boolean isEmpty();

    @Override
    @NotNull
    public PathIterator getPathIterator(@Nullable AffineTransform at) {
        return new RoundRectIterator(this, at);
    }

    public int hashCode() {
        double d = this.getX();
        boolean bl = false;
        long bits = java.lang.Double.doubleToRawLongBits(d);
        d = this.getY();
        bl = false;
        bits += java.lang.Double.doubleToRawLongBits(d) * (long)37;
        d = this.getWidth();
        bl = false;
        bits += java.lang.Double.doubleToRawLongBits(d) * (long)43;
        d = this.getHeight();
        bl = false;
        bits += java.lang.Double.doubleToRawLongBits(d) * (long)47;
        d = this.getArcWidth();
        bl = false;
        bits += java.lang.Double.doubleToRawLongBits(d) * (long)53;
        d = this.getArcHeight();
        bl = false;
        return (int)(bits += java.lang.Double.doubleToRawLongBits(d) * (long)59) ^ (Integer)(bits >> 32);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RoundRectangle2D) {
            Object rr2d = obj;
            return this.getX() == ((RoundRectangle2D)rr2d).getX() && this.getY() == ((RoundRectangle2D)rr2d).getY() && this.getWidth() == ((RoundRectangle2D)rr2d).getWidth() && this.getHeight() == ((RoundRectangle2D)rr2d).getHeight() && this.getArcWidth() == ((RoundRectangle2D)rr2d).getArcWidth() && this.getArcHeight() == ((RoundRectangle2D)rr2d).getArcHeight();
        }
        return false;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0002\b\u0016B2\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\u0006\u0010!\u001a\u00020 J\b\u0010\"\u001a\u00020 H\u0016J8\u0010#\u001a\u00020$2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0001H\u0016R\u001a\u0010\t\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\rR\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0016R\u001a\u0010\u0018\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000b\"\u0004\b\u001a\u0010\rR\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u000b\"\u0004\b\u001c\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u000b\"\u0004\b\u001e\u0010\r\u00a8\u0006&"}, d2={"Lorg/kamaeleo/geom/RoundRectangle2D$Double;", "Lorg/kamaeleo/geom/RoundRectangle2D;", "x", "", "y", "w", "h", "arcw", "arch", "arcHeight", "getArcHeight", "()D", "setArcHeight", "(D)V", "arcWidth", "getArcWidth", "setArcWidth", "height", "getHeight", "setHeight", "isEmpty", "", "()Z", "isNormalized", "width", "getWidth", "setWidth", "getX", "setX", "getY", "setY", "add", "Lorg/kamaeleo/geom/Rectangle2D;", "computeBounds2D", "normalize", "setRoundRect", "", "rr", "kamaeleo"})
    @StabilityInferred(parameters=0)
    public static final class Double
    extends RoundRectangle2D {
        private double x;
        private double y;
        private double width;
        private double height;
        private double arcWidth;
        private double arcHeight;
        public static final int $stable = 8;

        @Override
        public double getX() {
            return this.x;
        }

        public void setX(double d) {
            this.x = d;
        }

        @Override
        public double getY() {
            return this.y;
        }

        public void setY(double d) {
            this.y = d;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        public void setWidth(double d) {
            this.width = d;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        public void setHeight(double d) {
            this.height = d;
        }

        @Override
        public double getArcWidth() {
            return this.arcWidth;
        }

        public void setArcWidth(double d) {
            this.arcWidth = d;
        }

        @Override
        public double getArcHeight() {
            return this.arcHeight;
        }

        public void setArcHeight(double d) {
            this.arcHeight = d;
        }

        public Double() {
        }

        public Double(double x, double y, double w, double h, double arcw, double arch) {
            this.setRoundRect(x, y, w, h, arcw, arch);
        }

        @Override
        @NotNull
        public Rectangle2D add(double x, double y) {
            double d = this.getMinX();
            boolean bl = false;
            double x1 = Math.min(d, x);
            double d2 = this.getMaxX();
            boolean bl2 = false;
            double x2 = Math.max(d2, x);
            double d3 = this.getMinY();
            boolean bl3 = false;
            double y1 = Math.min(d3, y);
            double d4 = this.getMaxY();
            boolean bl4 = false;
            double y2 = Math.max(d4, y);
            return new Double(x1, y1, x2 - x1, y2 - y1, this.getArcWidth(), this.getArcHeight());
        }

        @Override
        @NotNull
        public Rectangle2D normalize() {
            if (this.isNormalized()) {
                return this;
            }
            double normalizedX = this.getX();
            double normalizedY = this.getY();
            double normalizedWidth = this.getWidth();
            double normalizedHeight = this.getHeight();
            if (normalizedWidth < 0.0) {
                normalizedWidth = -normalizedWidth;
                normalizedX -= normalizedWidth;
            }
            if (normalizedHeight < 0.0) {
                normalizedHeight = -normalizedHeight;
                normalizedY -= normalizedHeight;
            }
            return new Double(normalizedX, normalizedY, normalizedWidth, normalizedHeight, this.getArcWidth(), this.getArcHeight());
        }

        private final boolean isNormalized() {
            return this.getWidth() >= 0.0 && this.getHeight() >= 0.0;
        }

        @Override
        public void setRoundRect(double x, double y, double w, double h, double arcw, double arch) {
            this.setX(x);
            this.setY(y);
            this.setWidth(w);
            this.setHeight(h);
            this.setArcWidth(arcw);
            this.setArcHeight(arch);
        }

        @Override
        public void setRoundRect(@NotNull RoundRectangle2D rr) {
            Intrinsics.checkNotNullParameter((Object)rr, (String)"rr");
            this.setX(rr.getX());
            this.setY(rr.getY());
            this.setWidth(rr.getWidth());
            this.setHeight(rr.getHeight());
            this.setArcWidth(rr.getArcWidth());
            this.setArcHeight(rr.getArcHeight());
        }

        @Override
        public boolean isEmpty() {
            return this.getWidth() <= 0.0 || this.getHeight() <= 0.0;
        }

        @NotNull
        public final Rectangle2D computeBounds2D() {
            return new Rectangle2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
    }
}

