/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.geom.curve;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.geom.curve.BinaryCurveApproximationAlgorithm;
import org.kamaeleo.geom.curve.ControlPath;
import org.kamaeleo.geom.curve.GroupIterator;
import org.kamaeleo.geom.curve.MultiPath;
import org.kamaeleo.geom.curve.ParametricCurve;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0014\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\bH\u0016R\u0018\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lorg/kamaeleo/geom/curve/CatmullRomSpline;", "Lorg/kamaeleo/geom/curve/ParametricCurve;", "cp", "Lorg/kamaeleo/geom/curve/ControlPath;", "gi", "Lorg/kamaeleo/geom/curve/GroupIterator;", "pt", "", "", "[[D", "sampleLimit", "", "getSampleLimit", "()I", "appendTo", "", "mp", "Lorg/kamaeleo/geom/curve/MultiPath;", "eval", "p", "kamaeleo"})
@StabilityInferred(parameters=0)
public final class CatmullRomSpline
extends ParametricCurve {
    @NotNull
    private final double[][] pt = new double[4][];
    public static final int $stable = 8;

    public CatmullRomSpline(@Nullable ControlPath cp, @Nullable GroupIterator gi) {
        super(cp, gi);
    }

    @Override
    public void appendTo(@NotNull MultiPath mp) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
        Object object3 = this.getGi();
        Intrinsics.checkNotNull((Object)object3);
        GroupIterator groupIterator = object3;
        object3 = this.getCp();
        Intrinsics.checkNotNull((Object)object3);
        if (!groupIterator.isInRange(0, ((ControlPath)object3).numPoints())) {
            return;
        }
        object3 = this.getGi();
        Intrinsics.checkNotNull((Object)object3);
        if (((GroupIterator)object3).getGroupSize() < 4) {
            return;
        }
        object3 = this.getGi();
        Intrinsics.checkNotNull((Object)object3);
        ((GroupIterator)object3).set(0, 0);
        int n = 0;
        do {
            int i = n++;
            object2 = this.getCp();
            Intrinsics.checkNotNull((Object)object2);
            ControlPath controlPath = object2;
            object2 = this.getGi();
            Intrinsics.checkNotNull((Object)object2);
            object = controlPath.getPoint(((GroupIterator)object2).next());
            Intrinsics.checkNotNull((Object)object);
            this.pt[i] = object.getLocation();
        } while (n <= 3);
        double[] d = new double[mp.getDimension() + 1];
        this.eval(d);
        if (this.getConnect()) {
            mp.lineTo(d);
        } else {
            mp.moveTo(d);
        }
        GroupIterator i = this.getGi();
        Intrinsics.checkNotNull((Object)i);
        i.set(0, 0);
        while (true) {
            object = this.getGi();
            Intrinsics.checkNotNull((Object)object);
            int index_i = ((GroupIterator)object).index_i();
            object2 = this.getGi();
            Intrinsics.checkNotNull((Object)object2);
            int count_j = ((GroupIterator)object2).count_j();
            int n2 = 0;
            do {
                int i2 = n2++;
                Object object4 = this.getGi();
                Intrinsics.checkNotNull((Object)object4);
                if (!((GroupIterator)object4).hasNext()) {
                    return;
                }
                Object object5 = this.getCp();
                Intrinsics.checkNotNull((Object)object5);
                ControlPath controlPath = object5;
                object5 = this.getGi();
                Intrinsics.checkNotNull((Object)object5);
                object4 = controlPath.getPoint(((GroupIterator)object5).next());
                Intrinsics.checkNotNull((Object)object4);
                this.pt[i2] = object4.getLocation();
            } while (n2 <= 3);
            object2 = this.getGi();
            Intrinsics.checkNotNull((Object)object2);
            ((GroupIterator)object2).set(index_i, count_j);
            object2 = this.getGi();
            Intrinsics.checkNotNull((Object)object2);
            ((GroupIterator)object2).next();
            BinaryCurveApproximationAlgorithm.INSTANCE.genPts(this, 0.0, 1.0, mp);
        }
    }

    @Override
    public void eval(@NotNull double[] p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        double t = p[p.length - 1];
        double t2 = t * t;
        double t3 = t2 * t;
        int n = p.length - 1;
        int n2 = 0;
        int n3 = n + -1;
        if (n != Integer.MIN_VALUE && n2 <= n3) {
            do {
                int i = n2++;
                double[] dArray = this.pt[3];
                Intrinsics.checkNotNull((Object)dArray);
                double d = dArray[i];
                dArray = this.pt[0];
                Intrinsics.checkNotNull((Object)dArray);
                double d2 = d - dArray[i];
                double d3 = 3;
                dArray = this.pt[1];
                Intrinsics.checkNotNull((Object)dArray);
                double d4 = dArray[i];
                dArray = this.pt[2];
                Intrinsics.checkNotNull((Object)dArray);
                double d5 = (d2 + d3 * (d4 - dArray[i])) * t3;
                double d6 = 2;
                dArray = this.pt[0];
                Intrinsics.checkNotNull((Object)dArray);
                double d7 = dArray[i];
                double d8 = 2;
                dArray = this.pt[2];
                Intrinsics.checkNotNull((Object)dArray);
                double d9 = d6 * (d7 + d8 * dArray[i]);
                double d10 = 5;
                dArray = this.pt[1];
                Intrinsics.checkNotNull((Object)dArray);
                double d11 = d9 - d10 * dArray[i];
                dArray = this.pt[3];
                Intrinsics.checkNotNull((Object)dArray);
                double d12 = d5 + (d11 - dArray[i]) * t2;
                dArray = this.pt[2];
                Intrinsics.checkNotNull((Object)dArray);
                double d13 = dArray[i];
                dArray = this.pt[0];
                Intrinsics.checkNotNull((Object)dArray);
                double d14 = 0.5 * (d12 + (d13 - dArray[i]) * t);
                dArray = this.pt[1];
                Intrinsics.checkNotNull((Object)dArray);
                p[i] = d14 + dArray[i];
            } while (n2 <= n3);
        }
    }

    @Override
    public int getSampleLimit() {
        return 1;
    }
}

