/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.geom.curve;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.geom.AffineTransform;
import org.kamaeleo.geom.PathIterator;
import org.kamaeleo.geom.curve.MultiPath;
import org.kamaeleo.geom.curve.ShapeMultiPath;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0013\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0013H\u0016J\t\u0010\u0014\u001a\u00020\u0015H\u0096\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lorg/kamaeleo/geom/curve/ShapeMultiPathIterator;", "Lorg/kamaeleo/geom/PathIterator;", "smp", "Lorg/kamaeleo/geom/curve/ShapeMultiPath;", "at", "Lorg/kamaeleo/geom/AffineTransform;", "ai0", "", "ai1", "isDone", "", "()Z", "n", "windingRule", "getWindingRule", "()I", "currentSegment", "coords", "", "", "next", "", "kamaeleo"})
public final class ShapeMultiPathIterator
implements PathIterator {
    private final int ai0;
    private final int ai1;
    @Nullable
    private final AffineTransform at;
    @NotNull
    private final ShapeMultiPath smp;
    private final int windingRule;
    private int n;

    public ShapeMultiPathIterator(@NotNull ShapeMultiPath smp, @Nullable AffineTransform at) {
        Intrinsics.checkNotNullParameter((Object)smp, (String)"smp");
        this.smp = smp;
        this.at = at;
        int[] bv = smp.getBasisVectors();
        this.ai0 = bv[0];
        this.ai1 = bv[1];
        this.windingRule = smp.getWindingRule();
    }

    @Override
    public int getWindingRule() {
        return this.windingRule;
    }

    @Override
    public boolean isDone() {
        return this.n >= this.smp.getNumPoints();
    }

    @Override
    public void next() {
        ShapeMultiPathIterator shapeMultiPathIterator = this;
        int n = shapeMultiPathIterator.n;
        shapeMultiPathIterator.n = n + 1;
    }

    @Override
    public int currentSegment(@NotNull float[] coords) {
        Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
        double[] p = this.smp.get(this.n);
        coords[0] = (float)p[this.ai0];
        coords[1] = (float)p[this.ai1];
        if (this.n > 0 && Intrinsics.areEqual((Object)p, (Object)this.smp.get(0))) {
            return 4;
        }
        if (this.at != null) {
            this.at.transform(coords, 0, coords, 0, 1);
        }
        return this.smp.getType(this.n) == MultiPath.Companion.getMOVE_TO() ? 0 : 1;
    }

    @Override
    public int currentSegment(@NotNull double[] coords) {
        Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
        double[] p = this.smp.get(this.n);
        coords[0] = p[this.ai0];
        coords[1] = p[this.ai1];
        if (this.n > 0 && Intrinsics.areEqual((Object)p, (Object)this.smp.get(0))) {
            return 4;
        }
        if (this.at != null) {
            this.at.transform(coords, 0, coords, 0, 1);
        }
        return this.smp.getType(this.n) == MultiPath.Companion.getMOVE_TO() ? 0 : 1;
    }
}

