/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.graphics;

import androidx.compose.runtime.internal.StabilityInferred;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.graphics.Image;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0012\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003B\u001c\b\u0016\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003B\n\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\u001a\u001a\u00020\u0006J\u0010\u0010\u001b\u001a\u00020\u00182\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0006\u0010\u001e\u001a\u00020\u0018J2\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\b\u0010$\u001a\u0004\u0018\u00010%H\u0016R\u0014\u0010\u0004\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\rR\u0014\u0010\u000e\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\n\u00a8\u0006&"}, d2={"Lorg/kamaeleo/graphics/CPImage;", "Lorg/kamaeleo/graphics/Image;", "width", "", "height", "g2", "Ljava/awt/Graphics2D;", "image", "Ljava/awt/image/BufferedImage;", "getHeight", "()I", "isLoaded", "", "()Z", "isOneSamplePerArrayElement", "nativeImage", "Ljava/awt/Image;", "getNativeImage", "()Ljava/awt/Image;", "physicalHeight", "physicalWidth", "raster", "Ljava/awt/image/WritableRaster;", "scaleFactor", "", "getWidth", "createGraphics", "findCurrentScaleFactor", "flush", "", "getScaleFactor", "setPixels", "x", "y", "w", "h", "iArray", "", "kamaeleo"})
@StabilityInferred(parameters=0)
public final class CPImage
implements Image {
    @Nullable
    private BufferedImage image;
    @Nullable
    private WritableRaster raster;
    private int physicalWidth;
    private int physicalHeight;
    private double scaleFactor;
    private final boolean isOneSamplePerArrayElement;
    private final boolean isLoaded;
    public static final int $stable = 8;

    public CPImage(int width, int height) {
        this.isOneSamplePerArrayElement = true;
        this.isLoaded = true;
        this.scaleFactor = this.findCurrentScaleFactor(null);
        this.physicalWidth = (int)Math.floor((double)width * this.scaleFactor);
        this.physicalHeight = (int)Math.floor((double)height * this.scaleFactor);
        BufferedImage bufferedImage = this.image = new BufferedImage(this.physicalWidth, this.physicalHeight, 2);
        Intrinsics.checkNotNull((Object)bufferedImage);
        this.raster = bufferedImage.getRaster();
    }

    public CPImage(@Nullable Graphics2D g2, int width, int height) {
        this.isOneSamplePerArrayElement = true;
        this.isLoaded = true;
        this.scaleFactor = this.findCurrentScaleFactor(g2);
        this.physicalWidth = (int)Math.floor((double)width * this.scaleFactor);
        this.physicalHeight = (int)Math.floor((double)height * this.scaleFactor);
        Object object = g2;
        GraphicsConfiguration gc = object == null ? null : ((Graphics2D)object).getDeviceConfiguration();
        this.image = gc != null ? gc.createCompatibleImage(this.physicalWidth, this.physicalHeight, 3) : new BufferedImage(this.physicalWidth, this.physicalHeight, 2);
        object = this.image;
        Intrinsics.checkNotNull((Object)object);
        this.raster = ((BufferedImage)object).getRaster();
    }

    public CPImage(@NotNull BufferedImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        this.isOneSamplePerArrayElement = true;
        this.isLoaded = true;
        this.image = image;
        this.raster = image.getRaster();
    }

    @Override
    public int getWidth() {
        BufferedImage bufferedImage = this.image;
        Intrinsics.checkNotNull((Object)bufferedImage);
        return bufferedImage.getWidth();
    }

    @Override
    public int getHeight() {
        BufferedImage bufferedImage = this.image;
        Intrinsics.checkNotNull((Object)bufferedImage);
        return bufferedImage.getHeight();
    }

    @Override
    public void setPixels(int x, int y, int w, int h, @Nullable int[] iArray) {
        WritableRaster writableRaster = this.raster;
        Intrinsics.checkNotNull((Object)writableRaster);
        writableRaster.setPixels(x, y, w, h, iArray);
    }

    @Override
    public boolean isOneSamplePerArrayElement() {
        return this.isOneSamplePerArrayElement;
    }

    @Override
    public boolean isLoaded() {
        return this.isLoaded;
    }

    @Override
    public void flush() {
        if (this.image != null) {
            BufferedImage bufferedImage = this.image;
            Intrinsics.checkNotNull((Object)bufferedImage);
            bufferedImage.flush();
        }
        this.image = null;
        this.raster = null;
    }

    @Override
    @NotNull
    public java.awt.Image getNativeImage() {
        BufferedImage bufferedImage = this.image;
        Intrinsics.checkNotNull((Object)bufferedImage);
        return bufferedImage;
    }

    @NotNull
    public final Graphics2D createGraphics() {
        BufferedImage bufferedImage = this.image;
        Intrinsics.checkNotNull((Object)bufferedImage);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"image!!.createGraphics()");
        return graphics2D;
    }

    public final double getScaleFactor() {
        return this.scaleFactor;
    }

    public final double findCurrentScaleFactor(@Nullable Graphics2D g2) {
        double d;
        GraphicsConfiguration graphicsConfiguration;
        Graphics2D graphics2D = g2;
        AffineTransform affineTransform = graphics2D == null ? null : ((graphicsConfiguration = graphics2D.getDeviceConfiguration()) == null ? null : graphicsConfiguration.getDefaultTransform());
        return affineTransform == null ? 1.0 : (d = affineTransform.getScaleX());
    }
}

