/*
 * Copyright (c) 2017 Macrofocus GmbH. All Rights Reserved.
 */
package org.kamaeleo.colormap.editor

import com.macrofocus.common.selection.SelectionEvent
import com.macrofocus.common.selection.SelectionListener
import org.kamaeleo.colormap.ColorMap
import org.kamaeleo.colormap.ColorMapEvent
import org.kamaeleo.colormap.ColorMapListener

abstract class AbstractColorMapPanel<C> : ColorMapPanel<C> {
    protected var colorMap: ColorMap? = null
    set(colormap) {
        if (field != null) {
            field!!.removeColorMapListener(colorMapListener)
        }
        field = colorMap
        if (field != null) {
            field!!.addColorMapListener(colorMapListener)
        }
    }
    protected var model: ColorMapPanelModel<C>? = null
        set(model) {
            if (field != null) {
                field!!.colorSelection!!.removeSelectionListener(colorVariableSelectionListener)
            }
            field = model
            if (field != null) {
                model!!.colorSelection!!.addSelectionListener(colorVariableSelectionListener)
                updateSelectedVariable()
                updateColorMap()
            }
        }
    val colorVariableSelectionListener: SelectionListener<C?> = object : SelectionListener<C?> {
        override fun selectionChanged(selectionEvent: SelectionEvent<C?>) {
            updateSelectedVariable()
            updateColorMap()
        }
    }
    val colorMapListener: ColorMapListener = object : ColorMapListener {
        override fun colorMapChanged(event: ColorMapEvent) {
            updateSelectedVariable()
        }
    }

    protected abstract fun updateColorMap()
    protected abstract fun updateSelectedVariable()
}