package org.kamaeleo.color

import java.awt.Color

actual class CPColor constructor(color: Color) : IColor {
    val nativeColor: Color = color

    actual constructor(r: UByte, g: UByte, b: UByte, a: UByte) : this(Color(r.toInt(), g.toInt(), b.toInt(), a.toInt()))
    actual constructor(r: UByte, g: UByte, b: UByte) : this(r, g, b, 255u)
    actual constructor(r: Int, g: Int, b: Int) : this(r.toUByte(), g.toUByte(), b.toUByte(),255u)
    actual constructor(r: Int, g: Int, b: Int, a: Int) : this(r.toUByte(), g.toUByte(), b.toUByte(), a.toUByte())
    actual constructor(r: Float, g: Float, b: Float) : this(
        (r * 255 + 0.5).toInt(),
        (g * 255 + 0.5).toInt(),
        (b * 255 + 0.5).toInt(),
        255)
    actual constructor(r: Float, g: Float, b: Float, a: Float) : this(
        (r * 255 + 0.5).toInt(),
        (g * 255 + 0.5).toInt(),
        (b * 255 + 0.5).toInt(),
        (a * 255 + 0.5).toInt())

    actual constructor(rgba: Int) : this(Color(rgba, true))

    override fun getRed(): UByte {
        return nativeColor.red.toUByte();
    }

    override fun getGreen(): UByte {
        return nativeColor.green.toUByte()
    }

    override fun getBlue(): UByte {
        return nativeColor.blue.toUByte()
    }

    override fun getAlpha(): UByte {
        return nativeColor.alpha.toUByte()
    }
}