/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.colormap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.collection.SortedSet;
import com.macrofocus.common.interval.MutableInterval;
import com.macrofocus.common.interval.PropertyClosedInterval;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.color.CPColorFactory;
import org.kamaeleo.colormap.MutableColorMap;
import org.kamaeleo.colormap.SimpleColorMap;
import org.kamaeleo.palette.CustomPalette;
import org.kamaeleo.palette.MutablePalette;
import org.kamaeleo.palette.PaletteFactory;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\b\u0012\u0006\u0010\u0002\u001a\u00020\u0003J\u0014\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\tJ\u001a\u0010\n\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\fJ\u001a\u0010\u000e\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\fJ$\u0010\u000f\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010\u0014\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\tJ\u0014\u0010\u0015\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\tJ\u0016\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bJ\u0016\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bJ\u0014\u0010\u001f\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\tJ\u0006\u0010 \u001a\u00020\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/kamaeleo/colormap/ColorMapFactory;", "", "paletteFactory", "Lorg/kamaeleo/palette/PaletteFactory;", "colorFactory", "Lorg/kamaeleo/color/CPColorFactory;", "createAlphabeticalColorMap", "Lorg/kamaeleo/colormap/MutableColorMap;", "values", "", "createAutoContinuousColorMap", "mininum", "", "maximum", "createAutoSegmentedColorMap", "createCategoricalColorMap", "cyclic", "", "palette", "Lorg/kamaeleo/palette/MutablePalette;", "createCategoricalDivergingColorMap", "createCategoricalSequentialColorMap", "createColorMap", "interval", "Lcom/macrofocus/common/interval/MutableInterval;", "createContinuousColorMap", "min", "", "max", "createContinuousDivergingColorMap", "createContinuousSequentialColorMap", "createQualitativeColorMap", "getPaletteFactory", "kamaeleo"})
@StabilityInferred(parameters=0)
public final class ColorMapFactory {
    @NotNull
    private final CPColorFactory colorFactory;
    @NotNull
    private final PaletteFactory paletteFactory;
    public static final int $stable = 8;

    public ColorMapFactory(@NotNull PaletteFactory paletteFactory) {
        Intrinsics.checkNotNullParameter((Object)paletteFactory, (String)"paletteFactory");
        this.colorFactory = CPColorFactory.Companion.getInstance();
        this.paletteFactory = paletteFactory;
    }

    @NotNull
    public final PaletteFactory getPaletteFactory() {
        return this.paletteFactory;
    }

    @NotNull
    public final MutableColorMap createContinuousSequentialColorMap(double min, double max) {
        return this.createContinuousColorMap(min, max, this.paletteFactory.createDefaultSequentialPalette());
    }

    @NotNull
    public final MutableColorMap createContinuousDivergingColorMap(double min, double max) {
        return this.createContinuousColorMap(min, max, this.paletteFactory.createDefaultDivergingPalette());
    }

    @NotNull
    public final MutableColorMap createCategoricalSequentialColorMap(@Nullable Set<?> values) {
        return this.createCategoricalColorMap(values, false, this.paletteFactory.createDefaultSequentialPalette());
    }

    @NotNull
    public final MutableColorMap createCategoricalDivergingColorMap(@Nullable Set<?> values) {
        return this.createCategoricalColorMap(values, false, this.paletteFactory.createDefaultDivergingPalette());
    }

    @NotNull
    public final MutableColorMap createQualitativeColorMap(@Nullable Set<?> values) {
        return this.createCategoricalColorMap(values, true, this.paletteFactory.createDefaultQualititativePalette());
    }

    @NotNull
    public final MutableColorMap createContinuousColorMap(double min, double max, @NotNull MutablePalette palette) {
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        return new SimpleColorMap((MutableInterval)new PropertyClosedInterval(min, max - min), palette);
    }

    @NotNull
    public final MutableColorMap createCategoricalColorMap(@Nullable Set<?> values, boolean cyclic, @NotNull MutablePalette palette) {
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        return new SimpleColorMap(values, cyclic, palette);
    }

    @NotNull
    public final MutableColorMap createColorMap(@NotNull MutableInterval interval, @NotNull MutablePalette palette) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        return new SimpleColorMap(interval, palette);
    }

    @NotNull
    public final MutableColorMap createAlphabeticalColorMap(@Nullable Set<?> values) {
        SortedSet set = new SortedSet(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE), null, 2, null);
        set.add((Object)"A");
        set.add((Object)"B");
        set.add((Object)"C");
        return new SimpleColorMap((Set)set, false, this.paletteFactory.createDefaultSequentialPalette());
    }

    @NotNull
    public final MutableColorMap createAutoContinuousColorMap(@Nullable Number mininum, @Nullable Number maximum) {
        MutableColorMap mutableColorMap;
        if (mininum != null && maximum != null) {
            if (mininum.doubleValue() < 0.0 && maximum.doubleValue() > 0.0) {
                double diffMin = 0.0 - mininum.doubleValue();
                double diffMax = maximum.doubleValue();
                boolean bl = false;
                double maxDiff = Math.max(diffMin, diffMax);
                mutableColorMap = this.createContinuousDivergingColorMap(0.0 - maxDiff, maxDiff);
            } else {
                mutableColorMap = this.createContinuousSequentialColorMap(mininum.doubleValue(), maximum.doubleValue());
            }
        } else {
            mutableColorMap = this.createContinuousSequentialColorMap(0.0, 0.0);
        }
        return mutableColorMap;
    }

    @NotNull
    public final MutableColorMap createAutoSegmentedColorMap(@Nullable Number mininum, @Nullable Number maximum) {
        MutableColorMap mutableColorMap;
        if (mininum != null && maximum != null) {
            if (mininum.doubleValue() < 0.0 && maximum.doubleValue() > 0.0) {
                double diffMin = 0.0 - mininum.doubleValue();
                double diffMax = maximum.doubleValue();
                boolean bl = false;
                double maxDiff = Math.max(diffMin, diffMax);
                double min = 0.0 - maxDiff;
                double minF = (min - mininum.doubleValue()) / (maximum.doubleValue() - mininum.doubleValue());
                double maxF = (maxDiff - mininum.doubleValue()) / (maximum.doubleValue() - mininum.doubleValue());
                double meanF = (maxF + minF) / 2.0;
                CustomPalette.Entry[] entryArray = new CustomPalette.Entry[]{new CustomPalette.Entry(minF, this.colorFactory.createRGBColor(255, 0, 0)), new CustomPalette.Entry(meanF, this.colorFactory.getWhite()), new CustomPalette.Entry(maxF, this.colorFactory.createRGBColor(0, 128, 0))};
                mutableColorMap = this.createContinuousColorMap(mininum.doubleValue(), maximum.doubleValue(), new CustomPalette(entryArray));
            } else {
                CustomPalette.Entry[] entryArray = new CustomPalette.Entry[]{new CustomPalette.Entry(0.0, this.colorFactory.createRGBColor(255, 0, 0)), new CustomPalette.Entry(0.5, this.colorFactory.getWhite()), new CustomPalette.Entry(1.0, this.colorFactory.createRGBColor(0, 128, 0))};
                mutableColorMap = this.createContinuousColorMap(mininum.doubleValue(), maximum.doubleValue(), new CustomPalette(entryArray));
            }
        } else {
            CustomPalette.Entry[] entryArray = new CustomPalette.Entry[]{new CustomPalette.Entry(0.0, this.colorFactory.getWhite())};
            mutableColorMap = this.createContinuousColorMap(0.0, 0.0, new CustomPalette(entryArray));
        }
        return mutableColorMap;
    }
}

