/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.geom.curve;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.geom.curve.BinaryCurveApproximationAlgorithm;
import org.kamaeleo.geom.curve.ControlPath;
import org.kamaeleo.geom.curve.GroupIterator;
import org.kamaeleo.geom.curve.MultiPath;
import org.kamaeleo.geom.curve.ParametricCurve;
import org.kamaeleo.geom.curve.ValueVector;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0013\n\u0002\b\n\b\u0007\u0018\u0000 .2\u00020\u0001:\u0001.B\u0014\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J(\u0010\u001f\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\nH\u0002J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%H\u0016J\u0006\u0010&\u001a\u00020\u0007J\u0006\u0010'\u001a\u00020\u0007J\b\u0010(\u001a\u0004\u0018\u00010\u0013J\b\u0010)\u001a\u00020\u001cH\u0016J\u000e\u0010*\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u0007J\u000e\u0010+\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u0007J\u0010\u0010,\u001a\u00020\u001c2\b\u0010-\u001a\u0004\u0018\u00010\u0013R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006/"}, d2={"Lorg/kamaeleo/geom/curve/LagrangeCurve;", "Lorg/kamaeleo/geom/curve/ParametricCurve;", "cp", "Lorg/kamaeleo/geom/curve/ControlPath;", "gi", "Lorg/kamaeleo/geom/curve/GroupIterator;", "baseIndex", "", "baseLength", "interpolateFirst", "", "getInterpolateFirst", "()Z", "setInterpolateFirst", "(Z)V", "interpolateLast", "getInterpolateLast", "setInterpolateLast", "knotVector", "Lorg/kamaeleo/geom/curve/ValueVector;", "sampleLimit", "getSampleLimit", "()I", "L", "", "t", "i", "appendTo", "", "mp", "Lorg/kamaeleo/geom/curve/MultiPath;", "doBCAA", "t1", "t2", "b", "eval", "p", "", "getBaseIndex", "getBaseLength", "getKnotVector", "resetMemory", "setBaseIndex", "setBaseLength", "setKnotVector", "v", "Companion", "kamaeleo"})
@StabilityInferred(parameters=0)
public final class LagrangeCurve
extends ParametricCurve {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ValueVector knotVector;
    private int baseIndex;
    private int baseLength;
    private boolean interpolateFirst;
    private boolean interpolateLast;
    public static final int $stable = 8;
    @NotNull
    private static double[][] pt = new double[0][];

    public LagrangeCurve(@Nullable ControlPath cp, @Nullable GroupIterator gi) {
        super(cp, gi);
        double[] dArray = new double[]{0.0, 0.3333333333333333, 0.6666666666666666, 1.0};
        this.knotVector = new ValueVector(dArray, 4);
        this.baseIndex = 1;
        this.baseLength = 1;
    }

    public final boolean getInterpolateFirst() {
        return this.interpolateFirst;
    }

    public final void setInterpolateFirst(boolean bl) {
        this.interpolateFirst = bl;
    }

    public final boolean getInterpolateLast() {
        return this.interpolateLast;
    }

    public final void setInterpolateLast(boolean bl) {
        this.interpolateLast = bl;
    }

    public final int getBaseIndex() {
        return this.baseIndex;
    }

    public final void setBaseIndex(int b) {
        this.baseIndex = b;
    }

    public final int getBaseLength() {
        return this.baseLength;
    }

    public final void setBaseLength(int b) {
        this.baseLength = b;
    }

    @Nullable
    public final ValueVector getKnotVector() {
        return this.knotVector;
    }

    public final void setKnotVector(@Nullable ValueVector v) {
        this.knotVector = v;
    }

    @Override
    public void appendTo(@NotNull MultiPath mp) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
        Object object2 = this.getGi();
        Intrinsics.checkNotNull((Object)object2);
        GroupIterator groupIterator = object2;
        object2 = this.getCp();
        Intrinsics.checkNotNull((Object)object2);
        if (!groupIterator.isInRange(0, ((ControlPath)object2).numPoints())) {
            return;
        }
        object2 = this.knotVector;
        Intrinsics.checkNotNull((Object)object2);
        if (this.baseIndex + this.baseLength >= ((ValueVector)object2).size()) {
            return;
        }
        int n = ((Object[])pt).length;
        object2 = this.knotVector;
        Intrinsics.checkNotNull((Object)object2);
        if (n < ((ValueVector)object2).size()) {
            object2 = this.knotVector;
            Intrinsics.checkNotNull((Object)object2);
            pt = new double[2 * ((ValueVector)object2).size()][];
        }
        object2 = this.getGi();
        Intrinsics.checkNotNull((Object)object2);
        ((GroupIterator)object2).set(0, 0);
        boolean b = false;
        if (this.baseIndex != 0 && this.interpolateFirst) {
            ValueVector valueVector = this.knotVector;
            Intrinsics.checkNotNull((Object)valueVector);
            int n2 = valueVector.size();
            int n3 = 0;
            int n4 = n2 + -1;
            if (n2 != Integer.MIN_VALUE && n3 <= n4) {
                do {
                    int i = n3++;
                    Object object3 = this.getGi();
                    Intrinsics.checkNotNull((Object)object3);
                    if (!((GroupIterator)object3).hasNext()) {
                        return;
                    }
                    Object object4 = this.getCp();
                    Intrinsics.checkNotNull((Object)object4);
                    ControlPath controlPath = object4;
                    object4 = this.getGi();
                    Intrinsics.checkNotNull((Object)object4);
                    object3 = controlPath.getPoint(((GroupIterator)object4).next());
                    Intrinsics.checkNotNull((Object)object3);
                    LagrangeCurve.pt[i] = object3.getLocation();
                } while (n3 <= n4);
            }
            object = this.knotVector;
            Intrinsics.checkNotNull((Object)object);
            double d = ((ValueVector)object).get(0);
            object = this.knotVector;
            Intrinsics.checkNotNull((Object)object);
            b = this.doBCAA(mp, d, ((ValueVector)object).get(this.baseIndex), b);
        }
        object = this.getGi();
        Intrinsics.checkNotNull((Object)object);
        ((GroupIterator)object).set(0, 0);
        int last_i = 0;
        int last_j = 0;
        while (true) {
            Object object5;
            GroupIterator i = this.getGi();
            Intrinsics.checkNotNull((Object)i);
            int temp_i = i.index_i();
            GroupIterator groupIterator2 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator2);
            int temp_j = groupIterator2.count_j();
            int index_i = 0;
            int count_j = 0;
            int j = 0;
            int i2 = 0;
            while (true) {
                object5 = this.knotVector;
                Intrinsics.checkNotNull((Object)object5);
                if (j >= ((ValueVector)object5).size()) break;
                if (i2 == this.baseLength) {
                    object5 = this.getGi();
                    Intrinsics.checkNotNull((Object)object5);
                    index_i = ((GroupIterator)object5).index_i();
                    object5 = this.getGi();
                    Intrinsics.checkNotNull((Object)object5);
                    count_j = ((GroupIterator)object5).count_j();
                }
                object5 = this.getGi();
                Intrinsics.checkNotNull((Object)object5);
                if (!((GroupIterator)object5).hasNext()) break;
                Object object6 = this.getCp();
                Intrinsics.checkNotNull((Object)object6);
                ControlPath controlPath = object6;
                object6 = this.getGi();
                Intrinsics.checkNotNull((Object)object6);
                object5 = controlPath.getPoint(((GroupIterator)object6).next());
                Intrinsics.checkNotNull((Object)object5);
                LagrangeCurve.pt[j] = object5.getLocation();
                int n5 = i2;
                i2 = n5 + 1;
                n5 = j;
                j = n5 + 1;
            }
            object5 = this.knotVector;
            Intrinsics.checkNotNull((Object)object5);
            if (j < ((ValueVector)object5).size()) break;
            object5 = this.getGi();
            Intrinsics.checkNotNull((Object)object5);
            ((GroupIterator)object5).set(index_i, count_j);
            last_i = temp_i;
            last_j = temp_j;
            object5 = this.knotVector;
            Intrinsics.checkNotNull((Object)object5);
            double d = ((ValueVector)object5).get(this.baseIndex);
            object5 = this.knotVector;
            Intrinsics.checkNotNull((Object)object5);
            b = this.doBCAA(mp, d, ((ValueVector)object5).get(this.baseIndex + this.baseLength), b);
        }
        Object object7 = this.knotVector;
        Intrinsics.checkNotNull((Object)object7);
        if (this.baseIndex + this.baseLength < ((ValueVector)object7).size() - 1 && this.interpolateLast) {
            object7 = this.getGi();
            Intrinsics.checkNotNull((Object)object7);
            ((GroupIterator)object7).set(last_i, last_j);
            ValueVector valueVector = this.knotVector;
            Intrinsics.checkNotNull((Object)valueVector);
            int n6 = valueVector.size();
            int n7 = 0;
            int n8 = n6 + -1;
            if (n6 != Integer.MIN_VALUE && n7 <= n8) {
                do {
                    int i = n7++;
                    Object object8 = this.getGi();
                    Intrinsics.checkNotNull((Object)object8);
                    if (!((GroupIterator)object8).hasNext()) {
                        object8 = "not enough points to interpolate last";
                        boolean bl = false;
                        System.out.println(object8);
                        return;
                    }
                    Object object9 = this.getCp();
                    Intrinsics.checkNotNull((Object)object9);
                    ControlPath controlPath = object9;
                    object9 = this.getGi();
                    Intrinsics.checkNotNull((Object)object9);
                    object8 = controlPath.getPoint(((GroupIterator)object9).next());
                    Intrinsics.checkNotNull((Object)object8);
                    LagrangeCurve.pt[i] = object8.getLocation();
                } while (n7 <= n8);
            }
            ValueVector valueVector2 = this.knotVector;
            Intrinsics.checkNotNull((Object)valueVector2);
            double d = valueVector2.get(this.baseIndex + this.baseLength);
            valueVector2 = this.knotVector;
            Intrinsics.checkNotNull((Object)valueVector2);
            ValueVector valueVector3 = valueVector2;
            valueVector2 = this.knotVector;
            Intrinsics.checkNotNull((Object)valueVector2);
            this.doBCAA(mp, d, valueVector3.get(valueVector2.size() - 1), b);
        }
    }

    private final boolean doBCAA(MultiPath mp, double t1, double t2, boolean b) {
        double t12 = t1;
        double t22 = t2;
        boolean b2 = b;
        if (t22 < t12) {
            double temp = t12;
            t12 = t22;
            t22 = temp;
        }
        if (!b2) {
            b2 = true;
            double[] d = new double[mp.getDimension() + 1];
            d[mp.getDimension()] = t12;
            this.eval(d);
            if (this.getConnect()) {
                mp.lineTo(d);
            } else {
                mp.moveTo(d);
            }
        }
        BinaryCurveApproximationAlgorithm.INSTANCE.genPts(this, t12, t22, mp);
        return b2;
    }

    @Override
    public void eval(@NotNull double[] p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        double t = p[p.length - 1];
        ValueVector valueVector = this.knotVector;
        Intrinsics.checkNotNull((Object)valueVector);
        int n = valueVector.size();
        int n2 = 0;
        int n3 = n + -1;
        if (n != Integer.MIN_VALUE && n2 <= n3) {
            do {
                int i = n2++;
                double[] q = pt[i];
                double L = this.L(t, i);
                int n4 = p.length - 1;
                int n5 = 0;
                int n6 = n4 + -1;
                if (n4 == Integer.MIN_VALUE || n5 > n6) continue;
                do {
                    int j = n5++;
                    double[] dArray = p;
                    int n7 = j;
                    double d = dArray[n7];
                    Intrinsics.checkNotNull((Object)q);
                    dArray[n7] = d + q[j] * L;
                } while (n5 <= n6);
            } while (n2 <= n3);
        }
    }

    @Override
    public int getSampleLimit() {
        return 1;
    }

    private final double L(double t, int i) {
        double d = 1.0;
        ValueVector valueVector = this.knotVector;
        Intrinsics.checkNotNull((Object)valueVector);
        int n = valueVector.size();
        int n2 = 0;
        int n3 = n + -1;
        if (n != Integer.MIN_VALUE && n2 <= n3) {
            do {
                int j = n2++;
                ValueVector valueVector2 = this.knotVector;
                Intrinsics.checkNotNull((Object)valueVector2);
                double d2 = valueVector2.get(i);
                valueVector2 = this.knotVector;
                Intrinsics.checkNotNull((Object)valueVector2);
                double e = d2 - valueVector2.get(j);
                if (e == 0.0) continue;
                valueVector2 = this.knotVector;
                Intrinsics.checkNotNull((Object)valueVector2);
                d *= (t - valueVector2.get(j)) / e;
            } while (n2 <= n3);
        }
        return d;
    }

    @Override
    public void resetMemory() {
        if (((Object[])pt).length > 0) {
            pt = new double[0][];
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0002\b\u0002R\u0018\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/kamaeleo/geom/curve/LagrangeCurve$Companion;", "", "pt", "", "", "[[D", "kamaeleo"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

