/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.labeling;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.properties.Properties;
import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.PropertyEvent;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.BreakIterator;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.color.CPColor;
import org.kamaeleo.font.CPFont;
import org.kamaeleo.labeling.EnhancedLabel;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000 >2\u00020\u0001:\u0002>?B\f\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003B\u0002\b\u0016B\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005J\u0012\u0010,\u001a\u0004\u0018\u00010\u00032\b\u0010-\u001a\u0004\u0018\u00010\u0003J\n\u0010.\u001a\u0004\u0018\u00010/H\u0016J\b\u00100\u001a\u00020\rH\u0016J\b\u00101\u001a\u00020\rH\u0016J\u000e\u00101\u001a\u00020\r2\u0006\u00102\u001a\u000203J\b\u00104\u001a\u00020\rH\u0016J\u000e\u00104\u001a\u00020\r2\u0006\u00102\u001a\u000203J\u0010\u00105\u001a\u0002062\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J\u000e\u00107\u001a\u0002062\u0006\u0010\u0004\u001a\u00020\u0005J\u0010\u00108\u001a\u0002062\b\u00109\u001a\u0004\u0018\u00010:J\u0012\u0010;\u001a\u0002062\b\u0010<\u001a\u0004\u0018\u00010/H\u0016J\u0012\u0010=\u001a\u0002062\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0014R$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R$\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00138F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R$\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00198F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR(\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0018\u0010$\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010&\u001a\u0004\u0018\u00010'2\b\u0010&\u001a\u0004\u0018\u00010'8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+\u00a8\u0006@"}, d2={"Lorg/kamaeleo/labeling/EnhancedJLabel;", "Ljavax/swing/JLabel;", "text", "", "data", "Lorg/kamaeleo/labeling/EnhancedLabel;", "angle", "", "getAngle", "()D", "setAngle", "(D)V", "desiredSize", "Ljava/awt/Dimension;", "getDesiredSize", "()Ljava/awt/Dimension;", "setDesiredSize", "(Ljava/awt/Dimension;)V", "effectOpacity", "", "getEffectOpacity", "()F", "setEffectOpacity", "(F)V", "justified", "", "isJustified", "()Z", "setJustified", "(Z)V", "minimumCharactersToDisplay", "", "getMinimumCharactersToDisplay", "()Ljava/lang/Integer;", "setMinimumCharactersToDisplay", "(Ljava/lang/Integer;)V", "propertiesListener", "Lcom/macrofocus/common/properties/PropertiesListener;", "rendering", "Lorg/kamaeleo/labeling/EnhancedLabel$Rendering;", "getRendering", "()Lorg/kamaeleo/labeling/EnhancedLabel$Rendering;", "setRendering", "(Lorg/kamaeleo/labeling/EnhancedLabel$Rendering;)V", "addTag", "value", "getFont", "Ljava/awt/Font;", "getMaximumSize", "getMinimumSize", "g2", "Ljava/awt/Graphics2D;", "getPreferredSize", "registerListener", "", "setData", "setEffect", "effect", "Lorg/kamaeleo/labeling/EnhancedLabel$Effect;", "setFont", "font", "unregisterListener", "Companion", "EnhancedLabelUI", "kamaeleo"})
@StabilityInferred(parameters=0)
public class EnhancedJLabel
extends JLabel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private EnhancedLabel data;
    @Nullable
    private PropertiesListener<String> propertiesListener;
    public static final int $stable = 8;

    public EnhancedJLabel(@NotNull EnhancedLabel data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.setUI(new EnhancedLabelUI());
        this.setData(data);
    }

    public EnhancedJLabel(@Nullable String text) {
        this();
        this.setText(text);
    }

    public EnhancedJLabel() {
        this(new EnhancedLabel());
        this.setUI(new EnhancedLabelUI());
    }

    @NotNull
    public final Dimension getMinimumSize(@NotNull Graphics2D g2) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        ComponentUI componentUI = this.ui;
        if (componentUI == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.kamaeleo.labeling.EnhancedJLabel.EnhancedLabelUI");
        }
        return ((EnhancedLabelUI)componentUI).getMinimumSize(g2, this);
    }

    @NotNull
    public final Dimension getPreferredSize(@NotNull Graphics2D g2) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        ComponentUI componentUI = this.ui;
        if (componentUI == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.kamaeleo.labeling.EnhancedJLabel.EnhancedLabelUI");
        }
        return ((EnhancedLabelUI)componentUI).getPreferredSize(g2, this);
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"super.getPreferredSize()");
        return dimension;
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"super.getMinimumSize()");
        return dimension;
    }

    public final void setData(@NotNull EnhancedLabel data) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.unregisterListener(this.data);
        this.data = data;
        if (data.isHTML()) {
            super.setText(this.addTag(data.getText()));
        } else {
            super.setText(data.getText());
        }
        super.setVerticalAlignment(data.getVerticalAlignment());
        super.setHorizontalAlignment(data.getHorizontalAlignment());
        if (data.getFont() != null) {
            object = data.getFont();
            Intrinsics.checkNotNull((Object)object);
            super.setFont(((CPFont)object).getNativeFont());
        }
        if (data.getForeground() != null) {
            object = data.getForeground();
            Intrinsics.checkNotNull((Object)object);
            super.setForeground(((CPColor)object).getNativeColor());
        }
        if (data.getBackground() != null) {
            object = data.getBackground();
            Intrinsics.checkNotNull((Object)object);
            super.setBackground(((CPColor)object).getNativeColor());
        }
        super.setBorder(BorderFactory.createEmptyBorder(data.getInsetTop(), data.getInsetLeft(), data.getInsetBottom(), data.getInsetRight()));
        this.registerListener(data);
    }

    @Nullable
    public final String addTag(@Nullable String value) {
        return value != null ? (!StringsKt.startsWith$default((String)value, (String)"<html>", (boolean)false, (int)2, null) ? "<html>" + value + "</html>" : value) : (String)null;
    }

    protected void unregisterListener(@Nullable EnhancedLabel data) {
        if (data != null) {
            Properties<String> properties = data.getProperties();
            Intrinsics.checkNotNull(properties);
            Properties<String> properties2 = properties;
            properties = this.propertiesListener;
            Intrinsics.checkNotNull(properties);
            properties2.removePropertiesListener(properties);
        }
    }

    protected void registerListener(@NotNull EnhancedLabel data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (this.propertiesListener == null) {
            this.propertiesListener = (PropertiesListener)new PropertiesListener<String>(this){
                final /* synthetic */ EnhancedJLabel this$0;
                {
                    this.this$0 = $receiver;
                }

                public void propertyChanged(@Nullable String name, @NotNull PropertyEvent<Object> event2) {
                    Intrinsics.checkNotNullParameter(event2, (String)"event");
                    this.this$0.repaint();
                }
            };
        }
        Properties<String> properties = data.getProperties();
        Intrinsics.checkNotNull(properties);
        Properties<String> properties2 = properties;
        properties = this.propertiesListener;
        Intrinsics.checkNotNull(properties);
        properties2.addWeakPropertiesListener(properties);
    }

    public final void setEffect(@Nullable EnhancedLabel.Effect effect) {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        Intrinsics.checkNotNull((Object)((Object)effect));
        enhancedLabel.setEffect(effect);
    }

    public final float getEffectOpacity() {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        return enhancedLabel.getEffectOpacity();
    }

    public final void setEffectOpacity(float effectOpacity) {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        enhancedLabel.getEffectOpacity();
    }

    @Nullable
    public final EnhancedLabel.Rendering getRendering() {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        return enhancedLabel.getRendering();
    }

    public final void setRendering(@Nullable EnhancedLabel.Rendering rendering) {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        Intrinsics.checkNotNull((Object)((Object)rendering));
        enhancedLabel.setRendering(rendering);
    }

    @Nullable
    public final Integer getMinimumCharactersToDisplay() {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        return enhancedLabel.getMinimumCharactersToDisplay();
    }

    public final void setMinimumCharactersToDisplay(@Nullable Integer minimumCharactersToDisplay) {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        enhancedLabel.getMinimumCharactersToDisplay();
    }

    public final boolean isJustified() {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        return enhancedLabel.isJustified();
    }

    public final void setJustified(boolean justified) {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        enhancedLabel.setJustified(justified);
    }

    public final double getAngle() {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        return enhancedLabel.getAngle();
    }

    public final void setAngle(double angle) {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        enhancedLabel.setAngle(angle);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    public Font getFont() {
        Font font;
        if (this.data != null) {
            Object object = this.data;
            Intrinsics.checkNotNull((Object)object);
            if (((EnhancedLabel)object).getFont() != null) {
                EnhancedLabel enhancedLabel = this.data;
                Intrinsics.checkNotNull((Object)enhancedLabel);
                object = enhancedLabel.getFont();
                Intrinsics.checkNotNull((Object)object);
                font = ((CPFont)object).getNativeFont();
                return font;
            }
        }
        font = super.getFont();
        return font;
    }

    @Override
    public void setFont(@Nullable Font font) {
        Font oldFont = this.getFont();
        if (this.data != null) {
            EnhancedLabel enhancedLabel = this.data;
            Intrinsics.checkNotNull((Object)enhancedLabel);
            Intrinsics.checkNotNull((Object)font);
            enhancedLabel.setFont(new CPFont(font));
        } else {
            super.setFont(font);
        }
        this.firePropertyChange("font", oldFont, font);
    }

    @Override
    @NotNull
    public Dimension getMaximumSize() {
        Dimension dimension = super.getMaximumSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"super.getMaximumSize()");
        return dimension;
    }

    @NotNull
    public final Dimension getDesiredSize() {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        int n = enhancedLabel.getDesiredWidth();
        enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        return new Dimension(n, enhancedLabel.getDesiredWidth());
    }

    public final void setDesiredSize(@NotNull Dimension desiredSize) {
        Intrinsics.checkNotNullParameter((Object)desiredSize, (String)"desiredSize");
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        enhancedLabel.setDesiredWidth(desiredSize.width);
        enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        enhancedLabel.setDesiredHeight(desiredSize.height);
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u000e\b\u0084\u0004\u0018\u00002\u00020\u0001B\u0000J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0012\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ*\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0004JD\u0010\u001c\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00142\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0003H\u0014J\u0018\u0010$\u001a\u00020%2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J0\u0010&\u001a\u00020%2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u001aH\u0014J4\u0010)\u001a\u00020%2\u0006\u0010\f\u001a\u00020*2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00142\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010'\u001a\u00020-2\u0006\u0010(\u001a\u00020-H\u0002J0\u0010.\u001a\u00020%2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u001aH\u0014JD\u0010/\u001a\u00020%2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00142\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u001a2\u0006\u00100\u001a\u00020,2\b\u00101\u001a\u0004\u0018\u00010,H\u0002J\"\u00102\u001a\u00020%2\u0006\u0010\f\u001a\u00020*2\b\u00103\u001a\u0004\u0018\u00010\u00142\b\u0010\u000e\u001a\u0004\u0018\u00010,J\"\u00104\u001a\u00020%2\u0006\u0010\f\u001a\u00020*2\b\u00103\u001a\u0004\u0018\u00010\u00142\b\u00105\u001a\u0004\u0018\u00010,J\"\u00106\u001a\u00020%2\u0006\u0010\f\u001a\u00020*2\b\u00103\u001a\u0004\u0018\u00010\u00142\b\u0010\u000e\u001a\u0004\u0018\u00010,JP\u00107\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\f\u001a\u0004\u0018\u00010*2\u0006\u0010\u001d\u001a\u00020\u00182\b\u0010\u001e\u001a\u0004\u0018\u00010\u00142\u0006\u00108\u001a\u00020\u001a2\u0006\u00109\u001a\u00020\u001a2\b\u00100\u001a\u0004\u0018\u00010,2\b\u00101\u001a\u0004\u0018\u00010,H\u0002J\u0012\u0010:\u001a\u0004\u0018\u00010,2\b\u0010\u000e\u001a\u0004\u0018\u00010,R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/kamaeleo/labeling/EnhancedJLabel$EnhancedLabelUI;", "Ljavax/swing/plaf/basic/BasicLabelUI;", "paintIconR", "Ljava/awt/Rectangle;", "paintTextR", "useSwingPaintText", "", "createAffineTransform", "Ljava/awt/geom/AffineTransform;", "dimension", "Ljava/awt/Dimension;", "getMinimumSize", "g", "Ljava/awt/Graphics;", "c", "Ljavax/swing/JComponent;", "getPreferredSize", "getRotatedDimension", "getUnrotatedPreferredSize", "layout", "", "label", "Ljavax/swing/JLabel;", "fm", "Ljava/awt/FontMetrics;", "width", "", "height", "layoutCL", "fontMetrics", "text", "icon", "Ljavax/swing/Icon;", "viewR", "iconR", "textR", "paint", "", "paintDisabledText", "x", "y", "paintEffect", "Ljava/awt/Graphics2D;", "color", "Ljava/awt/Color;", "", "paintEnabledText", "paintText", "foreground", "background", "paintTextEmphasize", "s", "paintTextGlow", "glow", "paintTextShadow", "paintWordWrapText", "desiredWidth", "yStart", "removeAlpha", "kamaeleo"})
    protected final class EnhancedLabelUI
    extends BasicLabelUI {
        private final boolean useSwingPaintText;
        @NotNull
        private final Rectangle paintIconR;
        @NotNull
        private final Rectangle paintTextR;

        public EnhancedLabelUI() {
            Intrinsics.checkNotNullParameter((Object)EnhancedJLabel.this, (String)"this$0");
            this.paintIconR = new Rectangle();
            this.paintTextR = new Rectangle();
        }

        @Override
        public void paint(@NotNull Graphics g, @NotNull JComponent c2) {
            int n;
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
            Graphics2D g2 = (Graphics2D)g;
            JLabel label = (JLabel)c2;
            EnhancedLabel.Rendering rendering = EnhancedJLabel.this.getRendering();
            int n2 = n = rendering == null ? -1 : WhenMappings.$EnumSwitchMapping$0[rendering.ordinal()];
            if (n == 1) {
                int n3;
                Serializable d;
                int y = 0;
                if (label.getVerticalAlignment() != 1) {
                    d = this.getPreferredSize(g, c2);
                    int n4 = label.getVerticalAlignment();
                    switch (n4) {
                        case 0: {
                            n3 = Math.max(0, (c2.getHeight() - d.height) / 2);
                            break;
                        }
                        case 3: {
                            n3 = Math.max(0, c2.getHeight() - d.height);
                            break;
                        }
                        default: {
                            n3 = 0;
                            break;
                        }
                    }
                } else {
                    n3 = 0;
                }
                y = n3;
                g2.setFont(EnhancedJLabel.this.getFont());
                d = g2.getFontMetrics();
                Intrinsics.checkNotNullExpressionValue((Object)d, (String)"g2.fontMetrics");
                this.paintWordWrapText(label, g2, (FontMetrics)d, EnhancedJLabel.this.getText(), EnhancedJLabel.this.getDesiredSize().width, y, label.getForeground(), label.getBackground());
            } else {
                Icon icon;
                Icon icon2;
                int y = label.getHorizontalAlignment();
                switch (y) {
                    default: 
                }
                y = label.getVerticalAlignment();
                switch (y) {
                    default: 
                }
                String text = label.getText();
                Icon icon3 = icon2 = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
                if (icon2 == null && text == null) {
                    return;
                }
                FontMetrics fm = label.getFontMetrics(g2.getFont());
                int width = 0;
                int height = 0;
                width = c2.getWidth();
                height = c2.getHeight();
                Intrinsics.checkNotNullExpressionValue((Object)fm, (String)"fm");
                String clippedText = this.layout(label, fm, width, height);
                if (!(EnhancedJLabel.this.getAngle() == 0.0)) {
                    g2.rotate(Math.PI * EnhancedJLabel.this.getAngle() / 180.0, this.paintTextR.getCenterX(), this.paintTextR.getCenterY());
                }
                if ((icon = icon2) != null) {
                    icon.paintIcon(c2, g2, this.paintIconR.x, this.paintIconR.y);
                }
                if (text != null) {
                    View v = (View)c2.getClientProperty("html");
                    if (v != null) {
                        v.paint(g2, this.paintTextR);
                    } else {
                        int textX = this.paintTextR.x;
                        int textY = this.paintTextR.y + fm.getAscent();
                        if (label.isEnabled()) {
                            Graphics graphics = g2;
                            Intrinsics.checkNotNull((Object)clippedText);
                            this.paintEnabledText(label, graphics, clippedText, textX, textY);
                        } else {
                            Graphics graphics = g2;
                            Intrinsics.checkNotNull((Object)clippedText);
                            this.paintDisabledText(label, graphics, clippedText, textX, textY);
                        }
                    }
                }
            }
        }

        @Nullable
        protected final String layout(@NotNull JLabel label, @NotNull FontMetrics fm, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)fm, (String)"fm");
            Insets insets = label.getInsets(null);
            String text = label.getText();
            Icon icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
            Rectangle paintViewR = new Rectangle();
            paintViewR.x = insets.left;
            paintViewR.y = insets.top;
            paintViewR.width = width - (insets.left + insets.right);
            paintViewR.height = height - (insets.top + insets.bottom);
            this.paintIconR.x = this.paintIconR.y = (this.paintIconR.width = (this.paintIconR.height = 0));
            this.paintTextR.x = this.paintTextR.y = (this.paintTextR.width = (this.paintTextR.height = 0));
            Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
            return this.layoutCL(label, fm, text, icon, paintViewR, this.paintIconR, this.paintTextR);
        }

        @NotNull
        public final Dimension getMinimumSize(@NotNull Graphics g, @NotNull JComponent c2) {
            Dimension dimension;
            int n;
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
            EnhancedLabel.Rendering rendering = EnhancedJLabel.this.getRendering();
            int n2 = n = rendering == null ? -1 : WhenMappings.$EnumSwitchMapping$0[rendering.ordinal()];
            if (n == 1) {
                Graphics2D g2 = (Graphics2D)g;
                EnhancedJLabel label = (EnhancedJLabel)c2;
                g2.setFont(EnhancedJLabel.this.getFont());
                FontMetrics fontMetrics = g2.getFontMetrics(EnhancedJLabel.this.getFont());
                JLabel jLabel = label;
                Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"fontMetrics");
                Dimension d = this.paintWordWrapText(jLabel, null, fontMetrics, EnhancedJLabel.this.getText(), label.getDesiredSize().width, 0, null, null);
                dimension = new Dimension(d.width, fontMetrics.getHeight());
            } else {
                dimension = this.getPreferredSize(c2);
            }
            return dimension;
        }

        @Override
        @NotNull
        public Dimension getMinimumSize(@NotNull JComponent c2) {
            Dimension dimension;
            int n;
            Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
            EnhancedLabel.Rendering rendering = EnhancedJLabel.this.getRendering();
            int n2 = n = rendering == null ? -1 : WhenMappings.$EnumSwitchMapping$0[rendering.ordinal()];
            if (n == 1) {
                EnhancedJLabel label = (EnhancedJLabel)c2;
                JLabel jLabel = label;
                FontMetrics fontMetrics = label.getFontMetrics(label.getFont());
                Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"label.getFontMetrics(label.font)");
                Dimension d = this.paintWordWrapText(jLabel, null, fontMetrics, EnhancedJLabel.this.getText(), label.getDesiredSize().width, 0, null, null);
                dimension = new Dimension(d.width, EnhancedJLabel.this.getFontMetrics(EnhancedJLabel.this.getFont()).getHeight());
            } else {
                dimension = this.getPreferredSize(c2);
            }
            return dimension;
        }

        @NotNull
        public final Dimension getPreferredSize(@NotNull Graphics g, @NotNull JComponent c2) {
            int n;
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
            Insets insets = EnhancedJLabel.this.getInsets();
            Dimension size = null;
            EnhancedLabel.Rendering rendering = EnhancedJLabel.this.getRendering();
            int n2 = n = rendering == null ? -1 : WhenMappings.$EnumSwitchMapping$0[rendering.ordinal()];
            if (n == 1) {
                Graphics2D g2 = (Graphics2D)g;
                EnhancedJLabel label = (EnhancedJLabel)c2;
                g2.setFont(EnhancedJLabel.this.getFont());
                JLabel jLabel = label;
                FontMetrics fontMetrics = g2.getFontMetrics(EnhancedJLabel.this.getFont());
                Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"g2.getFontMetrics(font)");
                Dimension d = this.paintWordWrapText(jLabel, null, fontMetrics, EnhancedJLabel.this.getText(), label.getDesiredSize().width, 0, null, null);
                size = new Dimension(d.width, d.height);
            } else {
                Dimension dimension;
                if (!(EnhancedJLabel.this.getAngle() == 0.0)) {
                    Dimension dimension2 = super.getPreferredSize(c2);
                    Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"super.getPreferredSize(c)");
                    Dimension d = this.getRotatedDimension(dimension2);
                    dimension = new Dimension(d.width + insets.left + insets.right, d.height + insets.top + insets.bottom);
                } else {
                    Dimension dimension3 = super.getPreferredSize(c2);
                    Intrinsics.checkNotNullExpressionValue((Object)dimension3, (String)"{\n                    super.getPreferredSize(c)\n                }");
                    dimension = dimension3;
                }
                size = dimension;
            }
            return size;
        }

        @Override
        @NotNull
        public Dimension getPreferredSize(@NotNull JComponent c2) {
            Dimension dimension;
            Dimension d;
            Serializable serializable;
            int n;
            Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
            Insets insets = EnhancedJLabel.this.getInsets();
            Dimension size = null;
            EnhancedLabel.Rendering rendering = EnhancedJLabel.this.getRendering();
            int n2 = n = rendering == null ? -1 : WhenMappings.$EnumSwitchMapping$0[rendering.ordinal()];
            if (n == 1) {
                EnhancedJLabel label = (EnhancedJLabel)c2;
                JLabel jLabel = label;
                serializable = label.getFontMetrics(label.getFont());
                Intrinsics.checkNotNullExpressionValue((Object)serializable, (String)"label.getFontMetrics(label.font)");
                d = this.paintWordWrapText(jLabel, null, (FontMetrics)serializable, EnhancedJLabel.this.getText(), label.getDesiredSize().width, 0, null, null);
                dimension = new Dimension(d.width, d.height);
            } else {
                Dimension dimension2;
                if (!(EnhancedJLabel.this.getAngle() == 0.0)) {
                    serializable = super.getPreferredSize(c2);
                    Intrinsics.checkNotNullExpressionValue((Object)serializable, (String)"super.getPreferredSize(c)");
                    d = this.getRotatedDimension((Dimension)serializable);
                    dimension2 = new Dimension(d.width + insets.left + insets.right, d.height + insets.top + insets.bottom);
                } else {
                    dimension2 = super.getPreferredSize(c2);
                }
                Dimension dimension3 = dimension2;
                Intrinsics.checkNotNullExpressionValue((Object)dimension3, (String)"if (angle != 0.0) {\n                    val d = getRotatedDimension(super.getPreferredSize(c))\n                    Dimension(d.width + insets.left + insets.right, d.height + insets.top + insets.bottom)\n                } else {\n                    super.getPreferredSize(c)\n                }");
                dimension = dimension3;
            }
            size = dimension;
            return size;
        }

        private final Dimension getRotatedDimension(Dimension dimension) {
            AffineTransform at = this.createAffineTransform(dimension);
            Rectangle rect = at.createTransformedShape(new Rectangle(dimension)).getBounds();
            return new Dimension(rect.width, rect.height);
        }

        private final AffineTransform createAffineTransform(Dimension dimension) {
            AffineTransform at = new AffineTransform();
            at.rotate(Math.PI * EnhancedJLabel.this.getAngle() / 180.0, dimension.getWidth() / 2.0, dimension.getHeight() / 2.0);
            return at;
        }

        @NotNull
        public final Dimension getUnrotatedPreferredSize(@Nullable JComponent c2) {
            Dimension dimension = super.getPreferredSize(c2);
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"super.getPreferredSize(c)");
            return dimension;
        }

        @Override
        protected void paintEnabledText(@NotNull JLabel label, @NotNull Graphics g, @NotNull String text, int x, int y) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Color color = label.getForeground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"label.foreground");
            this.paintText(label, g, text, x, y, color, label.getBackground());
        }

        @Override
        protected void paintDisabledText(@NotNull JLabel label, @NotNull Graphics g, @NotNull String text, int x, int y) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Color color = label.getForeground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"label.foreground");
            this.paintText(label, g, text, x, y, color, label.getBackground());
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @Nullable
        protected String layoutCL(@NotNull JLabel label, @NotNull FontMetrics fontMetrics, @NotNull String text, @Nullable Icon icon, @NotNull Rectangle viewR, @NotNull Rectangle iconR, @NotNull Rectangle textR) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)viewR, (String)"viewR");
            Intrinsics.checkNotNullParameter((Object)iconR, (String)"iconR");
            Intrinsics.checkNotNullParameter((Object)textR, (String)"textR");
            var8_8 = EnhancedJLabel.this.getRendering();
            var9_9 = var8_8 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[var8_8.ordinal()];
            switch (var9_9) {
                case 2: {
                    truncatedString = super.layoutCL(label, fontMetrics, text, icon, viewR, iconR, textR);
                    if (Intrinsics.areEqual((Object)text, (Object)truncatedString)) ** GOTO lbl-1000
                    if (truncatedString == null || truncatedString.length() <= 3) ** GOTO lbl-1000
                    if (EnhancedJLabel.this.getMinimumCharactersToDisplay() == null) ** GOTO lbl-1000
                    v0 = truncatedString.length() - 3;
                    var11_12 = EnhancedJLabel.this.getMinimumCharactersToDisplay();
                    Intrinsics.checkNotNull((Object)var11_12);
                    if (v0 >= var11_12) lbl-1000:
                    // 3 sources

                    {
                        v1 = truncatedString;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = null;
                    }
                    return v1;
                }
                case 3: {
                    clippedString = super.layoutCL(label, fontMetrics, text, icon, viewR, iconR, textR);
                    if (Intrinsics.areEqual((Object)text, (Object)clippedString) || clippedString == null || EnhancedJLabel.this.getMinimumCharactersToDisplay() == null) break;
                    v2 = clippedString.length();
                    var11_13 = EnhancedJLabel.this.getMinimumCharactersToDisplay();
                    Intrinsics.checkNotNull((Object)var11_13);
                    if (v2 >= var11_13) break;
                    return null;
                }
            }
            return text;
        }

        private final void paintText(JLabel label, Graphics g, String text, int x, int y, Color foreground, Color background) {
            g.setColor(foreground);
            if (background != null) {
                g.translate(x, y);
                EnhancedLabel enhancedLabel = EnhancedJLabel.this.data;
                Intrinsics.checkNotNull((Object)enhancedLabel);
                EnhancedLabel.Effect effect = enhancedLabel.getEffect();
                int n = WhenMappings.$EnumSwitchMapping$1[effect.ordinal()];
                switch (n) {
                    case 1: {
                        Color color = background;
                        this.paintTextShadow((Graphics2D)g, text, color);
                        break;
                    }
                    case 2: {
                        Color color = background;
                        this.paintTextGlow((Graphics2D)g, text, color);
                        break;
                    }
                    case 3: {
                        Color color = background;
                        this.paintTextGlow((Graphics2D)g, text, color);
                        break;
                    }
                    case 4: {
                        Color color = background;
                        this.paintTextEmphasize((Graphics2D)g, text, color);
                    }
                }
                g.translate(-x, -y);
            }
            if (this.useSwingPaintText) {
                super.paintEnabledText(label, g, text, x, y);
            } else if (text != null) {
                g.drawString(text, x, y);
            }
        }

        private final Dimension paintWordWrapText(JLabel label, Graphics2D g, FontMetrics fontMetrics, String text, int desiredWidth, int yStart, Color foreground, Color background) {
            Insets insets = EnhancedJLabel.this.getInsets();
            int width = desiredWidth + (insets.left + insets.right);
            float w = (float)insets.left + (float)insets.right;
            float x = insets.left;
            float y = (float)yStart + (float)insets.top;
            if (desiredWidth > 0 && text != null && text.length() > 0) {
                if (g != null) {
                    // empty if block
                }
                AttributedString as = new AttributedString(text);
                as.addAttribute(TextAttribute.FONT, EnhancedJLabel.this.getFont());
                as.addAttribute(TextAttribute.FOREGROUND, foreground);
                AttributedCharacterIterator aci = as.getIterator();
                FontRenderContext fontRenderContext = fontMetrics.getFontRenderContext();
                BreakIterator breakIterator = BreakIterator.getLineInstance();
                LineBreakMeasurer lbm = new LineBreakMeasurer(aci, breakIterator, fontRenderContext);
                float max = 0.0f;
                try {
                    while (lbm.getPosition() < aci.getEndIndex()) {
                        TextLayout layout = lbm.nextLayout(desiredWidth);
                        if (g != null && EnhancedJLabel.this.isJustified() && (double)layout.getVisibleAdvance() > 0.8 * (double)desiredWidth) {
                            layout = layout.getJustifiedLayout(desiredWidth);
                        }
                        float ascent = layout.getAscent();
                        float visibleAdvance = layout.getVisibleAdvance();
                        if (g != null) {
                            int n = label.getHorizontalAlignment();
                            switch (n) {
                                case 2: 
                                case 10: {
                                    layout.draw(g, x, y + ascent);
                                    break;
                                }
                                case 0: {
                                    float leftMargin = insets.left;
                                    float rightMargin = (float)EnhancedJLabel.this.getWidth() - (float)insets.right;
                                    layout.draw(g, (leftMargin + rightMargin - visibleAdvance) / (float)2, y + ascent);
                                    break;
                                }
                                case 4: 
                                case 11: {
                                    float rightMargin = (float)EnhancedJLabel.this.getWidth() - (float)insets.right;
                                    layout.draw(g, rightMargin - visibleAdvance, y + ascent);
                                    break;
                                }
                                default: {
                                    layout.draw(g, x, y + ascent);
                                }
                            }
                        }
                        float leading = layout.getLeading();
                        float descent = layout.getDescent();
                        y += descent + leading + ascent;
                        max = Math.max(max, visibleAdvance);
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
                w += max;
            }
            return new Dimension((int)Math.ceil(w), (int)Math.ceil(y) + insets.bottom);
        }

        private final void paintEffect(Graphics2D g, String text, Color color, double x, double y) {
            if (text != null) {
                Object oldTextAAHint = g.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                Composite oldComposite = g.getComposite();
                Color oldColor = g.getColor();
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g.setColor(color);
                g.translate(x, y);
                int additionalOffset = g.getFontMetrics().getHeight() / 32;
                EnhancedLabel enhancedLabel = EnhancedJLabel.this.data;
                Intrinsics.checkNotNull((Object)enhancedLabel);
                EnhancedLabel.Effect effect = enhancedLabel.getEffect();
                int n = WhenMappings.$EnumSwitchMapping$1[effect.ordinal()];
                switch (n) {
                    case 4: {
                        int size1 = 1 + additionalOffset;
                        int j = 0;
                        while (j < size1) {
                            double distance = (double)j * (double)j;
                            float alpha = EnhancedJLabel.this.getEffectOpacity();
                            if (distance > 0.0) {
                                alpha = (float)((double)0.5f / distance * (double)EnhancedJLabel.this.getEffectOpacity());
                            }
                            if (alpha > 1.0f) {
                                alpha = 1.0f;
                            }
                            g.setComposite(AlphaComposite.getInstance(3, alpha));
                            g.drawString(text, 0, j);
                            int n2 = j;
                            j = n2 + 1;
                        }
                        break;
                    }
                    case 1: {
                        int size = 1 + additionalOffset;
                        int i = 0;
                        while (i < size) {
                            int j = 0;
                            while (j < size) {
                                double distance = (double)(i * i) + (double)j * (double)j;
                                float alpha = EnhancedJLabel.this.getEffectOpacity();
                                if (distance > 0.0) {
                                    alpha = (float)((double)0.5f / distance * (double)EnhancedJLabel.this.getEffectOpacity());
                                }
                                if (alpha > 1.0f) {
                                    alpha = 1.0f;
                                }
                                g.setComposite(AlphaComposite.getInstance(3, alpha));
                                g.drawString(text, i, j);
                                int n3 = j;
                                j = n3 + 1;
                            }
                            int distance = i;
                            i = distance + 1;
                        }
                        break;
                    }
                    case 2: {
                        int size3 = 1 + additionalOffset;
                        int i = -size3;
                        while (i <= size3) {
                            int j = -size3;
                            while (j <= size3) {
                                double distance = (double)(i * i) + (double)j * (double)j;
                                float alpha = EnhancedJLabel.this.getEffectOpacity();
                                if (distance > 0.0) {
                                    alpha = (float)((double)1.0f / distance * (double)EnhancedJLabel.this.getEffectOpacity());
                                    if (alpha > 1.0f) {
                                        alpha = 1.0f;
                                    }
                                    g.setComposite(AlphaComposite.getInstance(3, alpha));
                                    g.drawString(text, i, j);
                                }
                                int n4 = j;
                                j = n4 + 1;
                            }
                            int n5 = i;
                            i = n5 + 1;
                        }
                        break;
                    }
                    case 3: {
                        Object oldAAHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        FontRenderContext frc = g.getFontRenderContext();
                        Font font = EnhancedJLabel.this.getFont();
                        Intrinsics.checkNotNull((Object)font);
                        GlyphVector gv = font.createGlyphVector(frc, text);
                        g.setStroke(new BasicStroke(2 + additionalOffset));
                        g.setComposite(AlphaComposite.getInstance(3, EnhancedJLabel.this.getEffectOpacity()));
                        g.draw(gv.getOutline());
                        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAAHint);
                    }
                }
                g.translate(-x, -y);
                g.setComposite(oldComposite);
                g.setColor(oldColor);
                if (oldTextAAHint != null) {
                    g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldTextAAHint);
                }
            }
        }

        public final void paintTextShadow(@NotNull Graphics2D g, @Nullable String s, @Nullable Color c2) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            this.paintEffect(g, s, this.removeAlpha(c2), 1.0, 1.0);
        }

        public final void paintTextEmphasize(@NotNull Graphics2D g, @Nullable String s, @Nullable Color c2) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            this.paintEffect(g, s, this.removeAlpha(c2), 0.0, 1.0);
        }

        public final void paintTextGlow(@NotNull Graphics2D g, @Nullable String s, @Nullable Color glow) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            this.paintEffect(g, s, this.removeAlpha(glow), 0.0, 0.0);
        }

        @Nullable
        public final Color removeAlpha(@Nullable Color c2) {
            Color c3 = c2;
            if (c3 != null && c3.getAlpha() != 100) {
                c3 = new Color(c3.getRGB());
            }
            return c3;
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[EnhancedLabel.Rendering.values().length];
                nArray[EnhancedLabel.Rendering.WordWrap.ordinal()] = 1;
                nArray[EnhancedLabel.Rendering.Truncate.ordinal()] = 2;
                nArray[EnhancedLabel.Rendering.Clip.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[EnhancedLabel.Effect.values().length];
                nArray[EnhancedLabel.Effect.Shadow.ordinal()] = 1;
                nArray[EnhancedLabel.Effect.Glow.ordinal()] = 2;
                nArray[EnhancedLabel.Effect.Outline.ordinal()] = 3;
                nArray[EnhancedLabel.Effect.Emphasize.ordinal()] = 4;
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0002\b\u0002J\u001b\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0007\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/kamaeleo/labeling/EnhancedJLabel$Companion;", "", "main", "", "args", "", "", "([Ljava/lang/String;)V", "kamaeleo"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            JFrame frame = new JFrame("EnhancedJLabel");
            frame.setSize(new Dimension(600, 600));
            frame.getContentPane().setLayout(new BorderLayout());
            EnhancedJLabel label = new EnhancedJLabel();
            label.setText("This is a test");
            Font font = label.getFont();
            Intrinsics.checkNotNull((Object)font);
            label.setFont(font.deriveFont(72.0f));
            label.setEffect(EnhancedLabel.Effect.Shadow);
            label.setBackground(Color.yellow);
            label.setRendering(EnhancedLabel.Rendering.Truncate);
            label.setVerticalAlignment(0);
            label.setHorizontalAlignment(0);
            label.setIconTextGap(0);
            frame.getContentPane().add((Component)label, "Center");
            frame.setVisible(true);
            Timer timer2 = new Timer(10, new ActionListener(label){
                final /* synthetic */ EnhancedJLabel $label;
                {
                    this.$label = $label;
                }

                public final void actionPerformed(ActionEvent it) {
                    this.$label.setAngle((this.$label.getAngle() + 1.0) % (double)360);
                }
            });
            timer2.start();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

