package org.kamaeleo.font

import java.awt.Font

actual class CPFont {
    val nativeFont: Font

    constructor(defaultFont: Font) {
        this.nativeFont = defaultFont
    }

    constructor() {
        this.nativeFont = Font("Helvetica", Font.PLAIN, 12)
    }

    actual fun getSize(): Double {
        return nativeFont.size2D.toDouble()
    }

    actual fun deriveFontSize(fontSize: Double): CPFont {
        return CPFont(nativeFont.deriveFont(fontSize.toFloat()))
    }

    actual fun getSize2D(): Double {
        return nativeFont.getSize2D().toDouble();
    }

    actual fun deriveFontWeight(weight: Weight): CPFont {
        var style = nativeFont.style
        when (weight) {
            Weight.NORMAL -> if (style and Font.BOLD == Font.BOLD) {
                style = style xor Font.BOLD
            }
            Weight.BOLD -> style = style or Font.BOLD
        }
        return CPFont(nativeFont.deriveFont(style))
    }
}