/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.color;

import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UnsignedKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.color.CPColor;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, xi=16, d1={"\u0000 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003\u001a(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0007\u001a\u0012\u0010\f\u001a\u00020\r*\u00020\r2\u0006\u0010\f\u001a\u00020\u0003\u001a\u001a\u0010\u000e\u001a\u00020\r*\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\n\u0010\u000f\u001a\u00020\r*\u00020\r\u001a\n\u0010\u0010\u001a\u00020\r*\u00020\r\u00a8\u0006\u0011"}, d2={"HSBtoRGB", "", "hue", "", "saturation", "brightness", "RGBtoHSB", "", "r", "g", "b", "hsbvals", "alpha", "Lorg/kamaeleo/color/CPColor;", "brightenAndSaturate", "brighter", "darker", "kamaeleo"})
public final class CPColorKt {
    @NotNull
    public static final CPColor brighter(@NotNull CPColor $this$brighter) {
        Intrinsics.checkNotNullParameter((Object)$this$brighter, (String)"<this>");
        double FACTOR = 0.7;
        byte by = $this$brighter.getRed-w2LRezQ();
        byte by2 = 0;
        int r = by & 0xFF;
        by2 = $this$brighter.getGreen-w2LRezQ();
        byte by3 = 0;
        int g = by2 & 0xFF;
        by3 = $this$brighter.getBlue-w2LRezQ();
        byte by4 = 0;
        int b = by3 & 0xFF;
        by4 = $this$brighter.getAlpha-w2LRezQ();
        int n = 0;
        int alpha = by4 & 0xFF;
        int i = (int)(1.0 / (1.0 - FACTOR));
        if (r == 0 && g == 0 && b == 0) {
            return new CPColor(i, i, i, alpha);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        n = (int)((double)r / FACTOR);
        int n2 = 255;
        boolean bl = false;
        int n3 = Math.min(n, n2);
        n = (int)((double)g / FACTOR);
        n2 = 255;
        bl = false;
        int n4 = Math.min(n, n2);
        n = (int)((double)b / FACTOR);
        n2 = 255;
        bl = false;
        return new CPColor(n3, n4, Math.min(n, n2), alpha);
    }

    @NotNull
    public static final CPColor alpha(@NotNull CPColor $this$alpha, float alpha) {
        Intrinsics.checkNotNullParameter((Object)$this$alpha, (String)"<this>");
        float f = (float)255 * alpha;
        boolean bl = false;
        int n = UnsignedKt.doubleToUInt((double)f);
        bl = false;
        int n2 = n;
        boolean bl2 = false;
        return new CPColor($this$alpha.getRed-w2LRezQ(), $this$alpha.getGreen-w2LRezQ(), $this$alpha.getBlue-w2LRezQ(), UByte.constructor-impl((byte)((byte)n2)), null);
    }

    @NotNull
    public static final CPColor darker(@NotNull CPColor $this$darker) {
        Intrinsics.checkNotNullParameter((Object)$this$darker, (String)"<this>");
        double FACTOR = 0.7;
        int n = $this$darker.getRed-w2LRezQ();
        int n2 = 0;
        int n3 = n;
        boolean bl = false;
        n = (int)((double)(n3 & 0xFF) * FACTOR);
        n2 = 0;
        n3 = 0;
        int n4 = Math.max(n, n2);
        n = $this$darker.getGreen-w2LRezQ();
        n2 = 0;
        n3 = n;
        bl = false;
        n = (int)((double)(n3 & 0xFF) * FACTOR);
        n2 = 0;
        n3 = 0;
        int n5 = Math.max(n, n2);
        n = $this$darker.getBlue-w2LRezQ();
        n2 = 0;
        n3 = n;
        bl = false;
        n = (int)((double)(n3 & 0xFF) * FACTOR);
        n2 = 0;
        n3 = 0;
        int n6 = Math.max(n, n2);
        n = $this$darker.getAlpha-w2LRezQ();
        n2 = 0;
        return new CPColor(n4, n5, n6, n & 0xFF);
    }

    @NotNull
    public static final CPColor brightenAndSaturate(@NotNull CPColor $this$brightenAndSaturate, float brightness, float saturation) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$brightenAndSaturate, (String)"<this>");
        byte by = $this$brightenAndSaturate.getRed-w2LRezQ();
        boolean bl2 = false;
        int n = by & 0xFF;
        by = $this$brightenAndSaturate.getGreen-w2LRezQ();
        bl2 = false;
        int n2 = by & 0xFF;
        by = $this$brightenAndSaturate.getBlue-w2LRezQ();
        bl2 = false;
        float[] hsb = CPColorKt.RGBtoHSB(n, n2, by & 0xFF, null);
        if (!(brightness == 0.0f)) {
            float f = 0.0f;
            float f2 = 1.0f;
            float f3 = hsb[2] + brightness;
            bl = false;
            f2 = Math.min(f2, f3);
            boolean bl3 = false;
            hsb[2] = Math.max(f, f2);
        }
        if (!(saturation == 0.0f)) {
            float f = 0.0f;
            float f4 = 1.0f;
            float f5 = hsb[1] + saturation;
            bl = false;
            f4 = Math.min(f4, f5);
            boolean bl4 = false;
            hsb[1] = Math.max(f, f4);
        }
        return new CPColor(CPColorKt.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
    }

    @NotNull
    public static final float[] RGBtoHSB(int r, int g, int b, @Nullable float[] hsbvals) {
        int cmin;
        int cmax;
        float[] hsbvals2 = hsbvals;
        float hue = 0.0f;
        float saturation = 0.0f;
        float brightness = 0.0f;
        if (hsbvals2 == null) {
            hsbvals2 = new float[3];
        }
        int n = cmax = r > g ? r : g;
        if (b > cmax) {
            cmax = b;
        }
        int n2 = cmin = r < g ? r : g;
        if (b < cmin) {
            cmin = b;
        }
        brightness = (float)cmax / 255.0f;
        saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = ((Float)(cmax - r)).floatValue() / ((Float)(cmax - cmin)).floatValue();
            float greenc = ((Float)(cmax - g)).floatValue() / ((Float)(cmax - cmin)).floatValue();
            float bluec = ((Float)(cmax - b)).floatValue() / ((Float)(cmax - cmin)).floatValue();
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        hsbvals2[0] = hue;
        hsbvals2[1] = saturation;
        hsbvals2[2] = brightness;
        return hsbvals2;
    }

    public static final int HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            r = g = (b = (int)(brightness * 255.0f + 0.5f));
        } else {
            double d = hue;
            boolean bl = false;
            float h = (hue - ((Float)Math.floor(d)).floatValue()) * 6.0f;
            double d2 = h;
            boolean bl2 = false;
            float f = h - ((Float)Math.floor(d2)).floatValue();
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            int n = (int)h;
            switch (n) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b << 0;
    }
}

