/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.geom.AffineTransform;
import org.kamaeleo.geom.Curve;
import org.kamaeleo.geom.FlatteningPathIterator;
import org.kamaeleo.geom.PathIterator;
import org.kamaeleo.geom.Point2D;
import org.kamaeleo.geom.Rectangle;
import org.kamaeleo.geom.Rectangle2D;
import org.kamaeleo.geom.Shape;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u001f\b'\u0018\u0000 K2\u00020\u0001:\u0003KLMB\u0007\b\u0010\u00a2\u0006\u0002\u0010\u0002B\u0017\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH&J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H&J\u0012\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(H&J\u0006\u0010)\u001a\u00020\u001dJ\u0016\u0010*\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fJ&\u0010*\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020\u001fJ\u0011\u0010*\u001a\u00020$2\u0006\u0010-\u001a\u00020\bH\u0096\u0002J\u0011\u0010*\u001a\u00020$2\u0006\u0010.\u001a\u00020/H\u0086\u0002J\u0014\u00100\u001a\u0004\u0018\u00010\u00012\b\u00101\u001a\u0004\u0018\u00010(H&J8\u00102\u001a\u00020\u001d2\u0006\u00103\u001a\u00020\u001f2\u0006\u00104\u001a\u00020\u001f2\u0006\u00105\u001a\u00020\u001f2\u0006\u00106\u001a\u00020\u001f2\u0006\u00107\u001a\u00020\u001f2\u0006\u00108\u001a\u00020\u001fH&J\u0012\u00109\u001a\u0004\u0018\u00010\b2\u0006\u0010:\u001a\u00020\u0004H&J&\u0010;\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020\u001fJ\u0010\u0010;\u001a\u00020$2\u0006\u0010.\u001a\u00020/H\u0016J\u0018\u0010<\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH&J\u0018\u0010=\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH&J\u0018\u0010>\u001a\u00020\u001d2\u0006\u0010?\u001a\u00020$2\u0006\u0010@\u001a\u00020\u0004H&J\u0018\u0010A\u001a\u00020\u00042\u0006\u0010B\u001a\u00020\u001f2\u0006\u0010C\u001a\u00020\u001fH&J(\u0010D\u001a\u00020\u001d2\u0006\u00103\u001a\u00020\u001f2\u0006\u00104\u001a\u00020\u001f2\u0006\u00105\u001a\u00020\u001f2\u0006\u00106\u001a\u00020\u001fH&J(\u0010E\u001a\u00020\u00042\u0006\u0010F\u001a\u00020\u001f2\u0006\u0010G\u001a\u00020\u001f2\u0006\u0010H\u001a\u00020\u001f2\u0006\u0010I\u001a\u00020\u001fH&J\u0006\u0010J\u001a\u00020\u001dR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\r\"\u0004\b\u001b\u0010\u000f\u00a8\u0006N"}, d2={"Lorg/kamaeleo/geom/Path2D;", "Lorg/kamaeleo/geom/Shape;", "()V", "rule", "", "initialTypes", "(II)V", "currentPoint", "Lorg/kamaeleo/geom/Point2D;", "getCurrentPoint", "()Lorg/kamaeleo/geom/Point2D;", "numCoords", "getNumCoords", "()I", "setNumCoords", "(I)V", "numTypes", "getNumTypes", "setNumTypes", "pointTypes", "", "getPointTypes", "()[B", "setPointTypes", "([B)V", "windingRule", "getWindingRule", "setWindingRule", "append", "", "x", "", "y", "pi", "Lorg/kamaeleo/geom/PathIterator;", "connect", "", "cloneCoordsDouble", "", "at", "Lorg/kamaeleo/geom/AffineTransform;", "closePath", "contains", "w", "h", "p", "r", "Lorg/kamaeleo/geom/Rectangle2D;", "createTransformedShape", "transform", "curveTo", "x1", "y1", "x2", "y2", "x3", "y3", "getPoint", "coordindex", "intersects", "lineTo", "moveTo", "needRoom", "needMove", "newCoords", "pointCrossings", "px", "py", "quadTo", "rectCrossings", "rxmin", "rymin", "rxmax", "rymax", "reset", "Companion", "Double", "Iterator", "kamaeleo"})
@StabilityInferred(parameters=0)
public abstract class Path2D
implements Shape {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private transient byte[] pointTypes;
    private transient int numTypes;
    private transient int numCoords;
    private transient int windingRule;
    public static final int $stable = 8;
    private static final int WIND_EVEN_ODD;
    private static final int WIND_NON_ZERO;
    public static final int INIT_SIZE = 20;
    public static final int EXPAND_MAX = 500;
    private static final byte SEG_MOVETO;
    private static final byte SEG_LINETO;
    private static final byte SEG_QUADTO;
    private static final byte SEG_CUBICTO;
    private static final byte SEG_CLOSE;

    @NotNull
    public final byte[] getPointTypes() {
        return this.pointTypes;
    }

    public final void setPointTypes(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.pointTypes = byArray;
    }

    public final int getNumTypes() {
        return this.numTypes;
    }

    public final void setNumTypes(int n) {
        this.numTypes = n;
    }

    public final int getNumCoords() {
        return this.numCoords;
    }

    public final void setNumCoords(int n) {
        this.numCoords = n;
    }

    public final int getWindingRule() {
        return this.windingRule;
    }

    public final void setWindingRule(int n) {
        this.windingRule = n;
    }

    public Path2D() {
        this.pointTypes = new byte[0];
    }

    public Path2D(int rule, int initialTypes) {
        this.windingRule = rule;
        this.pointTypes = new byte[initialTypes];
    }

    @NotNull
    public abstract double[] cloneCoordsDouble(@Nullable AffineTransform var1);

    public abstract void append(double var1, double var3);

    @Nullable
    public abstract Shape createTransformedShape(@Nullable AffineTransform var1);

    public abstract void moveTo(double var1, double var3);

    public abstract void lineTo(double var1, double var3);

    public abstract void quadTo(double var1, double var3, double var5, double var7);

    public abstract void curveTo(double var1, double var3, double var5, double var7, double var9, double var11);

    public final synchronized void closePath() {
        if (this.numTypes == 0 || this.pointTypes[this.numTypes - 1] != SEG_CLOSE) {
            this.needRoom(true, 0);
            Path2D path2D = this;
            int n = path2D.numTypes;
            path2D.numTypes = n + 1;
            this.pointTypes[n] = SEG_CLOSE;
        }
    }

    public abstract void needRoom(boolean var1, int var2);

    public abstract void append(@NotNull PathIterator var1, boolean var2);

    @Nullable
    public final synchronized Point2D getCurrentPoint() {
        int n;
        int index = this.numCoords;
        if (this.numTypes < 1 || index < 1) {
            return null;
        }
        if (this.pointTypes[this.numTypes - 1] == SEG_CLOSE && 1 <= (n = this.numTypes - 2)) {
            do {
                int i = n;
                n += -1;
                byte by = this.pointTypes[i];
                if (by == SEG_MOVETO) break;
                if (by == SEG_LINETO) {
                    index -= 2;
                    continue;
                }
                if (by == SEG_QUADTO) {
                    index -= 4;
                    continue;
                }
                if (by == SEG_CUBICTO) {
                    index -= 6;
                    continue;
                }
                if (by != SEG_CLOSE) continue;
            } while (1 <= n);
        }
        return this.getPoint(index - 2);
    }

    @Nullable
    public abstract Point2D getPoint(int var1);

    public final synchronized void reset() {
        this.numTypes = this.numCoords = 0;
    }

    @Override
    public boolean contains(@NotNull Point2D p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return this.contains(p.getX(), p.getY());
    }

    public final boolean contains(double x, double y) {
        boolean bl;
        if (x * 0.0 + y * 0.0 == 0.0) {
            int mask;
            if (this.numTypes < 2) {
                return false;
            }
            int n = mask = this.windingRule == Companion.getWIND_NON_ZERO() ? -1 : 1;
            bl = (this.pointCrossings(x, y) & mask) != 0;
        } else {
            bl = false;
        }
        return bl;
    }

    public abstract int pointCrossings(double var1, double var3);

    @Override
    public boolean intersects(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public final boolean intersects(double x, double y, double w, double h) {
        block5: {
            block4: {
                double d = x + w;
                boolean bl = false;
                if (java.lang.Double.isNaN(d)) break block4;
                d = y + h;
                bl = false;
                if (!java.lang.Double.isNaN(d)) break block5;
            }
            return false;
        }
        if (w <= 0.0 || h <= 0.0) {
            return false;
        }
        int mask = this.windingRule == Companion.getWIND_NON_ZERO() ? -1 : 2;
        int crossings = this.rectCrossings(x, y, x + w, y + h);
        return crossings == Integer.MIN_VALUE || (crossings & mask) != 0;
    }

    public final boolean contains(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public final boolean contains(double x, double y, double w, double h) {
        block5: {
            block4: {
                double d = x + w;
                boolean bl = false;
                if (java.lang.Double.isNaN(d)) break block4;
                d = y + h;
                bl = false;
                if (!java.lang.Double.isNaN(d)) break block5;
            }
            return false;
        }
        if (w <= 0.0 || h <= 0.0) {
            return false;
        }
        int mask = this.windingRule == Companion.getWIND_NON_ZERO() ? -1 : 2;
        int crossings = this.rectCrossings(x, y, x + w, y + h);
        return crossings != Integer.MIN_VALUE && (crossings & mask) != 0;
    }

    public abstract int rectCrossings(double var1, double var3, double var5, double var7);

    @Override
    @Nullable
    public Rectangle getBounds() {
        return Shape.DefaultImpls.getBounds(this);
    }

    static {
        WIND_NON_ZERO = 1;
        SEG_MOVETO = (Byte)0;
        SEG_LINETO = (Byte)1;
        SEG_QUADTO = (Byte)2;
        SEG_CUBICTO = (Byte)3;
        SEG_CLOSE = (Byte)4;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0017\u0018\u00002\u00020\u0001:\u0002BCB\u001b\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fB\u000f\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#H\u0016J\u0012\u0010$\u001a\u00020\u00152\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0006\u0010%\u001a\u00020\u0011J\u0014\u0010&\u001a\u0004\u0018\u00010\t2\b\u0010'\u001a\u0004\u0018\u00010\u000bH\u0016J8\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020 2\u0006\u0010,\u001a\u00020 2\u0006\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020 H\u0016J\u0010\u0010/\u001a\u00020\u000e2\u0006\u00100\u001a\u00020 H\u0016J\u0012\u0010\u001b\u001a\u00020\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u0003H\u0016J\u0018\u00104\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0016J\u0018\u00105\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0016J\u0018\u00106\u001a\u00020\u001e2\u0006\u00107\u001a\u00020#2\u0006\u00108\u001a\u00020\u0003H\u0016J\u0018\u00109\u001a\u00020\u00032\u0006\u0010:\u001a\u00020 2\u0006\u0010;\u001a\u00020 H\u0016J(\u0010<\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020 2\u0006\u0010,\u001a\u00020 H\u0016J(\u0010=\u001a\u00020\u00032\u0006\u0010>\u001a\u00020 2\u0006\u0010?\u001a\u00020 2\u0006\u0010@\u001a\u00020 2\u0006\u0010A\u001a\u00020 H\u0016J\u000e\u0010'\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000bR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006D"}, d2={"Lorg/kamaeleo/geom/Path2D$Double;", "Lorg/kamaeleo/geom/Path2D;", "rule", "", "initialCapacity", "(II)V", "p2d", "(Lorg/kamaeleo/geom/Path2D;)V", "s", "Lorg/kamaeleo/geom/Shape;", "at", "Lorg/kamaeleo/geom/AffineTransform;", "(Lorg/kamaeleo/geom/Shape;Lorg/kamaeleo/geom/AffineTransform;)V", "pi", "Lorg/kamaeleo/geom/PathIterator;", "(Lorg/kamaeleo/geom/PathIterator;)V", "bounds2D", "Lorg/kamaeleo/geom/Rectangle2D;", "getBounds2D", "()Lorg/kamaeleo/geom/Rectangle2D;", "doubleCoords", "", "getDoubleCoords", "()[D", "setDoubleCoords", "([D)V", "pathIterator", "getPathIterator", "()Lorg/kamaeleo/geom/PathIterator;", "append", "", "x", "", "y", "connect", "", "cloneCoordsDouble", "computeBounds2D", "createTransformedShape", "transform", "curveTo", "x1", "y1", "x2", "y2", "x3", "y3", "getFlattenPathIterator", "flatness", "getPoint", "Lorg/kamaeleo/geom/Point2D;", "coordindex", "lineTo", "moveTo", "needRoom", "needMove", "newCoords", "pointCrossings", "px", "py", "quadTo", "rectCrossings", "rxmin", "rymin", "rxmax", "rymax", "CopyIterator", "TxIterator", "kamaeleo"})
    @StabilityInferred(parameters=0)
    public static class Double
    extends Path2D {
        @NotNull
        private transient double[] doubleCoords;
        public static final int $stable = 8;

        @NotNull
        public final double[] getDoubleCoords() {
            return this.doubleCoords;
        }

        public final void setDoubleCoords(@NotNull double[] dArray) {
            Intrinsics.checkNotNullParameter((Object)dArray, (String)"<set-?>");
            this.doubleCoords = dArray;
        }

        public Double(int rule, int initialCapacity) {
            super(rule, initialCapacity);
            this.doubleCoords = new double[initialCapacity * 2];
        }

        public /* synthetic */ Double(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                n = Companion.getWIND_NON_ZERO();
            }
            if ((n3 & 2) != 0) {
                n2 = 20;
            }
            this(n, n2);
        }

        public Double(@NotNull Path2D p2d) {
            Intrinsics.checkNotNullParameter((Object)p2d, (String)"p2d");
            this.setWindingRule(p2d.getWindingRule());
            this.setNumTypes(p2d.getNumTypes());
            this.setPointTypes(Companion.copyOf(p2d.getPointTypes(), p2d.getPointTypes().length));
            this.setNumCoords(p2d.getNumCoords());
            this.doubleCoords = p2d.cloneCoordsDouble(null);
        }

        public Double(@NotNull Shape s, @Nullable AffineTransform at) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            if (s instanceof Path2D) {
                Shape p2d = s;
                this.setWindingRule(((Path2D)p2d).getWindingRule());
                this.setNumTypes(((Path2D)p2d).getNumTypes());
                this.setPointTypes(Companion.copyOf(((Path2D)p2d).getPointTypes(), ((Path2D)p2d).getNumTypes()));
                this.setNumCoords(((Path2D)p2d).getNumCoords());
                this.doubleCoords = ((Path2D)p2d).cloneCoordsDouble(at);
            } else {
                PathIterator pi = s.getPathIterator(at);
                this.setWindingRule(pi.getWindingRule());
                this.setPointTypes(new byte[20]);
                this.doubleCoords = new double[40];
                this.append(pi, false);
            }
        }

        public Double(@NotNull PathIterator pi) {
            Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
            this.setWindingRule(pi.getWindingRule());
            this.setPointTypes(new byte[20]);
            this.doubleCoords = new double[40];
            this.append(pi, false);
        }

        @Override
        @NotNull
        public double[] cloneCoordsDouble(@Nullable AffineTransform at) {
            double[] ret = null;
            if (at == null) {
                ret = Companion.copyOf(this.doubleCoords, this.getNumCoords());
            } else {
                ret = new double[this.getNumCoords()];
                at.transform(this.doubleCoords, 0, ret, 0, this.getNumCoords() / 2);
            }
            return ret;
        }

        @Override
        public void append(double x, double y) {
            Double double_ = this;
            int n = double_.getNumCoords();
            double_.setNumCoords(n + 1);
            this.doubleCoords[n] = x;
            double_ = this;
            n = double_.getNumCoords();
            double_.setNumCoords(n + 1);
            this.doubleCoords[n] = y;
        }

        @Override
        @NotNull
        public Point2D getPoint(int coordindex) {
            return new Point2D.Double(this.doubleCoords[coordindex], this.doubleCoords[coordindex + 1]);
        }

        @Override
        public void needRoom(boolean needMove, int newCoords) {
            int grow;
            boolean bl = !needMove || this.getNumTypes() != 0;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "missing initial moveto in path definition";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            int size = this.getPointTypes().length;
            if (this.getNumTypes() >= size) {
                grow = size;
                if (grow > 500) {
                    grow = 500;
                }
                this.setPointTypes(Companion.copyOf(this.getPointTypes(), size + grow));
            }
            size = this.doubleCoords.length;
            if (this.getNumCoords() + newCoords > size) {
                grow = size;
                if (grow > 1000) {
                    grow = 1000;
                }
                if (grow < newCoords) {
                    grow = newCoords;
                }
                this.doubleCoords = Companion.copyOf(this.doubleCoords, size + grow);
            }
        }

        @Override
        public int pointCrossings(double px, double py) {
            if (this.getNumTypes() == 0) {
                return 0;
            }
            double movx = 0.0;
            double[] coords = this.doubleCoords;
            movx = coords[0];
            double curx = 0.0;
            curx = movx;
            double movy = 0.0;
            movy = coords[1];
            double cury = 0.0;
            cury = movy;
            int crossings = 0;
            int ci = 0;
            ci = 2;
            int n = this.getNumTypes();
            int n2 = 1;
            int n3 = n + -1;
            if (n != Integer.MIN_VALUE && n2 <= n3) {
                do {
                    double d;
                    double d2;
                    int n4;
                    Curve.Companion companion;
                    double d3;
                    double d4;
                    double d5;
                    double d6;
                    boolean bl;
                    boolean bl2;
                    int i = n2++;
                    double endy = 0.0;
                    double endx = 0.0;
                    byte by = this.getPointTypes()[i];
                    if (by == SEG_MOVETO) {
                        if (!(cury == movy)) {
                            crossings += Curve.Companion.pointCrossingsForLine(px, py, curx, cury, movx, movy);
                        }
                        Double double_ = this;
                        bl2 = false;
                        bl = false;
                        Double $this$pointCrossings_u24lambda_u2d1 = double_;
                        boolean bl3 = false;
                        int n5 = ci;
                        ci = n5 + 1;
                        movx = curx = coords[n5];
                        double_ = this;
                        bl2 = false;
                        bl = false;
                        Double $this$pointCrossings_u24lambda_u2d2 = double_;
                        boolean bl4 = false;
                        n5 = ci;
                        ci = n5 + 1;
                        movy = cury = coords[n5];
                        continue;
                    }
                    if (by == SEG_LINETO) {
                        double it;
                        int n6 = ci;
                        ci = n6 + 1;
                        double d7 = coords[n6];
                        bl2 = false;
                        bl = false;
                        double $this$pointCrossings_u24lambda_u2d2 = d7;
                        d6 = cury;
                        d5 = curx;
                        d4 = py;
                        d3 = px;
                        companion = Curve.Companion;
                        n4 = crossings;
                        boolean bl5 = false;
                        endx = it;
                        Unit unit = Unit.INSTANCE;
                        int n7 = ci;
                        ci = n7 + 1;
                        double d8 = coords[n7];
                        bl2 = false;
                        bl = false;
                        it = d8;
                        d2 = d7;
                        boolean bl6 = false;
                        endy = it;
                        Unit unit2 = Unit.INSTANCE;
                        crossings = n4 + companion.pointCrossingsForLine(d3, d4, d5, d6, d2, d8);
                        curx = endx;
                        cury = endy;
                        continue;
                    }
                    if (by == SEG_QUADTO) {
                        int n8 = ci;
                        ci = n8 + 1;
                        double d9 = coords[n8];
                        n8 = ci;
                        ci = n8 + 1;
                        double d10 = coords[n8];
                        n8 = ci;
                        ci = n8 + 1;
                        double d11 = coords[n8];
                        bl2 = false;
                        bl = false;
                        double it = d11;
                        double d12 = d10;
                        d2 = d9;
                        d6 = cury;
                        d5 = curx;
                        d4 = py;
                        d3 = px;
                        companion = Curve.Companion;
                        n4 = crossings;
                        boolean bl7 = false;
                        endx = it;
                        Unit unit = Unit.INSTANCE;
                        int n9 = ci;
                        ci = n9 + 1;
                        double d13 = coords[n9];
                        bl2 = false;
                        bl = false;
                        it = d13;
                        d = d11;
                        boolean bl8 = false;
                        endy = it;
                        Unit unit3 = Unit.INSTANCE;
                        crossings = n4 + companion.pointCrossingsForQuad(d3, d4, d5, d6, d2, d12, d, d13, 0);
                        curx = endx;
                        cury = endy;
                        continue;
                    }
                    if (by == SEG_CUBICTO) {
                        int n10 = ci;
                        ci = n10 + 1;
                        double d14 = coords[n10];
                        n10 = ci;
                        ci = n10 + 1;
                        double d15 = coords[n10];
                        n10 = ci;
                        ci = n10 + 1;
                        double d16 = coords[n10];
                        n10 = ci;
                        ci = n10 + 1;
                        double d17 = coords[n10];
                        n10 = ci;
                        ci = n10 + 1;
                        double d18 = coords[n10];
                        bl2 = false;
                        bl = false;
                        double it = d18;
                        double d19 = d17;
                        d = d16;
                        double d20 = d15;
                        d2 = d14;
                        d6 = cury;
                        d5 = curx;
                        d4 = py;
                        d3 = px;
                        companion = Curve.Companion;
                        n4 = crossings;
                        boolean bl9 = false;
                        endx = it;
                        Unit unit = Unit.INSTANCE;
                        int n11 = ci;
                        ci = n11 + 1;
                        double d21 = coords[n11];
                        bl2 = false;
                        bl = false;
                        it = d21;
                        double d22 = d18;
                        boolean bl10 = false;
                        endy = it;
                        Unit unit4 = Unit.INSTANCE;
                        crossings = n4 + companion.pointCrossingsForCubic(d3, d4, d5, d6, d2, d20, d, d19, d22, d21, 0);
                        curx = endx;
                        cury = endy;
                        continue;
                    }
                    if (by != SEG_CLOSE) continue;
                    if (!(cury == movy)) {
                        crossings += Curve.Companion.pointCrossingsForLine(px, py, curx, cury, movx, movy);
                    }
                    curx = movx;
                    cury = movy;
                } while (n2 <= n3);
            }
            if (!(cury == movy)) {
                crossings += Curve.Companion.pointCrossingsForLine(px, py, curx, cury, movx, movy);
            }
            return crossings;
        }

        @Override
        public int rectCrossings(double rxmin, double rymin, double rxmax, double rymax) {
            if (this.getNumTypes() == 0) {
                return 0;
            }
            double[] coords = this.doubleCoords;
            double movx = 0.0;
            movx = coords[0];
            double curx = 0.0;
            curx = movx;
            double movy = 0.0;
            movy = coords[1];
            double cury = 0.0;
            cury = movy;
            int crossings = 0;
            int ci = 0;
            ci = 2;
            int i = 1;
            while (crossings != Integer.MIN_VALUE && i < this.getNumTypes()) {
                double d;
                Curve.Companion companion;
                int n;
                double d2;
                double d3;
                double d4;
                double d5;
                double d6;
                double d7;
                double d8;
                double d9;
                boolean bl;
                boolean bl2;
                double endy = 0.0;
                double endx = 0.0;
                int n2 = this.getPointTypes()[i];
                if (n2 == SEG_MOVETO) {
                    if (!(curx == movx) || !(cury == movy)) {
                        crossings = Curve.Companion.rectCrossingsForLine(crossings, rxmin, rymin, rxmax, rymax, curx, cury, movx, movy);
                    }
                    Double double_ = this;
                    bl2 = false;
                    bl = false;
                    Double $this$rectCrossings_u24lambda_u2d9 = double_;
                    boolean bl3 = false;
                    int n3 = ci;
                    ci = n3 + 1;
                    movx = curx = coords[n3];
                    double_ = this;
                    bl2 = false;
                    bl = false;
                    Double $this$rectCrossings_u24lambda_u2d10 = double_;
                    boolean bl4 = false;
                    n3 = ci;
                    ci = n3 + 1;
                    movy = cury = coords[n3];
                } else if (n2 == SEG_LINETO) {
                    int n4 = ci;
                    ci = n4 + 1;
                    endx = coords[n4];
                    n4 = ci;
                    ci = n4 + 1;
                    endy = coords[n4];
                    crossings = Curve.Companion.rectCrossingsForLine(crossings, rxmin, rymin, rxmax, rymax, curx, cury, endx, endy);
                    curx = endx;
                    cury = endy;
                } else if (n2 == SEG_QUADTO) {
                    double it;
                    int n5 = ci;
                    ci = n5 + 1;
                    double d10 = coords[n5];
                    n5 = ci;
                    ci = n5 + 1;
                    double d11 = coords[n5];
                    n5 = ci;
                    ci = n5 + 1;
                    double d12 = coords[n5];
                    bl2 = false;
                    bl = false;
                    double $this$rectCrossings_u24lambda_u2d10 = d12;
                    d9 = d11;
                    d8 = d10;
                    d7 = cury;
                    d6 = curx;
                    d5 = rymax;
                    d4 = rxmax;
                    d3 = rymin;
                    d2 = rxmin;
                    n = crossings;
                    companion = Curve.Companion;
                    boolean bl5 = false;
                    endx = it;
                    Unit unit = Unit.INSTANCE;
                    int n6 = ci;
                    ci = n6 + 1;
                    double d13 = coords[n6];
                    bl2 = false;
                    bl = false;
                    it = d13;
                    d = d12;
                    boolean bl6 = false;
                    endy = it;
                    Unit unit2 = Unit.INSTANCE;
                    crossings = companion.rectCrossingsForQuad(n, d2, d3, d4, d5, d6, d7, d8, d9, d, d13, 0);
                    curx = endx;
                    cury = endy;
                } else if (n2 == SEG_CUBICTO) {
                    int n7 = ci;
                    ci = n7 + 1;
                    double d14 = coords[n7];
                    n7 = ci;
                    ci = n7 + 1;
                    double d15 = coords[n7];
                    n7 = ci;
                    ci = n7 + 1;
                    double d16 = coords[n7];
                    n7 = ci;
                    ci = n7 + 1;
                    double d17 = coords[n7];
                    n7 = ci;
                    ci = n7 + 1;
                    double d18 = coords[n7];
                    bl2 = false;
                    bl = false;
                    double it = d18;
                    double d19 = d17;
                    d = d16;
                    d9 = d15;
                    d8 = d14;
                    d7 = cury;
                    d6 = curx;
                    d5 = rymax;
                    d4 = rxmax;
                    d3 = rymin;
                    d2 = rxmin;
                    n = crossings;
                    companion = Curve.Companion;
                    boolean bl7 = false;
                    endx = it;
                    Unit unit = Unit.INSTANCE;
                    int n8 = ci;
                    ci = n8 + 1;
                    double d20 = coords[n8];
                    bl2 = false;
                    bl = false;
                    it = d20;
                    double d21 = d18;
                    boolean bl8 = false;
                    endy = it;
                    Unit unit3 = Unit.INSTANCE;
                    crossings = companion.rectCrossingsForCubic(n, d2, d3, d4, d5, d6, d7, d8, d9, d, d19, d21, d20, 0);
                    curx = endx;
                    cury = endy;
                } else if (n2 == SEG_CLOSE) {
                    if (!(curx == movx) || !(cury == movy)) {
                        crossings = Curve.Companion.rectCrossingsForLine(crossings, rxmin, rymin, rxmax, rymax, curx, cury, movx, movy);
                    }
                    curx = movx;
                    cury = movy;
                }
                n2 = i;
                i = n2 + 1;
            }
            if (!(crossings == Integer.MIN_VALUE || curx == movx && cury == movy)) {
                crossings = Curve.Companion.rectCrossingsForLine(crossings, rxmin, rymin, rxmax, rymax, curx, cury, movx, movy);
            }
            return crossings;
        }

        @Override
        @Nullable
        public Shape createTransformedShape(@Nullable AffineTransform transform) {
            return null;
        }

        @Override
        public synchronized void moveTo(double x, double y) {
            if (this.getNumTypes() > 0 && this.getPointTypes()[this.getNumTypes() - 1] == SEG_MOVETO) {
                this.doubleCoords[this.getNumCoords() - 2] = x;
                this.doubleCoords[this.getNumCoords() - 1] = y;
            } else {
                this.needRoom(false, 2);
                byte[] byArray = this.getPointTypes();
                Double double_ = this;
                int n = double_.getNumTypes();
                double_.setNumTypes(n + 1);
                byArray[n] = SEG_MOVETO;
                double_ = this;
                n = double_.getNumCoords();
                double_.setNumCoords(n + 1);
                this.doubleCoords[n] = x;
                double_ = this;
                n = double_.getNumCoords();
                double_.setNumCoords(n + 1);
                this.doubleCoords[n] = y;
            }
        }

        @Override
        public synchronized void lineTo(double x, double y) {
            this.needRoom(true, 2);
            byte[] byArray = this.getPointTypes();
            Double double_ = this;
            int n = double_.getNumTypes();
            double_.setNumTypes(n + 1);
            byArray[n] = SEG_LINETO;
            double_ = this;
            n = double_.getNumCoords();
            double_.setNumCoords(n + 1);
            this.doubleCoords[n] = x;
            double_ = this;
            n = double_.getNumCoords();
            double_.setNumCoords(n + 1);
            this.doubleCoords[n] = y;
        }

        @Override
        public synchronized void quadTo(double x1, double y1, double x2, double y2) {
            this.needRoom(true, 4);
            byte[] byArray = this.getPointTypes();
            Double double_ = this;
            int n = double_.getNumTypes();
            double_.setNumTypes(n + 1);
            byArray[n] = SEG_QUADTO;
            double_ = this;
            n = double_.getNumCoords();
            double_.setNumCoords(n + 1);
            this.doubleCoords[n] = x1;
            double_ = this;
            n = double_.getNumCoords();
            double_.setNumCoords(n + 1);
            this.doubleCoords[n] = y1;
            double_ = this;
            n = double_.getNumCoords();
            double_.setNumCoords(n + 1);
            this.doubleCoords[n] = x2;
            double_ = this;
            n = double_.getNumCoords();
            double_.setNumCoords(n + 1);
            this.doubleCoords[n] = y2;
        }

        @Override
        public synchronized void curveTo(double x1, double y1, double x2, double y2, double x3, double y3) {
            this.needRoom(true, 6);
            byte[] byArray = this.getPointTypes();
            Double double_ = this;
            int n = double_.getNumTypes();
            double_.setNumTypes(n + 1);
            byArray[n] = SEG_CUBICTO;
            double_ = this;
            n = double_.getNumCoords();
            double_.setNumCoords(n + 1);
            this.doubleCoords[n] = x1;
            double_ = this;
            n = double_.getNumCoords();
            double_.setNumCoords(n + 1);
            this.doubleCoords[n] = y1;
            double_ = this;
            n = double_.getNumCoords();
            double_.setNumCoords(n + 1);
            this.doubleCoords[n] = x2;
            double_ = this;
            n = double_.getNumCoords();
            double_.setNumCoords(n + 1);
            this.doubleCoords[n] = y2;
            double_ = this;
            n = double_.getNumCoords();
            double_.setNumCoords(n + 1);
            this.doubleCoords[n] = x3;
            double_ = this;
            n = double_.getNumCoords();
            double_.setNumCoords(n + 1);
            this.doubleCoords[n] = y3;
        }

        @Override
        public void append(@NotNull PathIterator pi, boolean connect) {
            Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
            boolean connect2 = connect;
            double[] coords = new double[6];
            while (!pi.isDone()) {
                byte by = (byte)pi.currentSegment(coords);
                if (by == SEG_MOVETO) {
                    if (!connect2 || this.getNumTypes() < 1 || this.getNumCoords() < 1) {
                        this.moveTo(coords[0], coords[1]);
                        break;
                    }
                    if (this.getPointTypes()[this.getNumTypes() - 1] != SEG_CLOSE && this.doubleCoords[this.getNumCoords() - 2] == coords[0] && this.doubleCoords[this.getNumCoords() - 1] == coords[1]) break;
                    this.lineTo(coords[0], coords[1]);
                } else if (by == SEG_LINETO) {
                    this.lineTo(coords[0], coords[1]);
                } else if (by == SEG_QUADTO) {
                    this.quadTo(coords[0], coords[1], coords[2], coords[3]);
                } else if (by == SEG_CUBICTO) {
                    this.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                } else if (by == SEG_CLOSE) {
                    this.closePath();
                }
                pi.next();
                connect2 = false;
            }
        }

        public final void transform(@NotNull AffineTransform at) {
            Intrinsics.checkNotNullParameter((Object)at, (String)"at");
            at.transform(this.doubleCoords, 0, this.doubleCoords, 0, this.getNumCoords() / 2);
        }

        @Override
        @NotNull
        public Rectangle2D getBounds2D() {
            return this.computeBounds2D();
        }

        @NotNull
        public final synchronized Rectangle2D computeBounds2D() {
            double x1 = 0.0;
            double y1 = 0.0;
            double x2 = 0.0;
            double y2 = 0.0;
            int i = this.getNumCoords();
            if (i > 0) {
                y1 = y2 = this.doubleCoords[--i];
                x1 = x2 = this.doubleCoords[--i];
                while (i > 0) {
                    double x;
                    double y = this.doubleCoords[--i];
                    if ((x = this.doubleCoords[--i]) < x1) {
                        x1 = x;
                    }
                    if (y < y1) {
                        y1 = y;
                    }
                    if (x > x2) {
                        x2 = x;
                    }
                    if (!(y > y2)) continue;
                    y2 = y;
                }
            } else {
                x1 = y1 = (x2 = (y2 = 0.0));
            }
            return new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
        }

        @Override
        @NotNull
        public PathIterator getPathIterator() {
            return this.getPathIterator(null);
        }

        @Override
        @NotNull
        public PathIterator getPathIterator(@Nullable AffineTransform at) {
            return at == null ? (PathIterator)new CopyIterator(this) : (PathIterator)new TxIterator(this, at);
        }

        @Override
        @NotNull
        public PathIterator getFlattenPathIterator(double flatness) {
            return new FlatteningPathIterator(this.getPathIterator(), flatness);
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lorg/kamaeleo/geom/Path2D$Double$CopyIterator;", "Lorg/kamaeleo/geom/Path2D$Iterator;", "p2dd", "Lorg/kamaeleo/geom/Path2D$Double;", "(Lorg/kamaeleo/geom/Path2D$Double;)V", "doubleCoords", "", "getDoubleCoords", "()[D", "currentSegment", "", "coords", "", "kamaeleo"})
        public static final class CopyIterator
        extends Iterator {
            @NotNull
            private final double[] doubleCoords;

            public CopyIterator(@NotNull Double p2dd) {
                Intrinsics.checkNotNullParameter((Object)p2dd, (String)"p2dd");
                super(p2dd);
                this.doubleCoords = p2dd.getDoubleCoords();
            }

            @NotNull
            public final double[] getDoubleCoords() {
                return this.doubleCoords;
            }

            @Override
            public int currentSegment(@NotNull float[] coords) {
                Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
                byte type = this.getPath().getPointTypes()[this.getTypeIdx()];
                int numCoords = Iterator.Companion.getCurvecoords()[type];
                if (numCoords > 0) {
                    int n = 0;
                    int n2 = numCoords + -1;
                    if (numCoords != Integer.MIN_VALUE && n <= n2) {
                        do {
                            int i = n++;
                            coords[i] = (float)this.doubleCoords[this.getPointIdx() + i];
                        } while (n <= n2);
                    }
                }
                return type;
            }

            @Override
            public int currentSegment(@NotNull double[] coords) {
                Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
                byte type = this.getPath().getPointTypes()[this.getTypeIdx()];
                int numCoords = Iterator.Companion.getCurvecoords()[type];
                if (numCoords > 0) {
                    int n = 0;
                    int n2 = numCoords + -1;
                    if (numCoords != Integer.MIN_VALUE && n <= n2) {
                        do {
                            int i = n++;
                            coords[i] = this.doubleCoords[this.getPointIdx() + i];
                        } while (n <= n2);
                    }
                }
                return type;
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lorg/kamaeleo/geom/Path2D$Double$TxIterator;", "Lorg/kamaeleo/geom/Path2D$Iterator;", "p2dd", "Lorg/kamaeleo/geom/Path2D$Double;", "at", "Lorg/kamaeleo/geom/AffineTransform;", "(Lorg/kamaeleo/geom/Path2D$Double;Lorg/kamaeleo/geom/AffineTransform;)V", "affine", "getAffine", "()Lorg/kamaeleo/geom/AffineTransform;", "doubleCoords", "", "getDoubleCoords", "()[D", "currentSegment", "", "coords", "", "kamaeleo"})
        public static final class TxIterator
        extends Iterator {
            @NotNull
            private final double[] doubleCoords;
            @NotNull
            private final AffineTransform affine;

            public TxIterator(@NotNull Double p2dd, @NotNull AffineTransform at) {
                Intrinsics.checkNotNullParameter((Object)p2dd, (String)"p2dd");
                Intrinsics.checkNotNullParameter((Object)at, (String)"at");
                super(p2dd);
                this.doubleCoords = p2dd.getDoubleCoords();
                this.affine = at;
            }

            @NotNull
            public final double[] getDoubleCoords() {
                return this.doubleCoords;
            }

            @NotNull
            public final AffineTransform getAffine() {
                return this.affine;
            }

            @Override
            public int currentSegment(@NotNull float[] coords) {
                Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
                byte type = this.getPath().getPointTypes()[this.getTypeIdx()];
                int numCoords = Iterator.Companion.getCurvecoords()[type];
                if (numCoords > 0) {
                    this.affine.transform(this.doubleCoords, this.getPointIdx(), coords, 0, numCoords / 2);
                }
                return type;
            }

            @Override
            public int currentSegment(@NotNull double[] coords) {
                Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
                byte type = this.getPath().getPointTypes()[this.getTypeIdx()];
                int numCoords = Iterator.Companion.getCurvecoords()[type];
                if (numCoords > 0) {
                    this.affine.transform(this.doubleCoords, this.getPointIdx(), coords, 0, numCoords / 2);
                }
                return type;
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\b \u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0015\u001a\u00020\u0016H\u0096\u0002R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u0014\u0010\u0013\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/kamaeleo/geom/Path2D$Iterator;", "Lorg/kamaeleo/geom/PathIterator;", "path", "Lorg/kamaeleo/geom/Path2D;", "(Lorg/kamaeleo/geom/Path2D;)V", "isDone", "", "()Z", "getPath", "()Lorg/kamaeleo/geom/Path2D;", "pointIdx", "", "getPointIdx", "()I", "setPointIdx", "(I)V", "typeIdx", "getTypeIdx", "setTypeIdx", "windingRule", "getWindingRule", "next", "", "Companion", "kamaeleo"})
    public static abstract class Iterator
    implements PathIterator {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Path2D path;
        private int typeIdx;
        private int pointIdx;
        @NotNull
        private static final int[] curvecoords;

        public Iterator(@NotNull Path2D path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.path = path;
        }

        @NotNull
        public final Path2D getPath() {
            return this.path;
        }

        public final int getTypeIdx() {
            return this.typeIdx;
        }

        public final void setTypeIdx(int n) {
            this.typeIdx = n;
        }

        public final int getPointIdx() {
            return this.pointIdx;
        }

        public final void setPointIdx(int n) {
            this.pointIdx = n;
        }

        @Override
        public int getWindingRule() {
            return this.path.getWindingRule();
        }

        @Override
        public boolean isDone() {
            return this.typeIdx >= this.path.getNumTypes();
        }

        @Override
        public void next() {
            Iterator iterator = this;
            int n = iterator.typeIdx;
            iterator.typeIdx = n + 1;
            byte type = this.path.getPointTypes()[n];
            iterator = this;
            iterator.pointIdx += Companion.getCurvecoords()[type];
        }

        static {
            int[] nArray = new int[]{2, 2, 4, 6, 0};
            curvecoords = nArray;
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/kamaeleo/geom/Path2D$Iterator$Companion;", "", "()V", "curvecoords", "", "getCurvecoords", "()[I", "kamaeleo"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final int[] getCurvecoords() {
                return curvecoords;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\u0010\u0015\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016J.\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0004J\u0016\u0010\u001e\u001a\u00020\"2\u0006\u0010 \u001a\u00020\"2\u0006\u0010!\u001a\u00020\u0004J\u0016\u0010\u001e\u001a\u00020#2\u0006\u0010 \u001a\u00020#2\u0006\u0010!\u001a\u00020\u0004J.\u0010$\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016J\u0016\u0010$\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006%"}, d2={"Lorg/kamaeleo/geom/Path2D$Companion;", "", "()V", "EXPAND_MAX", "", "INIT_SIZE", "SEG_CLOSE", "", "SEG_CUBICTO", "SEG_LINETO", "SEG_MOVETO", "SEG_QUADTO", "WIND_EVEN_ODD", "getWIND_EVEN_ODD", "()I", "WIND_NON_ZERO", "getWIND_NON_ZERO", "contains", "", "pi", "Lorg/kamaeleo/geom/PathIterator;", "x", "", "y", "w", "h", "p", "Lorg/kamaeleo/geom/Point2D;", "r", "Lorg/kamaeleo/geom/Rectangle2D;", "copyOf", "", "original", "newLength", "", "", "intersects", "kamaeleo"})
    public static final class Companion {
        private Companion() {
        }

        public final int getWIND_EVEN_ODD() {
            return WIND_EVEN_ODD;
        }

        public final int getWIND_NON_ZERO() {
            return WIND_NON_ZERO;
        }

        public final boolean contains(@NotNull PathIterator pi, @NotNull Point2D p) {
            Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return this.contains(pi, p.getX(), p.getY());
        }

        public final boolean contains(@NotNull PathIterator pi, double x, double y) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
            if (x * 0.0 + y * 0.0 == 0.0) {
                int mask = pi.getWindingRule() == this.getWIND_NON_ZERO() ? -1 : 1;
                int cross = Curve.Companion.pointCrossingsForPath(pi, x, y);
                bl = (cross & mask) != 0;
            } else {
                bl = false;
            }
            return bl;
        }

        public final boolean contains(@NotNull PathIterator pi, @NotNull Rectangle2D r) {
            Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            return this.contains(pi, r.getX(), r.getY(), r.getWidth(), r.getHeight());
        }

        public final boolean contains(@NotNull PathIterator pi, double x, double y, double w, double h) {
            block5: {
                block4: {
                    Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
                    double d = x + w;
                    boolean bl = false;
                    if (java.lang.Double.isNaN(d)) break block4;
                    d = y + h;
                    bl = false;
                    if (!java.lang.Double.isNaN(d)) break block5;
                }
                return false;
            }
            if (w <= 0.0 || h <= 0.0) {
                return false;
            }
            int mask = pi.getWindingRule() == this.getWIND_NON_ZERO() ? -1 : 2;
            int crossings = Curve.Companion.rectCrossingsForPath(pi, x, y, x + w, y + h);
            return crossings != Integer.MIN_VALUE && (crossings & mask) != 0;
        }

        public final boolean intersects(@NotNull PathIterator pi, @NotNull Rectangle2D r) {
            Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            return this.intersects(pi, r.getX(), r.getY(), r.getWidth(), r.getHeight());
        }

        public final boolean intersects(@NotNull PathIterator pi, double x, double y, double w, double h) {
            block5: {
                block4: {
                    Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
                    double d = x + w;
                    boolean bl = false;
                    if (java.lang.Double.isNaN(d)) break block4;
                    d = y + h;
                    bl = false;
                    if (!java.lang.Double.isNaN(d)) break block5;
                }
                return false;
            }
            if (w <= 0.0 || h <= 0.0) {
                return false;
            }
            int mask = pi.getWindingRule() == this.getWIND_NON_ZERO() ? -1 : 2;
            int crossings = Curve.Companion.rectCrossingsForPath(pi, x, y, x + w, y + h);
            return crossings == Integer.MIN_VALUE || (crossings & mask) != 0;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final byte[] copyOf(@NotNull byte[] original, int newLength) {
            void srcPos$iv;
            void dstPos$iv;
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            byte[] copy = new byte[newLength];
            boolean bl = false;
            boolean bl2 = false;
            int n = original.length;
            boolean bl3 = false;
            int size$iv = Math.min(n, newLength);
            boolean $i$f$arraycopy = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            ArraysKt.copyInto((byte[])original, (byte[])copy, (int)dstPos$iv, (int)srcPos$iv, (int)(srcPos$iv + size$iv));
            return copy;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final int[] copyOf(@NotNull int[] original, int newLength) {
            void srcPos$iv;
            void dstPos$iv;
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            int[] copy = new int[newLength];
            boolean bl = false;
            boolean bl2 = false;
            int n = original.length;
            boolean bl3 = false;
            int size$iv = Math.min(n, newLength);
            boolean $i$f$arraycopy = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            ArraysKt.copyInto((int[])original, (int[])copy, (int)dstPos$iv, (int)srcPos$iv, (int)(srcPos$iv + size$iv));
            return copy;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final double[] copyOf(@NotNull double[] original, int newLength) {
            void srcPos$iv;
            void dstPos$iv;
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            double[] copy = new double[newLength];
            boolean bl = false;
            boolean bl2 = false;
            int n = original.length;
            boolean bl3 = false;
            int size$iv = Math.min(n, newLength);
            boolean $i$f$arraycopy = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            ArraysKt.copyInto((double[])original, (double[])copy, (int)dstPos$iv, (int)srcPos$iv, (int)(srcPos$iv + size$iv));
            return copy;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

