/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.rubberband;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.SimpleSingleSelection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.geom.Rectangle;
import org.kamaeleo.geom.Rectangle2D;
import org.kamaeleo.rubberband.RubberBand;
import org.kamaeleo.transform.TwoDScreenTransform;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u000e\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007R\u001c\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/kamaeleo/rubberband/ScreenTransformRubberBand;", "Lorg/kamaeleo/rubberband/RubberBand;", "screenTransform", "Lorg/kamaeleo/transform/TwoDScreenTransform;", "(Lorg/kamaeleo/transform/TwoDScreenTransform;)V", "rubberBand", "Lcom/macrofocus/common/selection/MutableSingleSelection;", "Lorg/kamaeleo/geom/Rectangle2D;", "getRubberBand", "()Lcom/macrofocus/common/selection/MutableSingleSelection;", "rubberBandScreen", "getRubberBandScreen", "()Lorg/kamaeleo/geom/Rectangle2D;", "startRubberBand", "", "x", "", "y", "stopRubberBand", "stretchRubberBand", "worldToScreen", "r", "kamaeleo"})
@StabilityInferred(parameters=0)
public final class ScreenTransformRubberBand
implements RubberBand {
    @NotNull
    private final MutableSingleSelection<Rectangle2D> rubberBand;
    @NotNull
    private final TwoDScreenTransform screenTransform;
    public static final int $stable = 8;

    public ScreenTransformRubberBand(@NotNull TwoDScreenTransform screenTransform) {
        Intrinsics.checkNotNullParameter((Object)screenTransform, (String)"screenTransform");
        this.rubberBand = (MutableSingleSelection)new SimpleSingleSelection(null);
        this.screenTransform = screenTransform;
    }

    @NotNull
    public MutableSingleSelection<Rectangle2D> getRubberBand() {
        return this.rubberBand;
    }

    @Override
    public void startRubberBand(int x, int y) {
        double xWorld = this.screenTransform.getX().screenToWorld(x);
        double yWorld = this.screenTransform.getY().screenToWorld(y);
        this.getRubberBand().setSelected((Object)new Rectangle2D.Double(xWorld, yWorld, 0.0, 0.0));
    }

    @Override
    public void stretchRubberBand(int x, int y) {
        if (this.getRubberBand().isActive()) {
            double xWorld = this.screenTransform.getX().screenToWorld(x);
            double yWorld = this.screenTransform.getY().screenToWorld(y);
            Rectangle2D rectangle2D = (Rectangle2D)this.getRubberBand().getSelected();
            Intrinsics.checkNotNull((Object)rectangle2D);
            Rectangle2D r = rectangle2D;
            this.getRubberBand().setSelected((Object)new Rectangle2D.Double(r.getX(), r.getY(), xWorld - r.getX(), yWorld - r.getY()));
        }
    }

    @Override
    public void stopRubberBand() {
        this.getRubberBand().clearSelection();
    }

    @Override
    @Nullable
    public Rectangle2D getRubberBandScreen() {
        Rectangle2D rectangle2D;
        if (this.getRubberBand().isActive()) {
            Rectangle2D rectangle2D2 = (Rectangle2D)this.getRubberBand().getSelected();
            Intrinsics.checkNotNull((Object)rectangle2D2);
            rectangle2D = this.worldToScreen(rectangle2D2).normalize();
        } else {
            rectangle2D = null;
        }
        return rectangle2D;
    }

    @NotNull
    public final Rectangle2D worldToScreen(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        double d = this.screenTransform.getX().worldToScreenPrecise(r.getMinX());
        boolean bl = false;
        int x1 = (Integer)Math.rint(d);
        double d2 = this.screenTransform.getX().worldToScreenPrecise(r.getMaxX());
        boolean bl2 = false;
        int x2 = (Integer)Math.rint(d2);
        double d3 = this.screenTransform.getY().worldToScreenPrecise(r.getMinY());
        boolean bl3 = false;
        int y1 = (Integer)Math.rint(d3);
        double d4 = this.screenTransform.getY().worldToScreenPrecise(r.getMaxY());
        boolean bl4 = false;
        int y2 = (Integer)Math.rint(d4);
        int width = x2 - x1;
        int height = y2 - y1;
        return new Rectangle(x1, y1, width, height);
    }
}

