/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kamaeleo.geom.CubicCurve2D;
import org.kamaeleo.geom.PathIterator;
import org.kamaeleo.geom.QuadCurve2D;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0013\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\u0018\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 K2\u00020\u0001:\u0001KB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010C\u001a\u00020\u00072\u0006\u0010D\u001a\u00020\u0013H\u0016J\u0010\u0010C\u001a\u00020\u00072\u0006\u0010D\u001a\u00020EH\u0016J\u000e\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020\u0007J\t\u0010I\u001a\u00020GH\u0096\u0002J\u0010\u0010I\u001a\u00020G2\u0006\u0010J\u001a\u00020$H\u0002R\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000bR\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR\u001a\u0010 \u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001a\"\u0004\b\"\u0010\u001cR\u001a\u0010#\u001a\u00020$X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u001a\"\u0004\b*\u0010\u001cR\u001a\u0010+\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001a\u00101\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u000b\"\u0004\b3\u0010\rR\u001a\u00104\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u000b\"\u0004\b6\u0010\rR\u001a\u00107\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\u001a\"\u0004\b9\u0010\u001cR\u001a\u0010:\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010\u000b\"\u0004\b<\u0010\rR\u001a\u0010\u0002\u001a\u00020\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u0014\u0010A\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010\u001a\u00a8\u0006L"}, d2={"Lorg/kamaeleo/geom/FlatteningPathIterator;", "Lorg/kamaeleo/geom/PathIterator;", "src", "flatness", "", "(Lorg/kamaeleo/geom/PathIterator;D)V", "limit", "", "(Lorg/kamaeleo/geom/PathIterator;DI)V", "curx", "getCurx", "()D", "setCurx", "(D)V", "cury", "getCury", "setCury", "getFlatness", "hold", "", "getHold", "()[D", "setHold", "([D)V", "holdEnd", "getHoldEnd", "()I", "setHoldEnd", "(I)V", "holdIndex", "getHoldIndex", "setHoldIndex", "holdType", "getHoldType", "setHoldType", "isDone", "", "()Z", "setDone", "(Z)V", "levelIndex", "getLevelIndex", "setLevelIndex", "levels", "", "getLevels", "()[I", "setLevels", "([I)V", "movx", "getMovx", "setMovx", "movy", "getMovy", "setMovy", "recursionLimit", "getRecursionLimit", "setRecursionLimit", "squareflat", "getSquareflat", "setSquareflat", "getSrc", "()Lorg/kamaeleo/geom/PathIterator;", "setSrc", "(Lorg/kamaeleo/geom/PathIterator;)V", "windingRule", "getWindingRule", "currentSegment", "coords", "", "ensureHoldCapacity", "", "want", "next", "doNext", "Companion", "kamaeleo"})
@StabilityInferred(parameters=0)
public final class FlatteningPathIterator
implements PathIterator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private PathIterator src;
    private double squareflat;
    private int recursionLimit;
    @NotNull
    private double[] hold;
    private double curx;
    private double cury;
    private double movx;
    private double movy;
    private int holdType;
    private int holdEnd;
    private int holdIndex;
    @NotNull
    private int[] levels;
    private int levelIndex;
    private boolean isDone;
    public static final int $stable = 8;
    public static final int GROW_SIZE = 24;

    public FlatteningPathIterator(@NotNull PathIterator src, double flatness, int limit) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        this.hold = new double[14];
        boolean bl = flatness >= 0.0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "flatness must be >= 0";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = limit >= 0;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "limit must be >= 0";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.src = src;
        this.squareflat = flatness * flatness;
        this.recursionLimit = limit;
        this.levels = new int[limit + 1];
        this.next(false);
    }

    @NotNull
    public final PathIterator getSrc() {
        return this.src;
    }

    public final void setSrc(@NotNull PathIterator pathIterator) {
        Intrinsics.checkNotNullParameter((Object)pathIterator, (String)"<set-?>");
        this.src = pathIterator;
    }

    public final double getSquareflat() {
        return this.squareflat;
    }

    public final void setSquareflat(double d) {
        this.squareflat = d;
    }

    public final int getRecursionLimit() {
        return this.recursionLimit;
    }

    public final void setRecursionLimit(int n) {
        this.recursionLimit = n;
    }

    @NotNull
    public final double[] getHold() {
        return this.hold;
    }

    public final void setHold(@NotNull double[] dArray) {
        Intrinsics.checkNotNullParameter((Object)dArray, (String)"<set-?>");
        this.hold = dArray;
    }

    public final double getCurx() {
        return this.curx;
    }

    public final void setCurx(double d) {
        this.curx = d;
    }

    public final double getCury() {
        return this.cury;
    }

    public final void setCury(double d) {
        this.cury = d;
    }

    public final double getMovx() {
        return this.movx;
    }

    public final void setMovx(double d) {
        this.movx = d;
    }

    public final double getMovy() {
        return this.movy;
    }

    public final void setMovy(double d) {
        this.movy = d;
    }

    public final int getHoldType() {
        return this.holdType;
    }

    public final void setHoldType(int n) {
        this.holdType = n;
    }

    public final int getHoldEnd() {
        return this.holdEnd;
    }

    public final void setHoldEnd(int n) {
        this.holdEnd = n;
    }

    public final int getHoldIndex() {
        return this.holdIndex;
    }

    public final void setHoldIndex(int n) {
        this.holdIndex = n;
    }

    @NotNull
    public final int[] getLevels() {
        return this.levels;
    }

    public final void setLevels(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.levels = nArray;
    }

    public final int getLevelIndex() {
        return this.levelIndex;
    }

    public final void setLevelIndex(int n) {
        this.levelIndex = n;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    public void setDone(boolean bl) {
        this.isDone = bl;
    }

    public FlatteningPathIterator(@NotNull PathIterator src, double flatness) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        this(src, flatness, 10);
    }

    private final void next(boolean doNext) {
        if (this.holdIndex >= this.holdEnd) {
            if (doNext) {
                this.src.next();
            }
            if (this.src.isDone()) {
                this.setDone(true);
                return;
            }
            this.holdType = this.src.currentSegment(this.hold);
            this.levelIndex = 0;
            this.levels[0] = 0;
        }
        int level = 0;
        int n = this.holdType;
        switch (n) {
            case 0: 
            case 1: {
                this.curx = this.hold[0];
                this.cury = this.hold[1];
                if (this.holdType == 0) {
                    this.movx = this.curx;
                    this.movy = this.cury;
                }
                this.holdIndex = 0;
                this.holdEnd = 0;
                break;
            }
            case 4: {
                this.curx = this.movx;
                this.cury = this.movy;
                this.holdIndex = 0;
                this.holdEnd = 0;
                break;
            }
            case 2: {
                int n2;
                FlatteningPathIterator flatteningPathIterator;
                if (this.holdIndex >= this.holdEnd) {
                    this.holdIndex = this.hold.length - 6;
                    this.holdEnd = this.hold.length - 2;
                    this.hold[this.holdIndex + 0] = this.curx;
                    this.hold[this.holdIndex + 1] = this.cury;
                    this.hold[this.holdIndex + 2] = this.hold[0];
                    this.hold[this.holdIndex + 3] = this.hold[1];
                    this.hold[this.holdIndex + 4] = this.curx = this.hold[2];
                    this.hold[this.holdIndex + 5] = this.cury = this.hold[3];
                }
                level = this.levels[this.levelIndex];
                while (level < this.recursionLimit && !(QuadCurve2D.Companion.getFlatnessSq(this.hold, this.holdIndex) < this.squareflat)) {
                    this.ensureHoldCapacity(4);
                    QuadCurve2D.Companion.subdivide(this.hold, this.holdIndex, this.hold, this.holdIndex - 4, this.hold, this.holdIndex);
                    flatteningPathIterator = this;
                    flatteningPathIterator.holdIndex -= 4;
                    int n3 = level;
                    this.levels[this.levelIndex] = level = n3 + 1;
                    flatteningPathIterator = this;
                    n2 = flatteningPathIterator.levelIndex;
                    flatteningPathIterator.levelIndex = n2 + 1;
                    this.levels[this.levelIndex] = level;
                }
                flatteningPathIterator = this;
                flatteningPathIterator.holdIndex += 4;
                flatteningPathIterator = this;
                n2 = flatteningPathIterator.levelIndex;
                flatteningPathIterator.levelIndex = n2 + -1;
                break;
            }
            case 3: {
                int n4;
                FlatteningPathIterator flatteningPathIterator;
                if (this.holdIndex >= this.holdEnd) {
                    this.holdIndex = this.hold.length - 8;
                    this.holdEnd = this.hold.length - 2;
                    this.hold[this.holdIndex + 0] = this.curx;
                    this.hold[this.holdIndex + 1] = this.cury;
                    this.hold[this.holdIndex + 2] = this.hold[0];
                    this.hold[this.holdIndex + 3] = this.hold[1];
                    this.hold[this.holdIndex + 4] = this.hold[2];
                    this.hold[this.holdIndex + 5] = this.hold[3];
                    this.hold[this.holdIndex + 6] = this.curx = this.hold[4];
                    this.hold[this.holdIndex + 7] = this.cury = this.hold[5];
                }
                level = this.levels[this.levelIndex];
                while (level < this.recursionLimit && !(CubicCurve2D.INSTANCE.getFlatnessSq(this.hold, this.holdIndex) < this.squareflat)) {
                    this.ensureHoldCapacity(6);
                    CubicCurve2D.INSTANCE.subdivide(this.hold, this.holdIndex, this.hold, this.holdIndex - 6, this.hold, this.holdIndex);
                    flatteningPathIterator = this;
                    flatteningPathIterator.holdIndex -= 6;
                    int n5 = level;
                    this.levels[this.levelIndex] = level = n5 + 1;
                    flatteningPathIterator = this;
                    n4 = flatteningPathIterator.levelIndex;
                    flatteningPathIterator.levelIndex = n4 + 1;
                    this.levels[this.levelIndex] = level;
                }
                flatteningPathIterator = this;
                flatteningPathIterator.holdIndex += 6;
                flatteningPathIterator = this;
                n4 = flatteningPathIterator.levelIndex;
                flatteningPathIterator.levelIndex = n4 + -1;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void ensureHoldCapacity(int want) {
        if (this.holdIndex - want < 0) {
            void srcPos$iv;
            void src$iv;
            int have = this.hold.length - this.holdIndex;
            int newsize = this.hold.length + 24;
            double[] newhold = new double[newsize];
            Object object = this.hold;
            int n = this.holdIndex;
            int dstPos$iv = this.holdIndex + 24;
            boolean $i$f$arraycopy = false;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            ArraysKt.copyInto((double[])src$iv, (double[])newhold, (int)dstPos$iv, (int)srcPos$iv, (int)(srcPos$iv + have));
            this.hold = newhold;
            object = this;
            object.holdIndex += 24;
            object = this;
            object.holdEnd += 24;
        }
    }

    public final double getFlatness() {
        double d = this.squareflat;
        boolean bl = false;
        return Math.sqrt(d);
    }

    @Override
    public int getWindingRule() {
        return this.src.getWindingRule();
    }

    @Override
    public void next() {
        this.next(true);
    }

    @Override
    public int currentSegment(@NotNull float[] coords) {
        Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
        if (this.isDone()) {
            throw new NoSuchElementException("flattening iterator out of bounds");
        }
        int type = this.holdType;
        if (type != 4) {
            coords[0] = (float)this.hold[this.holdIndex + 0];
            coords[1] = (float)this.hold[this.holdIndex + 1];
            if (type != 0) {
                type = 1;
            }
        }
        return type;
    }

    @Override
    public int currentSegment(@NotNull double[] coords) {
        Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
        if (this.isDone()) {
            throw new NoSuchElementException("flattening iterator out of bounds");
        }
        int type = this.holdType;
        if (type != 4) {
            coords[0] = this.hold[this.holdIndex + 0];
            coords[1] = this.hold[this.holdIndex + 1];
            if (type != 0) {
                type = 1;
            }
        }
        return type;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/kamaeleo/geom/FlatteningPathIterator$Companion;", "", "()V", "GROW_SIZE", "", "kamaeleo"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

