package org.kamaeleo.canvas

interface MouseListener {
    /**
     * Invoked when the mouse button has been clicked (pressed
     * and released) on a component.
     */
    fun mouseClicked(event: MouseEvent)

    /**
     * Invoked when a mouse button has been pressed on a component.
     */
    fun mousePressed(event: MouseEvent)

    /**
     * Invoked when a mouse button has been released on a component.
     */
    fun mouseReleased(event: MouseEvent)

    /**
     * Invoked when the mouse enters a component.
     */
    fun mouseEntered(event: MouseEvent)

    /**
     * Invoked when the mouse exits a component.
     */
    fun mouseExited(event: MouseEvent)
}