package org.kamaeleo.color

import androidx.compose.ui.graphics.Color

actual class CPColor constructor(color: Color) : IColor {
    val nativeColor: Color = color

    actual constructor(r: UByte, g: UByte, b: UByte, a: UByte) : this(Color(r.toInt(), g.toInt(), b.toInt(), a.toInt()))
    actual constructor(r: UByte, g: UByte, b: UByte) : this(r, g, b, 255u)
    actual constructor(r: Int, g: Int, b: Int) : this(r.toUByte(), g.toUByte(), b.toUByte(),255u)
    actual constructor(r: Int, g: Int, b: Int, a: Int) : this(r.toUByte(), g.toUByte(), b.toUByte(), a.toUByte())
    actual constructor(r: Float, g: Float, b: Float) : this(
        (r * 255 + 0.5).toInt(),
        (g * 255 + 0.5).toInt(),
        (b * 255 + 0.5).toInt(),
        255)
    actual constructor(r: Float, g: Float, b: Float, a: Float) : this(
        (r * 255 + 0.5).toInt(),
        (g * 255 + 0.5).toInt(),
        (b * 255 + 0.5).toInt(),
        (a * 255 + 0.5).toInt())

    actual constructor(rgba: Int) : this(Color(rgba))

    override fun getRed(): UByte {
        return Math.round(nativeColor.red * 255.0).toUByte();
    }

    override fun getGreen(): UByte {
        return Math.round(nativeColor.green * 255.0).toUByte();
    }

    override fun getBlue(): UByte {
        return Math.round(nativeColor.blue * 255.0).toUByte();
    }

    override fun getAlpha(): UByte {
        return Math.round(nativeColor.alpha * 255.0).toUByte();
    }
}