/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.palette;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.collection.SortedSet;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.common.properties.SimpleProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.color.CPColor;
import org.kamaeleo.palette.DynamicPalette;
import org.kamaeleo.palette.Palette;
import org.kamaeleo.palette.PaletteEvent;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0002'(B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0016\u0012\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\fH\u0002J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0018J\u0006\u0010\u0019\u001a\u00020\u0013J \u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\fH\u0002J\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u0015J\u0014\u0010#\u001a\u00020 2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070$J\u000e\u0010%\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u0013J\b\u0010&\u001a\u00020 H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/kamaeleo/palette/CustomPalette;", "Lorg/kamaeleo/palette/DynamicPalette;", "palette", "Lorg/kamaeleo/palette/Palette;", "(Lorg/kamaeleo/palette/Palette;)V", "entries", "", "Lorg/kamaeleo/palette/CustomPalette$Entry;", "([Lorg/kamaeleo/palette/CustomPalette$Entry;)V", "Lcom/macrofocus/common/collection/SortedSet;", "(Lcom/macrofocus/common/collection/SortedSet;)V", "highestFraction", "", "getHighestFraction", "()D", "lowestFraction", "getLowestFraction", "mode", "Lcom/macrofocus/common/properties/MutableProperty;", "Lorg/kamaeleo/palette/CustomPalette$Mode;", "computeColor", "Lorg/kamaeleo/color/CPColor;", "fration", "getEntries", "", "getMode", "interpolate", "c1", "c2", "p", "modeProperty", "setColor", "", "fraction", "color", "setEntries", "", "setMode", "updateFixedColorGradient", "Entry", "Mode", "kamaeleo"})
@StabilityInferred(parameters=0)
public final class CustomPalette
extends DynamicPalette {
    @NotNull
    private final MutableProperty<Mode> mode;
    @NotNull
    private final SortedSet<Entry> entries;
    public static final int $stable = 8;

    public CustomPalette(@NotNull SortedSet<Entry> entries) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        super(new CPColor[0]);
        this.mode = (MutableProperty)new SimpleProperty((Object)Mode.Ramps);
        this.entries = entries;
        this.mode.addPropertyListener((PropertyListener)new PropertyListener<Mode>(){

            public void propertyChanged(@NotNull PropertyEvent<Mode> event2) {
                Intrinsics.checkNotNullParameter(event2, (String)"event");
                this.notifyPaletteChanged(new PaletteEvent());
                this.updateFixedColorGradient();
            }
        });
    }

    public CustomPalette(@NotNull Palette palette) {
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        int n = 0;
        this((SortedSet<Entry>)new SortedSet(new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Entry it = (Entry)a;
                boolean bl2 = false;
                Comparable comparable = Double.valueOf(it.getFraction());
                it = (Entry)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Comparable comparable3 = Double.valueOf(it.getFraction());
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
            }
        }, null, 2, null));
        n = palette.getColorCount();
        int n2 = 0;
        int n3 = n + -1;
        if (n != Integer.MIN_VALUE && n2 <= n3) {
            do {
                int i = n2++;
                CPColor c2 = palette.getColorAt(i);
                this.entries.add((Object)new Entry((double)i / (double)(palette.getColorCount() - 1), c2));
            } while (n2 <= n3);
        }
        this.updateFixedColorGradient();
    }

    public CustomPalette(Entry ... entries) {
        Intrinsics.checkNotNullParameter((Object)entries, (String)"entries");
        boolean bl = false;
        this((SortedSet<Entry>)new SortedSet(new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Entry it = (Entry)a;
                boolean bl2 = false;
                Comparable comparable = Double.valueOf(it.getFraction());
                it = (Entry)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Comparable comparable3 = Double.valueOf(it.getFraction());
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
            }
        }, (Collection)ArraysKt.asList((Object[])entries)));
        this.updateFixedColorGradient();
    }

    private final void updateFixedColorGradient() {
        List colors = new ArrayList();
        int n = 0;
        do {
            int i = n++;
            double fraction = 1.0 * (double)i / (double)255;
            CPColor cPColor = this.computeColor(fraction);
            Intrinsics.checkNotNull((Object)cPColor);
            CPColor color = cPColor;
            colors.add(color);
        } while (n <= 255);
        this.setColorCount(colors.size());
        this.notifyPaletteChanged(new PaletteEvent());
    }

    private final CPColor computeColor(double fration) {
        if (!this.entries.isEmpty()) {
            Entry previous = null;
            for (Entry current : this.entries) {
                if (previous != null && previous.getFraction() <= fration && fration <= current.getFraction()) {
                    double v = (fration - previous.getFraction()) / (current.getFraction() - previous.getFraction());
                    return this.interpolate(previous.getColor(), current.getColor(), v);
                }
                previous = current;
            }
            if (fration < ((Entry)CollectionsKt.first((Iterable)((Iterable)this.entries))).getFraction()) {
                return ((Entry)CollectionsKt.first((Iterable)((Iterable)this.entries))).getColor();
            }
            if (fration > ((Entry)CollectionsKt.last((Iterable)((Iterable)this.entries))).getFraction()) {
                return ((Entry)CollectionsKt.last((Iterable)((Iterable)this.entries))).getColor();
            }
        }
        return null;
    }

    private final CPColor interpolate(CPColor c1, CPColor c2, double p) {
        CPColor cPColor;
        Mode mode = (Mode)((Object)this.mode.getValue());
        int n = WhenMappings.$EnumSwitchMapping$0[mode.ordinal()];
        switch (n) {
            case 1: {
                if (p == 0.0) {
                    return c1;
                }
                if (p == 1.0) {
                    cPColor = c2;
                    break;
                }
                byte by = c1.getRed-w2LRezQ();
                boolean bl = false;
                byte by2 = by;
                boolean bl2 = false;
                double d = (double)(by2 & 0xFF) * (1.0 - p);
                by = c2.getRed-w2LRezQ();
                bl = false;
                by2 = by;
                bl2 = false;
                int n2 = (int)(d + (double)(by2 & 0xFF) * p);
                by = c1.getGreen-w2LRezQ();
                bl = false;
                by2 = by;
                bl2 = false;
                double d2 = (double)(by2 & 0xFF) * (1.0 - p);
                by = c2.getGreen-w2LRezQ();
                bl = false;
                by2 = by;
                bl2 = false;
                int n3 = (int)(d2 + (double)(by2 & 0xFF) * p);
                by = c1.getBlue-w2LRezQ();
                bl = false;
                by2 = by;
                bl2 = false;
                double d3 = (double)(by2 & 0xFF) * (1.0 - p);
                by = c2.getBlue-w2LRezQ();
                bl = false;
                by2 = by;
                bl2 = false;
                int n4 = (int)(d3 + (double)(by2 & 0xFF) * p);
                by = c1.getAlpha-w2LRezQ();
                bl = false;
                by2 = by;
                bl2 = false;
                double d4 = (double)(by2 & 0xFF) * (1.0 - p);
                by = c2.getAlpha-w2LRezQ();
                bl = false;
                by2 = by;
                bl2 = false;
                CPColor cPColor2 = new CPColor(n2, n3, n4, (int)(d4 + (double)(by2 & 0xFF) * p));
                cPColor = cPColor2;
                break;
            }
            case 2: {
                cPColor = c1;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return cPColor;
    }

    public final void setColor(double fraction, @NotNull CPColor color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Entry entry = new Entry(fraction, color);
        this.entries.remove((Object)entry);
        this.entries.add((Object)entry);
        this.notifyPaletteChanged(new PaletteEvent());
        this.updateFixedColorGradient();
    }

    @NotNull
    public final Mode getMode() {
        return (Mode)((Object)this.mode.getValue());
    }

    @NotNull
    public final MutableProperty<Mode> modeProperty() {
        return this.mode;
    }

    public final void setMode(@NotNull Mode mode) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.mode.setValue((Object)mode);
    }

    @NotNull
    public final Set<Entry> getEntries() {
        return (Set)this.entries;
    }

    public final void setEntries(@NotNull Iterable<Entry> entries) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        this.entries.clear();
        for (Entry entry : entries) {
            this.entries.add((Object)entry);
        }
        this.notifyPaletteChanged(new PaletteEvent());
        this.updateFixedColorGradient();
    }

    @Override
    protected double getLowestFraction() {
        return !this.entries.isEmpty() ? ((Entry)CollectionsKt.first((Iterable)((Iterable)this.entries))).getFraction() : super.getLowestFraction();
    }

    @Override
    protected double getHighestFraction() {
        return !this.entries.isEmpty() ? ((Entry)CollectionsKt.last((Iterable)((Iterable)this.entries))).getFraction() : super.getHighestFraction();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/kamaeleo/palette/CustomPalette$Mode;", "", "(Ljava/lang/String;I)V", "Ramps", "Bands", "kamaeleo"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode Ramps = new Mode();
        public static final /* enum */ Mode Bands = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;

        public static Mode[] values() {
            Mode[] modeArray = $VALUES;
            Mode[] modeArray2 = new Mode[modeArray.length];
            System.arraycopy(modeArray, 0, modeArray2, 0, modeArray.length);
            return modeArray2;
        }

        public static Mode valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(Mode.class, value);
        }

        static {
            Mode[] modeArray = new Mode[]{Ramps, Bands};
            $VALUES = modeArray;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\u0006\u0010\u0010\u001a\u00020\u0005J\b\u0010\u0011\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lorg/kamaeleo/palette/CustomPalette$Entry;", "", "fraction", "", "color", "Lorg/kamaeleo/color/CPColor;", "(DLorg/kamaeleo/color/CPColor;)V", "getFraction", "()D", "compareTo", "", "o", "equals", "", "other", "", "getColor", "hashCode", "kamaeleo"})
    @StabilityInferred(parameters=0)
    public static final class Entry
    implements Comparable<Entry> {
        private final double fraction;
        @NotNull
        private final CPColor color;
        public static final int $stable;

        public Entry(double fraction, @NotNull CPColor color) {
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            this.fraction = fraction;
            this.color = color;
        }

        public final double getFraction() {
            return this.fraction;
        }

        @NotNull
        public final CPColor getColor() {
            return this.color;
        }

        @Override
        public int compareTo(@NotNull Entry o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            return Double.compare(this.fraction, o.fraction);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)Reflection.getOrCreateKotlinClass(other.getClass()))) {
                return false;
            }
            Entry cfr_ignored_0 = (Entry)other;
            return this.fraction == ((Entry)other).fraction;
        }

        public int hashCode() {
            return Double.hashCode(this.fraction);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Mode.values().length];
            nArray[Mode.Ramps.ordinal()] = 1;
            nArray[Mode.Bands.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

