package org.kamaeleo.color

import androidx.compose.ui.graphics.Color

actual class CPColorFactory {
    actual companion object {
        actual val instance = CPColorFactory()
    }

    actual fun createNativeColor(color: Any?): CPColor? {
        return if (color is Color) {
            CPColor(color)
        } else {
            null
        }
    }

    actual fun createColor(color: Int): CPColor {
        return CPColor(color)
    }

    actual fun createFloatRGBColor(r: Float, g: Float, b: Float): CPColor {
        return CPColor(r, g, b, 1.0f)
    }

    actual fun createRGBColor(r: Int, g: Int, b: Int): CPColor {
        return CPColor(r, g, b)
    }

    actual val white by lazy { CPColor(255u, 255u, 255u) }
    actual val lightGray by lazy { CPColor(192u, 192u, 192u) }
    actual val gray by lazy { CPColor(128u, 128u, 128u) }
    actual val darkGray by lazy { CPColor(64u,64u,64u) }
    actual val black by lazy { CPColor(0u, 0u, 0u) }

    val orange by lazy {CPColor(255u, 220u, 0u)}
    val purple by lazy {CPColor(128u, 0u, 128u)}
    val red by lazy {CPColor(Color.Red)}
}