/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.geom.AffineTransform;
import org.kamaeleo.geom.PathIterator;
import org.kamaeleo.geom.QuadCurve2D;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0013\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001bH\u0016J\t\u0010\u001c\u001a\u00020\u001dH\u0096\u0002R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\r\u00a8\u0006\u001e"}, d2={"Lorg/kamaeleo/geom/QuadIterator;", "Lorg/kamaeleo/geom/PathIterator;", "q", "Lorg/kamaeleo/geom/QuadCurve2D;", "at", "Lorg/kamaeleo/geom/AffineTransform;", "(Lorg/kamaeleo/geom/QuadCurve2D;Lorg/kamaeleo/geom/AffineTransform;)V", "affine", "getAffine", "()Lorg/kamaeleo/geom/AffineTransform;", "index", "", "getIndex", "()I", "setIndex", "(I)V", "isDone", "", "()Z", "quad", "getQuad", "()Lorg/kamaeleo/geom/QuadCurve2D;", "windingRule", "getWindingRule", "currentSegment", "coords", "", "", "next", "", "kamaeleo"})
@StabilityInferred(parameters=0)
public final class QuadIterator
implements PathIterator {
    @NotNull
    private final QuadCurve2D quad;
    @Nullable
    private final AffineTransform affine;
    private int index;
    public static final int $stable = 8;

    public QuadIterator(@NotNull QuadCurve2D q, @Nullable AffineTransform at) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        this.quad = q;
        this.affine = at;
    }

    @NotNull
    public final QuadCurve2D getQuad() {
        return this.quad;
    }

    @Nullable
    public final AffineTransform getAffine() {
        return this.affine;
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n) {
        this.index = n;
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.index > 1;
    }

    @Override
    public void next() {
        QuadIterator quadIterator = this;
        int n = quadIterator.index;
        quadIterator.index = n + 1;
    }

    @Override
    public int currentSegment(@NotNull float[] coords) {
        Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
        if (this.isDone()) {
            throw new NoSuchElementException("quad iterator iterator out of bounds");
        }
        int type = 0;
        if (this.index == 0) {
            coords[0] = ((Float)this.quad.getX1()).floatValue();
            coords[1] = ((Float)this.quad.getY1()).floatValue();
            type = 0;
        } else {
            coords[0] = ((Float)this.quad.getCtrlX()).floatValue();
            coords[1] = ((Float)this.quad.getCtrlY()).floatValue();
            coords[2] = ((Float)this.quad.getX2()).floatValue();
            coords[3] = ((Float)this.quad.getY2()).floatValue();
            type = 2;
        }
        if (this.affine != null) {
            this.affine.transform(coords, 0, coords, 0, this.index == 0 ? 1 : 2);
        }
        return type;
    }

    @Override
    public int currentSegment(@NotNull double[] coords) {
        Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
        if (this.isDone()) {
            throw new NoSuchElementException("quad iterator iterator out of bounds");
        }
        int type = 0;
        if (this.index == 0) {
            coords[0] = this.quad.getX1();
            coords[1] = this.quad.getY1();
            type = 0;
        } else {
            coords[0] = this.quad.getCtrlX();
            coords[1] = this.quad.getCtrlY();
            coords[2] = this.quad.getX2();
            coords[3] = this.quad.getY2();
            type = 2;
        }
        if (this.affine != null) {
            this.affine.transform(coords, 0, coords, 0, this.index == 0 ? 1 : 2);
        }
        return type;
    }
}

