/*
 * Copyright (c) 2017 Macrofocus GmbH. All Rights Reserved.
 */
package org.kamaeleo.colormap

import com.macrofocus.common.properties.AbstractMutableProperty
import com.macrofocus.common.properties.MutableProperty
import com.macrofocus.common.properties.PropertyEvent
import com.macrofocus.common.properties.PropertyListener
import org.kamaeleo.color.CPColor
import org.kamaeleo.palette.MutablePalette

internal class SetStoreMutableProperty(
    private val set: MutableProperty<Boolean>,
    store: MutableProperty<CPColor?>,
    palette: MutableProperty<MutablePalette?>,
    fraction: Double
) : AbstractMutableProperty<CPColor?>() {
    private val store: MutableProperty<CPColor?>
    private val palette: MutableProperty<MutablePalette?>
    private val fraction: Double
    override var value: CPColor?
        get() = if (store.value != null) {
            store.value
        } else {
            if (palette.value != null) palette!!.value!!.getColor(fraction) else null
        }
        set(value) {
            if (value != null) {
                set!!.value = true
            }
            store.value = value
        }

    init {
        this.store = store
        this.palette = palette
        this.fraction = fraction
        set!!.addPropertyListener(object : PropertyListener<Boolean> {
            override fun propertyChanged(event: PropertyEvent<Boolean>) {
                if (!event.newValue) {
                    store.value = null
                }
            }
        })
        palette.addPropertyListener(object : PropertyListener<MutablePalette?> {
            override fun propertyChanged(event: PropertyEvent<MutablePalette?>) {
                notifyPropertyChanged(PropertyEvent(null, value))
            }
        })
        store.addPropertyListener(object : PropertyListener<CPColor?> {
            override fun propertyChanged(event: PropertyEvent<CPColor?>) {
                notifyPropertyChanged(PropertyEvent<CPColor?>(event.oldValue, value))
            }
        })
    }
}