/*
 * Copyright (c) 2020 Macrofocus GmbH. All Rights Reserved.
 */
package org.kamaeleo.geom

import kotlin.math.max
import kotlin.math.min

class CurveLink(curve: Curve, ystart: Double, yend: Double, etag: Int) {
    val curve: Curve
    val edgeTag: Int
    var yTop: Double
    var yBot: Double
    var next: CurveLink? = null
    fun absorb(link: CurveLink): Boolean {
        return absorb(link.curve, link.yTop, link.yBot, link.edgeTag)
    }

    fun absorb(curve: Curve, ystart: Double, yend: Double, etag: Int): Boolean {
        if (this.curve !== curve || edgeTag != etag || yBot < ystart || yTop > yend) {
            return false
        }
        if (ystart < curve.yTop || yend > curve.yBot) {
            throw UnsupportedOperationException("bad curvelink [$ystart=>$yend] for $curve")
        }
        yTop = min(yTop, ystart)
        yBot = max(yBot, yend)
        return true
    }

    val isEmpty: Boolean
        get() = yTop == yBot

    val subCurve: org.kamaeleo.geom.Curve
        get() = if (yTop == curve.yTop && yBot == curve.yBot) {
            curve.getWithDirection(edgeTag)
        } else curve.getSubCurve(yTop, yBot, edgeTag)
    val moveto: org.kamaeleo.geom.Curve
        get() = Order0(xTop, yTop)
    val xTop: Double
        get() = curve.XforY(yTop)
    val xBot: Double
        get() = curve.XforY(yBot)
    val x: Double
        get() = curve.XforY(yTop)

    init {
        this.curve = curve
        yTop = ystart
        yBot = yend
        edgeTag = etag
        if (yTop < curve.yTop || yBot > curve.yBot) {
            throw UnsupportedOperationException("bad curvelink [" + yTop + "=>" + yBot + "] for " + curve)
        }
    }
}